/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.CharArrayWriter;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StringReader;
import java.lang.ref.WeakReference;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.common.BufferInputStream;
import weblogic.jms.common.BufferOutputStream;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.common.Payload;
import weblogic.jms.common.PayloadFactoryImpl;
import weblogic.jms.common.PayloadStream;
import weblogic.jms.common.PayloadText;
import weblogic.jms.extensions.XMLMessage;
import weblogic.jms.utils.xml.dom.DOMDeserializer;
import weblogic.jms.utils.xml.dom.DOMSerializer;
import weblogic.jms.utils.xml.stax.bin.BinaryXMLStreamReader;
import weblogic.jms.utils.xml.stax.bin.BinaryXMLStreamWriter;
import weblogic.utils.StackTraceUtilsClient;
import weblogic.utils.XXEUtils;
import weblogic.utils.io.FilteringObjectInputStream;
import weblogic.utils.io.StringInput;
import weblogic.utils.io.StringOutput;

public final class XMLMessageImpl
extends MessageImpl
implements XMLMessage,
Externalizable {
    private static final long serialVersionUID = -7021112875012439613L;
    private static final byte EXTVERSION1 = 1;
    private static final byte EXTVERSION2 = 2;
    private static final byte EXTVERSION3 = 3;
    private static final byte VERSIONMASK = 127;
    private static final boolean mydebug = false;
    private String text;
    private PayloadStream payloadToken;
    private PayloadText payloadText;
    private byte subflag = 0;
    private WeakReference selectedDocument;

    public XMLMessageImpl() {
    }

    public XMLMessageImpl(String xmlText) {
        this.text = xmlText;
    }

    public XMLMessageImpl(Document document) throws jakarta.jms.JMSException {
        this.setDocumentInternal(document);
    }

    @Override
    public void setText(String text) throws jakarta.jms.JMSException {
        this.writeMode();
        this.text = text;
        this.payloadToken = null;
        this.payloadText = null;
    }

    @Override
    public String getText() throws jakarta.jms.JMSException {
        this.decompressMessageBody();
        if (this.text != null) {
            return this.text;
        }
        if (this.payloadText != null) {
            try {
                this.text = this.payloadText.readUTF8();
                this.payloadText = null;
                return this.text;
            }
            catch (IOException ioe) {
                throw new JMSException(ioe);
            }
        }
        Document document = null;
        if (this.payloadToken != null) {
            try {
                document = XMLMessageImpl.detokenize(this.payloadToken);
            }
            catch (ParserConfigurationException pce) {
                throw XMLMessageImpl.serializationJMSException(pce);
            }
            catch (XMLStreamException xse) {
                throw XMLMessageImpl.serializationJMSException(xse);
            }
            catch (IOException ioe) {
                throw new JMSException(ioe);
            }
        }
        if (document != null) {
            try {
                this.text = XMLMessageImpl.serialize(document);
            }
            catch (TransformerException te) {
                throw XMLMessageImpl.serializationJMSException(te);
            }
            return this.text;
        }
        return null;
    }

    @Override
    public synchronized void setDocument(Document document) throws jakarta.jms.JMSException {
        this.writeMode();
        this.text = null;
        this.payloadText = null;
        this.setDocumentInternal(document);
    }

    private void setDocumentInternal(Document document) throws jakarta.jms.JMSException {
        try {
            this.payloadToken = document == null ? null : XMLMessageImpl.tokenize(document);
        }
        catch (XMLStreamException xmlse) {
            throw XMLMessageImpl.serializationJMSException(xmlse);
        }
        catch (IOException ioe) {
            throw new JMSException(ioe);
        }
    }

    @Override
    public Document getDocument() throws jakarta.jms.JMSException {
        this.decompressMessageBody();
        if (this.payloadToken != null) {
            try {
                return XMLMessageImpl.detokenize(this.payloadToken);
            }
            catch (ParserConfigurationException pce) {
                throw XMLMessageImpl.deserializationJMSException(pce);
            }
            catch (XMLStreamException xmlse) {
                throw XMLMessageImpl.deserializationJMSException(xmlse);
            }
            catch (IOException ioe) {
                throw new JMSException(ioe);
            }
        }
        if (this.payloadText != null) {
            try {
                this.text = this.payloadText.readUTF8();
            }
            catch (IOException ioe) {
                throw new JMSException(ioe);
            }
            this.payloadText = null;
        }
        if (this.text != null) {
            try {
                return XMLMessageImpl.deserialize(this.text);
            }
            catch (ParserConfigurationException pce) {
                throw XMLMessageImpl.deserializationJMSException(pce);
            }
            catch (SAXException se) {
                throw XMLMessageImpl.deserializationJMSException(se);
            }
            catch (IOException ioe) {
                throw XMLMessageImpl.deserializationJMSException(ioe);
            }
        }
        return null;
    }

    @Override
    public byte getType() {
        return 7;
    }

    @Override
    public MessageImpl copy() throws jakarta.jms.JMSException {
        XMLMessageImpl xmi = new XMLMessageImpl();
        this.copy(xmi);
        xmi.text = this.text;
        if (this.payloadToken != null) {
            xmi.payloadToken = this.payloadToken.copyPayloadWithoutSharedStream();
        }
        if (this.payloadText != null) {
            xmi.payloadText = this.payloadText.copyPayloadWithoutSharedText();
        }
        xmi.subflag = this.subflag;
        return xmi;
    }

    public static Document deserialize(String text) throws ParserConfigurationException, SAXException, IOException {
        if (JMSDebug.JMSCommon.isDebugEnabled()) {
            JMSDebug.JMSCommon.debug("XMLMessageImpl.parse(): message: " + text);
        }
        DocumentBuilderFactory dbf = XXEUtils.createDocumentBuilderFactoryInstance();
        DocumentBuilder docBuilder = dbf.newDocumentBuilder();
        return docBuilder.parse(new InputSource(new StringReader(text)));
    }

    private static String serialize(Document document) throws TransformerException {
        if (JMSDebug.JMSCommon.isDebugEnabled()) {
            JMSDebug.JMSCommon.debug("XMLMessageImpl.serialize(): " + document);
        }
        CharArrayWriter caw = new CharArrayWriter();
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer idTransform = tf.newTransformer();
        DOMSource input = new DOMSource(document);
        StreamResult output = new StreamResult(caw);
        idTransform.transform(input, output);
        return caw.toString();
    }

    private static PayloadStream tokenize(Document document) throws XMLStreamException, IOException {
        BufferOutputStream bos = PayloadFactoryImpl.createOutputStream();
        BinaryXMLStreamWriter xsw = new BinaryXMLStreamWriter(bos);
        DOMSerializer.serialize(document, xsw);
        return (PayloadStream)bos.moveToPayload();
    }

    private static Document detokenize(PayloadStream payloadToken) throws XMLStreamException, ParserConfigurationException, IOException {
        BufferInputStream is = payloadToken.getInputStream();
        BinaryXMLStreamReader xsr = new BinaryXMLStreamReader(is);
        return (Document)DOMDeserializer.deserialize(xsr);
    }

    @Override
    public Object parse() throws Exception {
        Document doc = null;
        if (this.selectedDocument != null) {
            doc = (Document)this.selectedDocument.get();
        }
        if (doc != null) {
            return doc;
        }
        this.selectedDocument = null;
        doc = this.getDocumentForSelection();
        if (doc != null) {
            this.selectedDocument = new WeakReference<Document>(doc);
        }
        return doc;
    }

    @Override
    public void nullBody() {
        this.text = null;
        this.payloadText = null;
        this.payloadToken = null;
    }

    private static jakarta.jms.JMSException serializationJMSException(Exception cause) {
        jakarta.jms.JMSException ret = new jakarta.jms.JMSException("failed to serialize message");
        ret.initCause(cause);
        return ret;
    }

    private static jakarta.jms.JMSException deserializationJMSException(Exception cause) {
        jakarta.jms.JMSException ret = new jakarta.jms.JMSException("failed to deserialize message");
        ret.initCause(cause);
        return ret;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("XMLMessage[id=" + this.getJMSMessageID() + ",text=\n");
        try {
            ret.append(this.getText());
        }
        catch (jakarta.jms.JMSException jmse) {
            ret.append(StackTraceUtilsClient.throwable2StackTrace(jmse));
        }
        return ret.toString();
    }

    @Override
    public void writeExternal(ObjectOutput tOut) throws IOException {
        PeerInfo pi;
        ObjectOutput out;
        super.writeExternal(tOut);
        int compressionThreshold = Integer.MAX_VALUE;
        int flag = 0;
        boolean readStringAsObject = true;
        if (tOut instanceof MessageImpl.JMSObjectOutputWrapper) {
            out = ((MessageImpl.JMSObjectOutputWrapper)tOut).getInnerObjectOutput();
            compressionThreshold = ((MessageImpl.JMSObjectOutputWrapper)tOut).getCompressionThreshold();
            readStringAsObject = ((MessageImpl.JMSObjectOutputWrapper)tOut).getReadStringAsObject();
        } else {
            out = tOut;
        }
        flag = out instanceof PeerInfoable ? ((pi = ((PeerInfoable)((Object)out)).getPeerInfo()).getMajor() >= 9 ? (this.needToDecompressDueToInterop(out) ? 3 : (int)((byte)(3 | (this.shouldCompress(out, compressionThreshold) ? -128 : 0)))) : 2) : (int)((byte)(3 | (this.shouldCompress(out, compressionThreshold) ? -128 : 0)));
        out.writeByte(flag);
        if ((flag & 0x7F) == 3) {
            if (this.isCompressed()) {
                if (this.needToDecompressDueToInterop(out)) {
                    Payload payload = this.decompress();
                    String text = null;
                    if ((this.subflag & 2) != 0) {
                        text = ((PayloadText)payload).readUTF8();
                    } else if ((this.subflag & 4) != 0) {
                        FilteringObjectInputStream ouinput = new FilteringObjectInputStream(payload.getInputStream());
                        try {
                            text = (String)ouinput.readObject();
                        }
                        catch (ClassNotFoundException cnfe) {
                            throw new IOException(JMSClientExceptionLogger.logErrorDeserializeMessageBodyLoggable().getMessage(), cnfe);
                        }
                    }
                    if (text != null && text.length() > 0) {
                        out.writeBoolean(true);
                        if (out instanceof StringOutput) {
                            out.writeByte(2 | (readStringAsObject ? 128 : 0));
                            ((StringOutput)((Object)out)).writeUTF8(text);
                        } else {
                            out.writeByte(4);
                            out.writeObject(text);
                        }
                    }
                    if ((this.subflag & 1) != 0) {
                        out.writeBoolean(true);
                        out.writeByte(1);
                        ((PayloadStream)payload).writeLengthAndData(out);
                    }
                } else {
                    out.writeByte(this.subflag);
                    this.flushCompressedMessageBody(out);
                }
            } else if ((flag & 0xFFFFFF80) != 0) {
                if (this.payloadToken != null) {
                    out.writeByte(1);
                    this.writeExternalCompressPayload(out, this.payloadToken);
                } else if (this.payloadText != null) {
                    out.writeByte(2);
                    this.writeExternalCompressPayload(out, this.payloadText);
                } else {
                    out.writeByte(4);
                    this.writeExternalCompressPayload(out, PayloadFactoryImpl.convertObjectToPayload(this.text));
                }
            } else if (this.payloadToken != null) {
                out.writeBoolean(true);
                out.writeByte(1);
                this.payloadToken.writeLengthAndData(out);
            } else if (this.text != null && this.text.length() > 0) {
                out.writeBoolean(true);
                if (out instanceof StringOutput) {
                    out.writeByte(2 | (readStringAsObject ? 128 : 0));
                    ((StringOutput)((Object)out)).writeUTF8(this.text);
                } else {
                    out.writeByte(4);
                    out.writeObject(this.text);
                }
            } else if (this.payloadText != null) {
                out.writeBoolean(true);
                out.writeByte(2 | (readStringAsObject ? 128 : 0));
                this.payloadText.writeLengthAndData(out);
            } else {
                out.writeBoolean(false);
            }
        } else {
            String interopStr = null;
            PayloadText payloadTextInterop = null;
            PayloadStream payloadStreamInterop = null;
            int interopflag = 0;
            if (this.isCompressed()) {
                interopflag = this.subflag;
            } else if (this.text != null) {
                interopStr = this.text;
            } else if (this.payloadText != null) {
                payloadTextInterop = this.payloadText;
                interopflag = 2;
            } else if (this.payloadToken != null) {
                payloadStreamInterop = this.payloadToken;
                interopflag = 1;
            }
            if (interopStr == null && (payloadTextInterop != null || payloadStreamInterop != null)) {
                if ((interopflag & 2) != 0) {
                    interopStr = this.payloadText.readUTF8();
                } else {
                    if ((interopflag & 4) != 0) {
                        try {
                            BufferInputStream is = payloadTextInterop.getInputStream();
                            FilteringObjectInputStream ouinput = new FilteringObjectInputStream(is);
                            interopStr = (String)ouinput.readObject();
                        }
                        catch (ClassNotFoundException cnfe) {
                            IOException ioe = new IOException(JMSClientExceptionLogger.logErrorInteropXMLMessageLoggable().getMessage());
                            ioe.initCause(cnfe);
                            throw ioe;
                        }
                    }
                    if ((interopflag & 1) != 0) {
                        Document document = null;
                        try {
                            document = XMLMessageImpl.detokenize(payloadStreamInterop);
                        }
                        catch (ParserConfigurationException pce) {
                            IOException ioe = new IOException(JMSClientExceptionLogger.logErrorInteropXMLMessageLoggable().getMessage());
                            ioe.initCause(pce);
                            throw ioe;
                        }
                        catch (XMLStreamException xse) {
                            IOException ioe = new IOException(JMSClientExceptionLogger.logErrorInteropXMLMessageLoggable().getMessage());
                            ioe.initCause(xse);
                            throw ioe;
                        }
                        try {
                            interopStr = XMLMessageImpl.serialize(document);
                        }
                        catch (TransformerException te) {
                            IOException ioe = new IOException(JMSClientExceptionLogger.logErrorInteropXMLMessageLoggable().getMessage());
                            ioe.initCause(te);
                            throw ioe;
                        }
                    }
                }
            }
            if (interopStr != null && interopStr.length() > 0) {
                out.writeBoolean(true);
                out.writeObject(interopStr);
            } else {
                out.writeBoolean(false);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        byte vrsn = in.readByte();
        switch (vrsn & 0x7F) {
            case 1: {
                this.text = in.readUTF();
                break;
            }
            case 2: {
                if (!in.readBoolean()) break;
                this.text = (String)in.readObject();
                break;
            }
            case 3: {
                if ((vrsn & 0xFFFFFF80) != 0) {
                    this.subflag = in.readByte();
                    this.readExternalCompressedMessageBody(in);
                    break;
                }
                boolean hasData = in.readBoolean();
                if (!hasData) break;
                byte mysubflag = in.readByte();
                if ((mysubflag & 1) != 0) {
                    this.payloadToken = (PayloadStream)PayloadFactoryImpl.createPayload((InputStream)((Object)in));
                    break;
                }
                if ((mysubflag & 2) != 0) {
                    if (in instanceof StringInput && (mysubflag & 0x80) != 0) {
                        this.text = ((StringInput)((Object)in)).readUTF8();
                        break;
                    }
                    this.payloadText = (PayloadText)PayloadFactoryImpl.createPayload((InputStream)((Object)in));
                    break;
                }
                if ((mysubflag & 4) == 0) break;
                this.text = (String)in.readObject();
                break;
            }
            default: {
                throw JMSUtilities.versionIOException(vrsn, 1, 3);
            }
        }
    }

    @Override
    public long getPayloadSize() {
        if (this.bodySize != -1L) {
            return this.bodySize;
        }
        if (this.isCompressed()) {
            this.bodySize = this.getCompressedMessageBodySize();
            return this.bodySize;
        }
        if (this.text != null) {
            this.bodySize = this.text.length();
            return this.bodySize;
        }
        if (this.payloadToken != null) {
            this.bodySize = this.payloadToken.getLength();
            return this.bodySize;
        }
        if (this.payloadText != null) {
            this.bodySize = this.payloadText.getLength();
            return this.bodySize;
        }
        this.bodySize = 0L;
        return 0L;
    }

    @Override
    public void decompressMessageBody() throws jakarta.jms.JMSException {
        if (!this.isCompressed()) {
            return;
        }
        try {
            Payload payload = this.decompress();
            if ((this.subflag & 2) != 0) {
                this.text = ((PayloadText)payload).readUTF8();
            } else if ((this.subflag & 4) != 0) {
                FilteringObjectInputStream ouinput = new FilteringObjectInputStream(payload.getInputStream());
                this.text = (String)ouinput.readObject();
            } else if ((this.subflag & 1) != 0) {
                this.payloadToken = (PayloadStream)payload;
            }
            this.cleanupCompressedMessageBody();
        }
        catch (IOException ioe) {
            throw new JMSException(JMSClientExceptionLogger.logErrorDeserializeMessageBodyLoggable().getMessage(), (Throwable)ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new JMSException(JMSClientExceptionLogger.logErrorDeserializeMessageBodyLoggable().getMessage(), (Throwable)cnfe);
        }
    }

    private Document getDocumentForSelection() throws jakarta.jms.JMSException {
        Document doc = null;
        String text = this.text;
        PayloadStream localPayloadToken = this.payloadToken;
        PayloadText localPayloadText = this.payloadText;
        if (this.isCompressed()) {
            try {
                Payload payload = this.decompress();
                if ((this.subflag & 2) != 0) {
                    text = ((PayloadText)payload).readUTF8();
                } else if ((this.subflag & 4) != 0) {
                    FilteringObjectInputStream ouinput = new FilteringObjectInputStream(payload.getInputStream());
                    text = (String)ouinput.readObject();
                } else if ((this.subflag & 1) != 0) {
                    localPayloadToken = (PayloadStream)payload;
                }
            }
            catch (IOException ioe) {
                throw new JMSException(JMSClientExceptionLogger.logErrorDeserializeMessageBodyLoggable().getMessage(), (Throwable)ioe);
            }
            catch (ClassNotFoundException cnfe) {
                throw new JMSException(JMSClientExceptionLogger.logErrorDeserializeMessageBodyLoggable().getMessage(), (Throwable)cnfe);
            }
        }
        if (localPayloadToken != null) {
            try {
                doc = XMLMessageImpl.detokenize(localPayloadToken);
            }
            catch (ParserConfigurationException pce) {
                throw XMLMessageImpl.deserializationJMSException(pce);
            }
            catch (XMLStreamException xmlse) {
                throw XMLMessageImpl.deserializationJMSException(xmlse);
            }
            catch (IOException ioe) {
                throw XMLMessageImpl.deserializationJMSException(ioe);
            }
        }
        if (localPayloadText != null) {
            try {
                text = localPayloadText.readUTF8();
            }
            catch (IOException ioe) {
                throw new JMSException(ioe);
            }
        }
        if (text != null) {
            try {
                doc = XMLMessageImpl.deserialize(text);
            }
            catch (ParserConfigurationException pce) {
                throw XMLMessageImpl.deserializationJMSException(pce);
            }
            catch (SAXException se) {
                throw XMLMessageImpl.deserializationJMSException(se);
            }
            catch (IOException ioe) {
                throw XMLMessageImpl.deserializationJMSException(ioe);
            }
        }
        return doc;
    }
}

