/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dispatcher;

import jakarta.jms.JMSException;
import weblogic.jms.dispatcher.DispatcherPartition4rmic;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.messaging.dispatcher.Dispatcher;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.messaging.dispatcher.DispatcherId;
import weblogic.messaging.dispatcher.DispatcherPeerGoneListener;
import weblogic.messaging.dispatcher.Request;
import weblogic.messaging.dispatcher.ResourceSetup;
import weblogic.messaging.dispatcher.Response;
import weblogic.utils.StackTraceUtilsClient;

public class DispatcherAdapter
implements JMSDispatcher,
ResourceSetup {
    private final Dispatcher delegate;
    private final DispatcherPartition4rmic dispatcherPartition4rmic;

    public DispatcherAdapter(Dispatcher d, DispatcherPartition4rmic dispatcherPartition4rmic) {
        this.delegate = d;
        this.dispatcherPartition4rmic = dispatcherPartition4rmic;
    }

    @Override
    public void dispatchNoReply(Request request) throws JMSException {
        this.giveRequestResource(request);
        try {
            this.delegate.dispatchNoReply(request);
        }
        catch (DispatcherException de) {
            throw DispatcherAdapter.convertToJMSExceptionAndThrow(de);
        }
    }

    @Override
    public void dispatchNoReplyWithId(Request request, int id) throws JMSException {
        this.giveRequestResource(request);
        try {
            this.delegate.dispatchNoReplyWithId(request, id);
        }
        catch (DispatcherException de) {
            throw DispatcherAdapter.convertToJMSExceptionAndThrow(de);
        }
    }

    @Override
    public Response dispatchSync(Request request) throws JMSException {
        this.giveRequestResource(request);
        try {
            return this.delegate.dispatchSync(request);
        }
        catch (DispatcherException de) {
            throw DispatcherAdapter.convertToJMSExceptionAndThrow(de);
        }
    }

    @Override
    public Response dispatchSyncTran(Request request) throws JMSException {
        this.giveRequestResource(request);
        try {
            return this.delegate.dispatchSyncTran(request);
        }
        catch (DispatcherException de) {
            throw DispatcherAdapter.convertToJMSExceptionAndThrow(de);
        }
    }

    @Override
    public Response dispatchSyncNoTran(Request request) throws JMSException {
        this.giveRequestResource(request);
        try {
            return this.delegate.dispatchSyncNoTran(request);
        }
        catch (DispatcherException de) {
            throw DispatcherAdapter.convertToJMSExceptionAndThrow(de);
        }
    }

    @Override
    public Response dispatchSyncNoTranWithId(Request request, int id) throws JMSException {
        this.giveRequestResource(request);
        try {
            return this.delegate.dispatchSyncNoTranWithId(request, id);
        }
        catch (DispatcherException de) {
            throw DispatcherAdapter.convertToJMSExceptionAndThrow(de);
        }
    }

    @Override
    public DispatcherId getId() {
        return this.delegate.getId();
    }

    @Override
    public boolean isLocal() {
        return this.delegate.isLocal();
    }

    @Override
    public void dispatchAsync(Request r) throws DispatcherException {
        this.giveRequestResource(r);
        this.delegate.dispatchAsync(r);
    }

    @Override
    public void dispatchAsyncWithId(Request r, int id) throws DispatcherException {
        this.giveRequestResource(r);
        this.delegate.dispatchAsyncWithId(r, id);
    }

    @Override
    public DispatcherPeerGoneListener addDispatcherPeerGoneListener(DispatcherPeerGoneListener listener) {
        return this.delegate.addDispatcherPeerGoneListener(listener);
    }

    @Override
    public void removeDispatcherPeerGoneListener(DispatcherPeerGoneListener listener) {
        this.delegate.removeDispatcherPeerGoneListener(listener);
    }

    @Override
    public Dispatcher getDelegate() {
        return this.delegate;
    }

    private static JMSException convertToJMSExceptionAndThrow(DispatcherException de) throws JMSException {
        Throwable cause = de.getCause();
        while (cause instanceof DispatcherException) {
            cause = cause.getCause();
        }
        if (cause instanceof JMSException) {
            return (JMSException)StackTraceUtilsClient.getThrowableWithCause(cause);
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        throw new weblogic.jms.common.JMSException(de);
    }

    @Override
    public void giveRequestResource(Request request) {
        request.setDispatcherPartition4rmic(this.dispatcherPartition4rmic);
    }

    @Override
    public DispatcherPartition4rmic getDispatcherPartition4rmic() {
        return this.dispatcherPartition4rmic;
    }
}

