/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dispatcher;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSID;
import weblogic.jms.dispatcher.DispatcherPartition4rmic;
import weblogic.jms.dispatcher.InvocableManagerDelegate;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.jms.dispatcher.VoidResponse;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.messaging.dispatcher.InvocableManager;
import weblogic.messaging.dispatcher.Response;
import weblogic.rmi.extensions.AsyncResultListener;
import weblogic.utils.StackTraceUtilsClient;

public abstract class Request
extends weblogic.messaging.dispatcher.Request
implements Runnable,
AsyncResultListener,
Externalizable {
    static final long serialVersionUID = -3580248041850964617L;

    public Request(JMSID invocableId, int methodId) {
        super(invocableId, methodId, VoidResponse.THE_ONE);
    }

    protected InvocableManager getInvocableManager(String partitionId) throws Exception {
        return InvocableManagerDelegate.getDelegate(partitionId).getInvocableManager();
    }

    protected boolean isPushToClientRequest(int invocabletyp) {
        return InvocableManagerDelegate.isPushToClient(invocabletyp);
    }

    @Override
    protected int getInvocableTypeMask() {
        return InvocableManagerDelegate.getInvocableTypeMask();
    }

    @Override
    protected Throwable getAppException(String str, Throwable th) {
        return new JMSException(str, th);
    }

    @Override
    public synchronized Response getResult() throws jakarta.jms.JMSException {
        try {
            return super.getResult();
        }
        catch (Throwable throwable) {
            return Request.handleThrowable(throwable);
        }
    }

    public synchronized Response useChildResult(Class responseClass) throws jakarta.jms.JMSException {
        Response response = ((Request)super.getChild()).getResult();
        this.setResult(response);
        this.setState(Integer.MAX_VALUE);
        return response;
    }

    public static Response handleThrowable(Throwable throwable) throws jakarta.jms.JMSException {
        if (JMSDebug.JMSDispatcherVerbose.isDebugEnabled()) {
            JMSDebug.JMSDispatcherVerbose.debug("Handling throwable: " + throwable.getMessage(), throwable);
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof jakarta.jms.JMSException) {
            throw (jakarta.jms.JMSException)StackTraceUtilsClient.getThrowableWithCause(throwable);
        }
        throw new JMSException(throwable.getMessage(), throwable);
    }

    public void dispatchAsync(JMSDispatcher dispatcher, weblogic.messaging.dispatcher.Request request) throws DispatcherException {
        if (JMSDebug.JMSDispatcherVerbose.isDebugEnabled()) {
            JMSDebug.JMSDispatcherVerbose.debug("delegateing to super.dispatchAsync; dispatcher: " + dispatcher.getId());
        }
        super.dispatchAsync(dispatcher.getDelegate(), request);
    }

    public void dispatchAsyncWithId(JMSDispatcher dispatcher, weblogic.messaging.dispatcher.Request request, int id) throws DispatcherException {
        if (JMSDebug.JMSDispatcherVerbose.isDebugEnabled()) {
            JMSDebug.JMSDispatcherVerbose.debug("delegateing to super.dispatchAsyncWithId; dispatcher: " + dispatcher.getId());
        }
        super.dispatchAsyncWithId(dispatcher.getDelegate(), request, id);
    }

    @Override
    public void run() {
        block3: {
            try {
                DispatcherPartition4rmic dpc4rmic = this.getDispatcherPartition4rmic();
                if (JMSDebug.JMSDispatcherVerbose.isDebugEnabled()) {
                    JMSDebug.JMSDispatcherVerbose.debug("Request.run(): dispatching Async: using dispatcher: " + dpc4rmic);
                }
                JMSDispatcher dispatcherToUse = dpc4rmic.getLocalDispatcher();
                dispatcherToUse.dispatchAsync(this);
            }
            catch (jakarta.jms.JMSException | DispatcherException ignored) {
                if (!JMSDebug.JMSDispatcherVerbose.isDebugEnabled()) break block3;
                JMSDebug.JMSDispatcherVerbose.debug(ignored.getMessage(), ignored);
            }
        }
    }

    public Request() {
        this.setAppVoidResponse(VoidResponse.THE_ONE);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in, new JMSID());
    }
}

