/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dispatcher;

import jakarta.jms.JMSException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import weblogic.jms.dispatcher.DispatcherPartition4rmic;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.messaging.dispatcher.Dispatcher;
import weblogic.messaging.dispatcher.DispatcherCommon;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.messaging.dispatcher.DispatcherId;
import weblogic.messaging.dispatcher.DispatcherPeerGoneListener;
import weblogic.messaging.dispatcher.Request;
import weblogic.messaging.dispatcher.ResourceSetup;
import weblogic.messaging.dispatcher.Response;
import weblogic.security.Security;

public class SecurityDispatcherWrapper
implements JMSDispatcher,
DispatcherCommon,
ResourceSetup {
    private JMSDispatcher adapter;
    private Subject subject;
    private final DispatcherPartition4rmic dispatcherPartition4rmic;

    public SecurityDispatcherWrapper(Subject subject, JMSDispatcher adapter, DispatcherPartition4rmic dispatcherPartition4rmic) {
        this.subject = subject;
        this.adapter = adapter;
        this.dispatcherPartition4rmic = dispatcherPartition4rmic;
    }

    @Override
    public DispatcherId getId() {
        return this.adapter.getId();
    }

    @Override
    public boolean isLocal() {
        return this.adapter.isLocal();
    }

    @Override
    public void dispatchAsync(Request r) throws DispatcherException {
        r.setDispatcherPartition4rmic(this.dispatcherPartition4rmic);
        try {
            final Request request = r;
            Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws DispatcherException {
                    SecurityDispatcherWrapper.this.adapter.dispatchAsync(request);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof DispatcherException) {
                throw (DispatcherException)e;
            }
            throw new DispatcherException(e.getMessage());
        }
    }

    @Override
    public void dispatchAsyncWithId(Request r, int id) throws DispatcherException {
        r.setDispatcherPartition4rmic(this.dispatcherPartition4rmic);
        try {
            final Request request = r;
            final int workId = id;
            Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws DispatcherException {
                    SecurityDispatcherWrapper.this.adapter.dispatchAsyncWithId(request, workId);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof DispatcherException) {
                throw (DispatcherException)e;
            }
            throw new DispatcherException(e.getMessage());
        }
    }

    @Override
    public DispatcherPeerGoneListener addDispatcherPeerGoneListener(DispatcherPeerGoneListener listener) {
        return this.adapter.addDispatcherPeerGoneListener(listener);
    }

    @Override
    public void removeDispatcherPeerGoneListener(DispatcherPeerGoneListener listener) {
        this.adapter.removeDispatcherPeerGoneListener(listener);
    }

    @Override
    public void dispatchNoReply(Request r) throws JMSException {
        r.setDispatcherPartition4rmic(this.dispatcherPartition4rmic);
        try {
            final Request request = r;
            Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws JMSException {
                    SecurityDispatcherWrapper.this.adapter.dispatchNoReply(request);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof JMSException) {
                throw (JMSException)e;
            }
            throw new JMSException(e.getMessage());
        }
    }

    @Override
    public void dispatchNoReplyWithId(Request r, int id) throws JMSException {
        r.setDispatcherPartition4rmic(this.dispatcherPartition4rmic);
        try {
            final Request request = r;
            final int fid = id;
            Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws JMSException {
                    SecurityDispatcherWrapper.this.adapter.dispatchNoReplyWithId(request, fid);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof JMSException) {
                throw (JMSException)e;
            }
            throw new JMSException(e.getMessage());
        }
    }

    @Override
    public Response dispatchSync(Request r) throws JMSException {
        r.setDispatcherPartition4rmic(this.dispatcherPartition4rmic);
        try {
            final Request request = r;
            return (Response)Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws JMSException {
                    return SecurityDispatcherWrapper.this.adapter.dispatchSync(request);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof JMSException) {
                throw (JMSException)e;
            }
            throw new JMSException(e.getMessage());
        }
    }

    @Override
    public Response dispatchSyncTran(Request r) throws JMSException {
        r.setDispatcherPartition4rmic(this.dispatcherPartition4rmic);
        try {
            final Request request = r;
            return (Response)Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws JMSException {
                    return SecurityDispatcherWrapper.this.adapter.dispatchSyncTran(request);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof JMSException) {
                throw (JMSException)e;
            }
            throw new JMSException(e.getMessage());
        }
    }

    @Override
    public Response dispatchSyncNoTran(Request r) throws JMSException {
        r.setDispatcherPartition4rmic(this.dispatcherPartition4rmic);
        try {
            final Request request = r;
            return (Response)Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws JMSException {
                    return SecurityDispatcherWrapper.this.adapter.dispatchSyncNoTran(request);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof JMSException) {
                throw (JMSException)e;
            }
            throw new JMSException(e.getMessage());
        }
    }

    @Override
    public Response dispatchSyncNoTranWithId(Request r, int id) throws JMSException {
        r.setDispatcherPartition4rmic(this.dispatcherPartition4rmic);
        try {
            final Request request = r;
            final int fid = id;
            return (Response)Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws JMSException {
                    return SecurityDispatcherWrapper.this.adapter.dispatchSyncNoTranWithId(request, fid);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof JMSException) {
                throw (JMSException)e;
            }
            throw new JMSException(e.getMessage());
        }
    }

    @Override
    public Dispatcher getDelegate() {
        return this.adapter.getDelegate();
    }

    @Override
    public void giveRequestResource(Request request) {
        request.setDispatcherPartition4rmic(this.dispatcherPartition4rmic);
    }

    @Override
    public DispatcherPartition4rmic getDispatcherPartition4rmic() {
        return this.dispatcherPartition4rmic;
    }
}

