/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.extensions;

import jakarta.jms.BytesMessage;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import weblogic.jms.common.BytesMessageImpl;
import weblogic.jms.common.HdrMessageImpl;
import weblogic.jms.common.MapMessageImpl;
import weblogic.jms.common.ObjectMessageImpl;
import weblogic.jms.common.StreamMessageImpl;
import weblogic.jms.common.TextMessageImpl;
import weblogic.jms.common.XMLMessageImpl;
import weblogic.jms.extensions.WLMessageFactory;
import weblogic.jms.extensions.XMLMessage;

public final class JMSMessageFactoryImpl
implements WLMessageFactory {
    private static WLMessageFactory messageFactory = null;

    public static final synchronized WLMessageFactory getFactory() {
        if (messageFactory == null) {
            messageFactory = new JMSMessageFactoryImpl();
        }
        return messageFactory;
    }

    JMSMessageFactoryImpl() {
    }

    @Override
    public final Message createMessage() {
        return new HdrMessageImpl();
    }

    @Override
    public final Message createMessage(Document jmsMessageDocument) throws DOMException, JMSException, IOException, ClassNotFoundException {
        try {
            Class<?> clz = Class.forName("weblogic.jms.common.XMLHelper");
            Method m = clz.getMethod("createMessage", Document.class);
            return (Message)m.invoke(null, jmsMessageDocument);
        }
        catch (InvocationTargetException ite) {
            Throwable target = ite.getTargetException();
            if (target instanceof DOMException) {
                throw (DOMException)target;
            }
            if (target instanceof JMSException) {
                throw (JMSException)target;
            }
            if (target instanceof IOException) {
                throw (IOException)target;
            }
            if (target instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)target;
            }
            throw new AssertionError((Object)target);
        }
        catch (Exception exc) {
            throw new AssertionError((Object)exc);
        }
    }

    @Override
    public final BytesMessage createBytesMessage() {
        return new BytesMessageImpl();
    }

    @Override
    public final MapMessage createMapMessage() {
        return new MapMessageImpl();
    }

    @Override
    public final ObjectMessage createObjectMessage() {
        return new ObjectMessageImpl();
    }

    @Override
    public final ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        ObjectMessageImpl om = new ObjectMessageImpl();
        om.setObject(object);
        return om;
    }

    @Override
    public final StreamMessage createStreamMessage() {
        return new StreamMessageImpl();
    }

    @Override
    public final TextMessage createTextMessage() {
        return new TextMessageImpl();
    }

    @Override
    public final TextMessage createTextMessage(String string) {
        return new TextMessageImpl(string);
    }

    @Override
    public final TextMessage createTextMessage(StringBuffer buffer) {
        return new TextMessageImpl(buffer.toString());
    }

    @Override
    public final XMLMessage createXMLMessage() {
        return new XMLMessageImpl();
    }

    @Override
    public final XMLMessage createXMLMessage(String string) {
        return new XMLMessageImpl(string);
    }

    @Override
    public final XMLMessage createXMLMessage(Document document) throws JMSException {
        return new XMLMessageImpl(document);
    }
}

