/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.DispatcherWrapper;

public final class FEConnectionCreateRequest
implements Externalizable {
    static final long serialVersionUID = 8136687183971929785L;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private static final int XA_MASK = 256;
    private static final int HAS_USER_MASK = 512;
    private static final int HAS_PW_MASK = 1024;
    private static final int OBS_MASK = 2048;
    private static final int OBS_SUBJECT_MASK = 4096;
    private DispatcherWrapper wrapper;
    private String userName;
    private String password;
    private boolean createXAConnection;
    private boolean isOBSSupported = true;
    private boolean sendBackSubject = false;

    public FEConnectionCreateRequest() {
    }

    public FEConnectionCreateRequest(DispatcherWrapper wrapper, String userName, String password, boolean createXAConnection) {
        this.wrapper = wrapper;
        this.userName = userName;
        this.password = password;
        this.createXAConnection = createXAConnection;
    }

    public DispatcherWrapper getDispatcherWrapper() {
        return this.wrapper;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isOBSSupported() {
        return this.isOBSSupported;
    }

    public boolean isSendBackSubject() {
        return this.sendBackSubject;
    }

    public boolean setSendBackSubject(Boolean sendBackSubject) {
        this.sendBackSubject = sendBackSubject;
        return this.sendBackSubject;
    }

    public boolean getCreateXAConnection() {
        return this.createXAConnection;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int mask = 1;
        if (this.createXAConnection) {
            mask |= 0x100;
        }
        if (this.userName != null) {
            mask |= 0x200;
        }
        if (this.password != null) {
            mask |= 0x400;
        }
        mask |= 0x800;
        if (this.sendBackSubject) {
            mask |= 0x1000;
        }
        out.writeInt(mask);
        this.wrapper.writeExternal(out);
        if (this.userName != null) {
            out.writeUTF(this.userName);
        }
        if (this.password != null) {
            out.writeUTF(this.password);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int mask = in.readInt();
        int version = mask & 0xFF;
        if (version != 1) {
            throw JMSUtilities.versionIOException(version, 1, 1);
        }
        this.wrapper = new DispatcherWrapper();
        this.wrapper.readExternal(in);
        boolean bl = this.createXAConnection = (mask & 0x100) != 0;
        if ((mask & 0x200) != 0) {
            this.userName = in.readUTF();
        }
        if ((mask & 0x400) != 0) {
            this.password = in.readUTF();
        }
        this.isOBSSupported = (mask & 0x800) != 0;
        this.sendBackSubject = (mask & 0x1000) != 0;
    }
}

