/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.JMSServerId;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;
import weblogic.jms.dispatcher.VoidResponse;
import weblogic.messaging.dispatcher.Response;

public final class FERemoveSubscriptionRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = 4562660717591850604L;
    private String clientId;
    private String name;
    private int clientIdPolicy = 0;
    private JMSServerId backEndId;
    private String destinationName;
    private DestinationImpl destination;
    private static final int EXTVERSION_PRE_1033 = 1;
    private static final int EXTVERSION_1033 = 2;
    private static final int EXTVERSION_1034 = 3;
    private static final int EXTVERSION = 3;
    private static final int VERSION_MASK = 255;
    private static final int HAS_JMSSERVER_ID = 256;
    private static final int HAS_DESTINATION_NAME = 512;
    private static final int HAS_DESTINATION = 1024;
    static final int START = 0;
    static final int WAIT = 1;

    public FERemoveSubscriptionRequest(String clientId, String name) {
        super(null, 5377);
        this.clientId = clientId;
        this.name = name;
    }

    public FERemoveSubscriptionRequest(String clientId, String name, int clientIdPolicy, JMSServerId backEndId, String destinationName) {
        this(clientId, name);
        this.clientIdPolicy = clientIdPolicy;
        this.destinationName = destinationName;
        this.backEndId = backEndId;
    }

    public FERemoveSubscriptionRequest(String clientId, String name, int clientIdPolicy, DestinationImpl destination) {
        this(clientId, name);
        this.clientIdPolicy = clientIdPolicy;
        this.destination = destination;
        this.backEndId = destination.getBackEndId();
        this.destinationName = destination.getTopicName();
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getName() {
        return this.name;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public int getClientIdPolicy() {
        return this.clientIdPolicy;
    }

    public JMSServerId getBackEndId() {
        return this.backEndId;
    }

    void setBackEndId(JMSServerId newBackEndId) {
        this.backEndId = newBackEndId;
    }

    public DestinationImpl getDestination() {
        return this.destination;
    }

    void setDestination(DestinationImpl refreshedDestination) {
        this.destination = refreshedDestination;
        this.backEndId = refreshedDestination.getBackEndId();
        this.destinationName = refreshedDestination.getTopicName();
    }

    @Override
    public int remoteSignature() {
        return 18;
    }

    @Override
    public Response createResponse() {
        return VoidResponse.THE_ONE;
    }

    public FERemoveSubscriptionRequest() {
    }

    private byte getVersion(Object o) throws IOException {
        if (o instanceof PeerInfoable) {
            PeerInfo pi = ((PeerInfoable)o).getPeerInfo();
            if (pi.compareTo(PeerInfo.VERSION_1033) < 0) {
                return 1;
            }
            if (pi.compareTo(PeerInfo.VERSION_1034) < 0) {
                return 2;
            }
        }
        return 3;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int version;
        out = this.getVersionedStream(out);
        int mask = version = this.getVersion(out) & 0xFF;
        if (version >= 3) {
            if (this.destination != null) {
                mask |= 0x400;
            }
        } else if (version >= 2) {
            if (this.backEndId != null) {
                mask |= 0x100;
            }
            if (this.destinationName != null) {
                mask |= 0x200;
            }
        }
        out.writeInt(mask);
        super.writeExternal(out);
        out.writeUTF(this.clientId == null ? "" : this.clientId);
        out.writeUTF(this.name);
        if (version >= 3) {
            out.writeInt(this.clientIdPolicy);
            if (this.destination != null) {
                this.destination.writeExternal(out);
            }
        } else if (version >= 2) {
            out.writeInt(this.clientIdPolicy);
            if (this.backEndId != null) {
                this.backEndId.writeExternal(out);
            }
            if (this.destinationName != null) {
                out.writeUTF(this.destinationName);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int mask = in.readInt();
        int version = mask & 0xFF;
        if (version != 1 && version != 2 && version != 3) {
            throw JMSUtilities.versionIOException(version, 1, 3);
        }
        super.readExternal(in);
        this.clientId = in.readUTF();
        if (this.clientId.length() == 0) {
            this.clientId = null;
        }
        this.name = in.readUTF();
        if (version >= 3) {
            this.clientIdPolicy = in.readInt();
            if ((mask & 0x400) != 0) {
                this.destination = new DestinationImpl();
                this.destination.readExternal(in);
                this.backEndId = this.destination.getBackEndId();
                this.destinationName = this.destination.getTopicName();
            }
        } else if (version >= 2) {
            this.clientIdPolicy = in.readInt();
            if ((mask & 0x100) != 0) {
                this.backEndId = new JMSServerId();
                this.backEndId.readExternal(in);
            }
            if ((mask & 0x200) != 0) {
                this.destinationName = in.readUTF();
            }
        }
    }
}

