/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.multicast;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import weblogic.jms.multicast.JMSTDMSocket;

public final class JMSTDMSocketIPM
implements JMSTDMSocket {
    private MulticastSocket sock;
    private ArrayList groups;
    private int timeout = 0;

    public JMSTDMSocketIPM(int port) throws IOException, UnknownHostException {
        this.sock = new MulticastSocket(port);
        this.groups = new ArrayList();
    }

    public JMSTDMSocketIPM() throws IOException, UnknownHostException {
        this.sock = new MulticastSocket();
        this.groups = new ArrayList();
    }

    @Override
    public void send(byte[] buffer, int length, InetAddress group, int port, byte ttl) throws IOException {
        DatagramPacket packet = new DatagramPacket(buffer, length, group, port);
        this.sock.send(packet, ttl);
    }

    @Override
    public void setSoTimeout(int timeout) throws IOException {
        try {
            this.sock.setSoTimeout(timeout);
        }
        catch (SocketException ne) {
            throw new IOException(ne.toString());
        }
    }

    @Override
    public void setTTL(byte ttl) throws IOException {
        this.sock.setTTL(ttl);
    }

    @Override
    public int receive(byte[] buffer) throws IOException {
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
        try {
            this.sock.receive(packet);
        }
        catch (InterruptedIOException ne) {
            return 0;
        }
        return packet.getLength();
    }

    @Override
    public void close() {
        if (this.sock == null) {
            return;
        }
        for (int i = 0; i < this.groups.size(); ++i) {
            try {
                this.sock.leaveGroup((InetAddress)this.groups.get(i));
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.sock.close();
        this.sock = null;
        this.groups = null;
    }

    @Override
    public void joinGroup(InetAddress group) throws IOException {
        if (this.sock == null) {
            throw new IOException("Socket is closed");
        }
        if (this.groups.indexOf(group) >= 0) {
            throw new IOException("Group exists");
        }
        this.sock.joinGroup(group);
        this.groups.add(group);
    }

    @Override
    public void leaveGroup(InetAddress group) throws IOException {
        if (this.sock == null) {
            throw new IOException("Socket is closed");
        }
        if (this.groups.indexOf(group) == -1) {
            throw new IOException("Group not found");
        }
        this.sock.leaveGroup(group);
        this.groups.remove(group);
    }

    void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

