/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.utils.xml.stax.bin;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.jms.utils.xml.stax.bin.BinaryXMLConstants;
import weblogic.jms.utils.xml.stax.utils.NamespaceContextImpl;

public final class BinaryXMLStreamWriter
implements XMLStreamWriter {
    private static final String DEFAULT_NS = "";
    private static final int MAX_DICT_SIZE = 1024;
    private static final int MIN_DICT_ENTRY_SIZE = 8;
    final DataOutput dos;
    private final HashMap dict = new HashMap();
    private char[] charBuf;
    private boolean writingEmptyElement;
    private NamespaceContextImpl context = new NamespaceContextImpl();
    private HashSet needToWrite;
    private boolean startElementOpened;

    public BinaryXMLStreamWriter(OutputStream out) throws XMLStreamException {
        this.dos = out instanceof DataOutput ? (DataOutput)((Object)out) : new DataOutputStream(out);
        try {
            this.dos.write(BinaryXMLConstants.HEADERV2_BYTES);
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.openStartElement();
        int localNameID = this.abbrevString(localName);
        this.writeInt(1);
        this.writeInt(localNameID);
        this.writeInt(0);
    }

    @Override
    public void writeStartElement(String uri, String localName) throws XMLStreamException {
        this.openStartElement();
        int localNameID = this.abbrevString(localName);
        int uriID = this.abbrevString(uri);
        this.writeInt(1);
        this.writeInt(localNameID);
        this.writeInt(uriID);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String uri) throws XMLStreamException {
        this.openStartElement();
        this.writeNamespace(prefix, uri);
        this.writeStartElement(uri, localName);
    }

    @Override
    public void writeEmptyElement(String uri, String localName) throws XMLStreamException {
        this.writeStartElement(uri, localName);
        this.writingEmptyElement = true;
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String uri) throws XMLStreamException {
        this.writeStartElement(prefix, localName, uri);
        this.writingEmptyElement = true;
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.writeStartElement(localName);
        this.writingEmptyElement = true;
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.writingEmptyElement = false;
        this.context.closeScope(false);
        this.writeInt(4);
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.closeStartElement();
        this.writeInt(6);
    }

    @Override
    public void close() throws XMLStreamException {
        this.writeInt(62);
        this.dict.clear();
    }

    @Override
    public void flush() throws XMLStreamException {
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        int localNameID = this.abbrevString(localName);
        this.writeInt(2);
        this.writeInt(localNameID);
        this.writeInt(0);
        this.writePCDATA(value);
        this.writeInt(5);
    }

    @Override
    public void writeAttribute(String prefix, String uri, String localName, String value) throws XMLStreamException {
        this.writeNamespace(prefix, uri);
        this.writeAttribute(uri, localName, value);
    }

    @Override
    public void writeAttribute(String uri, String localName, String value) throws XMLStreamException {
        int localNameID = this.abbrevString(localName);
        int uriID = this.abbrevString(uri);
        this.writeInt(2);
        this.writeInt(localNameID);
        this.writeInt(uriID);
        this.writePCDATA(value);
        this.writeInt(5);
    }

    @Override
    public void writeNamespace(String prefix, String uri) throws XMLStreamException {
        int prefixID = this.abbrevString(prefix);
        int uriID = this.abbrevString(uri);
        this.writeInt(8);
        this.writeInt(prefixID);
        this.writeInt(uriID);
    }

    @Override
    public void writeDefaultNamespace(String uri) throws XMLStreamException {
        this.writeNamespace(DEFAULT_NS, uri);
        this.setPrefix(DEFAULT_NS, uri);
    }

    @Override
    public void writeComment(String value) throws XMLStreamException {
        this.closeStartElement();
        this.writeInt(7);
        this.writeString(value);
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.writeProcessingInstruction(target, DEFAULT_NS);
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.closeStartElement();
        int targetID = this.abbrevString(target);
        this.writeInt(9);
        this.writeInt(targetID);
        this.writeInt(0);
        this.writeString(data);
    }

    @Override
    public void writeCData(String s) throws XMLStreamException {
        this.closeStartElement();
        this.writeCharacters(s);
    }

    @Override
    public void writeDTD(String s) throws XMLStreamException {
        if (!s.startsWith("<!DOCTYPE") || !s.endsWith(">")) {
            throw new XMLStreamException("Invalid DTD");
        }
        int i1 = (s = s.substring(9, s.length() - 1).trim()).indexOf(" ");
        String name = i1 == -1 ? s : s.substring(0, i1);
        this.writeInt(50);
        this.writeString(name);
        this.writeString(DEFAULT_NS);
        this.writeString(DEFAULT_NS);
    }

    @Override
    public void writeEntityRef(String s) throws XMLStreamException {
        this.closeStartElement();
        throw new AssertionError((Object)"NYI");
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.writeStartDocument(DEFAULT_NS, DEFAULT_NS);
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this.writeStartDocument(DEFAULT_NS, version);
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.writeInt(3);
        this.writeString(version);
        this.writeString(encoding);
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.closeStartElement();
        this.writeInt(10);
        this.writeString(text);
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.closeStartElement();
        this.writeInt(10);
        this.writeChars(text, start, len);
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.context.getPrefix(uri);
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.needToWrite(uri);
        this.context.bindDefaultNameSpace(uri);
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.needToWrite(uri);
        this.context.bindDefaultNameSpace(uri);
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        if (context == null) {
            throw new NullPointerException("The namespace context may not be null");
        }
        this.context = new NamespaceContextImpl(context);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.context;
    }

    @Override
    public Object getProperty(String s) throws IllegalArgumentException {
        return null;
    }

    private final void closeStartElement() throws XMLStreamException {
        if (this.startElementOpened) {
            this.flushNamespace();
            if (this.writingEmptyElement) {
                this.writeEndElement();
            }
            this.startElementOpened = false;
        }
    }

    private final void openStartElement() throws XMLStreamException {
        if (this.startElementOpened) {
            this.flushNamespace();
            if (this.writingEmptyElement) {
                this.writeEndElement();
            }
        }
        this.startElementOpened = true;
        this.context.openScope();
    }

    private final void needToWrite(String uri) {
        if (this.needToWrite == null) {
            this.needToWrite = new HashSet();
        }
        this.needToWrite.add(uri);
    }

    protected final void flushNamespace() throws XMLStreamException {
        if (this.needToWrite == null || this.needToWrite.size() == 0) {
            return;
        }
        for (String uri : this.needToWrite) {
            String prefix = this.context.getPrefix(uri);
            if (prefix == null) {
                throw new XMLStreamException("Unable to default prefix with uri:" + uri);
            }
            if (uri == null) {
                throw new XMLStreamException("Attempt to write a null uri.");
            }
            this.writeNamespace(prefix, uri);
        }
        this.needToWrite.clear();
    }

    void writeString(String text) throws XMLStreamException {
        int len = text.length();
        if (this.charBuf == null || len > this.charBuf.length) {
            this.charBuf = new char[len * 2];
        }
        text.getChars(0, len, this.charBuf, 0);
        this.writeChars(this.charBuf, 0, len);
    }

    private void writeChars(char[] text, int start, int len) throws XMLStreamException {
        int utflen = 0;
        for (int i = start; i < start + len; ++i) {
            char c = text[i];
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        this.writeInt(utflen);
        byte[] bytearr = new byte[utflen];
        int count = 0;
        for (int i = start; i < start + len; ++i) {
            char c = text[i];
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
            bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        try {
            this.dos.write(bytearr);
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }

    void writePCDATA(String value) throws XMLStreamException {
        int length = value.length();
        if (length > 8) {
            int pcdataID = this.abbrevString(value);
            this.writeInt(83);
            this.writeInt(pcdataID);
        } else {
            this.writeInt(19);
            this.writeString(value);
        }
    }

    void writeInt(int value) throws XMLStreamException {
        try {
            do {
                int val = value & 0x7F;
                if ((value >>>= 7) != 0) {
                    val |= 0x80;
                }
                this.dos.write(val);
            } while (value != 0);
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }

    int abbrevString(String s) throws XMLStreamException {
        Integer i;
        if (s == null) {
            return 0;
        }
        if (this.dict.size() >= 1024) {
            this.writeInt(61);
            this.dict.clear();
        }
        if ((i = (Integer)this.dict.get(s)) != null) {
            return i;
        }
        int iv = this.dict.size() + 1;
        this.dict.put(s, new Integer(iv));
        this.writeInt(60);
        this.writeString(s);
        return iv;
    }
}

