/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.NamingManager;
import javax.security.auth.login.LoginException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.invocation.ComponentInvocationContext;
import weblogic.invocation.ComponentInvocationContextManager;
import weblogic.invocation.ManagedInvocationContext;
import weblogic.invocation.PartitionTable;
import weblogic.jndi.Environment;
import weblogic.jndi.internal.ExceptionTranslator;
import weblogic.jndi.internal.JNDIEnvironment;
import weblogic.jndi.internal.NamingDebugLogger;
import weblogic.jndi.internal.NamingNode;
import weblogic.jndi.internal.NamingNodeReplicaHandler;
import weblogic.jndi.internal.PartitionHandler;
import weblogic.jndi.internal.WLContextImpl;
import weblogic.jndi.internal.WLEventContextImpl;
import weblogic.jndi.internal.WLInternalContext;
import weblogic.jndi.spi.EnvironmentFactory;
import weblogic.kernel.KernelStatus;
import weblogic.protocol.LocalServerIdentity;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolManager;
import weblogic.protocol.ProtocolStack;
import weblogic.protocol.ServerIdentity;
import weblogic.rjvm.ClientServerURL;
import weblogic.rjvm.JVMID;
import weblogic.rjvm.RJVM;
import weblogic.rjvm.RJVMManager;
import weblogic.rmi.cluster.ClusterableRemoteRef;
import weblogic.rmi.cluster.ReplicaAwareInfo;
import weblogic.rmi.extensions.StubFactory;
import weblogic.rmi.extensions.server.RemoteReference;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.rmi.internal.BasicRemoteRef;
import weblogic.rmi.internal.ClientMethodDescriptor;
import weblogic.rmi.internal.ClientRuntimeDescriptor;
import weblogic.rmi.internal.StubInfo;
import weblogic.rmi.internal.StubInfoIntf;
import weblogic.rmi.spi.HostID;
import weblogic.security.SimpleCallbackHandler;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.DefaultUserInfoImpl;
import weblogic.security.acl.UserInfo;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.acl.internal.AuthenticatedUser;
import weblogic.security.acl.internal.RemoteAuthenticate;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityManager;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.Debug;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.http.HttpParsing;

public class WLInitialContextFactoryDelegate
implements InitialContextFactory,
EnvironmentFactory {
    private static final DebugLogger debugConnection;
    private static final AuthenticatedSubject kernelId;
    private static Class preload;
    private static final String ROOT_NAMING_NODE_CLASS_NAME = "weblogic.jndi.internal.ServerNamingNode";
    private static final boolean enableVisibilityControl;
    private static NamingNode rootNode;
    private static final String[] ROOT_NODE_INTERFACES;
    private static final ClientMethodDescriptor DESC;
    private static final Class[] STUB_INFO_CLASS;
    private static final ClientRuntimeDescriptor ROOT_NODE_DESCRIPTOR;
    private static final ReplicaAwareInfo NAMING_NODE_RA_INFO;
    private static boolean keepEnvironmentUntilContextClose;

    public static WLInitialContextFactoryDelegate theOne() {
        return SingletonMaker.singleton;
    }

    public WLInitialContextFactoryDelegate() {
        JNDIEnvironment.getJNDIEnvironment().prepareKernel();
    }

    public final Context getInitialContext(Hashtable env) throws NamingException {
        Environment environment = new Environment(env);
        return this.getInitialContext(environment, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Context getInitialContext(final Environment env, String subCtxName, final HostID hostID) throws NamingException {
        this.processLocalSchemaProviderURL(env);
        CommunicationException pendingException = null;
        IOException ioException = null;
        String url = this.getProviderURL(env);
        ServerIdentity explicitHost = env.getProviderIdentity();
        int retryTime = env.getRetryTimes();
        long retryInterval = env.getRetryInterval();
        ClientServerURL serverURL = null;
        int time = 0;
        while (time <= retryTime) {
            block32: {
                String providerUrl;
                ServerIdentity hostVM;
                block31: {
                    ++time;
                    hostVM = null;
                    if (explicitHost != null) {
                        hostVM = explicitHost;
                    } else if (url == "local://") {
                        hostVM = LocalServerIdentity.getIdentity();
                    } else {
                        JNDIEnvironment.getJNDIEnvironment().pushThreadEnvironment(env);
                        try {
                            boolean debugConn;
                            providerUrl = url;
                            final ClientServerURL surl = new ClientServerURL(providerUrl);
                            hostVM = env.getSecurityPrincipal() != null || env.getSecurityCredentials() != null ? (ServerIdentity)SecurityManager.runAs(kernelId, SubjectUtils.getAnonymousSubject(), new PrivilegedExceptionAction(){

                                public Object run() throws Exception {
                                    return surl.findOrCreateRJVM(env.getEnableServerAffinity(), env.getProviderChannel(), hostID, (int)env.getConnectionTimeout(), env.getForceResolveDNSName()).getID();
                                }
                            }) : surl.findOrCreateRJVM(env.getEnableServerAffinity(), env.getProviderChannel(), hostID, (int)env.getConnectionTimeout(), env.getForceResolveDNSName()).getID();
                            if (NamingDebugLogger.isDebugEnabled() && (debugConn = debugConnection.isDebugEnabled())) {
                                NamingDebugLogger.debug("Bootstrapping context from DNS " + url);
                            }
                            serverURL = surl;
                        }
                        catch (PrivilegedActionException pae) {
                            if (pae.getException() instanceof IOException) {
                                ioException = (IOException)pae.getException();
                            }
                            throw this.toNamingException(pae.getException());
                        }
                        catch (IOException ioe) {
                            ioException = ioe;
                            return ioException;
                        }
                        catch (Exception e) {
                            throw this.toNamingException(e);
                        }
                        finally {
                            JNDIEnvironment.getJNDIEnvironment().popThreadEnvironment();
                            if (ioException == null) break block31;
                            if (NamingDebugLogger.isDebugEnabled()) {
                                NamingDebugLogger.debug("Try to create JVM connection " + time + " time, encounter : " + ioException);
                            }
                            if (time > retryTime) {
                                throw this.throwRetryException(this.toNamingException(ioException), time, retryInterval);
                            }
                            ioException = null;
                            this.retrySleep(retryInterval);
                            continue;
                        }
                    }
                }
                try {
                    providerUrl = url;
                    if (serverURL != null) {
                        providerUrl = serverURL.getCurrentURL();
                    }
                    Context context = this.newContext(hostVM, env, subCtxName, providerUrl);
                    return context;
                }
                catch (CommunicationException e) {
                    pendingException = e;
                    if (NamingDebugLogger.isDebugEnabled()) {
                        NamingDebugLogger.debug("Try to create context " + time + " time, encounter : " + pendingException);
                    }
                }
                catch (NamingException ne) {
                    if (ne.getRootCause() instanceof IOException) {
                        ioException = (IOException)ne.getRootCause();
                        break block32;
                    }
                    throw ne;
                }
                finally {
                    if (ioException != null) {
                        if (NamingDebugLogger.isDebugEnabled()) {
                            NamingDebugLogger.debug("Try to create context " + time + " time, encounter : " + ioException);
                        }
                        if (time > retryTime) {
                            throw this.throwRetryException(this.toNamingException(ioException), time, retryInterval);
                        }
                        ioException = null;
                    }
                }
            }
            this.retrySleep(retryInterval);
        }
        throw this.throwRetryException(pendingException, time, retryInterval);
    }

    private void retrySleep(long millis) {
        if (millis <= 0L) {
            return;
        }
        try {
            Thread.currentThread();
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private final NamingException throwRetryException(NamingException e, int times, long interval) {
        if (e instanceof CommunicationException || e.getRootCause() instanceof IOException) {
            CommunicationException thr = new CommunicationException("Failed to initialize JNDI context, tried " + times + " time or times totally, the interval of each time is " + interval + "ms. \n" + e.getMessage());
            thr.setRootCause(e.getRootCause());
            return thr;
        }
        return e;
    }

    private String getProviderURL(Environment env) {
        String url = env.getClusterProviderUrl();
        if (url == null) {
            url = env.getProviderUrl();
        }
        return url;
    }

    private void processLocalSchemaProviderURL(Environment env) throws NamingException {
        String url = env.getProviderUrl();
        if (!KernelStatus.isServer() && url.toLowerCase().startsWith("local://")) {
            throw new NamingException("URL schema local:// is only supported on server side.");
        }
        if (url.length() > "local://".length() && url.toLowerCase().startsWith("local://")) {
            URI uri = null;
            try {
                uri = new URI(url);
            }
            catch (URISyntaxException e) {
                throw new NamingException(e.getMessage());
            }
            String queryString = uri.getQuery();
            if (null == queryString) {
                return;
            }
            Hashtable queryStringMap = new Hashtable();
            HttpParsing.parseQueryString(queryString, queryStringMap);
            String partitionInfo = (String)queryStringMap.get("partitionName");
            if (null == partitionInfo) {
                return;
            }
            if (!"DOMAIN".equals(partitionInfo)) {
                PartitionHandler.checkPartition((String)partitionInfo);
            }
            env.setProviderUrl("local://");
            if (env.getProperty("weblogic.jndi.partitionInformation") == null) {
                env.setProperty("weblogic.jndi.partitionInformation", partitionInfo);
            }
        }
    }

    @Override
    public Remote getInitialReference(Environment env, Class implClass) throws NamingException {
        this.processLocalSchemaProviderURL(env);
        String url = this.getProviderURL(env);
        ServerIdentity hostVM = env.getProviderIdentity();
        if (hostVM == null) {
            if (url == "local://") {
                hostVM = LocalServerIdentity.getIdentity();
            } else {
                JNDIEnvironment.getJNDIEnvironment().pushThreadEnvironment(env);
                try {
                    hostVM = this.getHostVM(env, url);
                }
                catch (IOException e) {
                    throw this.toNamingException(e);
                }
                finally {
                    JNDIEnvironment.getJNDIEnvironment().popThreadEnvironment();
                }
            }
        }
        JNDIEnvironment.getJNDIEnvironment().pushThreadEnvironment(env);
        try {
            long responseReadTimeout = env.getResponseReadTimeout();
            if (responseReadTimeout > 0L) {
                Remote remote = (Remote)StubFactory.getStubWithTimeout(implClass, hostVM, env.getProviderChannel(), responseReadTimeout);
                return remote;
            }
            Remote remote = (Remote)StubFactory.getStub(implClass, hostVM, env.getProviderChannel());
            return remote;
        }
        catch (RemoteException e) {
            throw this.toNamingException(e);
        }
        finally {
            JNDIEnvironment.getJNDIEnvironment().popThreadEnvironment();
        }
    }

    ServerIdentity getHostVM(Environment env, String url) throws IOException {
        boolean debugConn;
        JVMID hostVM = new ClientServerURL(url).findOrCreateRJVM(env.getEnableServerAffinity(), env.getProviderChannel(), null, (int)env.getConnectionTimeout(), env.getForceResolveDNSName()).getID();
        if (NamingDebugLogger.isDebugEnabled() && (debugConn = debugConnection.isDebugEnabled())) {
            NamingDebugLogger.debug("Bootstrapping reference from DNS " + url);
        }
        return hostVM;
    }

    @Override
    public Context getInitialContext(Environment environment, String contextName) throws NamingException {
        return this.getInitialContext(environment, contextName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Context newContext(ServerIdentity hostVM, Environment env, String subCtxName, String providerUrl) throws NamingException {
        Context initialContext = null;
        JNDIEnvironment.getJNDIEnvironment().pushThreadEnvironment(env);
        try {
            this.pushSubject(env, hostVM, providerUrl);
            JNDIEnvironment.getJNDIEnvironment().activateTransactionHelper();
            try {
                initialContext = hostVM.isLocal() ? (enableVisibilityControl && this.isRemoteAccessWithLocalRJVM(env, providerUrl) ? this.newRemoteContext(JVMID.localRemoteID(), env, subCtxName, providerUrl) : this.newLocalContext(env, subCtxName, providerUrl)) : this.newRemoteContext(hostVM, env, subCtxName, providerUrl);
                if (env.getSecurityUser() != null || env.isClientCertAvailable() || env.isLocalIdentitySet()) {
                    ((WLInternalContext)initialContext).enableLogoutOnClose();
                }
                this.cacheConnectionTimeout(hostVM, env, initialContext);
            }
            catch (RemoteException e) {
                throw this.toNamingException(e);
            }
            finally {
                if (initialContext == null) {
                    this.popSubject(env);
                    JNDIEnvironment.getJNDIEnvironment().deactivateTransactionHelper();
                }
            }
        }
        finally {
            if (!keepEnvironmentUntilContextClose) {
                JNDIEnvironment.getJNDIEnvironment().popThreadEnvironment();
            }
        }
        return initialContext;
    }

    private boolean isRemoteAccessWithLocalRJVM(Environment env, String providerUrl) throws NamingException {
        if (providerUrl.startsWith("local://")) {
            return false;
        }
        String partitionName = this.getPartitionNameFrom(env, providerUrl);
        if (partitionName == null) {
            return false;
        }
        return !partitionName.equals(this.getPartitionName());
    }

    private void cacheConnectionTimeout(ServerIdentity hostVM, Environment env, Context initialContext) {
        long connectionTimeout = env.getConnectionTimeout();
        if (connectionTimeout > 0L) {
            JNDIEnvironment.getJNDIEnvironment().storeConnectionTimeout(initialContext, hostVM, connectionTimeout);
        }
    }

    private Context newLocalContext(Environment env, String subCtxName, String providerUrl) throws NamingException {
        Debug.assertion(Thread.currentThread().getContextClassLoader() != null, "ContextClassLoader == null");
        Hashtable delegateEnv = env.getDelegateEnvironment();
        if (delegateEnv != null) {
            this.popSubject(env);
            return NamingManager.getInitialContext(delegateEnv);
        }
        try {
            NamingNode stub = this.getRootNode();
            Hashtable properties = env.getProperties();
            if (properties != null && !properties.containsKey("weblogic.jndi.partitionInformation")) {
                String partitionName = null;
                partitionName = providerUrl != "local://" ? this.getPartitionName(providerUrl) : this.getPartitionName();
                if (partitionName != null) {
                    properties.put("weblogic.jndi.partitionInformation", partitionName);
                }
            }
            WLEventContextImpl ctx = new WLEventContextImpl(properties, stub);
            if (subCtxName == null || subCtxName.length() == 0) {
                return ctx;
            }
            return (Context)ctx.lookup(subCtxName);
        }
        catch (NoSuchObjectException e) {
            throw new NoInitialContextException("JNDI subsystem is not ready for use ");
        }
    }

    private NamingNode getRootNode() throws NoSuchObjectException {
        if (rootNode == null) {
            rootNode = (NamingNode)ServerHelper.getRemoteObject(9);
        }
        return rootNode;
    }

    private Context newRemoteContext(ServerIdentity hostVM, Environment env, String subCtxName, String providerUrl) throws NamingException, RemoteException {
        Hashtable delegateEnv = env.getDelegateEnvironment();
        if (delegateEnv != null) {
            return JNDIEnvironment.getJNDIEnvironment().getDelegateContext(hostVM, env, subCtxName);
        }
        BasicRemoteRef basicRef = new BasicRemoteRef(9, hostVM, env.getProviderChannel());
        NamingNode stub = this.newRootNamingNodeStub(basicRef, providerUrl);
        WLContextImpl ctx = new WLContextImpl(env.getRemoteProperties(), stub);
        if (subCtxName == null || subCtxName.length() == 0) {
            return ctx;
        }
        return (Context)ctx.lookup(subCtxName);
    }

    private NamingNode newRootNamingNodeStub(RemoteReference ref, String providerUrl) {
        ClientRuntimeDescriptor desc = ROOT_NODE_DESCRIPTOR;
        ClusterableRemoteRef raRef = new ClusterableRemoteRef(ref);
        raRef.initialize(NAMING_NODE_RA_INFO);
        StubInfo info = new StubInfo(raRef, desc, ServerHelper.getStubClassName(ROOT_NAMING_NODE_CLASS_NAME), null, providerUrl, null);
        try {
            Class<?> stubCls = Class.forName(ServerHelper.getStubClassName(ROOT_NAMING_NODE_CLASS_NAME));
            Constructor<?> con = stubCls.getConstructor(STUB_INFO_CLASS);
            return (NamingNode)con.newInstance(info);
        }
        catch (ClassNotFoundException cnfe) {
            throw new AssertionError((Object)cnfe);
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private final void pushSubject(Environment env, ServerIdentity rjvm, String providerUrl) throws NamingException {
        Protocol protocol = null;
        try {
            protocol = this.getProtocol(env);
            WLInitialContextFactoryDelegate.pushProtocol(env, protocol);
        }
        catch (MalformedURLException mue) {
            throw new AssertionError((Object)mue);
        }
        UserInfo user = env.getSecurityUser();
        if (user == null && protocol.isSecure() && (env.isClientCertAvailable() || env.isLocalIdentitySet())) {
            user = new DefaultUserInfoImpl(null, null);
        }
        Object au = null;
        boolean isServer = rjvm.isLocal();
        AuthenticatedSubject subject = null;
        if (user != null) {
            subject = env.getSecuritySubject();
            if (subject != null) {
                subject = env.getSecuritySubject();
            } else if (isServer) {
                try {
                    String newPartitionName = this.getPartitionNameFrom(env, providerUrl);
                    if (null != newPartitionName && !newPartitionName.equals(this.getPartitionName())) {
                        ComponentInvocationContextManager cicm = ComponentInvocationContextManager.getInstance(kernelId);
                        try (ManagedInvocationContext mic = cicm.setCurrentComponentInvocationContext(cicm.createComponentInvocationContext(newPartitionName));){
                            subject = this.authenticateLocally(user);
                        }
                    }
                    subject = this.authenticateLocally(user);
                }
                catch (LoginException le) {
                    WLInitialContextFactoryDelegate.popProtocol(env);
                    throw this.toNamingException(le);
                }
            } else {
                try {
                    subject = this.authenticateRemotely(protocol, env, user, rjvm, providerUrl);
                }
                catch (SecurityException | RemoteException se) {
                    WLInitialContextFactoryDelegate.popProtocol(env);
                    throw this.toNamingException(se);
                }
            }
        }
        if (subject != null) {
            env.setSecuritySubject(subject);
            JNDIEnvironment.getJNDIEnvironment().pushSubject(kernelId, subject);
        }
    }

    private AuthenticatedSubject authenticateLocally(UserInfo user) throws LoginException {
        String realmName = "weblogicDEFAULT";
        PrincipalAuthenticator pa = (PrincipalAuthenticator)SecurityServiceManager.getSecurityService(kernelId, realmName, SecurityService.ServiceType.AUTHENTICATION);
        AuthenticatedSubject subject = null;
        if (user instanceof DefaultUserInfoImpl) {
            DefaultUserInfoImpl u = (DefaultUserInfoImpl)user;
            SimpleCallbackHandler handler = new SimpleCallbackHandler(u.getName(), u.getPassword());
            subject = pa.authenticate(handler);
        }
        return subject;
    }

    private Protocol getProtocol(Environment env) throws MalformedURLException {
        String url = env.getProviderUrl();
        Protocol protocol = null;
        protocol = url == "local://" ? ProtocolManager.getProtocolByName("t3") : ProtocolManager.getProtocolByName(new ClientServerURL(url).getProtocol());
        if (protocol.isUnknown()) {
            throw new MalformedURLException("No support for protocol: " + url);
        }
        return protocol;
    }

    private AuthenticatedSubject authenticateRemotely(Protocol protocol, Environment env, UserInfo user, ServerIdentity id, String providerUrl) throws RemoteException {
        RJVM rjvm = RJVMManager.getRJVMManager().findOrCreate((JVMID)id);
        int timeout = (int)env.getResponseReadTimeout();
        AuthenticatedUser au = RemoteAuthenticate.authenticate(user, rjvm, protocol, env.getProviderChannel(), env.getEnableDefaultUser(), timeout, providerUrl);
        rjvm.setUser(providerUrl, au);
        return JNDIEnvironment.getJNDIEnvironment().getASFromAU(au);
    }

    private void popSubject(Environment env) {
        WLInitialContextFactoryDelegate.popProtocol(env);
        if (env.getSecuritySubject() != null) {
            SecurityServiceManager.popSubject(kernelId);
            JNDIEnvironment.getJNDIEnvironment().popSubject(kernelId);
        }
    }

    private static void pushProtocol(Environment env, Protocol protocol) {
        if (env.getProviderUrl() != "local://") {
            ProtocolStack.push(protocol);
        }
    }

    private static void popProtocol(Environment env) {
        if (env.getProviderUrl() != "local://") {
            ProtocolStack.pop();
        }
    }

    private final NamingException toNamingException(Throwable e) {
        boolean debugConn;
        NamingException ne = ExceptionTranslator.toNamingException(e);
        if (NamingDebugLogger.isDebugEnabled() && (debugConn = debugConnection.isDebugEnabled()) && ne instanceof CommunicationException) {
            String exceptionDesc = StackTraceUtils.throwable2StackTrace(ne.getRootCause());
            NamingDebugLogger.debug("Failed to create initial context due to: " + exceptionDesc);
        }
        return ne;
    }

    private String getPartitionName() {
        ComponentInvocationContext cic = ComponentInvocationContextManager.getInstance().getCurrentComponentInvocationContext();
        return cic.getPartitionName();
    }

    private String getPartitionName(String url) throws NamingException {
        String partitionName = null;
        try {
            partitionName = PartitionTable.getInstance().lookup(url).getPartitionName();
        }
        catch (URISyntaxException uriException) {
            NamingDebugLogger.debug("Failed to get partition name from url : " + url + "  because " + uriException.getMessage());
            throw this.toNamingException(uriException);
        }
        return partitionName;
    }

    private String getPartitionNameFrom(Environment env, String providerURL) throws NamingException {
        String partitionName = null;
        if (null != providerURL && !providerURL.startsWith("local://")) {
            partitionName = this.getPartitionName(providerURL);
        }
        if (null == partitionName) {
            partitionName = (String)env.getProperty("weblogic.jndi.partitionInformation");
        }
        return partitionName;
    }

    static {
        String s;
        JNDIEnvironment.getJNDIEnvironment().prepareSubjectManager();
        debugConnection = DebugLogger.getDebugLogger("DebugConnection");
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        preload = ExceptionTranslator.class;
        enableVisibilityControl = System.getProperty("weblogic.jndi.mt.enableVisibilityControl") == null ? true : Boolean.parseBoolean(System.getProperty("weblogic.jndi.mt.enableVisibilityControl"));
        ROOT_NODE_INTERFACES = new String[]{NamingNode.class.getName(), StubInfoIntf.class.getName()};
        DESC = new ClientMethodDescriptor("*", false, false, false, false, 0);
        STUB_INFO_CLASS = new Class[]{StubInfo.class};
        ROOT_NODE_DESCRIPTOR = new ClientRuntimeDescriptor(ROOT_NODE_INTERFACES, null, null, DESC, ServerHelper.getStubClassName(ROOT_NAMING_NODE_CLASS_NAME)).intern();
        NAMING_NODE_RA_INFO = new ReplicaAwareInfo("", NamingNodeReplicaHandler.class);
        keepEnvironmentUntilContextClose = false;
        if (KernelStatus.isServer() && (s = System.getProperty("weblogic.jndi.retainenvironment")) != null) {
            keepEnvironmentUntilContextClose = true;
        }
    }

    static class SingletonMaker {
        static final WLInitialContextFactoryDelegate singleton = new WLInitialContextFactoryDelegate();

        SingletonMaker() {
        }
    }
}

