/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi;

import com.bea.core.security.managers.ManagerFactory;
import com.bea.core.security.managers.SubjectManagerFactory;
import com.bea.core.security.managers.internal.ManagerFactoryImpl;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.net.ssl.SSLContext;
import weblogic.jndi.Environment;
import weblogic.jndi.internal.JNDIEnvironment;
import weblogic.jndi.internal.RemoteContextFactory;
import weblogic.jndi.internal.SSL.ClientSSLProxyImpl;
import weblogic.jndi.internal.SSL.SSLProxy;
import weblogic.jndi.internal.ThreadEnvironment;
import weblogic.protocol.ServerIdentity;
import weblogic.rjvm.RJVMEnvironment;
import weblogic.rmi.extensions.StubFactory;
import weblogic.rmi.extensions.server.CBVInputStream;
import weblogic.rmi.extensions.server.CBVOutputStream;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.acl.internal.AuthenticatedUser;
import weblogic.security.internal.encryption.EncryptionServiceException;
import weblogic.security.subject.SubjectManager;

public class WLSClientJNDIEnvironmentImpl
extends JNDIEnvironment {
    @Override
    public void nullSSLClientCertificate() {
    }

    @Override
    public SSLProxy getSSLProxy() {
        return new ClientSSLProxyImpl();
    }

    @Override
    public Object copyObjectViaSerialization(Object object) throws IOException, ClassNotFoundException {
        CBVOutputStream out = new CBVOutputStream();
        out.writeObject(object);
        out.flush();
        CBVInputStream in = out.makeCBVInputStream();
        return in.readObject();
    }

    @Override
    public void prepareKernel() {
    }

    @Override
    public void loadTransportableFactories(List transportableFactories) throws ConfigurationException {
    }

    @Override
    public Context getDelegateContext(ServerIdentity hostVM, Environment env, String subCtxName) throws RemoteException, NamingException {
        if (hostVM.isLocal()) {
            throw new UnsupportedOperationException("This method is not supported on the standalone WebLogic client");
        }
        RemoteContextFactory stub = (RemoteContextFactory)StubFactory.getStub(RemoteContextFactory.class, hostVM);
        return stub.getContext(env.getRemoteProperties(), subCtxName);
    }

    @Override
    public void prepareSubjectManager() {
    }

    @Override
    public void activateTransactionHelper() {
    }

    @Override
    public void deactivateTransactionHelper() {
    }

    @Override
    public void pushThreadEnvironment(Environment env) {
        if (env == null || env.getSecurityCredentials() == null || !(env.getSecurityCredentials() instanceof SSLContext)) {
            ThreadEnvironment.push(env);
            return;
        }
        RJVMEnvironment.getEnvironment().setSSLContext((SSLContext)env.getSecurityCredentials());
        env.setSecurityCredentials(null);
        ThreadEnvironment.push(env);
    }

    @Override
    public Environment popThreadEnvironment() {
        Environment env = ThreadEnvironment.pop();
        if (env == null) {
            return env;
        }
        if (RJVMEnvironment.getEnvironment().getSSLContext() != null) {
            env.setSecurityCredentials(RJVMEnvironment.getEnvironment().getSSLContext());
        }
        RJVMEnvironment.getEnvironment().setSSLContext(null);
        return env;
    }

    @Override
    public void pushSubject(AuthenticatedSubject kernelIdentity, AuthenticatedSubject userIdentity) {
        SubjectManager.getSubjectManager().pushSubject(kernelIdentity, userIdentity);
    }

    @Override
    public void popSubject(AuthenticatedSubject kernelIdentity) {
        SubjectManager.getSubjectManager().popSubject(kernelIdentity);
    }

    @Override
    public AuthenticatedSubject getCurrentSubject(AuthenticatedSubject kernelIdentity) {
        return (AuthenticatedSubject)SubjectManager.getSubjectManager().getCurrentSubject(kernelIdentity);
    }

    @Override
    public AuthenticatedSubject getASFromAU(AuthenticatedUser au) {
        return (AuthenticatedSubject)au;
    }

    @Override
    public ObjectOutput getReplacerObjectOutputStream(ObjectOutput out) throws IOException {
        return out;
    }

    @Override
    public ObjectInput getReplacerObjectInputStream(ObjectInput in) throws IOException {
        return in;
    }

    @Override
    public byte[] encryptionHelperDecrypt(byte[] credential, AuthenticatedSubject id) throws EncryptionServiceException {
        throw new UnsupportedOperationException("This method is not supported on the standalone WebLogic client");
    }

    @Override
    public byte[] encryptionHelperClear(byte[] credential) {
        throw new UnsupportedOperationException("This method is not supported on the standalone WebLogic client");
    }

    static {
        ManagerFactory.setInstance(new ManagerFactoryImpl());
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SubjectManager.installCESubjectManager(SubjectManagerFactory.getInstance().getSubjectManager());
                return null;
            }
        });
    }
}

