/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi.internal;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.spi.NamingManager;
import weblogic.jndi.internal.NamingDebugLogger;

public final class JNDIUtils {
    private static final boolean jndiAllowAllScheme = Boolean.getBoolean("wls.jndi.jndiAllowAllScheme");
    private static final String jndiAllowedSchemes = System.getProperty("wls.jndi.jndiAllowedSchemes", "");
    private static final List<String> jndiAllowedSchemesList = Arrays.asList(jndiAllowedSchemes.trim().split("\\s*,\\s*"));

    private JNDIUtils() {
    }

    private static void debug(String s) {
        if (NamingDebugLogger.isDebugEnabled()) {
            NamingDebugLogger.debug(s);
        }
    }

    public static boolean isAllowedScheme(String scheme) {
        return jndiAllowedSchemesList.size() > 0 && jndiAllowedSchemesList.contains(scheme);
    }

    public static boolean isValidJndiScheme(Name jndiName) {
        return JNDIUtils.isValidJndiScheme(jndiName, false);
    }

    public static boolean isValidJndiScheme(Name jndiName, boolean isAllowExternal) {
        if (jndiAllowAllScheme || jndiName == null || jndiName.size() == 0) {
            return true;
        }
        String jndiNameStr = jndiName.get(0);
        if (jndiNameStr.startsWith("java:")) {
            return true;
        }
        String scheme = JNDIUtils.getUrlScheme(jndiNameStr);
        if (scheme == null || scheme.isEmpty()) {
            return true;
        }
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
            Context ctx = NamingManager.getURLContext(scheme, new InitialContext(env).getEnvironment());
            if (ctx == null) {
                return true;
            }
            if (isAllowExternal && JNDIUtils.isAllowedScheme(scheme)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static String getUrlScheme(String str) {
        int colon_pos = str.indexOf(58);
        int slash_pos = str.indexOf(47);
        if (colon_pos > 0 && (slash_pos == -1 || colon_pos < slash_pos)) {
            return str.substring(0, colon_pos);
        }
        return null;
    }
}

