/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi.internal;

import java.util.List;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingListener;
import javax.naming.event.ObjectChangeListener;

public final class NotifyEventListeners {
    private final List<NamingListener> listeners;
    private final NamingEvent namingEvent;
    private final int action;

    NotifyEventListeners(List<NamingListener> listeners, NamingEvent namingEvent, int action) {
        this.listeners = listeners;
        this.namingEvent = namingEvent;
        this.action = action;
    }

    public void notifyListeners() {
        for (NamingListener listener : this.listeners) {
            if (listener instanceof ObjectChangeListener) {
                this.handleListener((ObjectChangeListener)listener);
                continue;
            }
            if (listener instanceof NamespaceChangeListener) {
                this.handleListener(this.action, (NamespaceChangeListener)listener);
                continue;
            }
            throw new AssertionError((Object)(" Unknown event listener " + listener + '\t' + (listener != null ? listener.getClass().getName() : "null")));
        }
    }

    private void handleListener(ObjectChangeListener l) {
        l.objectChanged(this.namingEvent);
    }

    private void handleListener(int action, NamespaceChangeListener l) {
        switch (action) {
            case 0: {
                l.objectAdded(this.namingEvent);
                break;
            }
            case 1: {
                l.objectRemoved(this.namingEvent);
                break;
            }
            case 2: {
                l.objectRenamed(this.namingEvent);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown action: " + action + " on listener " + l));
            }
        }
    }
}

