/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi.internal;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.spi.NamingManager;
import weblogic.common.WLObjectInput;
import weblogic.common.WLObjectOutput;
import weblogic.jndi.Alias;
import weblogic.jndi.Environment;
import weblogic.jndi.JNDILogger;
import weblogic.jndi.ThreadLocalMap;
import weblogic.jndi.internal.ExceptionTranslator;
import weblogic.jndi.internal.JNDIEnvironment;
import weblogic.jndi.internal.NamingNode;
import weblogic.jndi.internal.WLInternalContext;
import weblogic.jndi.internal.WLNameParser;
import weblogic.kernel.KernelStatus;
import weblogic.protocol.ProtocolStack;
import weblogic.rmi.extensions.server.RemoteWrapper;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.transaction.TransactionHelper;

public class WLContextImpl
implements WLInternalContext,
RemoteWrapper,
Externalizable {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    static final long serialVersionUID = -7759756621062870766L;
    private NamingNode node;
    private Hashtable env;
    private transient Thread loginThread = null;
    private transient boolean disableWarning = false;
    private transient boolean enableLogout;
    protected Environment environment = null;

    public WLContextImpl(Hashtable env, NamingNode node) {
        this.node = node;
        this.env = env;
        if (this.env != null) {
            this.env.remove("jmx.remote.protocol.provider.class.loader");
        }
        if (env != null && (env.containsKey("weblogic.rmi.clientTimeout") || env.containsKey("weblogic.jndi.responseReadTimeout"))) {
            this.environment = new Environment(env);
        }
        if (!this.isLocalURL()) {
            String propertyVal;
            this.loginThread = Thread.currentThread();
            if (env != null && (propertyVal = (String)env.get("weblogic.jndi.disableLoggingOfWarningMsg")) != null) {
                this.disableWarning = Boolean.parseBoolean(propertyVal);
            }
        }
    }

    @Override
    public Remote getRemoteDelegate() {
        return this.node;
    }

    @Override
    public void enableLogoutOnClose() {
        this.loginThread = Thread.currentThread();
        this.enableLogout = true;
    }

    @Override
    @Deprecated
    public void disableThreadWarningOnClose() {
        this.disableWarning = true;
    }

    @Override
    public void close() throws NamingException {
        if (this.loginThread != null) {
            if (this.loginThread != Thread.currentThread()) {
                if (!this.disableWarning) {
                    JNDILogger.logDiffThread();
                }
            } else {
                if (!this.isLocalURL()) {
                    ProtocolStack.pop();
                }
                if (this.enableLogout) {
                    SecurityServiceManager.popSubject(kernelId);
                    JNDIEnvironment.getJNDIEnvironment().nullSSLClientCertificate();
                }
            }
            this.loginThread = null;
        }
        JNDIEnvironment.getJNDIEnvironment().removeConnectionTimeout(this);
        TransactionHelper.popTransactionHelper();
    }

    private final boolean isLocalURL() {
        return this.env != null && this.env.get("java.naming.provider.url") == null && KernelStatus.isServer();
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        try {
            return this.node.createSubcontext(name, this.env);
        }
        catch (RemoteException re) {
            throw this.translateException(re);
        }
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        try {
            return this.node.lookupLink(name, this.env);
        }
        catch (RemoteException re) {
            throw this.translateException(re);
        }
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        try {
            this.node.destroySubcontext(name, this.env);
        }
        catch (RemoteException re) {
            throw this.translateException(re);
        }
    }

    @Override
    public void rebind(Name name, Object object) throws NamingException {
        try {
            this.node.rebind(name, object, this.env);
        }
        catch (RemoteException re) {
            throw this.translateException(re);
        }
    }

    @Override
    public void rebind(String name, Object object) throws NamingException {
        try {
            this.node.rebind(name, object, this.env);
        }
        catch (RemoteException re) {
            throw this.translateException(re);
        }
    }

    @Override
    public void rebind(String name, Object oldService, Object newService) throws NamingException {
        try {
            this.node.rebind(name, oldService, newService, this.env);
        }
        catch (RemoteException re) {
            throw this.translateException(re);
        }
    }

    @Override
    public NameParser getNameParser(Name ctxName) throws NamingException {
        return this.getNameParser(ctxName.toString());
    }

    @Override
    public NameParser getNameParser(String ctxName) throws NamingException {
        try {
            return this.node.getNameParser(ctxName, this.env);
        }
        catch (RemoteException re) {
            throw this.translateException(re);
        }
    }

    public NamingEnumeration list(Name ctxName) throws NamingException {
        return this.list(ctxName.toString());
    }

    public NamingEnumeration list(String ctxName) throws NamingException {
        try {
            return this.node.list(ctxName, this.env);
        }
        catch (RemoteException re) {
            throw this.translateException(re);
        }
    }

    @Override
    public Object removeFromEnvironment(String property) throws NamingException {
        Object value = null;
        if (this.env != null) {
            value = this.env.remove(property);
        }
        if (this.env.size() == 0) {
            this.env = null;
        }
        return value;
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    @Override
    public void unbind(String name) throws NamingException {
        try {
            this.node.unbind(name, null, this.env);
        }
        catch (RemoteException re) {
            throw this.translateException(re);
        }
    }

    @Override
    public void unbind(Name name, Object object) throws NamingException {
        this.unbind(name.toString(), object);
    }

    @Override
    public void unbind(String name, Object object) throws NamingException {
        try {
            this.node.unbind(name, object, this.env);
        }
        catch (RemoteException re) {
            throw this.translateException(re);
        }
    }

    @Override
    public Name composeName(Name suffix, Name prefix) throws NamingException {
        return new CompositeName(this.composeName(suffix.toString(), prefix.toString()));
    }

    @Override
    public String composeName(String suffix, String prefix) throws NamingException {
        if (prefix.length() == 0) {
            return prefix;
        }
        if (suffix.length() == 0) {
            return prefix;
        }
        return prefix + "." + suffix;
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        try {
            return this.node.getNameInNamespace();
        }
        catch (RemoteException re) {
            throw this.translateException(re);
        }
    }

    @Override
    public String getNameInNamespace(String relativeName) throws NamingException {
        try {
            return this.node.getNameInNamespace(relativeName);
        }
        catch (RemoteException re) {
            throw this.translateException(re);
        }
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.env;
    }

    public NamingEnumeration listBindings(Name ctxName) throws NamingException {
        return this.listBindings(ctxName.toString());
    }

    public NamingEnumeration listBindings(String ctxName) throws NamingException {
        try {
            return this.node.listBindings(ctxName, this.env);
        }
        catch (RemoteException re) {
            throw this.translateException(re);
        }
    }

    @Override
    public void rename(Name name1, Name name2) throws NamingException {
        this.rename(name1.toString(), name2.toString());
    }

    @Override
    public void rename(String name1, String name2) throws NamingException {
        try {
            this.node.rename(name1, name2, this.env);
        }
        catch (RemoteException re) {
            throw this.translateException(re);
        }
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        Object ret = this.lookup(name, name.toString());
        if (ret instanceof Alias) {
            String nameStr = ((Alias)ret).getRealName();
            ret = this.lookup(nameStr);
        }
        return ret;
    }

    @Override
    public Object lookup(String name) throws NamingException {
        Object ret = this.lookup(WLNameParser.defaultParse(name), name);
        if (ret instanceof Alias) {
            name = ((Alias)ret).getRealName();
            ret = this.lookup(name);
        }
        return ret;
    }

    protected Object lookup(Name name, String nameStr) throws NamingException {
        boolean pushedEnv = false;
        try {
            pushedEnv = this.pushEnvOntoThread();
            Object o = this.node.lookup(nameStr, this.env);
            ServerHelper.ensureJNDIName(o, nameStr);
            Object object = NamingManager.getObjectInstance(o, name, this, this.env);
            return object;
        }
        catch (RemoteException re) {
            throw this.translateException(re);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new NamingException(e.getMessage());
        }
        finally {
            if (pushedEnv) {
                ThreadLocalMap.pop();
            }
        }
    }

    protected boolean pushEnvOntoThread() {
        boolean pushedEnv = false;
        if (this.env != null && (this.env.containsKey("weblogic.jndi.responseReadTimeout") || this.env.containsKey("weblogic.rmi.clientTimeout") || this.env.containsKey("java.naming.provider.url"))) {
            ThreadLocalMap.push(this.env);
            pushedEnv = true;
        }
        return pushedEnv;
    }

    @Override
    public Object lookup(String nameStr, AuthenticatedSubject lookupID) throws NamingException, RemoteException {
        try {
            Object o = this.node.authenticatedLookup(nameStr, this.env, lookupID);
            Name name = WLNameParser.defaultParse(nameStr);
            return NamingManager.getObjectInstance(o, name, this, this.env);
        }
        catch (RemoteException re) {
            throw this.translateException(re);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new NamingException(e.getMessage());
        }
    }

    @Override
    public void bind(Name name, Object object) throws NamingException {
        this.bind(name.toString(), object);
    }

    @Override
    public void bind(String name, Object object) throws NamingException {
        try {
            this.node.bind(name, object, this.env);
        }
        catch (RemoteException re) {
            throw this.translateException(re);
        }
    }

    @Override
    public Object addToEnvironment(String property, Object value) throws NamingException {
        if (this.env == null) {
            this.env = new Hashtable(5);
        }
        return this.env.put(property, value);
    }

    public NamingNode getNode() {
        return this.node;
    }

    protected NamingException translateException(RemoteException re) {
        return ExceptionTranslator.toNamingException((Throwable)re);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        if (this.node != null) {
            return this.node.equals(((WLContextImpl)object).getNode());
        }
        return false;
    }

    public int hashCode() {
        return this.node == null ? 0 : this.node.hashCode();
    }

    public String toString() {
        try {
            return "WLContext (" + this.getNameInNamespace() + ")";
        }
        catch (NamingException ne) {
            return "WLContext ( NAME UNKNOWN )";
        }
    }

    public WLContextImpl() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (out instanceof WLObjectOutput) {
            WLObjectOutput wlOut = (WLObjectOutput)out;
            wlOut.writeObjectWL(this.node);
            wlOut.writeObjectWL(this.env);
        } else {
            ObjectOutput objOutput = JNDIEnvironment.getJNDIEnvironment().getReplacerObjectOutputStream(out);
            objOutput.writeObject(this.node);
            objOutput.writeObject(this.env);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (in instanceof WLObjectInput) {
            WLObjectInput wlIn = (WLObjectInput)in;
            this.node = (NamingNode)wlIn.readObjectWL();
            this.env = (Hashtable)wlIn.readObjectWL();
        } else {
            ObjectInput objInput = JNDIEnvironment.getJNDIEnvironment().getReplacerObjectInputStream(in);
            this.node = (NamingNode)objInput.readObject();
            this.env = (Hashtable)objInput.readObject();
        }
    }

    @Override
    public void bind(String name, Object obj, boolean allowCrossPartitionAccess) throws NamingException {
        this.env.put("weblogic.jndi.crossPartitionAware", String.valueOf(allowCrossPartitionAccess));
        try {
            this.node.bind(name, obj, this.env);
        }
        catch (RemoteException re) {
            throw this.translateException(re);
        }
        finally {
            this.env.remove("weblogic.jndi.crossPartitionAware");
        }
    }

    @Override
    public void bind(Name name, Object obj, boolean allowCrossPartitionAccess) throws NamingException {
        this.bind(name.toString(), obj, allowCrossPartitionAccess);
    }

    @Override
    public boolean isBindable(String name, Object boundObject) throws NamingException {
        boolean pushedEnv = false;
        try {
            pushedEnv = this.pushEnvOntoThread();
            boolean bl = this.node.isBindable(name, boundObject, this.env);
            return bl;
        }
        catch (RemoteException re) {
            throw this.translateException(re);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new NamingException(e.getMessage());
        }
        finally {
            if (pushedEnv) {
                ThreadLocalMap.pop();
            }
        }
    }

    @Override
    public boolean isBindable(String name, boolean isAggregatable) throws NamingException {
        boolean pushedEnv = false;
        try {
            pushedEnv = this.pushEnvOntoThread();
            boolean bl = this.node.isBindable(name, isAggregatable, this.env);
            return bl;
        }
        catch (RemoteException re) {
            throw this.translateException(re);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new NamingException(e.getMessage());
        }
        finally {
            if (pushedEnv) {
                ThreadLocalMap.pop();
            }
        }
    }
}

