/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi.internal;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.event.EventContext;
import javax.naming.event.NamingListener;
import javax.naming.spi.NamingManager;
import weblogic.common.internal.InteropWriteReplaceable;
import weblogic.common.internal.PeerInfo;
import weblogic.jndi.internal.JNDIEnvironment;
import weblogic.jndi.internal.NamingNode;
import weblogic.jndi.internal.WLContextImpl;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.rmi.internal.RMIEnvironment;
import weblogic.utils.AssertionError;

public final class WLEventContextImpl
extends WLContextImpl
implements EventContext,
Externalizable,
InteropWriteReplaceable {
    private List listeners = Collections.synchronizedList(new ArrayList());
    public static final String ENABLE_EVENTS = "weblogic.jndi.events.enable";
    private static final long serialVersionUID = -570490474896887060L;
    private NamingNode node;
    private Hashtable env;
    private boolean copyNotRequired;

    public WLEventContextImpl(Hashtable env, NamingNode node, boolean copyNotRequired) {
        super(env, node);
        this.node = node;
        this.env = env;
        this.copyNotRequired = copyNotRequired;
    }

    public WLEventContextImpl(Hashtable env, NamingNode node) {
        this(env, node, false);
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        try {
            if (this.node != null) {
                return this.node.createSubcontext(name, this.env);
            }
            return super.createSubcontext(name);
        }
        catch (RemoteException re) {
            throw this.translateException(re);
        }
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        try {
            if (this.node != null) {
                return this.node.lookupLink(name, this.env);
            }
            return super.lookupLink(name);
        }
        catch (RemoteException re) {
            throw this.translateException(re);
        }
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        try {
            if (this.node != null) {
                this.node.destroySubcontext(name, this.env);
            } else {
                super.destroySubcontext(name);
            }
        }
        catch (RemoteException re) {
            throw this.translateException(re);
        }
    }

    @Override
    public void rebind(String name, Object object) throws NamingException {
        try {
            if (this.node != null) {
                Object copy = this.copyObject(object);
                this.node.rebind(name, copy, this.env);
            } else {
                super.rebind(name, object);
            }
        }
        catch (RemoteException re) {
            throw this.translateException(re);
        }
    }

    @Override
    public void rebind(String name, Object oldObject, Object newObject) throws NamingException {
        try {
            if (this.node != null) {
                Object newCopy = this.copyObject(newObject);
                Object oldCopy = this.copyObject(oldObject);
                this.node.rebind(name, oldCopy, newCopy, this.env);
            } else {
                super.rebind(name, oldObject, newObject);
            }
        }
        catch (RemoteException re) {
            throw this.translateException(re);
        }
    }

    @Override
    public NameParser getNameParser(String ctxName) throws NamingException {
        try {
            if (this.node != null) {
                return this.node.getNameParser(ctxName, this.env);
            }
            return super.getNameParser(ctxName);
        }
        catch (RemoteException re) {
            throw this.translateException(re);
        }
    }

    @Override
    public NamingEnumeration list(String ctxName) throws NamingException {
        try {
            if (this.node != null) {
                return this.node.list(ctxName, this.env);
            }
            return super.list(ctxName);
        }
        catch (RemoteException re) {
            throw this.translateException(re);
        }
    }

    @Override
    public void unbind(String name) throws NamingException {
        try {
            if (this.node != null) {
                this.node.unbind(name, null, this.env);
            } else {
                super.unbind(name);
            }
        }
        catch (RemoteException re) {
            throw this.translateException(re);
        }
    }

    @Override
    public void unbind(String name, Object object) throws NamingException {
        int reset = 0;
        String oldValue = null;
        if (name.startsWith("sharable:")) {
            if (this.env == null) {
                this.env = new Hashtable();
                reset = 1;
            } else {
                reset = 2;
            }
            name = name.substring(9);
            oldValue = this.env.put("weblogic.jndi.createUnderSharable", "true");
        } else if (name.startsWith("domain:")) {
            if (this.env == null) {
                this.env = new Hashtable();
                reset = 1;
            } else {
                reset = 3;
            }
            name = name.substring(7);
            oldValue = this.env.put("weblogic.jndi.partitionInformation", "DOMAIN");
        } else if (name.startsWith("partition:")) {
            if (this.env == null) {
                this.env = new Hashtable();
                reset = 1;
            } else {
                reset = 4;
            }
            int resolvedPos = name.indexOf(47);
            String partitionInfo = null;
            if (resolvedPos == -1) {
                partitionInfo = name.substring(10);
                name = "";
            } else {
                partitionInfo = name.substring(10, resolvedPos);
                name = name.substring(resolvedPos + 1);
            }
            oldValue = this.env.put("weblogic.jndi.partitionInformation", partitionInfo);
        }
        try {
            if (this.node != null) {
                this.node.unbind(name, object, this.env);
            } else {
                super.unbind(name, object);
            }
        }
        catch (RemoteException re) {
            throw this.translateException(re);
        }
        finally {
            switch (reset) {
                case 1: {
                    this.env = null;
                    break;
                }
                case 2: {
                    if (oldValue == null) {
                        this.env.remove("weblogic.jndi.createUnderSharable");
                        break;
                    }
                    this.env.put("weblogic.jndi.createUnderSharable", oldValue);
                    break;
                }
                case 3: 
                case 4: {
                    if (oldValue == null) {
                        this.env.remove("weblogic.jndi.partitionInformation");
                        break;
                    }
                    this.env.put("weblogic.jndi.partitionInformation", oldValue);
                    break;
                }
            }
        }
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        try {
            if (this.node != null) {
                return this.node.getNameInNamespace();
            }
            return super.getNameInNamespace();
        }
        catch (RemoteException re) {
            throw this.translateException(re);
        }
    }

    @Override
    public String getNameInNamespace(String relativeName) throws NamingException {
        try {
            if (this.node != null) {
                return this.node.getNameInNamespace(relativeName);
            }
            return super.getNameInNamespace(relativeName);
        }
        catch (RemoteException re) {
            throw this.translateException(re);
        }
    }

    @Override
    public NamingEnumeration listBindings(String ctxName) throws NamingException {
        try {
            if (this.node != null) {
                return this.node.listBindings(ctxName, this.env);
            }
            return super.listBindings(ctxName);
        }
        catch (RemoteException re) {
            throw this.translateException(re);
        }
    }

    @Override
    public void rename(String name1, String name2) throws NamingException {
        try {
            if (this.node != null) {
                this.node.rename(name1, name2, this.env);
            } else {
                super.rename(name1, name2);
            }
        }
        catch (RemoteException re) {
            throw this.translateException(re);
        }
    }

    @Override
    protected Object lookup(Name name, String nameStr) throws NamingException {
        boolean pushedEnv = false;
        try {
            if (this.node != null) {
                pushedEnv = this.pushEnvOntoThread();
                Object o = this.node.lookup(nameStr, this.env);
                Object object = NamingManager.getObjectInstance(this.copyObject(o), name, this, this.env);
                return object;
            }
            Object o = super.lookup(name, nameStr);
            return o;
        }
        catch (RemoteException re) {
            throw this.translateException(re);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new NamingException(e.getMessage());
        }
        finally {
            if (pushedEnv) {
                RMIEnvironment.getEnvironment().threadEnvironmentPop();
            }
        }
    }

    @Override
    public void bind(String name, Object object) throws NamingException {
        try {
            if (this.node != null) {
                Object copy = this.copyObject(object);
                this.node.bind(name, copy, this.env);
            } else {
                super.bind(name, object);
            }
        }
        catch (RemoteException re) {
            throw this.translateException(re);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        if (this.node != null) {
            return this.node.equals(((WLEventContextImpl)object).node);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.node == null ? 0 : this.node.hashCode();
    }

    @Override
    public void addNamingListener(Name target, int scope, NamingListener l) throws NamingException {
        this.addNamingListener(target.toString(), scope, l);
    }

    @Override
    public void addNamingListener(String target, int scope, NamingListener l) throws NamingException {
        if (this.node == null) {
            throw new OperationNotSupportedException("Unsupported operationaddNamingListener");
        }
        this.node.addNamingListener(target, scope, l, this.env);
        this.listeners.add(l);
    }

    @Override
    public void removeNamingListener(NamingListener l) throws NamingException {
        if (this.node == null) {
            throw new OperationNotSupportedException("Unsupported operationaddNamingListener");
        }
        this.node.removeNamingListener(l, this.env);
        this.listeners.remove(l);
    }

    @Override
    public boolean targetMustExist() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws NamingException {
        super.close();
        List list = this.listeners;
        synchronized (list) {
            Iterator i = this.listeners.iterator();
            while (i.hasNext()) {
                NamingListener l = (NamingListener)i.next();
                if (this.node != null) {
                    this.node.removeNamingListener(l, this.env);
                }
                i.remove();
            }
        }
    }

    @Override
    public String toString() {
        try {
            return "EventContext (" + this.getNameInNamespace() + ")";
        }
        catch (NamingException ne) {
            return "EventContext ( NAME UNKNOWN )";
        }
    }

    private Object copyObject(Object object) throws RemoteException {
        if (this.copyNotRequired) {
            return object;
        }
        return JNDIEnvironment.getJNDIEnvironment().copyObject(object);
    }

    @Override
    public Object interopWriteReplace(PeerInfo peerInfo) throws IOException {
        int major = peerInfo.getMajor();
        int minor = peerInfo.getMinor();
        int servicePack = peerInfo.getServicePack();
        if (major == 7 && minor == 0 && servicePack >= 3 || major == 8 && minor == 1 && servicePack >= 1) {
            return new WLEventContextImpl(this.env, this.node);
        }
        return new WLContextImpl(this.env, this.node);
    }

    public WLEventContextImpl() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        try {
            NamingNode nd = this.getNode();
            if (ServerHelper.isLocal(nd)) {
                this.node = (NamingNode)ServerHelper.getServerReference(nd).getImplementation();
                this.env = this.getEnvironment();
                this.copyNotRequired = false;
                this.listeners = new ArrayList();
            }
        }
        catch (NamingException ne) {
            throw new AssertionError("Unexpected exception", ne);
        }
    }

    public Object readResolve() throws ObjectStreamException {
        if (this.node != null) {
            return this;
        }
        try {
            return new WLContextImpl(this.getEnvironment(), this.getNode());
        }
        catch (NamingException ne) {
            throw new AssertionError("Unexpected exception", ne);
        }
    }

    @Override
    public void bind(String name, Object obj, boolean allowCrossPartitionAccess) throws NamingException {
        if (this.node != null) {
            this.env.put("weblogic.jndi.crossPartitionAware", String.valueOf(allowCrossPartitionAccess));
            try {
                this.node.bind(name, this.copyObject(obj), this.env);
            }
            catch (RemoteException re) {
                throw this.translateException(re);
            }
            finally {
                this.env.remove("weblogic.jndi.crossPartitionAware");
            }
        } else {
            super.bind(name, obj, allowCrossPartitionAccess);
        }
    }
}

