/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi.internal;

import java.security.AccessController;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.naming.CompositeName;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkException;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Referenceable;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.StateFactory;
import weblogic.jndi.ClassTypeOpaqueReference;
import weblogic.jndi.OpaqueReference;
import weblogic.jndi.ThreadLocalMap;
import weblogic.jndi.internal.JNDIEnvironment;
import weblogic.jndi.internal.JNDIUtils;
import weblogic.jndi.internal.NamingFactoriesDebugLogger;
import weblogic.jndi.internal.WLContextImpl;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.ServiceFailureException;

public final class WLNamingManager {
    private static volatile List<ObjectFactory> transportableFactories = null;
    private static volatile List<StateFactory> stateFactories = null;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() throws ServiceFailureException {
        Class<WLNamingManager> clazz = WLNamingManager.class;
        synchronized (WLNamingManager.class) {
            if (transportableFactories == null) {
                transportableFactories = new CopyOnWriteArrayList<ObjectFactory>();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            try {
                JNDIEnvironment.getJNDIEnvironment().loadTransportableFactories(transportableFactories);
            }
            catch (ConfigurationException e) {
                throw new ServiceFailureException(e);
            }
            return;
        }
    }

    public static void addStateFactory(StateFactory factory) throws NamingException {
        if (stateFactories == null) {
            WLNamingManager.loadStateFactories();
        }
        stateFactories.add(0, factory);
    }

    public static void addTransportableFactory(ObjectFactory factory) {
        transportableFactories.add(0, factory);
    }

    public static Object getObjectInstance(Object boundObject, Name name, Context ctx, Hashtable env) throws NamingException {
        if (boundObject instanceof ClassTypeOpaqueReference) {
            Hashtable jndiEnv = ThreadLocalMap.get();
            boundObject = jndiEnv != null && Boolean.parseBoolean((String)jndiEnv.get("weblogic.jndi.onlyGetClassType")) ? ((ClassTypeOpaqueReference)boundObject).getObjectClass() : ((OpaqueReference)boundObject).getReferent(name, ctx);
        } else if (boundObject instanceof OpaqueReference) {
            boundObject = ((OpaqueReference)boundObject).getReferent(name, ctx);
        } else if (boundObject instanceof LinkRef) {
            String linkName = ((LinkRef)boundObject).getLinkName();
            if (!JNDIUtils.isValidJndiScheme(new CompositeName(linkName), true)) {
                throw new NamingException("JNDI name is invalid - " + linkName);
            }
            InitialContext ic = null;
            try {
                ic = new InitialContext(env);
                boundObject = ic.lookup(linkName);
            }
            catch (NamingException e) {
                LinkException le = new LinkException("");
                le.setLinkRemainingName(new CompositeName(linkName));
                le.setLinkResolvedName(name);
                le.setLinkResolvedObj(boundObject);
                le.setRootCause(e);
                throw le;
            }
            finally {
                try {
                    ic.close();
                }
                catch (Exception exception) {}
            }
        }
        return boundObject;
    }

    public static Object getTransportableInstance(Object boundObject, Name name, Context ctx, Hashtable env) throws NamingException {
        return WLNamingManager.getReplacement(transportableFactories, boundObject, name, ctx, env);
    }

    public static Object getStateToBind(Object objectToBind, Name name, Context ctx, Hashtable env) throws NamingException {
        if (objectToBind instanceof WLContextImpl) {
            return ((WLContextImpl)objectToBind).getNode();
        }
        if (objectToBind instanceof Referenceable) {
            return ((Referenceable)objectToBind).getReference();
        }
        Object replacement = NamingManager.getStateToBind(objectToBind, name, ctx, env);
        if (replacement == objectToBind) {
            if (stateFactories == null) {
                WLNamingManager.loadStateFactories();
            }
            replacement = WLNamingManager.getReplacement(stateFactories, objectToBind, name, ctx, env);
        }
        return replacement;
    }

    private static Object getReplacement(List replacerList, Object object, Name name, Context ctx, Hashtable env) throws NamingException {
        Object replacement = object;
        if (replacerList == null) {
            return replacement;
        }
        for (Object f : replacerList) {
            Object newObject = null;
            try {
                newObject = f instanceof ObjectFactory ? ((ObjectFactory)f).getObjectInstance(object, name, ctx, env) : ((StateFactory)f).getStateToBind(object, name, ctx, env);
                if (newObject == null) continue;
                replacement = newObject;
                break;
            }
            catch (NamingException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                ConfigurationException ce = new ConfigurationException(f.getClass().getName() + " threw an exception");
                ce.setRootCause(e);
                throw ce;
            }
        }
        if (NamingFactoriesDebugLogger.isDebugEnabled() && replacement != object) {
            NamingFactoriesDebugLogger.debug("Replacing " + object.getClass().getName() + " with " + replacement.getClass().getName());
        }
        return replacement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadStateFactories() {
        Class<WLNamingManager> clazz = WLNamingManager.class;
        synchronized (WLNamingManager.class) {
            if (stateFactories == null) {
                stateFactories = new CopyOnWriteArrayList<StateFactory>();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

