/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi.remote;

import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import weblogic.jndi.internal.WLNamingManager;
import weblogic.jndi.remote.AttributeWrapper;
import weblogic.jndi.remote.RemoteAttributes;
import weblogic.rmi.extensions.RemoteRuntimeException;

public final class AttributesWrapper
implements RemoteAttributes {
    private Attributes delegate;
    private Hashtable env;

    protected Hashtable env() {
        return this.env;
    }

    protected Attributes delegate() {
        return this.delegate;
    }

    public AttributesWrapper(Attributes delegate, Hashtable env) {
        this.delegate = delegate;
        this.env = env;
    }

    @Override
    public Object clone() {
        return this.makeTransportable(this.delegate.clone());
    }

    @Override
    public Attribute get(String attrName) {
        return this.makeTransportable(this.delegate.get(attrName));
    }

    public NamingEnumeration getAll() {
        return this.makeTransportable(this.delegate.getAll());
    }

    public NamingEnumeration getIDs() {
        return this.makeTransportable(this.delegate.getIDs());
    }

    @Override
    public boolean isCaseIgnored() {
        return this.delegate.isCaseIgnored();
    }

    @Override
    public Attribute put(Attribute attr) {
        Attribute realAttr = attr;
        if (attr instanceof AttributeWrapper) {
            realAttr = ((AttributeWrapper)attr).delegate();
        }
        return this.makeTransportable(this.delegate.put(realAttr));
    }

    @Override
    public Attribute put(String name, Object value) {
        return this.makeTransportable(this.delegate.put(name, value));
    }

    @Override
    public Attribute remove(String attrName) {
        return this.makeTransportable(this.delegate.remove(attrName));
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    protected final Object makeTransportable(Object object) {
        try {
            return WLNamingManager.getTransportableInstance(object, null, null, this.env);
        }
        catch (NamingException e) {
            throw new RemoteRuntimeException("Failed to create a transportable instance of " + object + " due to :", e);
        }
    }

    protected final NamingEnumeration makeTransportable(NamingEnumeration enum_) {
        return (NamingEnumeration)this.makeTransportable((Object)enum_);
    }

    protected final Attribute makeTransportable(Attribute attr) {
        return (Attribute)this.makeTransportable((Object)attr);
    }
}

