/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi.spi;

import java.util.Locale;
import javax.naming.NamingException;
import weblogic.jndi.WLInitialContextFactoryDelegate;
import weblogic.jndi.spi.EnvironmentFactory;
import weblogic.utils.collections.ConcurrentHashMap;

public final class EnvironmentManager {
    public static final ConcurrentHashMap registeredFactories = new ConcurrentHashMap(11);
    private static final Object NULL_FACTORY = new Object();

    public static EnvironmentFactory getInstance(String protocol) throws NamingException {
        Object ef = registeredFactories.get(protocol = protocol.toLowerCase(Locale.ENGLISH));
        if (ef == null) {
            try {
                ef = Class.forName("weblogic.factories." + protocol + "." + protocol + "EnvironmentFactory", true, Thread.currentThread().getContextClassLoader()).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                ef = DefaultFactoryMaker.DEFAULT_FACTORY;
            }
            catch (InstantiationException ie) {
                ef = NULL_FACTORY;
            }
            catch (IllegalAccessException iae) {
                ef = NULL_FACTORY;
            }
            registeredFactories.put(protocol, ef);
        }
        if (ef == NULL_FACTORY) {
            throw new NamingException("No registered factory for " + protocol);
        }
        return (EnvironmentFactory)ef;
    }

    private static final class DefaultFactoryMaker {
        private static final EnvironmentFactory DEFAULT_FACTORY = WLInitialContextFactoryDelegate.theOne();

        private DefaultFactoryMaker() {
        }
    }
}

