/*
 * Decompiled with CFR 0.152.
 */
package weblogic.kernel;

import java.util.ArrayList;
import weblogic.health.HealthState;
import weblogic.health.Symptom;
import weblogic.kernel.ExecuteRequest;
import weblogic.kernel.ExecuteThread;
import weblogic.kernel.Kernel;
import weblogic.kernel.KernelStatus;
import weblogic.kernel.QueueFullException;
import weblogic.kernel.ServerExecuteThread;
import weblogic.kernel.T3SrvrLogger;
import weblogic.management.configuration.ExecuteQueueMBean;
import weblogic.utils.UnsyncCircularQueue;
import weblogic.utils.collections.Stack;

public class ExecuteThreadManager {
    private static boolean netscape = false;
    private static final ShutdownRequest SHUTDOWN_REQUEST = new ShutdownRequest();
    private final String name;
    private final ThreadGroup threadGroup;
    private final UnsyncCircularQueue q;
    private final ArrayList threads;
    private final Stack idleThreads;
    private boolean shutdownRequested = false;
    private int departures = 0;
    private final Object printOnceLock = new Object();
    private boolean capacityGreaterThanThreshold = false;
    private Symptom healthSymptom;
    private int healthState = 0;
    private final ExecuteQueueMBean queueMBean;

    protected ExecuteThreadManager(String name) {
        this.name = name;
        this.threadGroup = null;
        this.q = null;
        this.threads = null;
        this.idleThreads = null;
        this.queueMBean = null;
    }

    ExecuteThreadManager(String policyName, ExecuteQueueMBean queueBean) {
        this.name = policyName;
        this.queueMBean = queueBean;
        this.q = new UnsyncCircularQueue(256, queueBean.getQueueLength());
        this.idleThreads = new Stack(queueBean.getThreadCount());
        this.threads = new ArrayList(queueBean.getThreadCount());
        ThreadGroup tg = null;
        try {
            tg = new ThreadGroup("Thread Group for Queue: '" + policyName + "'");
        }
        catch (SecurityException e) {
            System.err.println("Caught a security exception. That's okay.");
            netscape = true;
        }
        this.threadGroup = tg;
        this.setThreadCount(queueBean.getThreadCount());
    }

    private int getThreadsIncrease() {
        return this.queueMBean != null ? this.queueMBean.getThreadsIncrease() : 0;
    }

    private int getThreadsMaximum() {
        return this.queueMBean != null ? this.queueMBean.getThreadsMaximum() : 0;
    }

    private int getCalculatedPercent() {
        if (this.queueMBean == null) {
            return 0;
        }
        return Math.max(this.queueMBean.getQueueLength() * this.queueMBean.getQueueLengthThresholdPercent() / 100, 1);
    }

    public boolean isShutdownInProgress() {
        return this.shutdownRequested;
    }

    ExecuteThread[] getExecuteThreads() {
        return this.threads.toArray(new ExecuteThread[this.threads.size()]);
    }

    public int getExecuteQueueDepth() {
        return this.q.size();
    }

    public int getExecuteQueueSize() {
        return this.q.capacity();
    }

    public int getExecuteQueueDepartures() {
        return this.departures;
    }

    public int getExecuteThreadCount() {
        return this.threads.size();
    }

    public final String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadCount(int count) throws SecurityException {
        int firstNew;
        ExecuteThreadManager executeThreadManager = this;
        synchronized (executeThreadManager) {
            if (this.shutdownRequested) {
                throw new IllegalStateException("Shutdown in progress");
            }
            int threadsMaximum = this.getThreadsMaximum();
            if (count > threadsMaximum) {
                count = threadsMaximum;
            }
            if (count <= this.threads.size()) {
                return;
            }
            int threadPriority = this.queueMBean != null ? this.queueMBean.getThreadPriority() : 5;
            for (int i = firstNew = this.threads.size(); i < count; ++i) {
                ExecuteThread thread;
                if (netscape) {
                    thread = ExecuteThreadManager.createExecuteThread(i, this);
                } else {
                    try {
                        thread = ExecuteThreadManager.createExecuteThread(i, this, this.threadGroup);
                        thread.setDaemon(true);
                    }
                    catch (SecurityException se) {
                        System.err.println("Caught a security exception. That's okay.");
                        netscape = true;
                        thread = ExecuteThreadManager.createExecuteThread(i, this);
                    }
                }
                thread.setPriority(threadPriority);
                this.threads.add(thread);
            }
        }
        this.startThreads(firstNew);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startThreads(int firstNew) {
        ArrayList arrayList = this.threads;
        synchronized (arrayList) {
            for (int i = firstNew; i < this.threads.size(); ++i) {
                ExecuteThread thread = (ExecuteThread)this.threads.get(i);
                if (thread == null) continue;
                thread.start();
                if (thread.isStarted()) continue;
                try {
                    Thread.sleep(5L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private void expandThreadPool() {
        int threadsIncrease = this.getThreadsIncrease();
        if (this.threads.size() == 0) {
            this.setThreadCount(threadsIncrease);
        } else if (this.q.size() + 1 >= this.getCalculatedPercent()) {
            this.capacityGreaterThanThreshold = true;
            Symptom symptom = new Symptom(Symptom.SymptomType.EXECUTEQUEUE_OVERFLOW, Symptom.Severity.MEDIUM, this.queueMBean.getName(), "Queue Capacity greater than configured threshold of " + this.queueMBean.getQueueLengthThresholdPercent() + "%.  Will try to allocate: '" + threadsIncrease + "' threads to help.");
            this.setHealthState(1, symptom);
            this.setThreadCount(this.threads.size() + threadsIncrease);
        } else if (this.healthState != 0) {
            this.capacityGreaterThanThreshold = false;
            this.setHealthState(0, null);
        }
    }

    synchronized ExecuteThread[] getStuckExecuteThreads(long maxTime) {
        long currentTime = System.currentTimeMillis();
        ArrayList<ExecuteThread> stuckThreadList = null;
        if (this.threads.size() == 0 || maxTime == 0L) {
            return null;
        }
        for (int i = 0; i < this.threads.size(); ++i) {
            long elapsedTime;
            long timeStamp;
            ExecuteThread thread = (ExecuteThread)this.threads.get(i);
            if (thread == null || thread.getSystemThread() || thread.getCurrentRequest() == null || (timeStamp = thread.getTimeStamp()) <= 0L || (elapsedTime = currentTime - timeStamp) <= maxTime) continue;
            thread.setPrintStuckThreadMessage(true);
            if (stuckThreadList == null) {
                stuckThreadList = new ArrayList<ExecuteThread>();
            }
            stuckThreadList.add(thread);
        }
        int threadsIncrease = this.getThreadsIncrease();
        if (stuckThreadList != null && stuckThreadList.size() == this.threads.size()) {
            Symptom symptom = new Symptom(Symptom.SymptomType.STUCK_THREADS, Symptom.Severity.HIGH, this.name, "All Threads are stuck.  Will try to allocate: '" + threadsIncrease + "' threads to help.");
            this.setHealthState(2, symptom);
            this.setThreadCount(this.threads.size() + threadsIncrease);
        } else if (this.healthState != 0) {
            this.setHealthState(0, null);
        }
        return stuckThreadList != null ? stuckThreadList.toArray(new ExecuteThread[stuckThreadList.size()]) : null;
    }

    synchronized void shutdown() throws SecurityException {
        if (this.shutdownRequested) {
            return;
        }
        this.shutdownRequested = true;
        while (this.idleThreads.size() != 0) {
            ExecuteThread t = (ExecuteThread)this.idleThreads.pop();
            t.notifyRequest(SHUTDOWN_REQUEST);
        }
    }

    public int getIdleThreadCount() {
        return this.idleThreads.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerIdle(ExecuteThread t) {
        ExecuteRequest req;
        if (t.getPrintStuckThreadMessage()) {
            T3SrvrLogger.logInfoUnstuckThread(t.getName());
            t.setPrintStuckThreadMessage(false);
        }
        ExecuteThreadManager executeThreadManager = this;
        synchronized (executeThreadManager) {
            req = this.shutdownRequested ? SHUTDOWN_REQUEST : (ExecuteRequest)this.q.get();
            if (req == null) {
                this.idleThreads.push(t);
                return;
            }
        }
        t.setRequest(req);
        ++this.departures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(ExecuteRequest r, boolean mayThrottle) {
        ExecuteThread t;
        if (mayThrottle && Kernel.isQueueThrottleAllowed()) {
            int queueLength = this.queueMBean.getQueueLength();
            if (this.q.size() >= queueLength) {
                throw new QueueFullException(queueLength);
            }
        }
        try {
            ExecuteThreadManager executeThreadManager = this;
            synchronized (executeThreadManager) {
                block10: {
                    if (this.idleThreads.size() != 0) break block10;
                    this.expandThreadPool();
                    this.q.put(r);
                    return;
                }
                t = (ExecuteThread)this.idleThreads.pop();
            }
        }
        finally {
            this.logQueueCapacityWarning();
        }
        ++this.departures;
        t.notifyRequest(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logQueueCapacityWarning() {
        boolean doLog = false;
        Object object = this.printOnceLock;
        synchronized (object) {
            if (this.capacityGreaterThanThreshold) {
                doLog = true;
                this.capacityGreaterThanThreshold = false;
            }
        }
        int threadsIncrease = this.getThreadsIncrease();
        if (doLog && threadsIncrease != 0 && this.threads.size() + threadsIncrease <= this.getThreadsMaximum()) {
            T3SrvrLogger.logWarnQueueCapacityGreaterThanThreshold(this.queueMBean.getQueueLengthThresholdPercent(), threadsIncrease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean executeIfIdle(ExecuteRequest r) {
        ExecuteThread t;
        ExecuteThreadManager executeThreadManager = this;
        synchronized (executeThreadManager) {
            if (this.idleThreads.size() == 0) {
                return false;
            }
            t = (ExecuteThread)this.idleThreads.pop();
        }
        ++this.departures;
        t.notifyRequest(r);
        return true;
    }

    private void setHealthState(int state, Symptom symptom) {
        this.healthState = state;
        this.healthSymptom = symptom;
    }

    public HealthState getHealthState() {
        return new HealthState(this.healthState, this.healthSymptom);
    }

    int getPendingTasksCount() {
        int taskCount = 0;
        if (this.threads.size() == 0) {
            return 0;
        }
        for (int i = 0; i < this.threads.size(); ++i) {
            ExecuteRequest request;
            ExecuteThread thread = (ExecuteThread)this.threads.get(i);
            if (thread == null || thread.getSystemThread() || (request = thread.getCurrentRequest()) == null) continue;
            ++taskCount;
        }
        return taskCount += this.getExecuteQueueDepth();
    }

    public final synchronized String toString() {
        return super.toString() + " - name: '" + this.getName() + "' threads: '" + this.getExecuteThreadCount() + "' idle: '" + this.getIdleThreadCount() + " departures: '" + this.getExecuteQueueDepartures() + "' queue:\n\t" + this.q;
    }

    private static ExecuteThread createExecuteThread(int which, ExecuteThreadManager etm) {
        if (KernelStatus.isApplet()) {
            return new ExecuteThread(which, etm);
        }
        return new ServerExecuteThread(which, etm);
    }

    private static ExecuteThread createExecuteThread(int which, ExecuteThreadManager etm, ThreadGroup tg) {
        if (KernelStatus.isApplet()) {
            return new ExecuteThread(which, etm, tg);
        }
        return new ServerExecuteThread(which, etm, tg);
    }

    static final class ShutdownError
    extends Error {
        ShutdownError() {
        }
    }

    private static final class ShutdownRequest
    implements ExecuteRequest {
        private ShutdownRequest() {
        }

        @Override
        public void execute(ExecuteThread thd) {
            throw new ShutdownError();
        }
    }
}

