/*
 * Decompiled with CFR 0.152.
 */
package weblogic.kernel;

import weblogic.kernel.MBeanStub;
import weblogic.management.configuration.IIOPMBean;

final class IIOPMBeanStub
extends MBeanStub
implements IIOPMBean {
    private int defaultGIOPMinorVersion = 2;
    private String iiopLocationForwardPolicy = "failover";
    private boolean useIIOPLocateRequest = false;
    private boolean useFullRepositoyIdList = false;
    private String iiopTxMechanism = "ots";
    private int idleIIOPConnectionTimeout = 240000;
    private String charCodeset = "US-ASCII";
    private String wcharCodeset = "UCS-2";
    public String systemSecurity = "none";
    private boolean statefulAuthentication = true;
    private boolean useSFV2 = false;
    private boolean enableIORServlet = false;
    private boolean useJavaSerialization = false;

    IIOPMBeanStub() {
        this.initializeFromSystemProperties("weblogic.iiop.");
    }

    @Override
    public int getMaxMessageSize() {
        return 10000000;
    }

    @Override
    public void setMaxMessageSize(int maxsize) {
    }

    @Override
    public int getCompleteMessageTimeout() {
        return 60;
    }

    @Override
    public void setCompleteMessageTimeout(int seconds) {
    }

    @Override
    public int getDefaultMinorVersion() {
        return this.defaultGIOPMinorVersion;
    }

    @Override
    public void setDefaultMinorVersion(int minor) {
        this.defaultGIOPMinorVersion = minor;
    }

    @Override
    public String getLocationForwardPolicy() {
        return this.iiopLocationForwardPolicy;
    }

    @Override
    public void setLocationForwardPolicy(String lcpolicy) {
        this.iiopLocationForwardPolicy = lcpolicy;
    }

    @Override
    public boolean getUseLocateRequest() {
        return this.useIIOPLocateRequest;
    }

    @Override
    public void setUseLocateRequest(boolean locate) {
        this.useIIOPLocateRequest = locate;
    }

    @Override
    public boolean getUseFullRepositoryIdList() {
        return this.useFullRepositoyIdList;
    }

    @Override
    public void setUseFullRepositoryIdList(boolean full) {
        this.useFullRepositoyIdList = full;
    }

    @Override
    public String getTxMechanism() {
        return this.iiopTxMechanism;
    }

    @Override
    public void setTxMechanism(String txmech) {
        this.iiopTxMechanism = txmech;
    }

    @Override
    public int getIdleConnectionTimeout() {
        return this.idleIIOPConnectionTimeout / 1000;
    }

    @Override
    public void setIdleConnectionTimeout(int seconds) {
        this.idleIIOPConnectionTimeout = seconds * 1000;
    }

    @Override
    public String getDefaultCharCodeset() {
        return this.charCodeset;
    }

    @Override
    public void setDefaultCharCodeset(String codeset) {
        this.charCodeset = codeset;
    }

    @Override
    public String getDefaultWideCharCodeset() {
        return this.wcharCodeset;
    }

    @Override
    public void setDefaultWideCharCodeset(String codeset) {
        this.wcharCodeset = codeset;
    }

    @Override
    public String getSystemSecurity() {
        return this.systemSecurity;
    }

    @Override
    public void setSystemSecurity(String value) {
        this.systemSecurity = value;
    }

    @Override
    public boolean getUseStatefulAuthentication() {
        return this.statefulAuthentication;
    }

    @Override
    public void setUseStatefulAuthentication(boolean auth) {
        this.statefulAuthentication = auth;
    }

    @Override
    public boolean getUseSerialFormatVersion2() {
        return this.useSFV2;
    }

    @Override
    public void setUseSerialFormatVersion2(boolean sfv) {
        this.useSFV2 = sfv;
    }

    @Override
    public boolean getEnableIORServlet() {
        return this.enableIORServlet;
    }

    @Override
    public void setEnableIORServlet(boolean flag) {
        this.enableIORServlet = flag;
    }

    @Override
    public boolean getUseJavaSerialization() {
        return this.useJavaSerialization;
    }

    @Override
    public void setUseJavaSerialization(boolean use) {
        this.useJavaSerialization = use;
    }
}

