/*
 * Decompiled with CFR 0.152.
 */
package weblogic.kernel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.management.InvalidAttributeValueException;
import org.jvnet.hk2.annotations.Service;
import weblogic.common.internal.VersionInfoFactory;
import weblogic.kernel.ExecuteQueueMBeanStub;
import weblogic.kernel.ExecuteRequest;
import weblogic.kernel.ExecuteThread;
import weblogic.kernel.ExecuteThreadManager;
import weblogic.kernel.KernelEnvironment;
import weblogic.kernel.KernelLogger;
import weblogic.kernel.KernelMBeanStub;
import weblogic.kernel.KernelStatus;
import weblogic.kernel.KernelTypeService;
import weblogic.management.configuration.ExecuteQueueMBean;
import weblogic.management.configuration.KernelDebugMBean;
import weblogic.management.configuration.KernelMBean;
import weblogic.protocol.ClientEnvironment;
import weblogic.utils.StackTraceUtils;
import weblogic.work.ExecuteQueueFactory;

public final class Kernel
extends KernelStatus {
    private static final String ALLOW_QUEUE_THROTTLE = "weblogic.kernel.allowQueueThrottling";
    private static final int DIRECT = 0;
    private static KernelMBean config;
    private static ExecuteThreadManager[] queues;
    private static final HashMap policyNameAlias;
    private static final ArrayList applicationQueueNames;
    private static int defaultDispatchIndex;
    private static boolean isTracingEnabled;
    private static final boolean allowQueueThrottling;

    private static final boolean initAllowThrottleProp() {
        if (Kernel.isApplet()) {
            return false;
        }
        return Boolean.getBoolean(ALLOW_QUEUE_THROTTLE);
    }

    public static final boolean isTracingEnabled() {
        return isTracingEnabled;
    }

    public static boolean isInitialized() {
        return config != null;
    }

    public static synchronized void ensureInitialized() {
        Kernel.initialized();
        if (config == null) {
            try {
                KernelMBeanStub kmb = new KernelMBeanStub();
                Kernel.initialize(kmb);
            }
            catch (Throwable t) {
                throw new InternalError("error initializing kernel caused by: " + StackTraceUtils.throwable2StackTrace(t));
            }
        }
    }

    public static synchronized void initialize(KernelMBean kmb) {
        Kernel.initialized();
        if (config != null) {
            throw new AssertionError((Object)"Kernel was initialized more than once");
        }
        config = kmb;
        Kernel.setIsConfigured();
        isTracingEnabled = config.getTracingEnabled();
        VersionInfoFactory.initialize(Kernel.isServer());
        ClientEnvironment.loadEnvironment();
        policyNameAlias.put("weblogic.kernel.Default", "default");
        if (kmb.getUse81StyleExecuteQueues()) {
            if (Kernel.isServer()) {
                KernelLogger.logInitializingKernelDelegator();
            }
            ExecuteQueueFactory.initialize(kmb);
        }
        defaultDispatchIndex = Kernel.getDispatchPolicyIndex("weblogic.kernel.Default");
    }

    public static KernelMBean getConfig() {
        if (!Kernel.isServer() && !Kernel.isInitialized()) {
            Kernel.ensureInitialized();
        }
        return config;
    }

    public static KernelDebugMBean getDebug() {
        return config.getKernelDebug();
    }

    public static ExecuteThreadManager getExecuteThreadManager(String policyName) {
        int index = Kernel.getDispatchPolicyIndex(policyName);
        return queues[index];
    }

    static ExecuteThreadManager[] getExecuteThreadManagers() {
        return queues;
    }

    public static void execute(ExecuteRequest er) {
        Kernel.execute(er, false);
    }

    public static void execute(ExecuteRequest er, boolean mayThrottle) {
        queues[defaultDispatchIndex].execute(er, mayThrottle);
    }

    public static void execute(ExecuteRequest er, int policyIndex) {
        Kernel.execute(er, policyIndex, false);
    }

    public static void execute(ExecuteRequest er, int policyIndex, boolean mayThrottle) {
        if (policyIndex == 0) {
            Kernel.executeLocally(er);
        } else {
            queues[policyIndex].execute(er, mayThrottle);
        }
    }

    private static void executeLocally(ExecuteRequest er) {
        try {
            er.execute(null);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (ExecuteThreadManager.ShutdownError se) {
            throw se;
        }
        catch (Throwable t) {
            if (!Kernel.isApplet()) {
                KernelLogger.logExecuteFailed(t);
            }
            t.printStackTrace();
        }
    }

    public static void execute(ExecuteRequest er, String policyName) {
        Kernel.execute(er, policyName, false);
    }

    public static void execute(ExecuteRequest er, String policyName, boolean mayThrottle) {
        Kernel.execute(er, Kernel.getDispatchPolicyIndex(policyName), mayThrottle);
    }

    public static void executeIfIdle(ExecuteRequest er, int policyIndex) {
        if (policyIndex == 0 || !queues[policyIndex].executeIfIdle(er)) {
            Thread t = Thread.currentThread();
            if (t instanceof ExecuteThread) {
                ((ExecuteThread)t).execute(er);
            } else {
                try {
                    er.execute(null);
                }
                catch (Exception e) {
                    throw new InternalError("Error executing the request on a Non-kernel Thread: " + StackTraceUtils.throwable2StackTrace(e));
                }
            }
        }
    }

    public static void executeIfIdle(ExecuteRequest er, String policyName) {
        Kernel.executeIfIdle(er, Kernel.getDispatchPolicyIndex(policyName));
    }

    public static int getExecuteQueueDepth() {
        return queues[defaultDispatchIndex].getExecuteQueueDepth();
    }

    public static int getExecuteQueueDepth(int policyIndex) {
        if (policyIndex == 0) {
            return 0;
        }
        return queues[policyIndex].getExecuteQueueDepth();
    }

    public static int getDispatchPolicyIndex(String policyName) {
        if ("direct".equalsIgnoreCase(policyName)) {
            return 0;
        }
        int max = queues.length;
        for (int i = 1; i < max; ++i) {
            String queueName = queues[i].getName();
            if (!queueName.equalsIgnoreCase(policyName) && !queueName.equalsIgnoreCase((String)policyNameAlias.get(policyName))) continue;
            return i;
        }
        Kernel.ensureInitialized();
        return Kernel.getDispatchPolicyIndex("weblogic.kernel.Default");
    }

    public static boolean isDispatchPolicy(String policyName) {
        if ("direct".equalsIgnoreCase(policyName)) {
            return true;
        }
        int max = queues.length;
        for (int i = 1; i < max; ++i) {
            String queueName = queues[i].getName();
            if (!queueName.equalsIgnoreCase(policyName) && !queueName.equalsIgnoreCase((String)policyNameAlias.get(policyName))) continue;
            return true;
        }
        return false;
    }

    public static void addExecuteQueue(String policyName, int threadCount) {
        Kernel.addInternalExecuteQueue(policyName, threadCount, 0, threadCount);
    }

    public static void addExecuteQueue(String policyName, String alias, int threadCount) {
        policyNameAlias.put(policyName, alias);
        Kernel.addInternalExecuteQueue(policyName, threadCount, 0, threadCount);
    }

    public static void addExecuteQueue(String policyName, int initialThreadCount, int increment, int maxThreadCount) {
        Kernel.addInternalExecuteQueue(policyName, initialThreadCount, increment, maxThreadCount);
    }

    private static void addInternalExecuteQueue(String policyName, int initialThreadCount, int increment, int maxThreadCount) {
        ExecuteQueueMBeanStub queueBean = new ExecuteQueueMBeanStub();
        try {
            queueBean.setThreadCount(initialThreadCount);
            queueBean.setThreadsIncrease(increment);
            queueBean.setThreadsMaximum(maxThreadCount);
        }
        catch (InvalidAttributeValueException iave) {
            throw new AssertionError((Object)("Invalid ExecuteQueueMBean attributes specified for " + policyName));
        }
        Kernel.addExecuteQueue(policyName, queueBean, false);
    }

    private static void addExecuteQueue(String policyName, ExecuteQueueMBean queueBean) {
        Kernel.addExecuteQueue(policyName, queueBean, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addExecuteQueue(String policyName, ExecuteQueueMBean queueBean, boolean isApplicationQueue) {
        if (isApplicationQueue) {
            if (!applicationQueueNames.contains(policyName)) {
                applicationQueueNames.add(policyName);
            }
        } else {
            applicationQueueNames.remove(policyName);
            applicationQueueNames.remove(policyNameAlias.get(policyName));
        }
        if (Kernel.isDispatchPolicy(policyName)) {
            return;
        }
        Class<Kernel> clazz = Kernel.class;
        synchronized (Kernel.class) {
            if (Kernel.isDispatchPolicy(policyName)) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            ExecuteThreadManager etm = new ExecuteThreadManager(policyName, queueBean);
            KernelEnvironment.getKernelEnvironment().addExecuteQueueRuntime(etm);
            ExecuteThreadManager[] tmp = new ExecuteThreadManager[queues.length + 1];
            System.arraycopy(queues, 0, tmp, 0, queues.length);
            tmp[Kernel.queues.length] = etm;
            queues = tmp;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static void initializeExecuteQueue(ExecuteQueueMBean queueBean) {
        Kernel.addExecuteQueue(queueBean.getName(), queueBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        KernelStatus.shutdown();
        Class<Kernel> clazz = Kernel.class;
        synchronized (Kernel.class) {
            int max = queues.length;
            for (int i = 1; i < max; ++i) {
                queues[i].shutdown();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static boolean checkStuckThreads(String policyName, long maxTime) {
        boolean status = false;
        ExecuteThreadManager[] tmpQueues = Kernel.getExecuteThreadManagers();
        if (policyName != null) {
            ExecuteThread[] threads;
            ExecuteThreadManager etm;
            int index = Kernel.getDispatchPolicyIndex(policyName);
            if (maxTime > 0L && index > 0 && (etm = tmpQueues[index]) != null && (threads = etm.getStuckExecuteThreads(maxTime)) != null && threads.length == etm.getExecuteThreadCount()) {
                status = true;
            }
        }
        return status;
    }

    public static int getPendingTasksCount(String policyName) {
        ExecuteThreadManager etm;
        int index;
        int count = 0;
        ExecuteThreadManager[] tmpQueues = Kernel.getExecuteThreadManagers();
        if (policyName != null && (index = Kernel.getDispatchPolicyIndex(policyName)) > 0 && (etm = tmpQueues[index]) != null) {
            count = etm.getPendingTasksCount();
        }
        return count;
    }

    public static List getApplicationDispatchPolicies() {
        return applicationQueueNames;
    }

    public static boolean isApplicationDispatchPolicy(int policy) {
        if (policy == 0) {
            return false;
        }
        return applicationQueueNames.contains(queues[policy].getName());
    }

    private Kernel() {
    }

    static boolean isQueueThrottleAllowed() {
        return allowQueueThrottling;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDummyDefaultQueue(ExecuteThreadManager etm) {
        Class<Kernel> clazz = Kernel.class;
        synchronized (Kernel.class) {
            ExecuteThreadManager[] tmp = new ExecuteThreadManager[queues.length + 1];
            System.arraycopy(queues, 0, tmp, 0, queues.length);
            tmp[Kernel.queues.length] = etm;
            queues = tmp;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static {
        queues = new ExecuteThreadManager[1];
        policyNameAlias = new HashMap();
        applicationQueueNames = new ArrayList();
        isTracingEnabled = false;
        allowQueueThrottling = Kernel.initAllowThrottleProp();
    }

    @Service
    private static class KernelTypeServiceImpl
    implements KernelTypeService {
        private KernelTypeServiceImpl() {
        }

        @Override
        public boolean isServer() {
            return Kernel.isServer();
        }

        @Override
        public boolean isApplet() {
            return Kernel.isApplet();
        }

        @Override
        public void ensureInitialized() {
            Kernel.ensureInitialized();
        }
    }
}

