/*
 * Decompiled with CFR 0.152.
 */
package weblogic.kernel;

import java.util.Map;
import weblogic.kernel.ExecuteQueueMBeanStub;
import weblogic.kernel.IIOPMBeanStub;
import weblogic.kernel.KernelDebugMBeanStub;
import weblogic.kernel.LogMBeanStub;
import weblogic.kernel.MBeanStub;
import weblogic.kernel.SSLMBeanStub;
import weblogic.logging.Severities;
import weblogic.management.configuration.ExecuteQueueMBean;
import weblogic.management.configuration.IIOPMBean;
import weblogic.management.configuration.KernelDebugMBean;
import weblogic.management.configuration.KernelMBean;
import weblogic.management.configuration.LogMBean;
import weblogic.management.configuration.SSLMBean;

final class KernelMBeanStub
extends MBeanStub
implements KernelMBean {
    private final LogMBean log = new LogMBeanStub();
    private final SSLMBean ssl = new SSLMBeanStub();
    private final IIOPMBeanStub iiop = new IIOPMBeanStub();
    private final KernelDebugMBeanStub debug = new KernelDebugMBeanStub();
    private final ExecuteQueueMBeanStub[] queues = new ExecuteQueueMBeanStub[]{new ExecuteQueueMBeanStub()};
    private boolean reverseDNSAllowed = false;
    private String defaultProtocol = "t3";
    private String defaultSecureProtocol = "t3s";
    private String defaultAdminProtocol = "t3s";
    private int systemThreadPoolSize = 0;
    private int selfTuningThreadPoolSizeMin = 1;
    private int selfTuningThreadPoolSizeMax = 600;
    private int jmsThreadPoolSize = 0;
    private int messagingBridgeThreadPoolSize = 0;
    private boolean nativeIOEnabled = false;
    private boolean outboundEnabled = false;
    private boolean outboundPrivateKeyEnabled = false;
    private String muxerClass = "weblogic.socket.JavaSocketMuxer";
    private boolean devPollDisabled = false;
    private int socketReaders = -1;
    private int percentSocketReaders = 33;
    private long timePeriod = 0L;
    private int socketReaderTimeoutMinMillis = 500;
    private int socketReaderTimeoutMaxMillis = 1000;
    private int maxMessageSize = 10000000;
    private int connectTimeout = 0;
    private int completeMessageTimeout = 60;
    private int completeT3MessageTimeout = 60;
    private boolean socketBufferSizeAsChunkSize = false;
    private int periodLength = 60000;
    private int idlePeriodsUntilTimeout = 4;
    private int idleTimeout = 0;
    private int rjvmIdleTimeout = 0;
    private int responseTimeout = 0;
    private boolean stdoutEnabled = true;
    private int stdoutSeverityLevel = 64;
    private boolean stdoutDebugEnabled = false;
    private int stacktraceDepth = 5;
    private boolean logRemoteExceptionsEnabled = false;
    private boolean instrumentStackTraceEnabled = true;
    private boolean printStackTraceInProductionMode = false;
    private int maxOpenSockCount = -1;
    private String fmt = "standard";
    private boolean stack = true;
    private int stuckThreadTimerInterval = 600;
    private int stuckThreadMaxTime = 600;
    private boolean tracingEnabled = false;
    private int mtuSize = 1500;
    private boolean enableStubLoadingUsingCCL;
    private boolean refreshClientRuntimeDescriptor = false;
    private boolean use81StyleExecuteQueues = true;
    private int t3clientAbbrevTableSize = 255;
    private int t3serverAbbrevTableSize = 2048;
    private boolean gatheredWritesEnabled = false;
    private boolean scatteredReadsEnabled = false;
    private boolean addWorkManagerThreadsByCpuCount = false;
    private boolean useConcurrentQueueForRequestManager = false;
    int completeWriteTimeout = 60;
    private boolean useDetailedThreadName = false;
    private boolean useEnhancedPriorityQueueForRequestManager = false;
    private boolean allowShrinkingPriorityRequestQueue = true;
    private boolean useEnhancedIncrementAdvisor = false;
    boolean eagerThreadLocalCleanup;
    boolean isolatePartitionThreadLocals;
    long rmiDeserializationMaxTimeLimit;

    KernelMBeanStub() {
        this.initializeFromSystemProperties("weblogic.");
        try {
            boolean stdoutDebugEnabled;
            String stdoutSeverity = System.getProperty("weblogic.StdoutSeverityLevel");
            if (stdoutSeverity != null) {
                this.getLog().setStdoutSeverity(Severities.severityNumToString(Integer.parseInt(stdoutSeverity)));
            }
            if (stdoutDebugEnabled = Boolean.getBoolean("weblogic.StdoutDebugEnabled")) {
                this.getLog().setStdoutSeverity("Debug");
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public Map getValidProtocols() {
        return null;
    }

    @Override
    public boolean isReverseDNSAllowed() {
        return this.reverseDNSAllowed;
    }

    @Override
    public void setReverseDNSAllowed(boolean flag) {
        this.reverseDNSAllowed = flag;
    }

    @Override
    public String getDefaultProtocol() {
        return this.defaultProtocol;
    }

    @Override
    public void setDefaultProtocol(String protocol) {
        this.defaultProtocol = protocol;
    }

    @Override
    public String getDefaultSecureProtocol() {
        return this.defaultSecureProtocol;
    }

    @Override
    public void setDefaultSecureProtocol(String protocol) {
        this.defaultSecureProtocol = protocol;
    }

    @Override
    public String getAdministrationProtocol() {
        return this.defaultAdminProtocol;
    }

    @Override
    public void setAdministrationProtocol(String protocol) {
        this.defaultAdminProtocol = protocol;
    }

    @Override
    public int getThreadPoolSize() {
        return this.queues[0].getThreadCount();
    }

    @Override
    public void setThreadPoolSize(int size) {
        this.queues[0].setThreadCount(size);
    }

    @Override
    public int getSystemThreadPoolSize() {
        return this.systemThreadPoolSize;
    }

    @Override
    public void setSystemThreadPoolSize(int size) {
        this.systemThreadPoolSize = size;
    }

    @Override
    public void setSelfTuningThreadPoolSizeMin(int size) {
        this.selfTuningThreadPoolSizeMin = size;
    }

    @Override
    public int getSelfTuningThreadPoolSizeMin() {
        return this.selfTuningThreadPoolSizeMin;
    }

    @Override
    public void setSelfTuningThreadPoolSizeMax(int size) {
        this.selfTuningThreadPoolSizeMax = size;
    }

    @Override
    public int getSelfTuningThreadPoolSizeMax() {
        return this.selfTuningThreadPoolSizeMax;
    }

    @Override
    public int getJMSThreadPoolSize() {
        return this.jmsThreadPoolSize;
    }

    @Override
    public void setJMSThreadPoolSize(int size) {
        this.jmsThreadPoolSize = size;
    }

    @Override
    public int getMessagingBridgeThreadPoolSize() {
        return this.messagingBridgeThreadPoolSize;
    }

    @Override
    public void setMessagingBridgeThreadPoolSize(int size) {
        this.messagingBridgeThreadPoolSize = size;
    }

    @Override
    public boolean isNativeIOEnabled() {
        return this.nativeIOEnabled;
    }

    @Override
    public void setNativeIOEnabled(boolean enable) {
        this.nativeIOEnabled = enable;
    }

    @Override
    public boolean isOutboundEnabled() {
        return this.outboundEnabled;
    }

    @Override
    public void setOutboundEnabled(boolean enable) {
        this.outboundEnabled = enable;
    }

    @Override
    public boolean isOutboundPrivateKeyEnabled() {
        return this.outboundPrivateKeyEnabled;
    }

    @Override
    public void setOutboundPrivateKeyEnabled(boolean enable) {
        this.outboundPrivateKeyEnabled = enable;
    }

    @Override
    public String getMuxerClass() {
        return this.muxerClass;
    }

    @Override
    public void setMuxerClass(String name) {
        this.muxerClass = name;
    }

    @Override
    public boolean isDevPollDisabled() {
        return this.devPollDisabled;
    }

    @Override
    public void setDevPollDisabled(boolean disable) {
        this.devPollDisabled = disable;
    }

    @Override
    public int getSocketReaders() {
        return this.socketReaders;
    }

    @Override
    public void setSocketReaders(int num) {
        this.socketReaders = num;
    }

    @Override
    public int getThreadPoolPercentSocketReaders() {
        return this.percentSocketReaders;
    }

    @Override
    public void setThreadPoolPercentSocketReaders(int percent) {
        this.percentSocketReaders = percent;
    }

    @Override
    public void setTimedOutRefIsolationTime(long timePeriod) {
        this.timePeriod = timePeriod;
    }

    @Override
    public long getTimedOutRefIsolationTime() {
        return this.timePeriod;
    }

    @Override
    public int getSocketReaderTimeoutMinMillis() {
        return this.socketReaderTimeoutMinMillis;
    }

    @Override
    public void setSocketReaderTimeoutMinMillis(int timeout) {
        this.socketReaderTimeoutMinMillis = timeout;
    }

    @Override
    public int getSocketReaderTimeoutMaxMillis() {
        return this.socketReaderTimeoutMaxMillis;
    }

    @Override
    public void setSocketReaderTimeoutMaxMillis(int timeout) {
        this.socketReaderTimeoutMaxMillis = timeout;
    }

    @Override
    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    @Override
    public void setMaxMessageSize(int maxsize) {
        this.maxMessageSize = maxsize;
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(int seconds) {
        this.connectTimeout = seconds;
    }

    @Override
    public int getCompleteMessageTimeout() {
        return this.completeMessageTimeout;
    }

    @Override
    public void setCompleteMessageTimeout(int seconds) {
        this.completeMessageTimeout = seconds;
    }

    @Override
    public int getMaxT3MessageSize() {
        return 10000000;
    }

    @Override
    public void setMaxT3MessageSize(int maxsize) {
    }

    @Override
    public int getMaxHTTPMessageSize() {
        return 10000000;
    }

    @Override
    public void setMaxHTTPMessageSize(int maxsize) {
    }

    @Override
    public int getMaxIIOPMessageSize() {
        return this.iiop.getMaxMessageSize();
    }

    @Override
    public void setMaxIIOPMessageSize(int maxsize) {
    }

    @Override
    public int getMaxCOMMessageSize() {
        return 10000000;
    }

    @Override
    public void setMaxCOMMessageSize(int maxsize) {
    }

    @Override
    public int getCompleteT3MessageTimeout() {
        return this.completeT3MessageTimeout;
    }

    @Override
    public void setCompleteT3MessageTimeout(int seconds) {
        this.completeT3MessageTimeout = seconds;
    }

    @Override
    public void setSocketBufferSizeAsChunkSize(boolean flag) {
        this.socketBufferSizeAsChunkSize = flag;
    }

    @Override
    public boolean isSocketBufferSizeAsChunkSize() {
        return this.socketBufferSizeAsChunkSize;
    }

    @Override
    public int getCompleteHTTPMessageTimeout() {
        return 60;
    }

    @Override
    public void setCompleteHTTPMessageTimeout(int seconds) {
    }

    @Override
    public int getCompleteIIOPMessageTimeout() {
        return this.iiop.getCompleteMessageTimeout();
    }

    @Override
    public void setCompleteIIOPMessageTimeout(int seconds) {
    }

    @Override
    public int getCompleteCOMMessageTimeout() {
        return 60;
    }

    @Override
    public void setCompleteCOMMessageTimeout(int seconds) {
    }

    @Override
    public int getPeriodLength() {
        return this.periodLength;
    }

    @Override
    public void setPeriodLength(int length) {
        this.periodLength = length;
    }

    @Override
    public int getIdlePeriodsUntilTimeout() {
        return this.idlePeriodsUntilTimeout;
    }

    @Override
    public void setIdlePeriodsUntilTimeout(int idlePeriods) {
        this.idlePeriodsUntilTimeout = idlePeriods;
    }

    @Override
    public int getIdleConnectionTimeout() {
        return this.idleTimeout;
    }

    @Override
    public void setIdleConnectionTimeout(int timeout) {
        this.idleTimeout = timeout;
    }

    @Override
    public int getDefaultGIOPMinorVersion() {
        return this.iiop.getDefaultMinorVersion();
    }

    @Override
    public void setDefaultGIOPMinorVersion(int minor) {
        this.iiop.setDefaultMinorVersion(minor);
    }

    @Override
    public String getIIOPLocationForwardPolicy() {
        return this.iiop.getLocationForwardPolicy();
    }

    @Override
    public void setIIOPLocationForwardPolicy(String lcpolicy) {
        this.iiop.setLocationForwardPolicy(lcpolicy);
    }

    @Override
    public boolean getUseIIOPLocateRequest() {
        return this.iiop.getUseLocateRequest();
    }

    @Override
    public void setUseIIOPLocateRequest(boolean locate) {
        this.iiop.setUseLocateRequest(locate);
    }

    @Override
    public String getIIOPTxMechanism() {
        return this.iiop.getTxMechanism();
    }

    @Override
    public void setIIOPTxMechanism(String txmech) {
        this.iiop.setTxMechanism(txmech);
    }

    @Override
    public int getIdleIIOPConnectionTimeout() {
        return this.iiop.getIdleConnectionTimeout();
    }

    @Override
    public void setIdleIIOPConnectionTimeout(int seconds) {
        this.iiop.setIdleConnectionTimeout(seconds);
    }

    @Override
    public IIOPMBean getIIOP() {
        return this.iiop;
    }

    public void setIIOPMBean() {
    }

    @Override
    public int getRjvmIdleTimeout() {
        return this.rjvmIdleTimeout;
    }

    @Override
    public void setRjvmIdleTimeout(int timeout) {
        this.rjvmIdleTimeout = timeout;
    }

    @Override
    public int getResponseTimeout() {
        return this.responseTimeout;
    }

    @Override
    public void setResponseTimeout(int timeout) {
        this.responseTimeout = timeout;
    }

    public boolean isUnsafeClassLoadingEnabled() {
        return false;
    }

    public void setUnsafeClassLoadingEnabled(boolean enabled) {
    }

    @Override
    public KernelDebugMBean getKernelDebug() {
        return this.debug;
    }

    public void setKernelDebug(KernelDebugMBean debug) {
    }

    @Override
    public int getDGCIdlePeriodsUntilTimeout() {
        return this.getIdlePeriodsUntilTimeout();
    }

    @Override
    public void setDGCIdlePeriodsUntilTimeout(int periods) {
    }

    @Override
    public LogMBean getLog() {
        return this.log;
    }

    @Override
    public boolean isStdoutEnabled() {
        return this.stdoutEnabled;
    }

    @Override
    public void setStdoutEnabled(boolean value) {
        this.stdoutEnabled = value;
    }

    @Override
    public int getStdoutSeverityLevel() {
        return this.stdoutSeverityLevel;
    }

    @Override
    public void setStdoutSeverityLevel(int value) {
        this.stdoutSeverityLevel = value;
    }

    @Override
    public boolean isStdoutDebugEnabled() {
        return this.stdoutDebugEnabled;
    }

    @Override
    public void setStdoutDebugEnabled(boolean value) {
        this.stdoutDebugEnabled = value;
    }

    public int getStacktraceDepth() {
        return this.stacktraceDepth;
    }

    public void setStacktraceDepth(int value) {
        this.stacktraceDepth = value;
    }

    @Override
    public boolean isLogRemoteExceptionsEnabled() {
        return false;
    }

    @Override
    public void setLogRemoteExceptionsEnabled(boolean value) {
        this.logRemoteExceptionsEnabled = value;
    }

    @Override
    public boolean isInstrumentStackTraceEnabled() {
        return this.instrumentStackTraceEnabled;
    }

    @Override
    public void setInstrumentStackTraceEnabled(boolean enable) {
        this.instrumentStackTraceEnabled = enable;
    }

    @Override
    public boolean getPrintStackTraceInProduction() {
        return this.printStackTraceInProductionMode;
    }

    @Override
    public void setPrintStackTraceInProduction(boolean show) {
        this.printStackTraceInProductionMode = show;
    }

    @Override
    public SSLMBean getSSL() {
        return this.ssl;
    }

    public void setSSLMBean() {
    }

    @Override
    public ExecuteQueueMBean[] getExecuteQueues() {
        return this.queues;
    }

    public void setExecuteQueues(ExecuteQueueMBean[] queues) {
    }

    @Override
    public int getMaxOpenSockCount() {
        return this.maxOpenSockCount;
    }

    @Override
    public void setMaxOpenSockCount(int sockCount) {
        this.maxOpenSockCount = sockCount;
    }

    @Override
    public String getStdoutFormat() {
        return this.fmt;
    }

    @Override
    public void setStdoutFormat(String format) {
        if (format.equals("standard") || format.equals("noid")) {
            this.fmt = format;
        }
    }

    @Override
    public boolean isStdoutLogStack() {
        return this.stack;
    }

    @Override
    public void setStdoutLogStack(boolean stackValue) {
        this.stack = stackValue;
    }

    @Override
    public int getStuckThreadTimerInterval() {
        return this.stuckThreadTimerInterval;
    }

    @Override
    public void setStuckThreadTimerInterval(int value) {
        this.stuckThreadTimerInterval = value;
    }

    @Override
    public int getStuckThreadMaxTime() {
        return this.stuckThreadMaxTime;
    }

    @Override
    public void setStuckThreadMaxTime(int value) {
        this.stuckThreadMaxTime = value;
    }

    @Override
    public boolean getTracingEnabled() {
        return this.tracingEnabled;
    }

    @Override
    public void setTracingEnabled(boolean value) {
        this.tracingEnabled = value;
    }

    @Override
    public int getMTUSize() {
        return this.mtuSize;
    }

    @Override
    public void setMTUSize(int mtuSize) {
        this.mtuSize = mtuSize;
    }

    @Override
    public void setLoadStubUsingContextClassLoader(boolean enable) {
        this.enableStubLoadingUsingCCL = enable;
    }

    @Override
    public boolean getLoadStubUsingContextClassLoader() {
        return this.enableStubLoadingUsingCCL;
    }

    @Override
    public void setRefreshClientRuntimeDescriptor(boolean enable) {
        this.refreshClientRuntimeDescriptor = enable;
    }

    @Override
    public boolean getRefreshClientRuntimeDescriptor() {
        return this.refreshClientRuntimeDescriptor;
    }

    @Override
    public void setUse81StyleExecuteQueues(boolean enable) {
        this.use81StyleExecuteQueues = enable;
    }

    @Override
    public boolean getUse81StyleExecuteQueues() {
        return this.use81StyleExecuteQueues;
    }

    @Override
    public void setT3ClientAbbrevTableSize(int size) {
        this.t3clientAbbrevTableSize = size;
    }

    @Override
    public int getT3ClientAbbrevTableSize() {
        return this.t3clientAbbrevTableSize;
    }

    @Override
    public void setT3ServerAbbrevTableSize(int size) {
        this.t3serverAbbrevTableSize = size;
    }

    @Override
    public int getT3ServerAbbrevTableSize() {
        return this.t3serverAbbrevTableSize;
    }

    @Override
    public ExecuteQueueMBean createExecuteQueue(String name) {
        return null;
    }

    @Override
    public ExecuteQueueMBean lookupExecuteQueue(String name) {
        return null;
    }

    @Override
    public void destroyExecuteQueue(ExecuteQueueMBean exec) {
    }

    public boolean removeExecuteQueue(ExecuteQueueMBean queue) {
        return true;
    }

    public boolean addExecuteQueue(ExecuteQueueMBean queue) {
        return true;
    }

    @Override
    public boolean isGatheredWritesEnabled() {
        return this.gatheredWritesEnabled;
    }

    @Override
    public void setGatheredWritesEnabled(boolean enable) {
        this.gatheredWritesEnabled = enable;
    }

    @Override
    public boolean isScatteredReadsEnabled() {
        return this.scatteredReadsEnabled;
    }

    @Override
    public void setScatteredReadsEnabled(boolean enable) {
        this.scatteredReadsEnabled = enable;
    }

    @Override
    public boolean isAddWorkManagerThreadsByCpuCount() {
        return this.addWorkManagerThreadsByCpuCount;
    }

    @Override
    public void setAddWorkManagerThreadsByCpuCount(boolean flag) {
        this.addWorkManagerThreadsByCpuCount = flag;
    }

    @Override
    public boolean isUseConcurrentQueueForRequestManager() {
        return this.useConcurrentQueueForRequestManager;
    }

    @Override
    public void setUseConcurrentQueueForRequestManager(boolean flag) {
        this.useConcurrentQueueForRequestManager = flag;
    }

    @Override
    public int getCompleteWriteTimeout() {
        return this.completeWriteTimeout;
    }

    @Override
    public void setCompleteWriteTimeout(int seconds) {
        this.completeWriteTimeout = seconds;
    }

    @Override
    public void setUseDetailedThreadName(boolean flag) {
        this.useDetailedThreadName = flag;
    }

    @Override
    public boolean isUseDetailedThreadName() {
        return this.useDetailedThreadName;
    }

    @Override
    public void setUseEnhancedPriorityQueueForRequestManager(boolean flag) {
        this.useEnhancedPriorityQueueForRequestManager = flag;
    }

    @Override
    public boolean isUseEnhancedPriorityQueueForRequestManager() {
        return this.useEnhancedPriorityQueueForRequestManager;
    }

    @Override
    public void setAllowShrinkingPriorityRequestQueue(boolean flag) {
        this.allowShrinkingPriorityRequestQueue = flag;
    }

    @Override
    public boolean isAllowShrinkingPriorityRequestQueue() {
        return this.allowShrinkingPriorityRequestQueue;
    }

    @Override
    public void setUseEnhancedIncrementAdvisor(boolean flag) {
        this.useEnhancedIncrementAdvisor = flag;
    }

    @Override
    public boolean isUseEnhancedIncrementAdvisor() {
        return this.useEnhancedIncrementAdvisor;
    }

    @Override
    public boolean isEagerThreadLocalCleanup() {
        return this.eagerThreadLocalCleanup;
    }

    @Override
    public void setEagerThreadLocalCleanup(boolean flag) {
        this.eagerThreadLocalCleanup = flag;
    }

    @Override
    public boolean isIsolatePartitionThreadLocals() {
        return this.isolatePartitionThreadLocals;
    }

    @Override
    public void setIsolatePartitionThreadLocals(boolean flag) {
        this.isolatePartitionThreadLocals = flag;
    }

    @Override
    public void setRMIDeserializationMaxTimeLimit(long limit) {
        this.rmiDeserializationMaxTimeLimit = limit;
    }

    @Override
    public long getRMIDeserializationMaxTimeLimit() {
        return this.rmiDeserializationMaxTimeLimit;
    }
}

