/*
 * Decompiled with CFR 0.152.
 */
package weblogic.kernel;

import java.util.Properties;
import javax.management.InvalidAttributeValueException;
import weblogic.kernel.Kernel;
import weblogic.kernel.KernelMBeanStub;
import weblogic.kernel.MBeanStub;
import weblogic.management.DistributedManagementException;
import weblogic.management.configuration.KernelMBean;
import weblogic.management.configuration.NetworkAccessPointMBean;

public class NetworkAccessPointMBeanStub
extends MBeanStub
implements NetworkAccessPointMBean {
    private String protocol;
    private String address;
    private String name;
    private boolean timeoutConnectionWithPendingResponses = false;
    private boolean sdpEnabled;
    private boolean resolveDNSName;
    private boolean t3SenderQueueEnabled;
    protected KernelMBean config;
    private int port = -1;
    private boolean httpEnabledForThisProtocol = false;
    private boolean outboundEnabled = false;
    private boolean fastSerialization = false;

    NetworkAccessPointMBeanStub() {
        this.initializeFromSystemProperties("weblogic.channels.");
    }

    public NetworkAccessPointMBeanStub(String protocol) {
        this(protocol, NetworkAccessPointMBeanStub.getKernelConfig());
    }

    private static KernelMBean getKernelConfig() {
        Kernel.ensureInitialized();
        return Kernel.getConfig();
    }

    public NetworkAccessPointMBeanStub(String protocol, KernelMBean config) {
        this.protocol = protocol;
        this.config = config;
        this.name = "Default";
        this.initializeFromSystemProperties("weblogic." + protocol + ".");
    }

    public static NetworkAccessPointMBean createBootstrapStub() {
        NetworkAccessPointMBeanStub nap = new NetworkAccessPointMBeanStub("ADMIN".toLowerCase(), new KernelMBeanStub());
        nap.httpEnabledForThisProtocol = true;
        nap.outboundEnabled = true;
        nap.name = " Bootstrap";
        return nap;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public void setProtocol(String protocol) throws InvalidAttributeValueException {
        this.protocol = protocol;
    }

    @Override
    public String getListenAddress() {
        return this.address;
    }

    @Override
    public void setListenAddress(String address) throws InvalidAttributeValueException {
        this.address = address;
    }

    @Override
    public String getPublicAddress() {
        return this.getListenAddress();
    }

    @Override
    public void setPublicAddress(String address) throws InvalidAttributeValueException {
    }

    @Override
    public int getListenPort() {
        return this.port;
    }

    @Override
    public void setListenPort(int port) {
        this.port = port;
    }

    @Override
    public int getPublicPort() {
        return this.getListenPort();
    }

    @Override
    public void setPublicPort(int port) {
    }

    @Override
    public boolean getResolveDNSName() {
        return this.resolveDNSName;
    }

    @Override
    public void setResolveDNSName(boolean enable) {
        this.resolveDNSName = enable;
    }

    @Override
    public String getProxyAddress() {
        return null;
    }

    @Override
    public void setProxyAddress(String address) {
    }

    @Override
    public int getProxyPort() {
        return -1;
    }

    @Override
    public void setProxyPort(int port) {
    }

    @Override
    public boolean isHttpEnabledForThisProtocol() {
        return this.httpEnabledForThisProtocol;
    }

    @Override
    public void setHttpEnabledForThisProtocol(boolean enabled) throws InvalidAttributeValueException {
    }

    @Override
    public int getAcceptBacklog() {
        return 50;
    }

    @Override
    public void setAcceptBacklog(int count) {
    }

    @Override
    public int getMaxBackoffBetweenFailures() {
        return 10000;
    }

    @Override
    public void setMaxBackoffBetweenFailures(int milliSeconds) {
    }

    @Override
    public int getLoginTimeoutMillis() {
        return 5000;
    }

    @Override
    public void setLoginTimeoutMillis(int timeout) {
    }

    @Override
    public int getConnectTimeout() {
        return this.config.getConnectTimeout();
    }

    @Override
    public void setConnectTimeout(int timeout) throws InvalidAttributeValueException, DistributedManagementException {
        this.config.setConnectTimeout(timeout);
    }

    @Override
    public int getTunnelingClientPingSecs() {
        return 0;
    }

    @Override
    public void setTunnelingClientPingSecs(int secs) throws InvalidAttributeValueException {
    }

    @Override
    public int getTunnelingClientTimeoutSecs() {
        return 0;
    }

    @Override
    public void setTunnelingClientTimeoutSecs(int secs) throws InvalidAttributeValueException {
    }

    @Override
    public boolean isTunnelingEnabled() {
        return false;
    }

    @Override
    public void setTunnelingEnabled(boolean enabled) throws InvalidAttributeValueException {
    }

    @Override
    public int getCompleteMessageTimeout() {
        return this.config.getCompleteMessageTimeout();
    }

    @Override
    public void setCompleteMessageTimeout(int seconds) throws InvalidAttributeValueException, DistributedManagementException {
        this.config.setCompleteMessageTimeout(seconds);
    }

    @Override
    public int getIdleConnectionTimeout() {
        return this.config.getIdleConnectionTimeout();
    }

    @Override
    public void setIdleConnectionTimeout(int seconds) throws InvalidAttributeValueException, DistributedManagementException {
        this.config.setIdleConnectionTimeout(seconds);
    }

    @Override
    public int getMaxMessageSize() {
        int i = this.config.getMaxMessageSize();
        if (i < 0) {
            i = Integer.MAX_VALUE;
        }
        return i;
    }

    @Override
    public void setMaxMessageSize(int maxsize) throws InvalidAttributeValueException, DistributedManagementException {
        this.config.setMaxMessageSize(maxsize);
    }

    @Override
    public boolean isOutboundEnabled() {
        return this.outboundEnabled;
    }

    @Override
    public void setOutboundEnabled(boolean enabled) throws InvalidAttributeValueException {
    }

    @Override
    public int getChannelWeight() {
        return 0;
    }

    @Override
    public void setChannelWeight(int weight) throws InvalidAttributeValueException {
    }

    @Override
    public String getClusterAddress() {
        return null;
    }

    @Override
    public void setClusterAddress(String address) throws InvalidAttributeValueException {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) throws InvalidAttributeValueException {
    }

    @Override
    public int getMaxConnectedClients() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void setMaxConnectedClients(int count) throws InvalidAttributeValueException {
    }

    @Override
    public boolean isTwoWaySSLEnabled() {
        return false;
    }

    @Override
    public void setTwoWaySSLEnabled(boolean enabled) {
    }

    @Override
    public boolean isChannelIdentityCustomized() {
        return false;
    }

    @Override
    public void setChannelIdentityCustomized(boolean val) {
    }

    @Override
    public String getCustomPrivateKeyAlias() {
        return null;
    }

    @Override
    public void setCustomPrivateKeyAlias(String alias) {
    }

    @Override
    public String getPrivateKeyAlias() {
        return this.getCustomPrivateKeyAlias();
    }

    @Override
    public boolean isOutboundPrivateKeyEnabled() {
        return false;
    }

    @Override
    public void setOutboundPrivateKeyEnabled(boolean enabled) {
    }

    @Override
    public boolean getUseFastSerialization() {
        if ("iiop".equals(this.protocol)) {
            return Kernel.getConfig().getIIOP().getUseJavaSerialization();
        }
        return this.fastSerialization;
    }

    @Override
    public void setUseFastSerialization(boolean enabled) throws InvalidAttributeValueException {
        this.fastSerialization = enabled;
    }

    @Override
    public String getCustomPrivateKeyPassPhrase() {
        return null;
    }

    @Override
    public void setCustomPrivateKeyPassPhrase(String phrase) {
    }

    @Override
    public String getPrivateKeyPassPhrase() {
        return this.getCustomPrivateKeyPassPhrase();
    }

    @Override
    public byte[] getCustomPrivateKeyPassPhraseEncrypted() {
        return null;
    }

    @Override
    public void setCustomPrivateKeyPassPhraseEncrypted(byte[] passwordEncrypted) {
    }

    @Override
    public boolean isClientCertificateEnforced() {
        return false;
    }

    @Override
    public void setClientCertificateEnforced(boolean enforce) {
    }

    @Override
    public boolean getTimeoutConnectionWithPendingResponses() {
        return this.timeoutConnectionWithPendingResponses;
    }

    @Override
    public void setTimeoutConnectionWithPendingResponses(boolean timeout) throws InvalidAttributeValueException, DistributedManagementException {
        this.timeoutConnectionWithPendingResponses = timeout;
    }

    @Override
    public int getIdleIIOPConnectionTimeout() {
        return 0;
    }

    @Override
    public void setIdleIIOPConnectionTimeout(int seconds) throws InvalidAttributeValueException, DistributedManagementException {
    }

    @Override
    public int getSSLListenPort() {
        return -1;
    }

    @Override
    public void setSSLListenPort(int port) throws InvalidAttributeValueException {
    }

    @Override
    public String getExternalDNSName() {
        return null;
    }

    @Override
    public void setExternalDNSName(String externalDNSName) throws InvalidAttributeValueException {
    }

    @Override
    public int getLoginTimeoutMillisSSL() {
        return 0;
    }

    @Override
    public void setLoginTimeoutMillisSSL(int millis) throws InvalidAttributeValueException {
    }

    @Override
    public int getCompleteT3MessageTimeout() {
        return 0;
    }

    @Override
    public void setCompleteT3MessageTimeout(int seconds) throws InvalidAttributeValueException, DistributedManagementException {
    }

    @Override
    public int getCompleteHTTPMessageTimeout() {
        return 0;
    }

    @Override
    public void setCompleteHTTPMessageTimeout(int seconds) throws InvalidAttributeValueException, DistributedManagementException {
    }

    @Override
    public int getCompleteCOMMessageTimeout() {
        return 0;
    }

    @Override
    public void setCompleteCOMMessageTimeout(int seconds) throws InvalidAttributeValueException, DistributedManagementException {
    }

    @Override
    public int getCompleteIIOPMessageTimeout() {
        return 0;
    }

    @Override
    public void setCompleteIIOPMessageTimeout(int seconds) throws InvalidAttributeValueException, DistributedManagementException {
    }

    @Override
    public void setCustomProperties(Properties properties) {
    }

    @Override
    public Properties getCustomProperties() {
        return null;
    }

    @Override
    public boolean isSDPEnabled() {
        return this.sdpEnabled;
    }

    @Override
    public void setSDPEnabled(boolean enable) {
        this.sdpEnabled = enable;
    }

    @Override
    public String getOutboundPrivateKeyAlias() {
        return null;
    }

    @Override
    public String getOutboundPrivateKeyPassPhrase() {
        return null;
    }

    @Override
    public String getCustomIdentityKeyStoreFileName() {
        return null;
    }

    @Override
    public void setCustomIdentityKeyStoreFileName(String fileName) {
    }

    @Override
    public String getCustomIdentityKeyStoreType() {
        return null;
    }

    @Override
    public void setCustomIdentityKeyStoreType(String type) {
    }

    @Override
    public String getCustomIdentityKeyStorePassPhrase() {
        return null;
    }

    @Override
    public void setCustomIdentityKeyStorePassPhrase(String passPhrase) {
    }

    @Override
    public byte[] getCustomIdentityKeyStorePassPhraseEncrypted() {
        return null;
    }

    @Override
    public void setCustomIdentityKeyStorePassPhraseEncrypted(byte[] passPhraseEncrypted) {
    }

    @Override
    public String getHostnameVerifier() {
        return null;
    }

    @Override
    public void setHostnameVerifier(String classname) throws InvalidAttributeValueException {
    }

    @Override
    public boolean isHostnameVerificationIgnored() {
        return false;
    }

    @Override
    public void setHostnameVerificationIgnored(boolean ignoreFlag) throws InvalidAttributeValueException {
    }

    @Override
    public String[] getCiphersuites() {
        return null;
    }

    @Override
    public void setCiphersuites(String[] ciphers) throws InvalidAttributeValueException {
    }

    @Override
    public String[] getExcludedCiphersuites() {
        return null;
    }

    @Override
    public void setExcludedCiphersuites(String[] excludedCiphersuitesciphers) {
    }

    @Override
    public void setAllowUnencryptedNullCipher(boolean enable) {
    }

    @Override
    public boolean isAllowUnencryptedNullCipher() {
        return false;
    }

    @Override
    public String getInboundCertificateValidation() {
        return null;
    }

    @Override
    public void setInboundCertificateValidation(String validationStyle) {
    }

    @Override
    public String getOutboundCertificateValidation() {
        return null;
    }

    @Override
    public void setOutboundCertificateValidation(String validationStyle) {
    }

    @Override
    public boolean isSSLv2HelloEnabled() {
        return false;
    }

    @Override
    public void setSSLv2HelloEnabled(boolean ssLv2HelloEnabled) {
    }

    @Override
    public boolean isClientInitSecureRenegotiationAccepted() {
        return false;
    }

    @Override
    public void setClientInitSecureRenegotiationAccepted(boolean ClientInitSecureRenegotiationAccepted) {
    }

    @Override
    public String getMinimumTLSProtocolVersion() {
        return null;
    }

    @Override
    public void setMinimumTLSProtocolVersion(String minimumTLSProtocolVersion) throws InvalidAttributeValueException {
    }

    @Override
    public String getAllowListViolationAction() {
        return null;
    }

    @Override
    public void setAllowListViolationAction(String allowListViolationAction) {
    }
}

