/*
 * Decompiled with CFR 0.152.
 */
package weblogic.kernel;

import java.util.EmptyStackException;
import weblogic.kernel.ResettableThreadLocal;
import weblogic.utils.collections.Stack;

public final class ResettableThreadLocalStack
extends ResettableThreadLocal {
    public ResettableThreadLocalStack() {
    }

    public ResettableThreadLocalStack(boolean inherit) {
        super(inherit);
    }

    @Override
    public Object get() {
        return this.peek();
    }

    @Override
    public void set(Object value) {
        Stack stack = (Stack)super.get();
        stack.clear();
        stack.push(value);
    }

    public Object peek() {
        Stack stack = (Stack)super.get();
        if (stack.isEmpty()) {
            return null;
        }
        return stack.peek();
    }

    public void push(Object value) {
        ((Stack)super.get()).push(value);
    }

    public Object pop() {
        try {
            return ((Stack)super.get()).pop();
        }
        catch (EmptyStackException e) {
            throw new AssertionError((Object)e);
        }
    }

    public int getSize() {
        return ((Stack)super.get()).size();
    }

    public Object popAndPeek() {
        try {
            Stack stack = (Stack)super.get();
            stack.pop();
            if (stack.isEmpty()) {
                return null;
            }
            return stack.peek();
        }
        catch (EmptyStackException e) {
            return null;
        }
    }

    @Override
    protected Object initialValue() {
        return new Stack();
    }

    @Override
    protected Object resetValue(Object o) {
        ((Stack)o).clear();
        return o;
    }

    @Override
    protected Object childValue(Object parentValue) {
        Stack parentStack = (Stack)parentValue;
        if (!parentStack.isEmpty()) {
            Stack newStack = (Stack)this.initialValue();
            newStack.push(parentStack.peek());
            return newStack;
        }
        return this.initialValue();
    }
}

