/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import weblogic.management.ManagementException;

public final class DistributedManagementException
extends ManagementException {
    private static final int MAX_EXCEPTIONS = 3;
    private static final long serialVersionUID = -1567833008917372777L;
    private List exceptions;

    public DistributedManagementException(List exceptionsArg) {
        super("Distributed Management [" + exceptionsArg.size() + " exceptions]");
        this.exceptions = Collections.unmodifiableList(new ArrayList(exceptionsArg));
    }

    public List getExceptions() {
        return this.exceptions;
    }

    @Override
    public String getMessage() {
        int i = 0;
        String message = "";
        message = super.getMessage();
        Iterator it = this.exceptions.iterator();
        while (it.hasNext() && i++ != 3) {
            message = message + " \n";
            message = message + ((Throwable)it.next()).getMessage();
        }
        return message;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream stream) {
        super.printStackTrace(stream);
        int i = 0;
        Iterator it = this.exceptions.iterator();
        while (it.hasNext() && i++ != 3) {
            ((Throwable)it.next()).printStackTrace(stream);
        }
    }

    @Override
    public void printStackTrace(PrintWriter writer) {
        super.printStackTrace(writer);
        int i = 0;
        Iterator it = this.exceptions.iterator();
        while (it.hasNext() && i++ != 3) {
            ((Throwable)it.next()).printStackTrace(writer);
        }
    }
}

