/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.dispatcher;

import weblogic.kernel.KernelStatus;
import weblogic.messaging.dispatcher.CrossDomainUtil;

public class CrossDomainManager {
    private static final String T3CLIENT_UTIL_CLASS = "weblogic.messaging.dispatcher.T3ClientCrossDomainUtil";
    private static final String IIOPCLIENT_UTIL_CLASS = "weblogic.messaging.dispatcher.IIOPClientCrossDomainUtil";
    private static final String SERVER_UTIL_CLASS = "weblogic.messaging.dispatcher.ServerCrossDomainUtil";
    private static CrossDomainUtil util;

    static void ensureInitialized() {
        Class<?> utilClass;
        if (KernelStatus.isServer()) {
            try {
                utilClass = Class.forName(SERVER_UTIL_CLASS);
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
        }
        try {
            utilClass = Class.forName(T3CLIENT_UTIL_CLASS);
        }
        catch (ClassNotFoundException d) {
            try {
                utilClass = Class.forName(IIOPCLIENT_UTIL_CLASS);
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
        }
        try {
            util = (CrossDomainUtil)utilClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static CrossDomainUtil getCrossDomainUtil() {
        return util;
    }

    static {
        CrossDomainManager.ensureInitialized();
    }
}

