/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.dispatcher;

import jakarta.jms.JMSException;
import weblogic.invocation.ManagedInvocationContext;
import weblogic.jms.dispatcher.DispatcherAdapter;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.messaging.dispatcher.DispatcherImpl;
import weblogic.messaging.dispatcher.PartitionAware;
import weblogic.messaging.dispatcher.Request;
import weblogic.messaging.dispatcher.Response;

public final class CrossPartitionDispatcher
extends DispatcherAdapter
implements PartitionAware {
    final DispatcherImpl dispatcherImpl;

    public CrossPartitionDispatcher(DispatcherImpl dispatcherImpl) {
        super(dispatcherImpl, dispatcherImpl.getDispatcherPartition4rmic());
        this.dispatcherImpl = dispatcherImpl;
    }

    private ManagedInvocationContext setupBefore(Request request) {
        Object pushed = this.dispatcherImpl.getDispatcherPartition4rmic().pushComponentInvocationContext();
        this.dispatcherImpl.giveRequestResource(request);
        return (ManagedInvocationContext)pushed;
    }

    @Override
    public void dispatchNoReply(Request request) throws JMSException {
        try (ManagedInvocationContext mic = this.setupBefore(request);){
            super.dispatchNoReply(request);
        }
    }

    @Override
    public void dispatchNoReplyWithId(Request request, int id) throws JMSException {
        try (ManagedInvocationContext mic = this.setupBefore(request);){
            super.dispatchNoReplyWithId(request, id);
        }
    }

    @Override
    public Response dispatchSync(Request request) throws JMSException {
        try (ManagedInvocationContext mic = this.setupBefore(request);){
            Response response = super.dispatchSync(request);
            return response;
        }
    }

    @Override
    public Response dispatchSyncTran(Request request) throws JMSException {
        try (ManagedInvocationContext mic = this.setupBefore(request);){
            Response response = super.dispatchSyncTran(request);
            return response;
        }
    }

    @Override
    public Response dispatchSyncNoTran(Request request) throws JMSException {
        try (ManagedInvocationContext mic = this.setupBefore(request);){
            Response response = super.dispatchSyncNoTran(request);
            return response;
        }
    }

    @Override
    public Response dispatchSyncNoTranWithId(Request request, int id) throws JMSException {
        try (ManagedInvocationContext mic = this.setupBefore(request);){
            Response response = super.dispatchSyncNoTranWithId(request, id);
            return response;
        }
    }

    @Override
    public void dispatchAsync(Request request) throws DispatcherException {
        try (ManagedInvocationContext mic = this.setupBefore(request);){
            super.dispatchAsync(request);
        }
    }

    @Override
    public void dispatchAsyncWithId(Request request, int id) throws DispatcherException {
        try (ManagedInvocationContext mic = this.setupBefore(request);){
            super.dispatchAsyncWithId(request, id);
        }
    }

    @Override
    public String getPartitionId() {
        return this.dispatcherImpl.getPartitionId();
    }

    @Override
    public String getPartitionName() {
        return this.dispatcherImpl.getPartitionName();
    }

    @Override
    public String getConnectionPartitionName() {
        return this.dispatcherImpl.getConnectionPartitionName();
    }
}

