/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.dispatcher;

import jakarta.transaction.Transaction;
import java.io.IOException;
import java.rmi.RemoteException;
import weblogic.common.internal.InteropWriteReplaceable;
import weblogic.common.internal.PeerInfo;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.dispatcher.DispatcherPartition4rmic;
import weblogic.jms.dispatcher.DispatcherWrapper;
import weblogic.kernel.KernelStatus;
import weblogic.messaging.dispatcher.Dispatcher;
import weblogic.messaging.dispatcher.DispatcherCommon;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.messaging.dispatcher.DispatcherId;
import weblogic.messaging.dispatcher.DispatcherOneWay;
import weblogic.messaging.dispatcher.DispatcherPeerGoneListener;
import weblogic.messaging.dispatcher.DispatcherRemote;
import weblogic.messaging.dispatcher.FastDispatcherImpl;
import weblogic.messaging.dispatcher.PartitionAware;
import weblogic.messaging.dispatcher.Request;
import weblogic.messaging.dispatcher.ResourceSetup;
import weblogic.messaging.dispatcher.Response;
import weblogic.rmi.extensions.AsyncResult;
import weblogic.rmi.extensions.PortableRemoteObject;
import weblogic.rmi.extensions.server.FutureResponse;
import weblogic.transaction.ClientTransactionManager;
import weblogic.transaction.TransactionHelper;
import weblogic.work.WorkManager;

public class DispatcherImpl
implements Dispatcher,
DispatcherRemote,
DispatcherOneWay,
InteropWriteReplaceable,
DispatcherCommon,
ResourceSetup,
PartitionAware {
    private final String name;
    private final DispatcherId dispatcherId;
    public static boolean UseClassCL = "true".equals(System.getProperty("weblogic.jms.client.dispatcher.use.threadccl", "false"));
    private static final ClientTransactionManager tm = TransactionHelper.getTransactionHelper().getTransactionManager();
    public static final boolean TESTXA = false;
    private Object fastDispatcher;
    protected final String objectHandlerClassName;
    protected final String partitionId;
    protected final String partitionName;
    protected final transient Object dispatcherPartition4rmic;
    protected final transient weblogic.jms.dispatcher.DispatcherImpl interopDispatcher;
    public static final boolean FASTDISPATCH = DispatcherImpl.fastDispatchEnabled();
    public static final String FASTDISPATCH_PROPNAME = "JMSFastDispatchEnabled";

    public DispatcherImpl(String name, DispatcherId dispatcherId, Object dispatcherPartition4rmic, String objectHandlerClassName, String partitionId, String partitionName) {
        this.name = name;
        this.objectHandlerClassName = objectHandlerClassName;
        this.dispatcherId = dispatcherId;
        this.partitionId = partitionId;
        this.partitionName = partitionName;
        this.dispatcherPartition4rmic = dispatcherPartition4rmic;
        this.interopDispatcher = new weblogic.jms.dispatcher.DispatcherImpl(this);
    }

    protected DispatcherImpl(DispatcherImpl delegate) {
        this.name = delegate.getName();
        this.objectHandlerClassName = delegate.getObjectHandlerClassName();
        this.dispatcherId = delegate.getId();
        this.partitionId = delegate.getPartitionId();
        this.partitionName = delegate.getPartitionName();
        this.dispatcherPartition4rmic = delegate.getDispatcherPartition4rmic();
        this.interopDispatcher = delegate.getInteropDispatcher();
    }

    public String getName() {
        return this.name;
    }

    WorkManager getFEWorkManager() {
        return this.getDispatcherPartition4rmic().getFEWorkManager();
    }

    WorkManager getBEWorkManager() {
        return this.getDispatcherPartition4rmic().getBEWorkManager();
    }

    WorkManager getOneWayWorkManager() {
        return this.getDispatcherPartition4rmic().getOneWayWorkManager();
    }

    String getObjectHandlerClassName() {
        return this.objectHandlerClassName;
    }

    public void export() {
        ClassLoader oldcl = null;
        try {
            oldcl = Thread.currentThread().getContextClassLoader();
            if (!(KernelStatus.isServer() || KernelStatus.isApplet() || UseClassCL)) {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            }
            PortableRemoteObject.exportObject(this);
        }
        catch (RemoteException remoteException) {
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldcl);
        }
    }

    public void unexport() {
        try {
            PortableRemoteObject.unexportObject(this);
        }
        catch (RemoteException re) {
            throw new AssertionError((Object)re);
        }
    }

    @Override
    public DispatcherId getId() {
        return this.dispatcherId;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public void dispatchAsync(Request request) {
        block2: {
            request.setTranInfo(2);
            try {
                this.dispatchAsyncInternal(request, tm.getTransaction(), true);
            }
            catch (Exception e) {
                if (!JMSDebug.JMSDispatcher.isDebugEnabled()) break block2;
                JMSDebug.JMSDispatcher.debug("DispatcherImpl.dispatchAsync(): " + e.getMessage());
            }
        }
    }

    @Override
    public void dispatchAsyncWithId(Request request, int id) {
        block2: {
            request.setTranInfo(2);
            try {
                this.dispatchAsyncInternal(request, tm.getTransaction(), true);
            }
            catch (Exception e) {
                if (!JMSDebug.JMSDispatcher.isDebugEnabled()) break block2;
                JMSDebug.JMSDispatcher.debug("DispatcherImpl.dispatchAsyncWithId(): " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchAsyncInternal(Request request, Transaction learnedTran, boolean cautiousResume) {
        try {
            this.giveRequestResource(request);
            request.wrappedFiniteStateMachine();
        }
        catch (Throwable t) {
            request.notifyResult(t, false);
        }
        finally {
            if (cautiousResume) {
                DispatcherImpl.cautiousResume(request, learnedTran);
            }
        }
    }

    private static final void cautiousResume(Object debug, Transaction suspendedTran) {
        try {
            Transaction leftover = tm.forceSuspend();
            if (leftover != null && JMSDebug.JMSDispatcher.isDebugEnabled()) {
                JMSDebug.JMSDispatcher.debug("DispatcherImpl.cautiousResume(): " + debug + " retained " + leftover);
            }
        }
        finally {
            if (suspendedTran != null) {
                tm.forceResume(suspendedTran);
            }
        }
    }

    @Override
    public void dispatchNoReply(Request request) {
        Transaction suspendedTran = tm.forceSuspend();
        this.dispatchAsyncInternal(request, suspendedTran, true);
    }

    @Override
    public void dispatchNoReplyWithId(Request request, int id) {
        Transaction suspendedTran = tm.forceSuspend();
        this.dispatchAsyncInternal(request, suspendedTran, true);
    }

    private Response syncRequest(Request request) throws DispatcherException {
        this.giveRequestResource(request);
        try {
            Response response = request.wrappedFiniteStateMachine();
            if (response != request) {
                return response;
            }
            return request.getResult();
        }
        catch (RuntimeException rte) {
            request.complete(rte, false);
            throw rte;
        }
        catch (Error err) {
            request.complete(err, false);
            throw err;
        }
        catch (DispatcherException de) {
            request.complete(de, false);
            throw de;
        }
        catch (Throwable t) {
            DispatcherException de = new DispatcherException(t);
            request.complete(de, false);
            throw de;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response dispatchSync(Request request) throws DispatcherException {
        Transaction suspendedTran = null;
        suspendedTran = tm.forceSuspend();
        request.setTranInfo(2);
        request.setSyncRequest(true);
        try {
            Response response = this.syncRequest(request);
            return response;
        }
        finally {
            DispatcherImpl.cautiousResume(request, suspendedTran);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response dispatchSyncTran(Request request) throws DispatcherException {
        Transaction learnedTran = null;
        try {
            learnedTran = tm.getTransaction();
        }
        catch (Exception e) {
            throw new DispatcherException(e);
        }
        request.setTranInfo(2);
        request.setSyncRequest(true);
        try {
            Response response = this.syncRequest(request);
            return response;
        }
        finally {
            DispatcherImpl.cautiousResume(request, learnedTran);
        }
    }

    @Override
    public Response dispatchSyncFuture(Request request) throws RemoteException {
        throw new Error("compiler error");
    }

    public void dispatchSyncFuture(Request request, FutureResponse future) {
        request.setTranInfo(0);
        request.setFutureResponse(future);
        request.setSyncRequest(true);
        this.dispatchAsyncInternal(request, null, false);
    }

    @Override
    public Response dispatchSyncTranFuture(Request request) throws RemoteException {
        throw new Error("compiler error");
    }

    @Override
    public Response dispatchSyncTranFutureWithId(Request request, int id) throws RemoteException {
        throw new Error("compiler error");
    }

    public void dispatchSyncTranFuture(Request request, FutureResponse future) {
        request.setTranInfo(2);
        request.setFutureResponse(future);
        request.setSyncRequest(true);
        this.dispatchAsyncInternal(request, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response dispatchSyncNoTran(Request request) throws DispatcherException {
        Transaction suspendedTran = tm.forceSuspend();
        request.setSyncRequest(true);
        try {
            Response response = this.syncRequest(request);
            return response;
        }
        finally {
            DispatcherImpl.cautiousResume(request, suspendedTran);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response dispatchSyncNoTranWithId(Request request, int id) throws DispatcherException {
        Transaction suspendedTran = tm.forceSuspend();
        request.setSyncRequest(true);
        try {
            Response response = this.syncRequest(request);
            return response;
        }
        finally {
            DispatcherImpl.cautiousResume(request, suspendedTran);
        }
    }

    @Override
    public Response dispatchSyncNoTranFuture(Request request) throws RemoteException {
        throw new Error("compiler error");
    }

    public void dispatchSyncNoTranFuture(Request request, FutureResponse future) {
        request.setTranInfo(0);
        request.setFutureResponse(future);
        request.setSyncRequest(true);
        this.dispatchAsyncInternal(request, null, false);
    }

    @Override
    public void dispatchAsyncFuture(Request request, AsyncResult asyncResult) {
        throw new Error("compiler error");
    }

    public void dispatchAsyncFuture(Request request, AsyncResult asyncResult, FutureResponse future) {
        if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
            JMSDebug.JMSDispatcher.debug("DispatcherImpl.dispatchAsyncFuture() : " + request);
        }
        request.setAsyncResult(asyncResult);
        request.setFutureResponse(future);
        this.dispatchAsyncInternal(request, null, false);
    }

    @Override
    public void dispatchAsyncFutureWithId(Request request, AsyncResult asyncResult, int id) {
        throw new Error("compiler error");
    }

    public void dispatchAsyncFutureWithId(Request request, AsyncResult asyncResult, int id, FutureResponse future) {
        if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
            JMSDebug.JMSDispatcher.debug("DispatcherImpl.dispatchAsyncFutureWithId() : " + request);
        }
        request.setAsyncResult(asyncResult);
        request.setFutureResponse(future);
        this.dispatchAsyncInternal(request, null, false);
    }

    @Override
    public void dispatchAsyncTranFuture(Request request, AsyncResult asyncResult) {
        throw new AssertionError((Object)"compiler error");
    }

    public void dispatchAsyncTranFuture(Request request, AsyncResult asyncResult, FutureResponse future) {
        if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
            JMSDebug.JMSDispatcher.debug("DispatcherImpl.dispatchAsyncFuture() : " + request);
        }
        request.setTranInfo(2);
        request.setAsyncResult(asyncResult);
        request.setFutureResponse(future);
        this.dispatchAsyncInternal(request, null, false);
    }

    @Override
    public void dispatchAsyncTranFutureWithId(Request request, AsyncResult asyncResult, int id) {
        throw new Error("compiler error");
    }

    public void dispatchAsyncTranFutureWithId(Request request, AsyncResult asyncResult, int id, FutureResponse future) {
        if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
            JMSDebug.JMSDispatcher.debug("DispatcherImpl.dispatchAsyncTranFutureWithId() : " + request);
        }
        request.setTranInfo(2);
        request.setAsyncResult(asyncResult);
        request.setFutureResponse(future);
        this.dispatchAsyncInternal(request, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchOneWayWithId(Request request, int id) {
        Transaction suspendedTran = tm.forceSuspend();
        try {
            this.dispatchAsyncInternal(request, suspendedTran, true);
        }
        finally {
            DispatcherImpl.cautiousResume(request, suspendedTran);
        }
    }

    @Override
    public void dispatchOneWay(Request request) {
        Transaction suspendedTran = tm.forceSuspend();
        try {
            this.dispatchAsyncInternal(request, suspendedTran, true);
        }
        finally {
            DispatcherImpl.cautiousResume(request, suspendedTran);
        }
    }

    @Override
    public DispatcherPeerGoneListener addDispatcherPeerGoneListener(DispatcherPeerGoneListener listener) {
        return null;
    }

    @Override
    public void removeDispatcherPeerGoneListener(DispatcherPeerGoneListener l) {
    }

    public final int hashCode() {
        return this.dispatcherId.hashCode() ^ this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof DispatcherImpl) {
            DispatcherImpl d = (DispatcherImpl)o;
            return this == d || (this.dispatcherId == d.getId() || this.dispatcherId.equals(d.getId())) && (this.name == d.getName() || this.name.equals(d.getName()));
        }
        return false;
    }

    public Object getFastDispatcher() {
        return this.fastDispatcher;
    }

    @Override
    public Object interopWriteReplace(PeerInfo peerInfo) throws IOException {
        if (FASTDISPATCH && peerInfo.compareTo(PeerInfo.VERSION_DIABLO) >= 0 && !KernelStatus.isApplet()) {
            if (this.fastDispatcher == null) {
                this.fastDispatcher = new FastDispatcherImpl(this);
            }
            if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
                JMSDebug.JMSDispatcher.debug("DispatcherImpl.interopWriteReplace(" + peerInfo + ") return FastDispatcherImpl(name=" + this.name + ", dispatcherId=" + this.dispatcherId + "this@" + this.hashCode());
            }
            return this.fastDispatcher;
        }
        if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
            JMSDebug.JMSDispatcher.debug("DispatcherImpl.interopWriteReplace(" + peerInfo + ") return DispatcherImpl(name=" + this.name + ", dispatcherId=" + this.dispatcherId + "this@" + this.hashCode());
        }
        return this;
    }

    static boolean fastDispatchEnabled() {
        String propName = FASTDISPATCH_PROPNAME;
        try {
            boolean ret;
            String val = System.getProperty(propName);
            boolean bl = ret = val == null || !val.equalsIgnoreCase("false");
            if (val != null) {
                System.out.println("\n\n *** -D" + propName + "=" + ret + " *** \n\n");
            }
            return ret;
        }
        catch (Throwable t) {
            new RuntimeException("error processing " + propName).printStackTrace();
            return true;
        }
    }

    public weblogic.jms.dispatcher.DispatcherImpl getInteropDispatcher() {
        return this.interopDispatcher;
    }

    public boolean isPartitionActive() {
        return this.getDispatcherPartition4rmic().isPartitionActive();
    }

    @Override
    public String getPartitionId() {
        return this.partitionId;
    }

    @Override
    public String getPartitionName() {
        return this.partitionName;
    }

    @Override
    public String getConnectionPartitionName() {
        return this.partitionName;
    }

    @Override
    public void giveRequestResource(Request request) {
        request.setDispatcherPartition4rmic(this.getDispatcherPartition4rmic());
    }

    @Override
    public DispatcherPartition4rmic getDispatcherPartition4rmic() {
        return (DispatcherPartition4rmic)this.dispatcherPartition4rmic;
    }

    public DispatcherWrapper constructPartitionAwareDispatcherWrapper() {
        return new DispatcherWrapper(this, this.getPartitionId(), this.getPartitionName(), this.getConnectionPartitionName());
    }
}

