/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.dispatcher;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import weblogic.jms.common.JMSDebug;
import weblogic.messaging.ID;
import weblogic.messaging.dispatcher.Request;
import weblogic.messaging.dispatcher.Response;

public abstract class DispatcherObjectHandler {
    protected int MASK;

    protected DispatcherObjectHandler(int mask) {
        this.MASK = mask;
    }

    public void writeRequest(ObjectOutput out, Request r) throws IOException {
        out.writeInt(r.getMethodId());
        r.writeShortened(out);
    }

    public Request readRequest(int methodID, ObjectInput in, ID invocableID) throws ClassNotFoundException, IOException {
        Request request = this.instantiate(methodID & this.MASK);
        try {
            request.readExternal(in);
        }
        catch (IOException e) {
            if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
                DispatcherObjectHandler.debugWireOperation("RecvReq  ", (byte)15, request, -1, invocableID, null, e);
            }
            throw e;
        }
        catch (ClassNotFoundException e) {
            if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
                DispatcherObjectHandler.debugWireOperation("RecvReq  ", (byte)15, request, -1, invocableID, null, e);
            }
            throw e;
        }
        if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
            DispatcherObjectHandler.debugWireOperation("RecvReq  ", (byte)15, request, -1, invocableID, null, null);
        }
        request.setMethodId(methodID);
        request.setInvocableId(invocableID);
        return request;
    }

    static void debugWireOperation(String sendRecv, byte requestType, Request request, int workId, ID invocableID, Response response, Throwable thrown) {
        String dbgWork = workId == 0 || workId == -1 ? "" : "workId " + Integer.toString(workId) + " ";
        String dbgType = 15 == requestType ? "" : ", requestType x" + Integer.toHexString(requestType).toUpperCase();
        String dbgResponse = response == null ? "" : ", Response " + response.getClass().getName();
        String msg = sendRecv + dbgWork + dbgType + ", ID " + invocableID + ", " + request.getClass().getName() + dbgResponse;
        if (thrown == null) {
            JMSDebug.JMSDispatcher.debug(msg);
        } else {
            JMSDebug.JMSDispatcher.debug(msg, thrown);
        }
    }

    public void writeResponse(ObjectOutput out, Request request, Response response) throws IOException {
        try {
            out.writeInt(request.getMethodId() & this.MASK);
            response.writeExternal(out);
        }
        catch (IOException ioe) {
            if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
                DispatcherObjectHandler.debugWireOperation("SendResp ", (byte)15, request, -1, request.getInvocableId(), response, ioe);
            }
            throw ioe;
        }
        if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
            DispatcherObjectHandler.debugWireOperation("SendResp ", (byte)15, request, -1, request.getInvocableId(), response, null);
        }
    }

    public Response readResponse(ObjectInput in, Request request) throws ClassNotFoundException, IOException {
        int tc = in.readInt();
        if (tc != (request.getMethodId() & this.MASK)) {
            StreamCorruptedException sce = new StreamCorruptedException("Unexpected response for " + request.getClass().getName() + " : " + tc);
            if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
                DispatcherObjectHandler.debugWireOperation("RecvResp ", (byte)15, request, -1, request.getInvocableId(), null, sce);
            }
            throw sce;
        }
        Response response = request.createResponse();
        try {
            response.readExternal(in);
        }
        catch (IOException ioe) {
            if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
                DispatcherObjectHandler.debugWireOperation("RecvResp ", (byte)15, request, -1, request.getInvocableId(), response, ioe);
            }
            throw ioe;
        }
        catch (ClassNotFoundException cce) {
            if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
                DispatcherObjectHandler.debugWireOperation("RecvResp ", (byte)15, request, -1, request.getInvocableId(), response, cce);
            }
            throw cce;
        }
        if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
            DispatcherObjectHandler.debugWireOperation("RecvResp ", (byte)15, request, -1, request.getInvocableId(), response, null);
        }
        return response;
    }

    protected Request instantiate(int tc) throws IOException {
        throw new StreamCorruptedException("Unknown typecode: " + tc);
    }

    static DispatcherObjectHandler load(String className) {
        try {
            return (DispatcherObjectHandler)Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new AssertionError((Object)cnfe);
        }
        catch (InstantiationException ie) {
            throw new AssertionError((Object)ie);
        }
        catch (IllegalAccessException iae) {
            throw new AssertionError((Object)iae);
        }
    }
}

