/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.dispatcher;

import jakarta.jms.JMSException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.security.AccessController;
import java.util.Map;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.dispatcher.DispatcherPartitionContext;
import weblogic.jms.dispatcher.InvocableManagerDelegate;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.jms.dispatcher.JMSDispatcherManager;
import weblogic.messaging.ID;
import weblogic.messaging.common.IDImpl;
import weblogic.messaging.dispatcher.DispatcherImpl;
import weblogic.messaging.dispatcher.DispatcherObjectHandler;
import weblogic.messaging.dispatcher.DispatcherProxy;
import weblogic.messaging.dispatcher.DispatcherUtils;
import weblogic.messaging.dispatcher.FastDispatcherImpl;
import weblogic.messaging.dispatcher.Invocable;
import weblogic.messaging.dispatcher.Request;
import weblogic.messaging.dispatcher.Response;
import weblogic.rmi.RMILogger;
import weblogic.rmi.extensions.server.FutureResponse;
import weblogic.rmi.internal.AsyncResultImpl;
import weblogic.rmi.internal.BasicFutureResponse;
import weblogic.rmi.internal.BasicServerRef;
import weblogic.rmi.spi.InboundRequest;
import weblogic.rmi.spi.Interceptor;
import weblogic.rmi.spi.InterceptorManager;
import weblogic.rmi.spi.MsgInput;
import weblogic.rmi.spi.MsgOutput;
import weblogic.rmi.spi.OutboundResponse;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.work.IDBasedConstraintEnforcement;
import weblogic.work.WorkAdapter;
import weblogic.work.WorkManager;

public class DispatcherServerRef
extends BasicServerRef {
    private static DispatcherServerRef centralRef;
    private static final AuthenticatedSubject KERNEL_ID;
    private int count;
    private int lastMethodId;
    private int lastRequestType;

    public DispatcherServerRef(Object o) throws RemoteException {
        super(o);
    }

    private DispatcherServerRef(int oid) throws RemoteException {
        super(DispatcherServerRef.class, oid);
    }

    public static void createJmsJavaOid() {
        if (centralRef != null) {
            return;
        }
        try {
            if (JMSDebug.JMSDispatcherRMI.isDebugEnabled()) {
                JMSDebug.JMSDispatcherRMI.debug("DispatcherServerRef.createJmsJavaOid: oid: 45");
            }
            centralRef = new DispatcherServerRef(45);
            centralRef.exportObject();
            centralRef.incrementRefCount();
        }
        catch (RemoteException re) {
            if (JMSDebug.JMSDispatcherRMI.isDebugEnabled()) {
                JMSDebug.JMSDispatcherRMI.debug("DispatcherServerRef registration failed.", re);
            }
            throw new RuntimeException(re);
        }
        catch (RuntimeException e) {
            if (JMSDebug.JMSDispatcherRMI.isDebugEnabled()) {
                JMSDebug.JMSDispatcherRMI.debug("DispatcherServerRef registration failed.", e);
            }
            throw e;
        }
    }

    @Override
    public final void dispatch(final InboundRequest request) {
        int methodID;
        IDImpl invocableID;
        int workId;
        byte requestType;
        FastDispatcherImpl fdi;
        Invocable invocable;
        block14: {
            Interceptor ti;
            MsgInput in = request.getMsgInput();
            invocable = null;
            fdi = null;
            int count = this.count++;
            int lastRequestType = this.lastRequestType;
            try {
                DispatcherPartitionContext dpc;
                Map allPartitionMap;
                requestType = in.readByte();
                workId = (requestType & 0x10) != 0 ? in.readInt() : 0;
                if (DispatcherProxy.hasInvocableID(requestType)) {
                    invocableID = new IDImpl();
                    invocableID.readExternal(in);
                } else {
                    invocableID = null;
                }
                this.lastRequestType = requestType;
                methodID = in.readInt();
                int invocableType = methodID & 0xFF;
                if (invocableID != null && (allPartitionMap = InvocableManagerDelegate.mapForAllParitions(invocableType)) != null && (invocable = (Invocable)allPartitionMap.get(invocableID)) != null && (dpc = (DispatcherPartitionContext)invocable.getDispatcherPartition4rmic()) != null) {
                    fdi = (FastDispatcherImpl)((DispatcherImpl)dpc.getLocalDispatcher().getDelegate()).getFastDispatcher();
                    if (JMSDebug.JMSInvocableVerbose.isDebugEnabled()) {
                        JMSDebug.JMSInvocableVerbose.debug("DispatcherServerRef superset has [" + invocableType + "](" + invocableID + ")/" + invocable);
                    }
                    if (JMSDebug.JMSDispatcherRMI.isDebugEnabled()) {
                        JMSDebug.JMSDispatcherRMI.debug("DispatcherServerRef superset has [" + invocableType + "](" + invocableID + ")/" + invocable);
                    }
                }
                if (fdi == null) {
                    fdi = this.getFastDispatcherImplForRequest(requestType, invocableID, methodID);
                }
            }
            catch (JMSException | IOException | ClassCastException | ClassNotFoundException exception) {
                DispatcherServerRef.trySendThrowableBeforeInterceptor(request, new UnmarshalException("error unmarshalling arguments; count=" + count + ", lastMethodId" + this.lastMethodId + ", lastRequestType" + lastRequestType + ", OID=" + this.getObjectID(), exception));
                return;
            }
            if (DispatcherProxy.isTransactional(requestType) && (ti = InterceptorManager.getManager().getTransactionInterceptor()) != null) {
                try {
                    ti.receiveRequest(request.getTxContext());
                }
                catch (RemoteException re) {
                    if (DispatcherProxy.isOneWay(requestType)) break block14;
                    DispatcherServerRef.trySendThrowable(request, re);
                    return;
                }
            }
        }
        final FastDispatcherImpl localFdi = fdi;
        final Invocable localInvocable = invocable;
        WorkManager manager = workId > 0 || DispatcherProxy.isOneWay(requestType) ? localFdi.getOneWayWorkManager() : (InvocableManagerDelegate.isBEMethod(methodID) ? localFdi.getBEWorkManager() : localFdi.getFEWorkManager());
        if (JMSDebug.JMSDispatcherRMI.isDebugEnabled()) {
            JMSDebug.JMSDispatcherRMI.debug("[" + Thread.currentThread() + "]DispatcherServerRef.dispatch(" + request + "@" + request.hashCode() + ") workId=" + workId + " workManager@" + manager.hashCode() + "=" + manager + " OneWay=" + DispatcherProxy.isOneWay(requestType) + " Async=" + DispatcherProxy.isAsync(requestType) + " Transactional=" + DispatcherProxy.isTransactional(requestType));
        }
        if (workId > 0) {
            IDBasedConstraintEnforcement.getInstance().schedule(manager, new WorkAdapter(){

                @Override
                public void run() {
                    DispatcherServerRef.this.handleRequest(requestType, invocableID, methodID, request, localFdi, localInvocable);
                }
            }, workId);
        } else {
            manager.schedule(new WorkAdapter(){

                @Override
                public void run() {
                    DispatcherServerRef.this.handleRequest(requestType, invocableID, methodID, request, localFdi, localInvocable);
                }
            });
        }
    }

    private FastDispatcherImpl getFastDispatcherImplForRequest(int requestType, ID invocableID, int methodID) throws UnmarshalException {
        FastDispatcherImpl dispatcherToUse;
        if (this.getObjectID() == 45) {
            String partitionId = DispatcherUtils.getPartitionId();
            if (JMSDebug.JMSDispatcherRMI.isDebugEnabled()) {
                JMSDebug.JMSDispatcherRMI.debug("getFastDispatcherImplForRequest: looking up dispatcher for partionId:" + partitionId + " requestType:" + requestType + " methodID:0x" + Integer.toHexString(methodID) + " invocableID:" + invocableID + " methodID:" + methodID);
            }
            try {
                JMSDispatcher jmsDispatcher = JMSDispatcherManager.getRawSingleton().findDispatcherByPartitionIdUnmarshalException(partitionId);
                dispatcherToUse = (FastDispatcherImpl)((DispatcherImpl)jmsDispatcher.getDelegate()).getFastDispatcher();
            }
            catch (UnmarshalException ue) {
                if (JMSDebug.JMSDispatcherRMI.isDebugEnabled()) {
                    JMSDebug.JMSDispatcherRMI.debug("getFastDispatcherImplForRequest: dispatcher not found: " + partitionId + " requestType:" + requestType + " methodID:0x" + Integer.toHexString(methodID) + " invocableID:" + invocableID + " methodID:" + methodID);
                }
                if (JMSDebug.JMSDispatcherRMI.isDebugEnabled()) {
                    JMSDebug.JMSDispatcherRMI.debug("DispatcherServerRef.getFastDispatcherImplForRequest: fdi: " + partitionId + " requestType:" + requestType + " methodID:0x" + Integer.toHexString(methodID) + " invocableID:" + invocableID + " methodID:" + methodID + ", OID=" + this.getObjectID());
                }
                throw ue;
            }
        } else {
            dispatcherToUse = (FastDispatcherImpl)this.getImplementation();
            if (JMSDebug.JMSDispatcherRMI.isDebugEnabled()) {
                JMSDebug.JMSDispatcherRMI.debug("getFastDispatcherImplForRequest with getImplementation " + (dispatcherToUse == null ? null : dispatcherToUse.getPartitionName() + "/<part,name>" + dispatcherToUse.getName()) + " requestType:" + requestType + " methodID:0x" + Integer.toHexString(methodID) + " invocableID:" + invocableID + " methodID:" + methodID + ", OID=" + this.getObjectID());
            }
        }
        if (JMSDebug.JMSDispatcherRMI.isDebugEnabled()) {
            JMSDebug.JMSDispatcherRMI.debug("getFastDispatcherImplForRequest: dispatcher: " + dispatcherToUse.getPartitionName() + " (" + dispatcherToUse.getPartitionId() + ") requestType:" + requestType + " methodID:0x" + Integer.toHexString(methodID) + " invocableID:" + invocableID + " methodID:" + methodID + ", OID=" + this.getObjectID());
        }
        return dispatcherToUse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleRequest(int requestType, ID invocableID, int methodID, InboundRequest request, FastDispatcherImpl localFdi, Invocable invocable) {
        OutboundResponse response = null;
        try {
            if (!DispatcherProxy.isOneWay(requestType)) {
                Interceptor ti;
                response = request.getOutboundResponse();
                if (DispatcherProxy.isTransactional(requestType) && (ti = InterceptorManager.getManager().getTransactionInterceptor()) != null) {
                    ti.dispatchRequest(request.getTxContext());
                }
            }
            AuthenticatedSubject subject = (AuthenticatedSubject)request.getSubject();
            try {
                SecurityServiceManager.pushSubject(KERNEL_ID, subject);
                this.invoke(requestType, invocableID, methodID, request, response, localFdi, invocable);
            }
            finally {
                SecurityServiceManager.popSubject(KERNEL_ID);
            }
        }
        catch (Throwable thr) {
            DispatcherServerRef.handleThrowable(request, response, thr);
        }
        finally {
            if (DispatcherProxy.isOneWay(requestType)) {
                try {
                    request.close();
                }
                catch (IOException ioe) {
                    throw new AssertionError((Object)ioe);
                }
            }
        }
    }

    private static void handleThrowable(InboundRequest request, OutboundResponse response, Throwable t) {
        if (t instanceof RuntimeException) {
            RMILogger.logRuntimeException("dispatch", t);
        } else if (t instanceof Error) {
            RMILogger.logError("dispatch", t);
        } else {
            RMILogger.logException("dispatch", t);
        }
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                response = request.getOutboundResponse();
                response.transferThreadLocalContext(request);
            }
            catch (IOException ioe) {
                RMILogger.logAssociateTX(ioe);
            }
        }
        DispatcherServerRef.handleThrowable(t, response);
    }

    private final void invoke(int requestType, ID invocableID, int methodID, InboundRequest inboundRequest, OutboundResponse response, FastDispatcherImpl localFdi, Invocable invocable) throws Exception {
        Request request;
        DispatcherObjectHandler objectHandler = localFdi.getObjectHandler();
        int count = this.count++;
        int lastMethodId = this.lastMethodId;
        int lastRequestType = this.lastRequestType;
        this.lastRequestType = requestType;
        try {
            MsgInput in = inboundRequest.getMsgInput();
            this.lastMethodId = methodID;
            request = objectHandler.readRequest(methodID, in, invocableID);
            if (invocable != null) {
                request.setInvocable(invocable);
            }
            localFdi.giveRequestResource(request);
        }
        catch (IOException ioexception) {
            throw new UnmarshalException("error unmarshalling arguments, count=" + count + ", lastMethodId" + lastMethodId + ", lastRequestType" + lastRequestType, ioexception);
        }
        catch (ClassNotFoundException classnotfoundexception) {
            throw new UnmarshalException("error unmarshalling arguments; count=" + count + ", lastMethodId" + lastMethodId + ", lastRequestType" + lastRequestType, classnotfoundexception);
        }
        if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
            JMSDebug.JMSDispatcher.debug("[" + Thread.currentThread() + "]Dispatching : " + request + " OneWay=" + DispatcherProxy.isOneWay(requestType) + " Async=" + DispatcherProxy.isAsync(requestType) + " Transactional=" + DispatcherProxy.isTransactional(requestType));
        }
        if (!DispatcherProxy.isOneWay(requestType)) {
            OutboundResponseWrapper rw = new OutboundResponseWrapper(inboundRequest, response, request, objectHandler);
            request.setFutureResponse(rw);
            if (DispatcherProxy.isAsync(requestType)) {
                AsyncResultImpl asyncResult = new AsyncResultImpl(inboundRequest, rw);
                request.setAsyncResult(asyncResult);
            }
            if (DispatcherProxy.isTransactional(requestType)) {
                request.setTranInfo(2);
            } else {
                request.setTranInfo(0);
            }
        }
        try {
            request.wrappedFiniteStateMachine();
        }
        catch (Throwable t) {
            request.notifyResult(t, false);
        }
    }

    protected boolean deferredUnmarshal() {
        return false;
    }

    static {
        KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }

    static final class OutboundResponseWrapper
    extends BasicFutureResponse
    implements FutureResponse,
    OutboundResponse,
    MsgOutput {
        private final DispatcherObjectHandler objectHandler;
        private final OutboundResponse outboundResponse;
        private MsgOutput msgOutputDelegate;
        private final Request request;

        private OutboundResponseWrapper(InboundRequest inboundRequest, OutboundResponse outboundResponse, Request request, DispatcherObjectHandler objectHandler) {
            super(inboundRequest, outboundResponse);
            this.outboundResponse = outboundResponse;
            this.request = request;
            this.objectHandler = objectHandler;
        }

        @Override
        public MsgOutput getMsgOutput() throws RemoteException {
            this.msgOutputDelegate = super.getMsgOutput();
            return this;
        }

        @Override
        public void writeObject(Object obj, Class c) throws IOException {
            if (obj instanceof Throwable) {
                if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
                    DispatcherObjectHandler.debugWireOperation("SendResp ", (byte)15, this.request, -1, this.request.getInvocableId(), null, (Throwable)obj);
                }
                this.outboundResponse.sendThrowable((Throwable)obj);
            } else {
                this.objectHandler.writeResponse(this.msgOutputDelegate, this.request, (Response)obj);
            }
        }

        @Override
        public void writeObject(Object obj) throws IOException {
            this.objectHandler.writeResponse(this.msgOutputDelegate, this.request, (Response)obj);
        }

        @Override
        public void write(int i) throws IOException {
            this.msgOutputDelegate.write(i);
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            this.msgOutputDelegate.write(bytes);
        }

        @Override
        public void write(byte[] bytes, int i, int i1) throws IOException {
            this.msgOutputDelegate.write(bytes, i, i1);
        }

        @Override
        public void flush() throws IOException {
            this.msgOutputDelegate.flush();
        }

        @Override
        public void writeBoolean(boolean b) throws IOException {
            this.msgOutputDelegate.writeBoolean(b);
        }

        @Override
        public void writeByte(int i) throws IOException {
            this.msgOutputDelegate.writeByte(i);
        }

        @Override
        public void writeShort(int i) throws IOException {
            this.msgOutputDelegate.writeShort(i);
        }

        @Override
        public void writeChar(int i) throws IOException {
            this.msgOutputDelegate.writeChar(i);
        }

        @Override
        public void writeInt(int i) throws IOException {
            this.msgOutputDelegate.writeInt(i);
        }

        @Override
        public void writeLong(long l) throws IOException {
            this.msgOutputDelegate.writeLong(l);
        }

        @Override
        public void writeFloat(float v) throws IOException {
            this.msgOutputDelegate.writeFloat(v);
        }

        @Override
        public void writeDouble(double v) throws IOException {
            this.msgOutputDelegate.writeDouble(v);
        }

        @Override
        public void writeBytes(String s) throws IOException {
            this.msgOutputDelegate.writeBytes(s);
        }

        @Override
        public void writeChars(String s) throws IOException {
            this.msgOutputDelegate.writeChars(s);
        }

        @Override
        public void writeUTF(String s) throws IOException {
            this.msgOutputDelegate.writeUTF(s);
        }
    }
}

