/*
 * Decompiled with CFR 0.152.
 */
package weblogic.net.http;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import weblogic.net.http.HttpRequestHeaderContributor;

public abstract class HttpContributorRegistrar {
    public static HttpContributorRegistrar getHttpContributorRegistrar() {
        return HttpContributorRegistrarImpl.getInstance();
    }

    public abstract void registerRequestHeaderContributor(HttpRequestHeaderContributor var1);

    abstract Collection<HttpRequestHeaderContributor> getRequestHeaderContributors();

    private static class HttpContributorRegistrarImpl
    extends HttpContributorRegistrar {
        private AtomicBoolean contributorsChanged;
        private Collection<HttpRequestHeaderContributor> snapShotContributors;
        private Collection<HttpRequestHeaderContributor> contributors = new ArrayList<HttpRequestHeaderContributor>();

        static HttpContributorRegistrar getInstance() {
            return SingletonMaker.theOne();
        }

        private HttpContributorRegistrarImpl() {
            this.snapShotContributors = new ArrayList<HttpRequestHeaderContributor>();
            this.contributorsChanged = new AtomicBoolean(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerRequestHeaderContributor(HttpRequestHeaderContributor contributor) {
            Collection<HttpRequestHeaderContributor> collection = this.contributors;
            synchronized (collection) {
                this.contributorsChanged.set(true);
                this.contributors.add(contributor);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        Collection<HttpRequestHeaderContributor> getRequestHeaderContributors() {
            if (this.contributorsChanged.get()) {
                Collection<HttpRequestHeaderContributor> collection = this.contributors;
                synchronized (collection) {
                    this.snapShotContributors = (Collection)((ArrayList)this.contributors).clone();
                    this.contributorsChanged.set(false);
                }
            }
            return this.snapShotContributors;
        }

        private static class SingletonMaker {
            private static final HttpContributorRegistrar singleton = new HttpContributorRegistrarImpl();

            private SingletonMaker() {
            }

            public static HttpContributorRegistrar theOne() {
                return singleton;
            }
        }
    }
}

