/*
 * Decompiled with CFR 0.152.
 */
package weblogic.net.http;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.ConnectException;
import java.net.CookieHandler;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.SocketFactory;
import javax.net.ssl.SSLException;
import weblogic.common.ProxyAuthenticator;
import weblogic.kernel.KernelStatus;
import weblogic.net.http.ContentLengthOutputStream;
import weblogic.net.http.HttpClient;
import weblogic.net.http.HttpContributorRegistrar;
import weblogic.net.http.HttpRequestHeaderContributor;
import weblogic.net.http.HttpUnauthorizedException;
import weblogic.net.http.MessageHeader;
import weblogic.net.http.ParseUtil;
import weblogic.net.http.SecurityHelper;
import weblogic.net.http.SocketClosedNotification;
import weblogic.net.http.SocketTimeoutNotification;
import weblogic.security.Security;
import weblogic.security.subject.SubjectManager;
import weblogic.utils.encoders.BASE64Encoder;
import weblogic.utils.http.HttpChunkOutputStream;
import weblogic.utils.http.HttpParsing;
import weblogic.utils.http.HttpReasonPhraseCoder;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.NullInputStream;
import weblogic.utils.io.UnsyncByteArrayOutputStream;

public class HttpURLConnection
extends java.net.HttpURLConnection {
    private static String userAgent;
    private static boolean strictPostRedirect;
    private static String proxyAuthClassName;
    private static String proxyAuthString;
    private static boolean http11;
    private static boolean bufferPostForRetry;
    static final boolean debug;
    private static final String acceptString = "text/html, image/gif, image/jpeg, */*; q=.2";
    private static final int MAX_REDIRECTS = 5;
    private static final int MAX_TRIES = 3;
    private static final int MAX_LENGTH_OF_REQUEST_METHOD = 32;
    protected HttpClient http;
    protected Proxy instProxy;
    protected MessageHeader requests;
    protected MessageHeader responses;
    protected InputStream inputStream = null;
    protected OutputStream streamedPostOS = null;
    protected UnsyncByteArrayOutputStream bufferedPostOS = null;
    protected boolean setRequests = false;
    protected boolean useHttp11 = http11;
    private boolean wroteRequests = false;
    private SocketFactory socketFactory;
    private String redirectCookieStr = null;
    private static final String COOKIE_SEPARATOR = ";";
    private static boolean sendCookiesRedirect;
    private int readTimeout = defaultReadTimeout;
    private int connectTimeout = defaultConnectTimeout;
    private int chunkLength = -1;
    private int fixedContentLength = -1;
    private CookieHandler cookieHandler;
    private boolean setUserCookies = true;
    private String userCookies = null;
    private String userCookies2 = null;
    private static int defaultReadTimeout;
    protected static int defaultConnectTimeout;
    protected IOException rememberedException = null;
    protected boolean ignoreSystemNonProxyHosts = false;
    protected boolean ignoreProxy = false;
    private static SocketFactory defaultSocketFactory;
    private static final String[] EXCLUDE_HEADERS;
    private static final String[] EXCLUDE_HEADERS2;
    private static boolean retryPost;
    private boolean triedOnce = false;
    private boolean fixedLengthStreamingModeEnabled = false;
    private boolean chunkStreamingModeEnabled = false;

    public HttpURLConnection(URL u) {
        this(u, null);
    }

    public HttpURLConnection(URL u, Proxy p) {
        super(u);
        this.requests = new MessageHeader();
        this.responses = new MessageHeader();
        this.instProxy = p == null ? Proxy.NO_PROXY : p;
        this.cookieHandler = HttpClient.getCookieHandler();
    }

    protected String getProtocol() {
        return "http";
    }

    public final void setSocketFactory(SocketFactory fact) {
        this.socketFactory = fact;
    }

    public final SocketFactory getSocketFactory() {
        if (this.socketFactory != null) {
            return this.socketFactory;
        }
        return defaultSocketFactory;
    }

    public static void setDefaultSocketFactory(SocketFactory nuDefaultSF) {
        defaultSocketFactory = nuDefaultSF;
    }

    protected synchronized void writeRequests() throws IOException {
        if (this.wroteRequests) {
            return;
        }
        this.wroteRequests = true;
        if (!this.setRequests) {
            this.doSetRequests();
        }
        this.setCookieHeader();
        this.requests.print(this.http.getOutputStream());
        this.http.getOutputStream().flush();
        if (debug) {
            HttpURLConnection.p("wrote request - " + this.requests);
        }
        if (this.http != null) {
            this.http.setLastUsed(System.currentTimeMillis());
        }
        if (this.bufferedPostOS != null) {
            this.bufferedPostOS.writeTo(this.http.getOutputStream());
            this.http.getOutputStream().flush();
        }
    }

    public void setIgnoreSystemNonProxyHosts(boolean v) {
        this.ignoreSystemNonProxyHosts = v;
    }

    public void setIgnoreProxy(boolean v) {
        this.ignoreProxy = v;
    }

    @Override
    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        try {
            this.http = HttpClient.New(this.url, this.instProxy, this.getSocketFactory(), this.useHttp11, this.getConnectTimeout(), this.getReadTimeout(), this.ignoreSystemNonProxyHosts, this.ignoreProxy);
        }
        catch (SocketTimeoutException ste) {
            this.rememberedException = ste;
            throw ste;
        }
        this.http.setConnection(this);
        this.connected = true;
        if (debug) {
            HttpURLConnection.p("connected " + this.http + " HTTP/1." + (this.useHttp11 ? "1" : "0"));
        }
    }

    protected HttpClient getHttpClient() throws IOException {
        HttpClient h = HttpClient.New(this.url, this.instProxy, this.getSocketFactory(), this.useHttp11, this.getConnectTimeout(), this.getReadTimeout(), false, this.ignoreSystemNonProxyHosts, this.ignoreProxy);
        h.setConnection(this);
        this.connected = true;
        if (debug) {
            HttpURLConnection.p("new HttpClient=" + h);
        }
        return h;
    }

    @Override
    public synchronized OutputStream getOutputStream() throws IOException {
        try {
            if (!this.doOutput) {
                throw new ProtocolException("cannot write to a URLConnection if doOutput=false - call setDoOutput(true)");
            }
            if (this.method.equals("GET")) {
                this.setRequestMethod("POST");
            }
            if (("HEAD".equals(this.method) || "OPTIONS".equals(this.method) || "DELETE".equals(this.method) || "TRACE".equals(this.method)) && this.getProtocol().equals(this.url.getProtocol())) {
                throw new ProtocolException("HTTP method " + this.method + " doesn't support output");
            }
            if (this.inputStream != null) {
                throw new ProtocolException("Cannot write output after reading input.");
            }
            if (!bufferPostForRetry) {
                if (this.useHttp11 && this.chunkStreamingModeEnabled) {
                    this.connect();
                    this.writeRequests();
                    OutputStream outputStream = this.streamedPostOS = this.chunkLength > 0 ? new HttpChunkOutputStream(this.http.getOutputStream(), this.chunkLength) : new HttpChunkOutputStream(this.http.getOutputStream());
                    if (debug) {
                        HttpURLConnection.p("using chunked streaming. ChunkSize=" + (this.chunkLength > 0 ? this.chunkLength : Chunk.CHUNK_SIZE - 6 - 2));
                    }
                    return this.streamedPostOS;
                }
                if (this.hasFixedContentLength()) {
                    this.connect();
                    this.writeRequests();
                    String clen = this.getRequestProperty("Content-Length");
                    this.streamedPostOS = new ContentLengthOutputStream(this.http.getOutputStream(), Integer.parseInt(clen));
                    if (debug) {
                        HttpURLConnection.p("using content length streaming. CL=" + Integer.parseInt(clen));
                    }
                    return this.streamedPostOS;
                }
            }
            if (this.bufferedPostOS == null) {
                this.bufferedPostOS = new UnsyncByteArrayOutputStream();
            } else if (!this.connected) {
                this.bufferedPostOS.reset();
            }
            if (debug) {
                HttpURLConnection.p("using buffered stream");
            }
            return this.bufferedPostOS;
        }
        catch (RuntimeException e) {
            this.disconnect();
            throw e;
        }
        catch (IOException e) {
            this.disconnect();
            throw e;
        }
    }

    private boolean hasFixedContentLength() {
        String clen = this.getRequestProperty("Content-Length");
        if (clen == null && this.useHttp11 && this.fixedContentLength > 0) {
            clen = Integer.toString(this.fixedContentLength);
        }
        return clen != null;
    }

    protected static String getProxyAuthString() {
        return proxyAuthString;
    }

    public static String getAuthInfo(String host, int port, String header) throws IOException {
        if (debug) {
            HttpURLConnection.p("getAuthInfo(" + host + ", " + port + ", " + header + ") called");
        }
        if (proxyAuthClassName == null || header == null) {
            throw new HttpUnauthorizedException("Proxy or Server Authentication Required");
        }
        if (debug) {
            HttpURLConnection.p("using ProxyAuthenticator = " + proxyAuthClassName);
        }
        ProxyAuthenticator pauth = null;
        String authType = null;
        String authPrompt = null;
        String authHeader = header.trim();
        int ind = authHeader.indexOf(32);
        if (ind == -1) {
            authType = authHeader;
            authPrompt = "Login to Proxy";
        } else {
            authType = authHeader.substring(0, ind);
            authPrompt = authHeader.substring(ind + 1);
            if ((ind = authPrompt.indexOf(61)) != -1) {
                authPrompt = authPrompt.substring(ind + 1);
            }
        }
        try {
            pauth = (ProxyAuthenticator)Class.forName(proxyAuthClassName).newInstance();
        }
        catch (Exception e) {
            throw new HttpUnauthorizedException("Proxy authenticator " + proxyAuthClassName + " failed: " + e);
        }
        pauth.init(host, port, authType, authPrompt);
        String[] unp = pauth.getLoginAndPassword();
        if (unp == null || unp.length != 2) {
            throw new HttpUnauthorizedException("Proxy authentication failed");
        }
        String unpstr = unp[0] + ':' + unp[1];
        byte[] buf = unpstr.getBytes();
        BASE64Encoder benc = new BASE64Encoder();
        String ret = "Basic " + benc.encodeBuffer(buf);
        if (debug) {
            HttpURLConnection.p("getAuthString() returning '" + ret + "'");
        }
        return ret;
    }

    public static String getProxyBasicCredentials(String proxyHost, int proxyPort, String authHeader, URL requestUrl) throws IOException {
        if (debug) {
            HttpURLConnection.p("getProxyBasicCredentials(" + proxyHost + ", " + proxyPort + ", " + authHeader + ", " + requestUrl + ") called");
        }
        if (authHeader == null) {
            throw new HttpUnauthorizedException("Proxy authentication required but Proxy-Authenticate header is null");
        }
        String[] schemeAndRealm = HttpURLConnection.getSchemeAndRealm(authHeader.trim());
        InetAddress requestInetAddress = HttpURLConnection.getRequestInetAddress(proxyHost);
        String unpstr = null;
        PasswordAuthentication auth = HttpURLConnection.priviledgedRequestPasswordAuthentication(proxyHost, requestInetAddress, proxyPort, "http", schemeAndRealm[1], schemeAndRealm[0], requestUrl, Authenticator.RequestorType.PROXY);
        if (auth == null) {
            if (proxyAuthClassName == null) {
                throw new HttpUnauthorizedException("Proxy Authentication Required");
            }
            ProxyAuthenticator pauth = null;
            try {
                pauth = (ProxyAuthenticator)Class.forName(proxyAuthClassName).newInstance();
            }
            catch (Exception e) {
                throw new HttpUnauthorizedException("Proxy authenticator " + proxyAuthClassName + " failed: " + e);
            }
            pauth.init(proxyHost, proxyPort, schemeAndRealm[0], schemeAndRealm[1]);
            String[] unp = pauth.getLoginAndPassword();
            if (unp == null || unp.length != 2) {
                throw new HttpUnauthorizedException("Proxy authentication failed");
            }
            unpstr = unp[0] + ':' + unp[1];
        } else {
            unpstr = auth.getUserName() + ':' + new String(auth.getPassword());
        }
        byte[] buf = unpstr.getBytes();
        BASE64Encoder benc = new BASE64Encoder();
        String ret = "Basic " + benc.encodeBuffer(buf);
        if (debug) {
            HttpURLConnection.p("getProxyBasicCredentials() returning '" + ret + "'");
        }
        return ret;
    }

    public static String getServerBasicCredentials(URL requestUrl, String authHeader) throws IOException {
        if (debug) {
            HttpURLConnection.p("getServerBasicCredentials(" + requestUrl + ", " + authHeader + ") called");
        }
        if (authHeader == null) {
            throw new HttpUnauthorizedException("Server authentication required but WWW-Authenticate header is null");
        }
        String[] schemeAndRealm = HttpURLConnection.getSchemeAndRealm(authHeader.trim());
        InetAddress requestInetAddress = HttpURLConnection.getRequestInetAddress(requestUrl.getHost());
        int requestPort = HttpURLConnection.getRequestPort(requestUrl);
        PasswordAuthentication auth = HttpURLConnection.priviledgedRequestPasswordAuthentication(requestUrl.getHost(), requestInetAddress, requestPort, requestUrl.getProtocol(), schemeAndRealm[1], schemeAndRealm[0], requestUrl, Authenticator.RequestorType.SERVER);
        if (auth == null) {
            throw new HttpUnauthorizedException("Server Authentication Required");
        }
        String unpstr = auth.getUserName() + ':' + new String(auth.getPassword());
        byte[] buf = unpstr.getBytes();
        BASE64Encoder benc = new BASE64Encoder();
        String ret = "Basic " + benc.encodeBuffer(buf);
        if (debug) {
            HttpURLConnection.p("getServerBasicCredentials() returning '" + ret + "'");
        }
        return ret;
    }

    private static String[] getSchemeAndRealm(String authHeader) throws IOException {
        String authScheme = null;
        String authPrompt = null;
        int ind = authHeader.indexOf(32);
        if (ind == -1) {
            authScheme = authHeader;
            authPrompt = "";
        } else {
            authScheme = authHeader.substring(0, ind);
            authPrompt = authHeader.substring(ind + 1);
            if ((ind = authPrompt.indexOf(61)) != -1) {
                authPrompt = (authPrompt = authPrompt.substring(ind + 1)).length() >= 2 && authPrompt.charAt(0) == '\"' && authPrompt.charAt(authPrompt.length() - 1) == '\"' ? authPrompt.substring(1, authPrompt.length() - 1) : "";
            }
        }
        if (!"basic".equalsIgnoreCase(authScheme)) {
            throw new HttpUnauthorizedException("Auth scheme " + authScheme + " is not supported!");
        }
        return new String[]{authScheme.toLowerCase(), authPrompt};
    }

    private static InetAddress getRequestInetAddress(String host) {
        InetAddress requestInetAddress = null;
        try {
            requestInetAddress = InetAddress.getByName(host);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return requestInetAddress;
    }

    private static int getRequestPort(URL requestUrl) {
        int requestPort = requestUrl.getPort();
        if (requestPort == -1) {
            requestPort = requestUrl.getDefaultPort();
        }
        return requestPort;
    }

    private static PasswordAuthentication priviledgedRequestPasswordAuthentication(final String host, final InetAddress addr, final int port, final String protocol, final String prompt, final String scheme, final URL url, final Authenticator.RequestorType authType) {
        if (KernelStatus.isServer()) {
            return (PasswordAuthentication)Security.runAs(SubjectManager.getSubjectManager().getAnonymousSubject().getSubject(), new PrivilegedAction<PasswordAuthentication>(){

                @Override
                public PasswordAuthentication run() {
                    return Authenticator.requestPasswordAuthentication(host, addr, port, protocol, prompt, scheme, url, authType);
                }
            });
        }
        return Authenticator.requestPasswordAuthentication(host, addr, port, protocol, prompt, scheme, url, authType);
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        if (!this.doInput) {
            throw new ProtocolException("Cannot read from URLConnection if doInput=false (call setDoInput(true))");
        }
        if (this.responseCode >= 400 && this.rememberedException != null) {
            throw this.rememberedException;
        }
        if (this.inputStream != null) {
            if (this.http != null) {
                this.http.setLastUsed(System.currentTimeMillis());
            }
            return this.inputStream;
        }
        if (this.streamedPostOS != null) {
            try {
                this.streamedPostOS.close();
            }
            catch (IOException e) {
                this.disconnect();
                throw e;
            }
        }
        int redirects = 0;
        int tries = 0;
        int maxTries = 3;
        if (this.getMethod().equals("POST") && !retryPost) {
            maxTries = 1;
            if (this.triedOnce) {
                throw this.rememberedException;
            }
        }
        do {
            try {
                if (debug) {
                    HttpURLConnection.p("########### connecting try " + tries + " of " + maxTries);
                }
                this.triedOnce = true;
                this.connect();
                this.writeRequests();
                this.http.parseHTTP(this.responses);
            }
            catch (HttpUnauthorizedException ue) {
                if (debug) {
                    HttpURLConnection.p("Authentication required for this request");
                }
                this.disconnect();
                this.wroteRequests = false;
                this.setRequests = false;
                this.requests = new MessageHeader();
                String authReqStringEnding = new String("-Authenticate: Basic Realm=WebLogic Realm");
                proxyAuthString = HttpURLConnection.getProxyBasicCredentials(this.getURL().getHost(), this.getURL().getPort(), ue.getMessage() + authReqStringEnding, this.url);
                ++redirects;
                continue;
            }
            catch (ConnectException e) {
                if (debug) {
                    HttpURLConnection.p("ConnectException " + e.getMessage());
                }
                throw e;
            }
            catch (InterruptedIOException e) {
                if (debug) {
                    HttpURLConnection.p("InterruptedIOException " + e.getMessage());
                }
                throw e;
            }
            catch (SSLException se) {
                if (debug) {
                    HttpURLConnection.p("SSLException " + se.getMessage());
                }
                throw se;
            }
            catch (IOException e) {
                if (debug) {
                    HttpURLConnection.p("IOException " + e.getMessage());
                }
                if (this.rememberedException != null && this.rememberedException instanceof SocketTimeoutException) {
                    throw e;
                }
                if (this.http != null) {
                    InputStream existingInputStream = this.http.getInputStream();
                    if (e instanceof SocketTimeoutException || existingInputStream != null && (existingInputStream instanceof SocketClosedNotification || existingInputStream instanceof SocketTimeoutNotification)) {
                        throw e;
                    }
                }
                if (++tries >= maxTries) {
                    this.rememberedException = e;
                    throw e;
                }
                this.wroteRequests = false;
                if (this.http != null) {
                    this.http.closeServer();
                }
                try {
                    Thread.sleep(tries * 100);
                }
                catch (InterruptedException existingInputStream) {
                    // empty catch block
                }
                this.connected = false;
                this.http = this.getHttpClient();
                continue;
            }
            this.inputStream = this.http.getInputStream();
            int respCode = this.getResponseCode();
            if (debug) {
                HttpURLConnection.p("response - " + this.responses);
            }
            if (respCode == 100) {
                this.handleContinueResponse();
            }
            if (this.followRedirect()) {
                this.wroteRequests = false;
                ++redirects;
                continue;
            }
            if (this.method.equals("HEAD")) {
                this.disconnect();
                if (this.http != null) {
                    this.http.setLastUsed(System.currentTimeMillis());
                }
                this.inputStream = new NullInputStream();
                return this.inputStream;
            }
            if (respCode == 407) {
                if (debug) {
                    HttpURLConnection.p("Proxy Authentication required");
                }
                String proxyHost = this.http.getProxyHost();
                int proxyPort = this.http.getProxyPort();
                this.disconnect();
                this.wroteRequests = false;
                proxyAuthString = HttpURLConnection.getProxyBasicCredentials(proxyHost, proxyPort, this.responses.findValue("Proxy-Authenticate"), this.url);
                if (proxyAuthString != null) {
                    this.requests.set("Proxy-Authorization", proxyAuthString);
                }
                ++redirects;
                continue;
            }
            if (respCode == 401) {
                if (debug) {
                    HttpURLConnection.p("Server Authentication required");
                }
                this.wroteRequests = false;
                String authStr = HttpURLConnection.getServerBasicCredentials(this.url, this.responses.findValue("WWW-Authenticate"));
                this.requests.set("Authorization", authStr);
                this.disconnect();
                ++redirects;
                continue;
            }
            if (respCode >= 400) {
                String reason = HttpReasonPhraseCoder.getReasonPhrase(respCode);
                throw new FileNotFoundException("Response: '" + respCode + ": " + reason + "' for url: '" + this.toStringWithoutUserinfo(this.url) + "'");
            }
            if (this.http != null) {
                this.http.setLastUsed(System.currentTimeMillis());
            }
            return this.inputStream;
        } while (redirects < 5);
        throw new ProtocolException("Server redirected too many times (" + redirects + ")");
    }

    void writeRequestForAsyncResponse() throws IOException {
        int tries = 0;
        while (true) {
            try {
                this.connect();
                this.writeRequests();
                return;
            }
            catch (IOException ioe) {
                if (++tries >= 3) {
                    throw ioe;
                }
                this.wroteRequests = false;
                if (this.http != null) {
                    this.http.closeServer();
                }
                try {
                    Thread.sleep(tries * 100);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.connected = false;
                this.http = this.getHttpClient();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCookieHeader() throws IOException {
        if (this.cookieHandler != null) {
            HttpURLConnection httpURLConnection = this;
            synchronized (httpURLConnection) {
                if (this.setUserCookies) {
                    this.userCookies = this.requests.findValue("Cookie");
                    this.userCookies2 = this.requests.findValue("Cookie2");
                    if (debug) {
                        HttpURLConnection.p("userCookies retrieved: " + this.userCookies);
                        HttpURLConnection.p("userCookies2 retrieved: " + this.userCookies2);
                    }
                    this.setUserCookies = false;
                }
            }
            this.requests.remove("Cookie");
            this.requests.remove("Cookie2");
            StringBuilder cookieBuilder = new StringBuilder();
            StringBuilder cookie2Builder = new StringBuilder();
            final URI uri = ParseUtil.toURI(this.url);
            if (uri != null) {
                if (debug) {
                    HttpURLConnection.p("CookieHandler request for " + uri);
                }
                Map cookies = null;
                cookies = KernelStatus.isServer() ? (Map)Security.runAs(SubjectManager.getSubjectManager().getAnonymousSubject().getSubject(), new PrivilegedAction<Map<String, List<String>>>(){

                    @Override
                    public Map<String, List<String>> run() {
                        try {
                            return HttpURLConnection.this.cookieHandler.get(uri, HttpURLConnection.this.responses.getHeaders(EXCLUDE_HEADERS));
                        }
                        catch (IOException ie) {
                            if (debug) {
                                HttpURLConnection.p(ie.toString());
                            }
                            return null;
                        }
                    }
                }) : this.cookieHandler.get(uri, this.responses.getHeaders(EXCLUDE_HEADERS));
                if (cookies != null && !cookies.isEmpty()) {
                    if (debug) {
                        HttpURLConnection.p("Cookies retrieved: " + cookies.toString());
                    }
                    for (Map.Entry entry : cookies.entrySet()) {
                        List valueList;
                        String key = (String)entry.getKey();
                        if (!"Cookie".equalsIgnoreCase(key) && !"Cookie2".equalsIgnoreCase(key) || (valueList = (List)entry.getValue()) == null || valueList.isEmpty()) continue;
                        StringBuilder cookieValue = new StringBuilder();
                        for (String value : valueList) {
                            cookieValue.append(value).append("; ");
                        }
                        cookieValue.setLength(cookieValue.length() - 2);
                        if ("Cookie".equalsIgnoreCase(key)) {
                            cookieBuilder.append((CharSequence)cookieValue);
                            continue;
                        }
                        cookie2Builder.append((CharSequence)cookieValue);
                    }
                }
            }
            if (this.userCookies != null) {
                if (cookieBuilder.length() > 0) {
                    cookieBuilder.append("; ").append(this.userCookies);
                } else {
                    cookieBuilder.append(this.userCookies);
                }
            }
            if (this.userCookies2 != null) {
                if (cookie2Builder.length() > 0) {
                    cookie2Builder.append("; ").append(this.userCookies2);
                } else {
                    cookie2Builder.append(this.userCookies2);
                }
            }
            if (debug) {
                HttpURLConnection.p("The Cookie for current request: " + cookieBuilder.toString());
                HttpURLConnection.p("The Cookie2 for current request: " + cookie2Builder.toString());
            }
            if (cookieBuilder.length() > 0) {
                this.requests.set("Cookie", cookieBuilder.toString());
            }
            if (cookie2Builder.length() > 0) {
                this.requests.set("Cookie2", cookie2Builder.toString());
            }
        }
    }

    private void handleContinueResponse() throws IOException {
        this.responseCode = -1;
        this.responses = new MessageHeader();
        this.http.parseHTTP(this.responses);
        this.inputStream = this.http.getInputStream();
        this.http.setLastUsed(System.currentTimeMillis());
        if (debug) {
            HttpURLConnection.p("handled 100 Continue. status=" + this.getResponseCode());
        }
    }

    @Override
    public InputStream getErrorStream() {
        if (this.http != null) {
            this.http.setLastUsed(System.currentTimeMillis());
        }
        if (this.connected && this.responseCode >= 400) {
            return this.inputStream;
        }
        return null;
    }

    protected boolean followRedirect() throws IOException {
        if (!this.getInstanceFollowRedirects()) {
            return false;
        }
        int stat = this.getResponseCode();
        if (stat < 300 || stat > 307 || stat == 304) {
            return false;
        }
        String loc = this.getHeaderField("Location");
        if (loc == null) {
            return false;
        }
        URL u = new URL(this.getURL(), loc);
        if (!u.getProtocol().equals(u.getProtocol())) {
            return false;
        }
        if (debug) {
            HttpURLConnection.p("followRedirect Location=" + loc);
        }
        this.disconnect();
        MessageHeader oldResponses = this.responses;
        this.responses = new MessageHeader();
        StringBuffer cookiesSB = new StringBuffer();
        int i = 0;
        while (true) {
            String k = oldResponses.getKey(i);
            String v = oldResponses.getValue(i);
            if (k == null && v == null) break;
            if (k != null && v != null && k.equalsIgnoreCase("Set-Cookie")) {
                if (sendCookiesRedirect) {
                    cookiesSB.append(v.split(COOKIE_SEPARATOR, 2)[0]);
                    cookiesSB.append(COOKIE_SEPARATOR);
                } else {
                    this.responses.add(k, v);
                }
            }
            ++i;
        }
        if (sendCookiesRedirect && cookiesSB.length() != 0) {
            this.redirectCookieStr = cookiesSB.substring(0, cookiesSB.length() - COOKIE_SEPARATOR.length());
            this.requests.add("Cookie", this.redirectCookieStr);
        }
        if (stat == 305) {
            this.requests.set(0, this.method + " " + this.http.getURLFile() + " " + this.getHttpVersion(), null);
            this.connected = true;
        } else {
            this.url = new URL(this.url, loc);
            if (this.method.equals("POST") && !strictPostRedirect) {
                this.requests = new MessageHeader();
                this.setRequests = false;
                this.setRequestMethod("GET");
                this.bufferedPostOS = null;
                this.connect();
            } else {
                this.connect();
                this.requests.set(0, this.method + " " + this.http.getURLFile() + " " + this.getHttpVersion(), null);
                this.requests.set("Host", this.url.getHost() + (this.url.getPort() == -1 || this.url.getPort() == 80 ? "" : ":" + String.valueOf(this.url.getPort())));
            }
        }
        return true;
    }

    @Override
    public void disconnect() {
        this.responseCode = -1;
        if (this.http != null) {
            if (debug) {
                HttpURLConnection.p("disconnect called on " + this.http);
            }
            this.http.closeServer();
            this.http = null;
            this.connected = false;
        }
    }

    boolean isConnected() {
        return this.connected;
    }

    @Override
    public boolean usingProxy() {
        if (this.http != null) {
            return this.http.usingProxy;
        }
        return false;
    }

    @Override
    public String getHeaderField(String name) {
        block2: {
            try {
                this.getInputStream();
            }
            catch (IOException e) {
                if (!(e instanceof SocketTimeoutException)) break block2;
                this.rememberedException = e;
            }
        }
        return this.responses.findValue(name);
    }

    @Override
    public String getHeaderField(int n) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.responses.getValue(n);
    }

    public Map getHeaderFields() {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.responses.getHeaders();
    }

    @Override
    public String getHeaderFieldKey(int n) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.responses.getKey(n);
    }

    @Override
    public void addRequestProperty(String key, String value) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        if (key.length() > 0) {
            this.requests.add(key, value);
        }
    }

    public synchronized Map getRequestProperties() {
        if (this.setUserCookies) {
            return this.requests.getHeaders(EXCLUDE_HEADERS);
        }
        HashMap<String, List<String>> userCookiesMap = null;
        if (this.userCookies != null || this.userCookies2 != null) {
            userCookiesMap = new HashMap<String, List<String>>();
            if (this.userCookies != null) {
                userCookiesMap.put("Cookie", (List<String>)((Object)this.userCookies));
            }
            if (this.userCookies2 != null) {
                userCookiesMap.put("Cookie2", (List<String>)((Object)this.userCookies2));
            }
        }
        return this.requests.filterAndAddHeaders(EXCLUDE_HEADERS2, userCookiesMap);
    }

    @Override
    public void setRequestProperty(String key, String value) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        if (key.length() > 0) {
            this.requests.set(key, value);
        }
    }

    public void setEmptyRequestProperty(String key) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        if (key.length() > 0) {
            this.requests.set(key, "");
        }
    }

    @Override
    public synchronized String getRequestProperty(String key) {
        if (key == null) {
            return null;
        }
        for (int i = 0; i < EXCLUDE_HEADERS.length; ++i) {
            if (!key.equalsIgnoreCase(EXCLUDE_HEADERS[i])) continue;
            return null;
        }
        if (!this.setUserCookies) {
            if (key.equalsIgnoreCase("Cookie")) {
                return this.userCookies;
            }
            if (key.equalsIgnoreCase("Cookie2")) {
                return this.userCookies2;
            }
        }
        return this.requests.findValue(key);
    }

    String getMethod() {
        return this.method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSetRequests() {
        this.requests.prepend(this.method + " " + this.http.getURLFile() + " " + this.getHttpVersion(), null);
        this.requests.setIfNotSet("User-Agent", userAgent);
        int port = this.url.getPort();
        String host = this.url.getHost();
        if (port != -1 && port != 80) {
            host = host + ":" + String.valueOf(port);
        }
        this.requests.setIfNotSet("Host", host);
        this.requests.setIfNotSet("Accept", acceptString);
        if (proxyAuthString != null) {
            this.requests.set("Proxy-Authorization", proxyAuthString);
        }
        if (sendCookiesRedirect && this.redirectCookieStr != null) {
            this.requests.setIfNotSet("Cookie", this.redirectCookieStr);
        }
        if (this.http.getHttpKeepAliveSet()) {
            this.requests.setIfNotSet("Connection", "Keep-Alive");
        }
        if (!bufferPostForRetry) {
            if (this.useHttp11 && this.chunkStreamingModeEnabled) {
                this.requests.set("Transfer-Encoding", "chunked");
            }
            if (this.useHttp11 && this.fixedContentLength > 0) {
                this.requests.setIfNotSet("Content-Length", Integer.toString(this.fixedContentLength));
            }
        }
        if (this.bufferedPostOS != null) {
            UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = this.bufferedPostOS;
            synchronized (unsyncByteArrayOutputStream) {
                this.requests.setIfNotSet("Content-Type", "application/x-www-form-urlencoded");
                this.requests.set("Content-Length", String.valueOf(this.bufferedPostOS.size()));
            }
        }
        Collection<HttpRequestHeaderContributor> contributors = HttpContributorRegistrar.getHttpContributorRegistrar().getRequestHeaderContributors();
        for (HttpRequestHeaderContributor contributor : contributors) {
            Set<Map.Entry<String, String>> headersToAdd = contributor.getHeadersForOutgoingRequest().entrySet();
            for (Map.Entry<String, String> headerToAdd : headersToAdd) {
                if (this.getRequestProperty(headerToAdd.getKey()) == null) {
                    this.requests.add(headerToAdd.getKey(), headerToAdd.getValue());
                }
                if (!debug) continue;
                HttpURLConnection.p("ERROR with HttpRequestHeaderContributor: " + contributor + " attempting to add existing HTTP header: " + headerToAdd.getKey());
            }
        }
        this.setRequests = true;
    }

    @Deprecated
    public void setTimeout(int i) {
        this.setReadTimeout(i);
    }

    @Deprecated
    public int getTimeout() {
        return this.getReadTimeout();
    }

    @Override
    public void setReadTimeout(int i) {
        this.readTimeout = i;
        if (this.http != null) {
            this.http.setReadTimeout(i);
        }
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setConnectTimeout(int i) {
        this.connectTimeout = i;
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setFixedLengthStreamingMode(int fixedContentLength) {
        if (this.chunkStreamingModeEnabled) {
            throw new IllegalStateException("Chunked encoding streaming mode set");
        }
        this.fixedLengthStreamingModeEnabled = true;
        this.fixedContentLength = fixedContentLength;
    }

    @Override
    public void setChunkedStreamingMode(int chunkLength) {
        if (this.fixedLengthStreamingModeEnabled) {
            throw new IllegalStateException("Fixed length streaming mode set");
        }
        this.chunkStreamingModeEnabled = true;
        this.chunkLength = chunkLength;
    }

    @Override
    public int getResponseCode() throws IOException {
        if (this.responseCode != -1) {
            return this.responseCode;
        }
        if (this.rememberedException != null && this.rememberedException instanceof SocketTimeoutException) {
            throw this.rememberedException;
        }
        IOException ioe = null;
        try {
            this.getInputStream();
        }
        catch (SocketTimeoutException ste) {
            this.rememberedException = ste;
            throw ste;
        }
        catch (ConnectException ce) {
            throw ce;
        }
        catch (InterruptedIOException iie) {
            throw iie;
        }
        catch (SSLException se) {
            throw se;
        }
        catch (IOException ie) {
            ioe = ie;
        }
        String resp = this.getHeaderField(0);
        if (resp == null && ioe != null) {
            throw ioe;
        }
        this.rememberedException = ioe;
        try {
            int ind = resp.indexOf(32);
            while (resp.charAt(ind) == ' ') {
                ++ind;
            }
            this.responseCode = Integer.parseInt(resp.substring(ind, ind + 3));
            this.responseMessage = resp.substring(ind + 4).trim();
            return this.responseCode;
        }
        catch (Exception e) {
            return this.responseCode;
        }
    }

    String getHttpVersion() {
        if (this.useHttp11) {
            return "HTTP/1.1";
        }
        return "HTTP/1.0";
    }

    private String toStringWithoutUserinfo(URL u) {
        String hostPort;
        StringBuilder result = new StringBuilder();
        result.append(u.getProtocol());
        result.append(":");
        String string = hostPort = u.getPort() == -1 ? u.getHost() : u.getHost() + ":" + u.getPort();
        if (hostPort != null && hostPort.length() > 0) {
            result.append("//");
            result.append(hostPort);
        }
        if (u.getPath() != null) {
            result.append(u.getPath());
        }
        if (u.getQuery() != null) {
            result.append('?');
            result.append(u.getQuery());
        }
        if (u.getRef() != null) {
            result.append("#");
            result.append(u.getRef());
        }
        return result.toString();
    }

    public void u11() {
        if (!this.connected) {
            this.useHttp11 = true;
            if (debug) {
                HttpURLConnection.p("will use HTTP/1.1");
            }
        }
    }

    void finish() {
        this.http = null;
    }

    static final void p(String s) {
        System.out.println("[" + new Date() + "] [" + Thread.currentThread().getName() + "] " + s);
    }

    private static boolean getBoolean(String prop, boolean def) {
        String s = SecurityHelper.getSystemProperty(prop);
        if (s != null) {
            return Boolean.valueOf(s);
        }
        return def;
    }

    Socket getSocket() {
        return this.http.getSocket();
    }

    void setInputStream(InputStream inputStream) {
        this.http.setInputStream(inputStream);
    }

    public void setMuxableSocket(Object socket) {
        this.http.setMuxableSocket(socket);
    }

    Object getMuxableSocket() {
        return this.http.getMuxableSocket();
    }

    void setScavenger(Runnable scavenger) {
        this.http.setScavenger(scavenger);
    }

    @Override
    public void setRequestMethod(String method) throws ProtocolException {
        if (this.connected) {
            throw new ProtocolException("Can't reset method: already connected");
        }
        if (method == null) {
            throw new ProtocolException("Invalid HTTP method: " + method);
        }
        if (method.length() > 32) {
            throw new ProtocolException("Invalid HTTP method: " + method + ", maximum length allowed is " + 32);
        }
        if (!HttpParsing.isTokenClean(method)) {
            throw new ProtocolException("Invalid HTTP method: " + method + ", invalid character(s) was found");
        }
        this.method = method;
    }

    static {
        strictPostRedirect = false;
        proxyAuthString = null;
        http11 = true;
        bufferPostForRetry = false;
        sendCookiesRedirect = false;
        EXCLUDE_HEADERS = new String[]{"Proxy-Authorization", "Authorization"};
        EXCLUDE_HEADERS2 = new String[]{"Proxy-Authorization", "Authorization", "Cookie", "Cookie2"};
        retryPost = true;
        boolean httpDebug = false;
        userAgent = "Java" + SecurityHelper.getSystemProperty("java.version");
        try {
            userAgent = SecurityHelper.getSystemProperty("http.agent", userAgent);
            defaultReadTimeout = SecurityHelper.getInteger("weblogic.http.client.defaultReadTimeout", -1);
            defaultConnectTimeout = SecurityHelper.getInteger("weblogic.http.client.defaultConnectTimeout", -1);
            strictPostRedirect = HttpURLConnection.getBoolean("http.strictPostRedirect", strictPostRedirect);
            sendCookiesRedirect = HttpURLConnection.getBoolean("weblogic.http.sendCookiesRedirect", sendCookiesRedirect);
            httpDebug = HttpURLConnection.getBoolean("http.debug", httpDebug);
            http11 = HttpURLConnection.getBoolean("http.11", http11);
            bufferPostForRetry = HttpURLConnection.getBoolean("http.bufferPostForRetry", bufferPostForRetry);
            proxyAuthClassName = SecurityHelper.getSystemProperty("weblogic.net.proxyAuthenticatorClassName");
            retryPost = HttpURLConnection.getBoolean("http.retryPost", retryPost);
        }
        catch (SecurityException ignore) {
            defaultReadTimeout = -1;
            defaultConnectTimeout = -1;
        }
        debug = httpDebug;
    }
}

