/*
 * Decompiled with CFR 0.152.
 */
package weblogic.net.http;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import weblogic.net.http.HttpClient;
import weblogic.utils.io.NullInputStream;

public final class KeepAliveStream
extends FilterInputStream {
    protected boolean closed = false;
    protected int expected;
    protected int count = 0;
    protected int markedCount = 0;
    protected int markLimit = -1;
    protected HttpClient client;
    protected boolean noMsgBodyResponseCode = false;

    public KeepAliveStream(HttpClient hc, InputStream is, int contentLen) {
        super(contentLen == 0 ? NullInputStream.getInstance() : is);
        this.expected = contentLen;
        this.client = hc;
    }

    public KeepAliveStream(HttpClient hc, InputStream is, int contentLen, boolean noMsgBodyRespCode) {
        this(hc, is, contentLen);
        this.noMsgBodyResponseCode = noMsgBodyRespCode;
    }

    private final void justRead(int n) throws IOException {
        if (n == -1) {
            if (!this.isMarked()) {
                this.close();
            }
            return;
        }
        this.count += n;
        if (this.count > this.markLimit) {
            this.markLimit = -1;
        }
        if (this.isMarked()) {
            return;
        }
        if (this.expected != -1 && this.count >= this.expected) {
            this.close();
        }
    }

    private boolean isMarked() {
        if (this.markLimit < 0) {
            return false;
        }
        return this.count <= this.markLimit;
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            return -1;
        }
        int c = this.in.read();
        if (c != -1) {
            this.justRead(1);
        } else {
            this.justRead(c);
        }
        return c;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            return -1;
        }
        int n = this.in.read(b, off, len);
        this.justRead(n);
        return n;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.closed) {
            return 0L;
        }
        int min = (int)n;
        if (this.expected != -1 && n > (long)(this.expected - this.count)) {
            min = this.expected - this.count;
        }
        n = this.in.skip(min);
        this.justRead((int)n);
        return n;
    }

    @Override
    public int available() throws IOException {
        return this.closed ? 0 : this.in.available();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        boolean bytesRemaining = false;
        try {
            if (this.expected == -1 && !this.noMsgBodyResponseCode) {
                boolean bl = bytesRemaining = this.in.read() != -1;
            }
            if (bytesRemaining || this.expected > this.count) {
                this.client.setKeepingAlive(false);
                this.in.close();
            }
        }
        finally {
            this.closed = true;
            HttpClient.finished(this.client);
        }
    }

    @Override
    public void mark(int readlimit) {
        if (this.closed || this.client.isKeepingAlive()) {
            return;
        }
        super.mark(readlimit);
        this.markedCount = this.count;
        this.markLimit = readlimit;
    }

    @Override
    public void reset() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.client.isKeepingAlive()) {
            throw new IOException("mark/reset not supported");
        }
        if (!this.isMarked()) {
            throw new IOException("Resetting to an invalid mark");
        }
        this.count = this.markedCount;
        super.reset();
    }

    @Override
    public boolean markSupported() {
        if (this.closed || this.client.isKeepingAlive()) {
            return false;
        }
        return super.markSupported();
    }
}

