/*
 * Decompiled with CFR 0.152.
 */
package weblogic.net.http;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import weblogic.net.http.HttpOutputStream;

final class MessageHeader {
    private static final byte[] HTTP_PROTOCOL_BYTES = new byte[]{72, 84, 84, 80, 47, 49, 46};
    private static final int HTTP_PROTOCOL_LEN = 7;
    private String[] keys;
    private String[] vals;
    private int nkeys;
    private byte[] byteBuffer = new byte[7];

    public MessageHeader() {
        this.grow();
    }

    public MessageHeader(InputStream is) throws IOException {
        this.parseHeader(is);
    }

    public String findValue(String k) {
        if (k == null) {
            int i = this.nkeys;
            while (--i >= 0) {
                if (this.keys[i] != null) continue;
                return this.vals[i];
            }
        } else {
            int i = this.nkeys;
            while (--i >= 0) {
                if (!k.equalsIgnoreCase(this.keys[i])) continue;
                return this.vals[i];
            }
        }
        return null;
    }

    public String getKey(int n) {
        if (n < 0 || n >= this.nkeys) {
            return null;
        }
        return this.keys[n];
    }

    public String getValue(int n) {
        if (n < 0 || n >= this.nkeys) {
            return null;
        }
        return this.vals[n];
    }

    public Map<String, List<String>> getHeaders(String[] excludeList) {
        return this.filterAndAddHeaders(excludeList, null);
    }

    public Map<String, List<String>> filterAndAddHeaders(String[] excludeList, Map<String, List<String>> include) {
        boolean skipIt = false;
        HashMap<String, List<Object>> m = new HashMap<String, List<Object>>();
        int i = this.nkeys;
        while (--i >= 0) {
            if (excludeList != null) {
                for (int j = 0; j < excludeList.length; ++j) {
                    if (excludeList[j] == null || !excludeList[j].equalsIgnoreCase(this.keys[i])) continue;
                    skipIt = true;
                    break;
                }
            }
            if (!skipIt) {
                ArrayList<String> l = (ArrayList<String>)m.get(this.keys[i]);
                if (l == null) {
                    l = new ArrayList<String>();
                    m.put(this.keys[i], l);
                }
                l.add(this.vals[i]);
                continue;
            }
            skipIt = false;
        }
        if (include != null) {
            for (Map.Entry<String, List<String>> entry : include.entrySet()) {
                ArrayList<List<String>> l = (ArrayList<List<String>>)m.get(entry.getKey());
                if (l == null) {
                    l = new ArrayList<List<String>>();
                    m.put(entry.getKey(), l);
                }
                l.add(entry.getValue());
            }
        }
        for (String key : m.keySet()) {
            m.put(key, Collections.unmodifiableList((List)m.get(key)));
        }
        return Collections.unmodifiableMap(m);
    }

    public void print(HttpOutputStream p) throws IOException {
        for (int i = 0; i < this.nkeys; ++i) {
            if (this.keys[i] == null) continue;
            p.print(this.keys[i]);
            if (this.vals[i] != null) {
                p.print(": ");
                p.print(this.vals[i]);
            }
            p.print("\r\n");
        }
        p.print("\r\n");
    }

    public void print(PrintStream p) {
        for (int i = 0; i < this.nkeys; ++i) {
            if (this.keys[i] == null) continue;
            p.print(this.keys[i] + (this.vals[i] != null ? ": " + this.vals[i] : "") + "\r\n");
        }
        p.print("\r\n");
        p.flush();
    }

    public void add(String k, String v) {
        this.grow();
        this.keys[this.nkeys] = k;
        this.vals[this.nkeys] = v;
        ++this.nkeys;
    }

    public void prepend(String k, String v) {
        this.grow();
        for (int i = this.nkeys; i > 0; --i) {
            this.keys[i] = this.keys[i - 1];
            this.vals[i] = this.vals[i - 1];
        }
        this.keys[0] = k;
        this.vals[0] = v;
        ++this.nkeys;
    }

    public void set(int i, String k, String v) {
        this.grow();
        if (i < 0) {
            return;
        }
        if (i > this.nkeys) {
            this.add(k, v);
        } else {
            this.keys[i] = k;
            this.vals[i] = v;
        }
    }

    private void grow() {
        if (this.keys == null || this.nkeys >= this.keys.length) {
            String[] nk = new String[this.nkeys + 4];
            String[] nv = new String[this.nkeys + 4];
            if (this.keys != null) {
                System.arraycopy(this.keys, 0, nk, 0, this.nkeys);
            }
            if (this.vals != null) {
                System.arraycopy(this.vals, 0, nv, 0, this.nkeys);
            }
            this.keys = nk;
            this.vals = nv;
        }
    }

    public void set(String k, String v) {
        int i = this.nkeys;
        while (--i >= 0) {
            if (!k.equalsIgnoreCase(this.keys[i])) continue;
            this.vals[i] = v;
            return;
        }
        this.add(k, v);
    }

    public void remove(String k) {
        if (k == null) {
            for (int i = 0; i < this.nkeys; ++i) {
                while (this.keys[i] == null && i < this.nkeys) {
                    for (int j = i; j < this.nkeys - 1; ++j) {
                        this.keys[j] = this.keys[j + 1];
                        this.vals[j] = this.vals[j + 1];
                    }
                    --this.nkeys;
                }
            }
        } else {
            for (int i = 0; i < this.nkeys; ++i) {
                while (k.equalsIgnoreCase(this.keys[i]) && i < this.nkeys) {
                    for (int j = i; j < this.nkeys - 1; ++j) {
                        this.keys[j] = this.keys[j + 1];
                        this.vals[j] = this.vals[j + 1];
                    }
                    --this.nkeys;
                }
            }
        }
    }

    public void setIfNotSet(String k, String v) {
        if (this.findValue(k) == null) {
            this.add(k, v);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void parseHeader(InputStream is) throws IOException {
        this.nkeys = 0;
        if (is == null || !this.isHTTP(is)) {
            return;
        }
        char[] s = new char[10];
        int firstc = is.read();
        if (firstc < 0) {
            throw new IOException("Response contained no data");
        }
        while (true) {
            String k;
            int keyend;
            int len;
            block21: {
                int c;
                boolean inKey;
                if (firstc != 10 && firstc != 13 && firstc >= 0) {
                    len = 0;
                    keyend = -1;
                    inKey = firstc > 32;
                    s[len++] = (char)firstc;
                } else {
                    return;
                }
                while ((c = is.read()) >= 0) {
                    switch (c) {
                        case 58: {
                            if (inKey && len > 0) {
                                keyend = len;
                            }
                            inKey = false;
                            break;
                        }
                        case 9: {
                            c = 32;
                        }
                        case 32: {
                            inKey = false;
                            break;
                        }
                        case 10: 
                        case 13: {
                            firstc = is.read();
                            if (c == 13 && firstc == 10 && (firstc = is.read()) == 13) {
                                firstc = is.read();
                            }
                            if (firstc == 10 || firstc == 13 || firstc > 32) break block21;
                            c = 32;
                        }
                    }
                    if (len >= s.length) {
                        char[] ns = new char[s.length * 2];
                        System.arraycopy(s, 0, ns, 0, len);
                        s = ns;
                    }
                    s[len++] = (char)c;
                }
                firstc = -1;
            }
            while (len > 0 && s[len - 1] <= ' ') {
                --len;
            }
            if (keyend <= 0) {
                k = null;
                keyend = 0;
            } else {
                k = String.copyValueOf(s, 0, keyend);
                if (keyend < len && s[keyend] == ':') {
                    ++keyend;
                }
                while (keyend < len && s[keyend] <= ' ') {
                    ++keyend;
                }
            }
            String v = keyend >= len ? new String() : String.copyValueOf(s, keyend, len - keyend);
            this.add(k, v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isHTTP(InputStream is) throws IOException {
        if (!is.markSupported()) {
            return true;
        }
        is.mark(7);
        try {
            int bytesRead;
            for (int total = 0; total < 7; total += bytesRead) {
                bytesRead = is.read(this.byteBuffer, total, 7 - total);
                if (bytesRead != -1) continue;
                throw new EOFException("Response had end of stream after " + total + " bytes");
            }
            boolean bl = Arrays.equals(HTTP_PROTOCOL_BYTES, this.byteBuffer);
            return bl;
        }
        finally {
            is.reset();
        }
    }

    public String toString() {
        String result = super.toString();
        for (int i = 0; i < this.keys.length; ++i) {
            result = result + "{" + this.keys[i] + ": " + this.vals[i] + "}";
        }
        return result;
    }

    public synchronized Map getHeaders() {
        HashMap hashmap = new HashMap();
        int i = this.nkeys;
        while (--i >= 0) {
            Object obj = hashmap.get(this.keys[i]);
            if (obj == null) {
                obj = new ArrayList();
                hashmap.put(this.keys[i], obj);
            }
            ((List)obj).add(this.vals[i]);
        }
        Set set1 = hashmap.keySet();
        for (Object obj1 : set1) {
            List list = (List)hashmap.get(obj1);
            hashmap.put((String)obj1, Collections.unmodifiableList(list));
        }
        return Collections.unmodifiableMap(hashmap);
    }
}

