/*
 * Decompiled with CFR 0.152.
 */
package weblogic.platform;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.SocketImpl;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import weblogic.platform.GCListener;
import weblogic.platform.GarbageCollectionEvent;
import weblogic.platform.UnsafeUtil;

public class VM {
    private static final String HEAP_RATIO_REQUIREMENT = "com.sun.management.HotSpotDiagnosticMXBean";
    private static final boolean DEBUG = false;
    private static final GarbageCollectionEvent MINOR_GC_EVENT = new GarbageCollectionEvent(1);
    private static final GarbageCollectionEvent MAJOR_GC_EVENT = new GarbageCollectionEvent(0);
    private static Field sockImplField;
    private static Field fileDesField;
    private static Field fdField;
    private static Field rawSocketField;
    private static Class layeredSocketClass;
    private static Method getFDValMethod;
    private static boolean postJdk15;
    private static boolean jdk17;
    private final ArrayList<GCListener> list = new ArrayList();
    private final boolean hotSpot;
    private static VM vm;
    private static VM vm15Delegate;

    public VM() {
        boolean isHotSpot;
        try {
            Class.forName(HEAP_RATIO_REQUIREMENT, false, ClassLoader.getSystemClassLoader());
            isHotSpot = true;
        }
        catch (Throwable th) {
            isHotSpot = false;
        }
        this.hotSpot = isHotSpot;
    }

    public int getFD(Socket sock) throws IOException {
        try {
            if (postJdk15) {
                if (sock.getClass().getName().equals("java.net.Socket")) {
                    SocketImpl impl = (SocketImpl)UnsafeUtil.getObjectFieldValue(sock, "impl");
                    if (impl.getClass().getName().equals("java.net.SocksSocketImpl")) {
                        SocketImpl delegateImpl = (SocketImpl)UnsafeUtil.getObjectFieldValue(impl, "delegate");
                        FileDescriptor delegateFd = (FileDescriptor)UnsafeUtil.getObjectFieldValue(delegateImpl, "fd");
                        return UnsafeUtil.getIntFieldValue(delegateFd, "fd");
                    }
                    FileDescriptor fd = (FileDescriptor)UnsafeUtil.getObjectFieldValue(impl, "fd");
                    return UnsafeUtil.getIntFieldValue(fd, "fd");
                }
                SocketChannel ch = (SocketChannel)UnsafeUtil.getObjectFieldValue(sock, "sc");
                return UnsafeUtil.getIntFieldValue(ch, "fdVal");
            }
            SocketChannel ch = sock.getChannel();
            if (ch != null && getFDValMethod != null) {
                return (Integer)getFDValMethod.invoke((Object)ch, new Object[0]);
            }
            SocketImpl sockImpl = (SocketImpl)sockImplField.get(this.getRawSocket(sock));
            FileDescriptor fileDes = (FileDescriptor)fileDesField.get(sockImpl);
            Object fdValue = fdField.get(fileDes);
            if (fdValue instanceof Integer) {
                return (Integer)fdValue;
            }
            if (fdValue instanceof Long) {
                return ((Long)fdValue).intValue();
            }
            throw new IOException("Invalid fd");
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            String msg = "Cannot get fd for sock=" + sock + ": " + t.getMessage();
            throw new IOException(msg);
        }
    }

    Socket getRawSocket(Socket sock) throws IllegalAccessException {
        if (layeredSocketClass != null && layeredSocketClass.isInstance(sock) && rawSocketField != null) {
            sock = (Socket)rawSocketField.get(sock);
        }
        return sock;
    }

    public void threadDump() {
        System.err.println("***** This VM does not support thread dumps *****");
    }

    public void threadDump(String filename) throws IOException {
        try (PrintStream pos = new PrintStream(new FileOutputStream(filename));){
            pos.println("***** This VM does not support thread dumps *****");
            pos.close();
        }
    }

    public void threadDump(FileDescriptor fd) throws IOException {
        try (PrintStream pos = new PrintStream(new FileOutputStream(fd));){
            pos.println("***** This VM does not support thread dumps *****");
            pos.close();
        }
    }

    public void threadDump(File f) throws IOException {
        try (PrintStream pos = new PrintStream(new FileOutputStream(f));){
            pos.println("***** This VM does not support thread dumps *****");
            pos.close();
        }
    }

    public void threadDump(PrintWriter pw) {
        pw.println("***** This VM does not support thread dumps *****");
        pw.flush();
    }

    public String threadDumpAsString(Thread thread) {
        if (vm15Delegate != null) {
            return vm15Delegate.threadDumpAsString(thread);
        }
        return null;
    }

    public String threadDumpAsString() {
        if (vm15Delegate != null) {
            return vm15Delegate.threadDumpAsString();
        }
        return null;
    }

    public String threadDumpAsString(boolean lockedMonitors, boolean lockedSynchronizers) {
        if (vm15Delegate != null) {
            return vm15Delegate.threadDumpAsString(lockedMonitors, lockedSynchronizers);
        }
        return null;
    }

    public String dumpDeadlockedThreads() {
        if (vm15Delegate != null) {
            return vm15Delegate.dumpDeadlockedThreads();
        }
        return null;
    }

    public boolean isNativeThreads() {
        return true;
    }

    public String getName() {
        return "UnknownVM";
    }

    public static synchronized VM getVM() {
        if (vm != null) {
            return vm;
        }
        String vendor = System.getProperty("java.vm.vendor");
        if (vendor == null) {
            vendor = "";
        }
        vendor = vendor.toLowerCase();
        String javavmname = System.getProperty("java.vm.name");
        if (javavmname == null) {
            javavmname = "";
        }
        javavmname = javavmname.toLowerCase();
        String version = System.getProperty("java.version");
        if (version == null) {
            version = "";
        }
        version = version.toLowerCase();
        String os = System.getProperty("os.name");
        if (os == null) {
            os = "";
        }
        os = os.toLowerCase();
        String arch = System.getProperty("os.arch");
        if (arch == null) {
            arch = "";
        }
        arch = arch.toLowerCase();
        vm = VM.getVM(vendor, javavmname, version, os, arch);
        return vm;
    }

    static VM getVM(String vendor, String javavmname, String version, String os, String arch) {
        VM.initVM15Delegate(version);
        VM vm = null;
        if (vendor.contains("sun") || vendor.contains("apple")) {
            try {
                vm = (VM)Class.forName("weblogic.platform.SunVM").newInstance();
            }
            catch (Throwable throwable) {}
        } else if (vendor.toLowerCase().contains("digital equi")) {
            if (arch.toLowerCase().contains("alpha")) {
                try {
                    vm = (VM)Class.forName("weblogic.platform.SunVM").newInstance();
                }
                catch (Throwable throwable) {}
            }
        } else if (vendor.contains("oracle")) {
            try {
                vm = (VM)Class.forName("weblogic.platform.SunVM").newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (vm == null) {
            vm = new VM();
        }
        return vm;
    }

    private static void initVM15Delegate(String version) {
        try {
            vm15Delegate = (VM)Class.forName("weblogic.platform.VM15").newInstance();
        }
        catch (Throwable e) {
            System.err.println("***** FATAL: Unable to initialize weblogic.platform.VM15 *****");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addGCListener(GCListener listener) {
        ArrayList<GCListener> arrayList = this.list;
        synchronized (arrayList) {
            if (listener != null) {
                this.list.add(listener);
            }
        }
    }

    protected final void sendMinorGCEvent() {
        this.sendGCEvent(MINOR_GC_EVENT);
    }

    protected final void sendMajorGCEvent() {
        this.sendGCEvent(MAJOR_GC_EVENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendGCEvent(GarbageCollectionEvent gce) {
        ArrayList<GCListener> arrayList = this.list;
        synchronized (arrayList) {
            Iterator<GCListener> iterator = this.list.iterator();
            while (iterator.hasNext()) {
                GCListener aList;
                GCListener listener = aList = iterator.next();
                listener.onGarbageCollection(gce);
            }
        }
    }

    public boolean isHotSpot() {
        return this.hotSpot;
    }

    public String getTimedWaitingThreadDelayString() {
        if (vm15Delegate != null) {
            return vm15Delegate.getTimedWaitingThreadDelayString();
        }
        return null;
    }

    static {
        postJdk15 = false;
        jdk17 = false;
        try {
            String version = System.getProperty("java.version");
            if (version != null && (version.startsWith("1.") || version.startsWith("9") || version.startsWith("11") || version.startsWith("13") || version.startsWith("15"))) {
                sockImplField = Socket.class.getDeclaredField("impl");
                sockImplField.setAccessible(true);
                fileDesField = SocketImpl.class.getDeclaredField("fd");
                fileDesField.setAccessible(true);
                getFDValMethod = Class.forName("sun.nio.ch.SocketChannelImpl").getDeclaredMethod("getFDVal", new Class[0]);
                getFDValMethod.setAccessible(true);
                fdField = FileDescriptor.class.getDeclaredField("fd");
                fdField.setAccessible(true);
                layeredSocketClass = Class.forName("javax.net.ssl.impl.SSLLayeredSocket");
                rawSocketField = layeredSocketClass.getDeclaredField("socket");
                rawSocketField.setAccessible(true);
            } else {
                if (version != null && version.startsWith("17")) {
                    jdk17 = true;
                }
                postJdk15 = true;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (ClassNotFoundException | RuntimeException exception) {
            // empty catch block
        }
    }
}

