/*
 * Decompiled with CFR 0.152.
 */
package weblogic.platform;

import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import weblogic.platform.VM;

public class VM15
extends VM {
    @Override
    public String threadDumpAsString() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        if (threadMXBean == null) {
            return null;
        }
        long[] threadIds = threadMXBean.getAllThreadIds();
        if (threadIds == null || threadIds.length == 0) {
            return null;
        }
        ThreadInfo[] threadInfos = threadMXBean.getThreadInfo(threadIds, true, true);
        StringBuilder sb = new StringBuilder();
        for (ThreadInfo info : threadInfos) {
            if (info == null) continue;
            sb.append(VM15.formattedThreadInfo(info)).append("\n");
        }
        return sb.toString();
    }

    @Override
    public String threadDumpAsString(boolean lockedMonitors, boolean lockedSynchronizers) {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        if (threadMXBean == null) {
            return null;
        }
        long[] threadIds = threadMXBean.getAllThreadIds();
        if (threadIds == null || threadIds.length == 0) {
            return null;
        }
        ThreadInfo[] threadInfos = threadMXBean.getThreadInfo(threadIds, lockedMonitors, lockedSynchronizers);
        StringBuilder sb = new StringBuilder();
        for (ThreadInfo info : threadInfos) {
            if (info == null) continue;
            sb.append(VM15.formattedThreadInfo(info)).append("\n");
        }
        return sb.toString();
    }

    private static String formattedThreadInfo(ThreadInfo info) {
        StringBuilder sb = new StringBuilder();
        sb.append("\"").append(info.getThreadName()).append("\"").append(" Id=").append(info.getThreadId()).append(" ").append((Object)info.getThreadState());
        if (info.getLockName() != null) {
            sb.append(" on ").append(info.getLockName());
        }
        if (info.getLockOwnerName() != null) {
            sb.append(" owned by \"").append(info.getLockOwnerName()).append("\" Id=").append(info.getLockOwnerId());
        }
        if (info.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (info.isInNative()) {
            sb.append(" (in native)");
        }
        sb.append('\n');
        StackTraceElement[] stackTrace = info.getStackTrace();
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement ste = stackTrace[i];
            sb.append("\tat ").append(ste.toString());
            sb.append('\n');
            if (i == 0 && info.getLockInfo() != null) {
                Thread.State ts = info.getThreadState();
                switch (ts) {
                    case BLOCKED: {
                        sb.append("\t-  blocked on ").append(info.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case WAITING: {
                        sb.append("\t-  waiting on ").append(info.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case TIMED_WAITING: {
                        sb.append("\t-  waiting on ").append(info.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                }
            }
            for (LockInfo lockInfo : info.getLockedMonitors()) {
                if (((MonitorInfo)lockInfo).getLockedStackDepth() != i) continue;
                sb.append("\t-  locked ").append(lockInfo).append('\n');
            }
        }
        LockInfo[] locks = info.getLockedSynchronizers();
        if (locks.length > 0) {
            sb.append("\n\tNumber of locked synchronizers = ").append(locks.length).append('\n');
            for (LockInfo lockInfo : locks) {
                sb.append("\t- ").append(lockInfo).append('\n');
            }
        }
        sb.append('\n');
        return sb.toString();
    }

    @Override
    public String threadDumpAsString(Thread thread) {
        if (thread == null) {
            return null;
        }
        return VM15.getStackTrace(thread.getStackTrace());
    }

    @Override
    public String dumpDeadlockedThreads() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        if (threadMXBean == null) {
            return null;
        }
        long[] threadIds = threadMXBean.findDeadlockedThreads();
        if (threadIds == null || threadIds.length == 0) {
            return null;
        }
        ThreadInfo[] threadInfos = threadMXBean.getThreadInfo(threadIds, Integer.MAX_VALUE);
        StringBuilder sb = new StringBuilder();
        for (ThreadInfo info : threadInfos) {
            if (info == null) continue;
            String name = "[deadlocked thread] " + info.getThreadName();
            sb.append(name).append(":\n");
            sb.append(VM15.underline(name.length()));
            sb.append("Thread '").append(info.getThreadName()).append("' is waiting to acquire lock '").append(info.getLockName()).append("' that is held by thread '").append(info.getLockOwnerName()).append("'\n");
            sb.append("\nStack trace:\n");
            sb.append(VM15.underline(12));
            sb.append(VM15.getStackTrace(info.getStackTrace())).append("\n");
        }
        return sb.toString();
    }

    private static String underline(int length) {
        StringBuilder buffer = new StringBuilder(length);
        for (int count = 0; count < length; ++count) {
            buffer.append("-");
        }
        buffer.append("\n");
        return buffer.toString();
    }

    private static String getStackTrace(StackTraceElement[] elements) {
        if (elements == null || elements.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement element : elements) {
            sb.append("\t").append(element.toString()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public String getTimedWaitingThreadDelayString() {
        ThreadInfo[] threadInfos;
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        if (threadMXBean == null) {
            return null;
        }
        long[] threadIds = threadMXBean.findDeadlockedThreads();
        if (threadIds == null || threadIds.length == 0) {
            return null;
        }
        for (ThreadInfo threadInfo : threadInfos = threadMXBean.getThreadInfo(threadIds, Integer.MAX_VALUE)) {
            String delayString;
            Thread.State threadState = threadInfo.getThreadState();
            if (!Thread.State.TIMED_WAITING.equals((Object)threadState) || (delayString = System.getProperty("deadlock_detection_delay_for_timed_waiting_" + threadInfo.getThreadId())) == null) continue;
            return delayString;
        }
        return null;
    }
}

