/*
 * Decompiled with CFR 0.152.
 */
package weblogic.protocol;

import java.io.ObjectOutput;
import weblogic.protocol.ProtocolHandlerAdmin;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerChannelManager;
import weblogic.protocol.ServerChannelStream;
import weblogic.rmi.spi.Channel;
import weblogic.utils.net.InetAddressHelper;

public class ChannelHelperBase {
    public static boolean isLocalAdminChannelEnabled() {
        return ServerChannelManager.findLocalServerChannel(ProtocolHandlerAdmin.PROTOCOL_ADMIN) != null;
    }

    public static long getAdminChannelCreationTime() {
        return ServerChannelManager.getServerChannelManager().getAdminChannelCreationTime();
    }

    public static boolean isAdminChannel(ServerChannel channel) {
        return channel.getProtocol().isSatisfactoryQOS((byte)103) || channel.getConfiguredProtocol().equalsIgnoreCase("ADMIN");
    }

    public static String getDefaultURL() {
        return ChannelHelperBase.createURL(ServerChannelManager.findDefaultLocalServerChannel());
    }

    public static String createURL(Channel ch) {
        if (ch == null) {
            return null;
        }
        return ch.getProtocolPrefix() + "://" + InetAddressHelper.convertHostIfIPV6(ch.getPublicAddress()) + ':' + ch.getPublicPort();
    }

    public static String getChannelURL(ObjectOutput out) {
        ServerChannel sc;
        if (out instanceof ServerChannelStream && (sc = ((ServerChannelStream)((Object)out)).getServerChannel()) != null) {
            return ChannelHelperBase.createURL(sc);
        }
        return ChannelHelperBase.getDefaultURL();
    }
}

