/*
 * Decompiled with CFR 0.152.
 */
package weblogic.protocol;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import weblogic.rmi.spi.Channel;

public class ChannelImpl
implements Channel {
    private final InetSocketAddress address;
    private final String protocol;
    private final int port;
    private final boolean secure;

    public ChannelImpl(String host, int port, String protocol) {
        this.port = port;
        this.address = port < 0 ? new InetSocketAddress(host, 0) : new InetSocketAddress(host, port);
        this.protocol = protocol;
        this.secure = false;
    }

    @Override
    public InetAddress getInetAddress() {
        return this.address.getAddress();
    }

    @Override
    public InetSocketAddress getPublicInetAddress() {
        return this.address;
    }

    @Override
    public String getProtocolPrefix() {
        return this.protocol;
    }

    @Override
    public boolean supportsTLS() {
        return this.secure;
    }

    @Override
    public String getPublicAddress() {
        return this.address.getHostName();
    }

    @Override
    public int getPublicPort() {
        return this.address.getPort() == 0 ? this.port : this.address.getPort();
    }

    public String toString() {
        return this.protocol + "://" + this.getPublicAddress() + ":" + this.getPublicPort();
    }
}

