/*
 * Decompiled with CFR 0.152.
 */
package weblogic.protocol;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.Socket;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolHandler;
import weblogic.protocol.ProtocolManager;
import weblogic.protocol.ServerChannel;
import weblogic.socket.MuxableSocket;
import weblogic.utils.io.Chunk;

public final class ProtocolImpl
implements Protocol,
Externalizable {
    private static final long serialVersionUID = 6784177831072346070L;
    public static final byte UNKNOWN = 9;
    public static final byte NUM_PROTOCOLS = 9;
    public static final int PROTOCOL_T3_FLAG = 1;
    public static final int PROTOCOL_T3S_FLAG = 4;
    public static final String PROTOCOL_T3_NAME = "T3";
    public static final String PROTOCOL_T3S_NAME = "T3S";
    public static final String PROTOCOL_HTTPS_NAME = "HTTPS";
    public static final Protocol PROTOCOL_UNKNOWN = ProtocolManager.createProtocol((byte)9, "unknown", "unknown", false, new NullProtocolHandler());
    private static byte dynamicPn = (byte)16;
    private String name;
    private String urlPrefix;
    private boolean secure;
    private byte protocolNumber;
    private ProtocolHandler handler;

    public ProtocolImpl() {
    }

    ProtocolImpl(byte pn, String name, String urlPrefix, boolean secure, ProtocolHandler handler) {
        this.protocolNumber = pn;
        this.secure = secure;
        this.name = name;
        this.urlPrefix = urlPrefix;
        this.handler = handler;
        ProtocolManager.registerProtocol(this);
    }

    ProtocolImpl(String name, String urlPrefix, boolean secure, ProtocolHandler handler) {
        this(ProtocolImpl.getNextProtocol(), name, urlPrefix, secure, handler);
    }

    private static synchronized byte getNextProtocol() {
        byte by = dynamicPn;
        dynamicPn = (byte)(by + 1);
        return by;
    }

    @Override
    public ProtocolHandler getHandler() {
        return this.handler;
    }

    @Override
    public String getProtocolName() {
        return this.name;
    }

    @Override
    public String getAsURLPrefix() {
        return this.urlPrefix;
    }

    @Override
    public byte toByte() {
        return this.protocolNumber;
    }

    @Override
    public byte getQOS() {
        if (this.protocolNumber == 6) {
            return 103;
        }
        if (this.isSecure()) {
            return 102;
        }
        return 101;
    }

    @Override
    public boolean isSatisfactoryQOS(byte QOS) {
        switch (QOS) {
            case 101: {
                return !this.isUnknown();
            }
            case 102: {
                if (this.protocolNumber == 6) {
                    return false;
                }
                return this.isSecure();
            }
            case 103: {
                return this.protocolNumber == 6;
            }
        }
        throw new IllegalArgumentException("Unknown QOS: '" + QOS + "'");
    }

    @Override
    public boolean isSecure() {
        if (this.protocolNumber == 6) {
            return ProtocolManager.getDefaultAdminProtocol().isSecure();
        }
        return this.secure;
    }

    @Override
    public boolean isUnknown() {
        return this.protocolNumber == 9;
    }

    @Override
    public boolean isEnabled() {
        return !this.isUnknown();
    }

    @Override
    public Protocol upgrade() {
        if (this.isSecure()) {
            return this;
        }
        return ProtocolManager.getProtocolByName(this.getProtocolName() + "S");
    }

    public int hashCode() {
        return this.protocolNumber;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        try {
            return ((ProtocolImpl)o).protocolNumber == this.protocolNumber;
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public String toString() {
        return this.getProtocolName();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.urlPrefix);
        out.writeBoolean(this.secure);
        out.writeByte(this.protocolNumber);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.name = in.readUTF();
        this.urlPrefix = in.readUTF();
        this.secure = in.readBoolean();
        this.protocolNumber = in.readByte();
    }

    public Object readResolve() {
        Protocol p = ProtocolManager.getProtocolByIndex(this.protocolNumber);
        if (p.toByte() != 9) {
            return p;
        }
        return this;
    }

    static class NullProtocolHandler
    implements ProtocolHandler {
        NullProtocolHandler() {
        }

        @Override
        public ServerChannel getDefaultServerChannel() {
            return null;
        }

        @Override
        public int getHeaderLength() {
            return 0;
        }

        @Override
        public int getPriority() {
            return 0;
        }

        @Override
        public boolean claimSocket(Chunk head) {
            return false;
        }

        @Override
        public MuxableSocket createSocket(Chunk head, Socket s, ServerChannel networkChannel) throws IOException {
            return null;
        }

        @Override
        public Protocol getProtocol() {
            return null;
        }
    }
}

