/*
 * Decompiled with CFR 0.152.
 */
package weblogic.protocol;

import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import weblogic.protocol.Identity;
import weblogic.protocol.LocalServerIdentity;
import weblogic.protocol.ServerIdentity;

public class ServerIdentityManager {
    private static final ConcurrentHashMap<Identity, ServerIdentity> identityMap = new ConcurrentHashMap(31);
    private static final ConcurrentHashMap<CompositeKey, ServerIdentity> identityNameMap = new ConcurrentHashMap(31);
    private static final ConcurrentHashMap<String, HashSet<String>> domainServerMap = new ConcurrentHashMap(31);

    public static ServerIdentity findServerIdentityFromTransient(Identity identity) {
        if (!Initializer.checkInitialized) {
            throw new AssertionError((Object)"Can not get here");
        }
        return identityMap.get(identity);
    }

    public static ServerIdentity findServerIdentityFromPersistent(Identity identity) {
        if (!Initializer.checkInitialized) {
            throw new AssertionError((Object)"Can not get here");
        }
        return identityMap.get(identity);
    }

    public static ServerIdentity findServerIdentity(String domainName, String serverName) {
        if (!Initializer.checkInitialized) {
            throw new AssertionError((Object)"Can not get here");
        }
        return identityNameMap.get(new CompositeKey(domainName, serverName));
    }

    public static synchronized boolean recordIdentity(ServerIdentity id) {
        String domainName = id.getDomainName();
        String serverName = id.getServerName();
        ServerIdentity old = identityMap.putIfAbsent(id.getTransientIdentity(), id);
        if (old != null) {
            if (!old.getServerName().equals(serverName) && !old.getDomainName().equals(domainName)) {
                throw new AssertionError((Object)("Found two servers with the same identity " + id + "\t" + old));
            }
            return true;
        }
        identityMap.put(id.getPersistentIdentity(), id);
        if (domainName != null) {
            identityNameMap.put(new CompositeKey(domainName, serverName), id);
            HashSet<String> serverList = domainServerMap.get(domainName);
            if (serverList == null) {
                serverList = new HashSet();
            }
            if (serverList.add(serverName)) {
                domainServerMap.put(domainName, serverList);
            }
        }
        return true;
    }

    public static synchronized void removeIdentity(ServerIdentity id) {
        ServerIdentityManager.removeTransientAndPersistentIdentity(id);
        CompositeKey key = new CompositeKey(id.getDomainName(), id.getServerName());
        ServerIdentity oldId = identityNameMap.get(key);
        if (oldId != null && id.equals(oldId) && id.getTransientIdentity().equals(oldId.getTransientIdentity())) {
            identityNameMap.remove(key);
        }
    }

    public static synchronized void removeTransientAndPersistentIdentity(ServerIdentity id) {
        identityMap.remove(id.getTransientIdentity());
        ServerIdentity oldId = identityMap.get(id.getPersistentIdentity());
        if (oldId != null && id.equals(oldId) && id.getTransientIdentity().equals(oldId.getTransientIdentity())) {
            HashSet<String> serverList;
            identityMap.remove(id.getPersistentIdentity());
            String domainName = id.getDomainName();
            String serverName = id.getServerName();
            if (domainName != null && serverName != null && (serverList = domainServerMap.get(domainName)) != null) {
                serverList.remove(serverName);
            }
        }
    }

    static synchronized String[] getConnectedServers(String domainName) {
        if (domainName == null) {
            return null;
        }
        HashSet<String> serverList = domainServerMap.get(domainName);
        if (serverList == null) {
            return null;
        }
        String[] array = new String[serverList.size()];
        serverList.toArray(array);
        return array;
    }

    static synchronized boolean isConnected(String serverName, String domainName) {
        if (serverName == null || domainName == null) {
            return false;
        }
        HashSet<String> serverList = domainServerMap.get(domainName);
        return serverList != null && serverList.contains(serverName);
    }

    private static class CompositeKey {
        private final String domainName;
        private final String serverName;
        private int hash = -1;

        private CompositeKey(String dName, String sName) {
            this.domainName = dName;
            this.serverName = sName;
        }

        public int hashCode() {
            if (this.hash == -1) {
                int result = this.domainName != null ? this.domainName.hashCode() : 0;
                this.hash = 31 * result + (this.serverName != null ? this.serverName.hashCode() : 0);
            }
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CompositeKey)) {
                return false;
            }
            CompositeKey other = (CompositeKey)obj;
            return !(this.domainName == null ? other.domainName != null : !this.domainName.equals(other.domainName)) && !(this.serverName == null ? other.serverName != null : !this.serverName.equals(other.serverName));
        }
    }

    private static final class Initializer {
        private static final boolean checkInitialized = ServerIdentityManager.recordIdentity(LocalServerIdentity.getIdentity());

        private Initializer() {
        }
    }
}

