/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rjvm;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.ref.WeakReference;

final class ClassTableEntry
implements Externalizable {
    private static final long serialVersionUID = 3409899474073745901L;
    private ObjectStreamClass descriptor;
    private WeakReference<ObjectStreamClass> weakDescriptor;
    private WeakReference<Class<?>> weakClass;
    private String annotation;
    private WeakReference<Class> clz;
    private WeakReference<ClassLoader> ccl;
    private int cachedHashCode;

    public ClassTableEntry() {
    }

    ClassTableEntry(ObjectStreamClass descriptor, String annotation) {
        this.descriptor = descriptor;
        this.annotation = annotation;
        this.calculateHashCode();
        if (annotation != null && !annotation.equals("")) {
            this.weakDescriptor = new WeakReference<ObjectStreamClass>(descriptor);
            this.weakClass = new WeakReference(descriptor.forClass());
            this.descriptor = null;
        }
    }

    public ObjectStreamClass getDescriptor() {
        ObjectStreamClass osc;
        Class c;
        ObjectStreamClass osc2;
        if (this.descriptor != null) {
            return this.descriptor;
        }
        if (this.weakDescriptor != null && (osc2 = (ObjectStreamClass)this.weakDescriptor.get()) != null) {
            return osc2;
        }
        if (this.weakClass != null && (c = (Class)this.weakClass.get()) != null && (osc = ObjectStreamClass.lookup(c)) != null) {
            return osc;
        }
        throw new AssertionError((Object)("all descriptor information is removed. : " + this.toString()));
    }

    public void setClazz(Class clazz) {
        this.clz = new WeakReference<Class>(clazz);
    }

    public Class getClazz() {
        return this.clz != null ? (Class)this.clz.get() : null;
    }

    public void setClazzLoader(ClassLoader classLoader) {
        this.ccl = new WeakReference<ClassLoader>(classLoader);
    }

    public ClassLoader getClazzLoader() {
        return this.ccl != null ? (ClassLoader)this.ccl.get() : null;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.getDescriptor());
        out.writeUTF(this.annotation);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.descriptor = (ObjectStreamClass)in.readObject();
        this.annotation = in.readUTF();
        this.calculateHashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        try {
            ClassTableEntry other = (ClassTableEntry)o;
            ObjectStreamClass thisDesc = this.getDescriptor();
            ObjectStreamClass otherDesc = other.getDescriptor();
            if (thisDesc == null || otherDesc == null) {
                return false;
            }
            return thisDesc.equals(otherDesc) && this.getAnnotation().equals(other.getAnnotation());
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public int hashCode() {
        return this.cachedHashCode;
    }

    public String toString() {
        return "ClassTableEntry: [" + this.descriptor + ":" + (this.weakDescriptor != null ? (Serializable)this.weakDescriptor.get() : "*") + ":" + (this.weakClass != null ? (Serializable)this.weakClass.get() : "*") + "] @" + this.getAnnotation();
    }

    private void calculateHashCode() {
        this.cachedHashCode = this.getDescriptor().hashCode() ^ this.getAnnotation().hashCode();
    }
}

