/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rjvm;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.Hashtable;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolManager;
import weblogic.protocol.ServerURL;
import weblogic.protocol.UnknownProtocolException;
import weblogic.rjvm.RJVM;
import weblogic.rjvm.RJVMEnvironment;
import weblogic.rjvm.RJVMFinder;
import weblogic.rjvm.RJVMManager;
import weblogic.rmi.spi.HostID;

public final class ClientServerURL
extends ServerURL {
    private static final Hashtable finderMap = new Hashtable();
    private static boolean protocolRegistry = RJVMManager.ensureInitialized();
    private RJVMFinder finder;
    private String currentPartitionURL;

    public ClientServerURL(String urlString) throws MalformedURLException {
        super(urlString);
    }

    public ClientServerURL(ServerURL context, String urlString) throws MalformedURLException {
        super(context, urlString);
    }

    public ClientServerURL(String protocol, String host, int port, String file) throws MalformedURLException {
        super(protocol, host, port, file);
    }

    public RJVM findOrCreateRJVM() throws IOException {
        return this.findOrCreateRJVM(false, null, null, 0);
    }

    public RJVM findRJVM() throws IOException {
        RJVMFinder rjvmfinder = new RJVMFinder(this);
        return rjvmfinder.findRJVM();
    }

    public RJVM findOrCreateRJVM(String channel) throws IOException {
        return this.findOrCreateRJVM(false, channel, null, 0);
    }

    public RJVM findOrCreateRJVM(boolean preferExistingRJVM, String channelName) throws IOException {
        return this.findOrCreateRJVM(preferExistingRJVM, channelName, null, 0);
    }

    public RJVM findOrCreateRJVM(boolean preferExistingRJVM, String channelName, HostID hostIDToIgnore) throws IOException {
        return this.findOrCreateRJVM(preferExistingRJVM, channelName, hostIDToIgnore, 0);
    }

    public RJVM findOrCreateRJVM(boolean preferExistingRJVM, String channelName, HostID hostIDToIgnore, int requestTimeout) throws IOException {
        return this.findOrCreateRJVM(preferExistingRJVM, channelName, hostIDToIgnore, requestTimeout, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RJVM findOrCreateRJVM(boolean preferExistingRJVM, String channelName, HostID hostIDToIgnore, int requestTimeout, boolean createNewFinder) throws IOException {
        try {
            RJVM rjvm;
            RJVMFinder rjvmfinder = createNewFinder ? new RJVMFinder(this) : this.getFinder();
            RJVMFinder rJVMFinder = rjvmfinder;
            synchronized (rJVMFinder) {
                rjvm = rjvmfinder.findOrCreate(preferExistingRJVM, channelName, hostIDToIgnore, requestTimeout);
                this.setCurrentPartitionURL(rjvmfinder.getPartitionUrl());
            }
            return rjvm;
        }
        catch (IOException ioe) {
            if (!createNewFinder) {
                finderMap.remove(this.finder);
            }
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RJVMFinder getFinder() throws IOException {
        RJVMEnvironment.getEnvironment().ensureInitialized();
        if (this.finder == null) {
            ClientServerURL clientServerURL = this;
            synchronized (clientServerURL) {
                if (this.finder == null) {
                    Hashtable hashtable = finderMap;
                    synchronized (hashtable) {
                        RJVMFinder newFinder = new RJVMFinder(this);
                        this.finder = (RJVMFinder)finderMap.get(newFinder);
                        if (this.finder == null) {
                            this.finder = newFinder;
                            finderMap.put(this.finder, this.finder);
                        } else {
                            try {
                                Protocol protocol = ProtocolManager.findProtocol(this.getProtocol());
                                byte newQOS = protocol.getQOS();
                                byte oldQOS = ProtocolManager.findProtocol(this.finder.getURL().getProtocol()).getQOS();
                                if (oldQOS == 101 && newQOS > oldQOS) {
                                    throw new IOException("Unable to open a secure connection to a non secure port");
                                }
                            }
                            catch (UnknownProtocolException unknownProtocolException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        }
        return this.finder;
    }

    public boolean isHostedByLocalRJVM() throws UnknownHostException {
        if (this.finder != null) {
            return this.finder.isHostedByLocalRJVM();
        }
        try {
            return this.getFinder().isHostedByLocalRJVM();
        }
        catch (IOException e) {
            UnknownHostException exp = new UnknownHostException(e.getMessage());
            exp.initCause(e);
            throw exp;
        }
    }

    public String getCurrentURL() {
        if (this.finder != null) {
            int indx = this.finder.getCurrentHostIdx();
            return this.getAddressCount() == 1 ? this.getUrlString(0) : this.getUrlString(indx);
        }
        try {
            int indx = this.getFinder().getCurrentHostIdx();
            return this.getAddressCount() == 1 ? this.getUrlString(0) : this.getUrlString(indx);
        }
        catch (IOException iOException) {
            return this.getUrlString();
        }
    }

    public String getCurrentPartitionURL() {
        return this.currentPartitionURL;
    }

    public void setCurrentPartitionURL(String currentPartitionURL) {
        this.currentPartitionURL = currentPartitionURL;
    }
}

