/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rjvm;

import java.io.IOException;
import java.io.ObjectOutput;
import weblogic.common.internal.PeerInfo;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerIdentity;
import weblogic.rjvm.ClusterInfo;
import weblogic.rjvm.ClusterInfo90;
import weblogic.rjvm.JVMID;
import weblogic.rjvm.MsgAbbrevInputStream;
import weblogic.rjvm.RJVMEnvironment;
import weblogic.utils.AssertionError;

public class ClusterInfoHelper {
    public static ClusterInfo readClusterInfo(MsgAbbrevInputStream in, PeerInfo pi, JVMID id) {
        ClusterInfo ci = null;
        if (pi.getMajor() > 8) {
            try {
                ci = (ClusterInfo)in.readObjectFromPreDiabloPeer();
            }
            catch (IOException ioe) {
                throw new AssertionError(ioe);
            }
            catch (ClassNotFoundException cnfe) {
                throw new AssertionError(cnfe);
            }
        } else if (pi.getMajor() > 6) {
            String protocolName = in.getProtocol().getProtocolName();
            try {
                ci = new ClusterInfo();
                ci.readExternal(in, pi);
                ci.setProtocolName(protocolName);
            }
            catch (IOException ioe) {
                throw new AssertionError(ioe);
            }
        } else {
            String protocolName = in.getProtocol().getProtocolName();
            ci = id.generate61ClusterInfo(protocolName, false);
        }
        return ci;
    }

    public static void writeClusterInfo(ObjectOutput oo, ServerChannel sc, ServerIdentity server, PeerInfo pi) throws IOException {
        ClusterInfo ci = ClusterInfoHelper.createClusterInfo(sc, server, pi);
        if (pi != null && pi.getMajor() > 8) {
            oo.writeObject(ci);
        } else {
            ci.writeExternal(oo, null);
        }
    }

    private static ClusterInfo createClusterInfo(ServerChannel sc, ServerIdentity server, PeerInfo pi) {
        if (pi != null && pi.getMajor() > 8) {
            return ClusterInfoHelper.createClusterInfo90Style(sc, server);
        }
        return ClusterInfoHelper.createClusterInfo81Style(sc, server);
    }

    private static ClusterInfo createClusterInfo81Style(ServerChannel channel, ServerIdentity server) {
        String addr = channel.getClusterAddress();
        if (server.getDomainName() == null || server.getServerName() == null || addr == null) {
            throw new AssertionError("Bad cluster info for: " + server.toString() + " on " + channel.toString());
        }
        int protocolMask = 1 << channel.getProtocol().toByte();
        int port = channel.supportsTLS() ? -1 : channel.getPort();
        int sslPort = channel.supportsTLS() ? channel.getPort() : -1;
        return new ClusterInfo(server.getDomainName(), addr, channel.getChannelName(), port, sslPort, -1, protocolMask, channel.getProtocol().getProtocolName(), false);
    }

    private static ClusterInfo createClusterInfo90Style(ServerChannel sc, ServerIdentity server) {
        return new ClusterInfo90(RJVMEnvironment.getEnvironment().createClusterURL(sc));
    }
}

