/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rjvm;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.concurrent.ConcurrentHashMap;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.kernel.KernelStatus;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolManager;
import weblogic.rjvm.ClientServerURL;
import weblogic.rjvm.JVMID;
import weblogic.rjvm.PeerGoneEvent;
import weblogic.rjvm.PeerGoneListener;
import weblogic.rjvm.ProxyManager;
import weblogic.rjvm.RJVM;
import weblogic.rjvm.RJVMEnvironment;
import weblogic.rjvm.RJVMLogger;
import weblogic.rjvm.RJVMManager;
import weblogic.rmi.spi.HostID;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.socket.UnrecoverableConnectException;

final class RJVMFinder
implements PeerGoneListener {
    private static final int BACKOFF_INTERVAL = 1000;
    private static final DebugLogger debugConnection = DebugLogger.getDebugLogger("DebugConnection");
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private RJVM localRJVM = null;
    private InetAddress[] hostList = null;
    private ConcurrentHashMap<JVMID, InetAddress> jvmIdToInetAddressMap = null;
    private int hostIdx = 0;
    private final String hostName;
    private int[] portList;
    private final ClientServerURL url;
    private boolean isApplet;
    private int hash;
    private static String thisHost;
    private IOException error;
    private int currentHostIdx = 0;
    private String currentPartitionUrl;
    private boolean useProxy;
    private InetAddress[] dnsEntries = null;

    RJVMFinder(ClientServerURL url) {
        this.url = url;
        Protocol protocol = ProtocolManager.getProtocolByName(url.getProtocol());
        this.hostName = url.getHost();
        this.portList = new int[9];
        int i = this.portList.length;
        while (--i >= 0) {
            this.portList[i] = -1;
        }
        if (!protocol.isUnknown()) {
            this.portList[protocol.toByte()] = url.getPort();
        }
        for (i = url.getAddressCount() - 1; i >= 0; --i) {
            this.hash ^= url.getLowerCaseHost(i).hashCode();
            this.hash ^= url.getPort(i);
        }
        this.hash ^= protocol.toByte();
        this.jvmIdToInetAddressMap = new ConcurrentHashMap();
        this.useProxy = ProxyManager.getProxyManager().shouldUseProxy(url.getHost());
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof RJVMFinder)) {
            return false;
        }
        ClientServerURL otherUrl = ((RJVMFinder)other).url;
        if (!otherUrl.getProtocol().equals(this.url.getProtocol())) {
            return false;
        }
        if (otherUrl.getAddressCount() != this.url.getAddressCount()) {
            return false;
        }
        for (int i = this.url.getAddressCount() - 1; i >= 0; --i) {
            if (otherUrl.getPort(i) == this.url.getPort(i) && otherUrl.getLowerCaseHost(i).equals(this.url.getLowerCaseHost(i))) continue;
            return false;
        }
        return true;
    }

    synchronized RJVM findOrCreate(boolean preferExistingRJVM, String channel, HostID hostIDtoIgnore, int connectionTimeout) throws IOException {
        if (this.error != null) {
            throw this.error;
        }
        try {
            return this.findOrCreateInternal(preferExistingRJVM, channel, hostIDtoIgnore, connectionTimeout);
        }
        catch (IOException ioe) {
            this.error = ioe;
            throw ioe;
        }
    }

    synchronized RJVM findRJVM() throws IOException {
        RJVM rjvm = null;
        if (this.hostList == null) {
            this.hostList = this.getDnsEntries();
        }
        try {
            if (this.isHostedByLocalRJVM()) {
                rjvm = this.localRJVM = RJVMManager.getLocalRJVM();
            } else if (this.hostList.length == 1 || this.isApplet) {
                return RJVMManager.getRJVMManager().findRemoteRJVM(this.hostList[0], this.url.getPort(0), this.url.getProtocol());
            }
        }
        catch (IOException ioe) {
            this.error = ioe;
            throw ioe;
        }
        return rjvm;
    }

    private RJVM findOrCreateInternal(boolean preferExistingRJVM, String channel, HostID hostIDtoIgnore, int connectionTimeout) throws IOException {
        RJVM rjvm;
        if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
            RJVMLogger.logDebug("RJVMFinder trying to find rjvm for " + this + '\n' + RJVMManager.getRJVMManager().toString());
        }
        if (this.localRJVM != null) {
            return this.localRJVM;
        }
        if (this.hostList == null) {
            try {
                this.hostList = this.getDnsEntries();
            }
            catch (UnknownHostException uhe) {
                if (this.useProxy) {
                    this.hostList = new InetAddress[]{JVMID.getDummyInetAddress()};
                }
                throw uhe;
            }
        }
        try {
            if (this.isHostedByLocalRJVM()) {
                rjvm = this.localRJVM = RJVMManager.getLocalRJVM();
            } else if (this.hostList.length == 1 || this.isApplet) {
                rjvm = this.findOrCreateRemoteServer(channel, connectionTimeout, 0);
                this.addPeerGoneListener(rjvm);
            } else {
                try {
                    rjvm = this.findOrCreateRemoteCluster(preferExistingRJVM, channel, hostIDtoIgnore, connectionTimeout);
                }
                catch (SecurityException se) {
                    this.isApplet = true;
                    rjvm = this.findOrCreateRemoteServer(channel, connectionTimeout, 0);
                    this.addPeerGoneListener(rjvm);
                }
            }
        }
        catch (java.rmi.ConnectException e) {
            String str = this.url.asUnsyncStringBuffer().append(": ").append(e.getMessage()).toString();
            throw (ConnectException)new ConnectException(str).initCause(e);
        }
        if (rjvm != null) {
            this.portList = rjvm.getID().ports();
        } else {
            this.hostList = null;
        }
        return rjvm;
    }

    private RJVM findOrCreateRemoteServer(String channelName, int connectionTimeout, int hostIdx) throws IOException {
        InetAddress host = this.hostList[hostIdx];
        int port = this.url.getAddressCount() == 1 ? this.url.getPort(0) : this.url.getPort(hostIdx);
        String partitionUrl = this.url.getAddressCount() == 1 ? this.url.getUrlString(0) : this.url.getUrlString(hostIdx);
        try {
            this.currentPartitionUrl = partitionUrl;
            return RJVMManager.getRJVMManager().findOrCreate(this.getHostName(hostIdx), host, port, this.url.getProtocol(), channelName, connectionTimeout, partitionUrl);
        }
        catch (IOException e) {
            if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
                RJVMLogger.logDebug("RJVMFinder can't find server at " + this.url.getProtocol() + "://" + host.getHostAddress() + ':' + port);
            }
            throw e;
        }
    }

    private RJVM findExistingRemoteServer() {
        if (this.jvmIdToInetAddressMap == null) {
            return null;
        }
        for (JVMID jvmid : this.jvmIdToInetAddressMap.keySet()) {
            RJVM rjvm = RJVMManager.getRJVMManager().find(jvmid);
            if (rjvm == null) continue;
            return rjvm;
        }
        return null;
    }

    private boolean isKernelOrServer(AuthenticatedSubject subject) {
        if (subject == kernelId) {
            return true;
        }
        return KernelStatus.isServer() && SecurityServiceManager.isServerIdentity(subject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RJVM findOrCreateRemoteCluster(boolean preferExistingRJVM, String channel, HostID hostIDToIgnore, int connectionTimeout) throws IOException {
        RJVM rjvm;
        RJVM rjvm2;
        IOException lastException = null;
        boolean[] unreachable = null;
        JVMID ignoreID = null;
        if (hostIDToIgnore instanceof JVMID) {
            ignoreID = (JVMID)hostIDToIgnore;
        }
        AuthenticatedSubject subject = SecurityServiceManager.getCurrentSubject(kernelId);
        if ((preferExistingRJVM || this.isKernelOrServer(subject)) && (rjvm2 = this.findExistingRemoteServer()) != null && !rjvm2.getID().equals(ignoreID)) {
            return rjvm2;
        }
        for (int i = 0; i < this.hostList.length; ++i) {
            try {
                if (this.hostList[this.hostIdx] == null) continue;
                rjvm = this.findOrCreateRemoteServer(channel, connectionTimeout, this.hostIdx);
                if (rjvm.getID().equals(ignoreID)) {
                    if (unreachable == null) {
                        unreachable = new boolean[this.hostList.length];
                    }
                    unreachable[this.hostIdx] = true;
                    this.hostList[this.hostIdx] = null;
                    continue;
                }
                this.addPeerGoneListener(rjvm);
                RJVM rJVM = rjvm;
                return rJVM;
            }
            catch (UnrecoverableConnectException e) {
                throw e;
            }
            catch (IOException e) {
                if (unreachable == null) {
                    unreachable = new boolean[this.hostList.length];
                }
                unreachable[this.hostIdx] = true;
                this.hostList[this.hostIdx] = null;
                lastException = e;
                continue;
            }
            finally {
                this.currentHostIdx = this.hostIdx;
                this.hostIdx = (this.hostIdx + 1) % this.hostList.length;
            }
        }
        try {
            Thread.sleep((long)(Math.random() * 1000.0));
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        this.hostList = this.getDnsEntries();
        for (int i = 0; i < this.hostList.length; ++i) {
            try {
                if (unreachable == null || !unreachable[this.hostIdx]) {
                    rjvm = this.findOrCreateRemoteServer(null, connectionTimeout, this.hostIdx);
                    this.addPeerGoneListener(rjvm);
                    RJVM rJVM = rjvm;
                    return rJVM;
                }
                this.hostList[this.hostIdx] = null;
                continue;
            }
            catch (UnrecoverableConnectException e) {
                throw e;
            }
            catch (IOException e) {
                this.hostList[this.hostIdx] = null;
                lastException = e;
                continue;
            }
            finally {
                this.currentHostIdx = this.hostIdx;
                this.hostIdx = (this.hostIdx + 1) % this.hostList.length;
            }
        }
        if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
            RJVMLogger.logDebug("RJVMFinder can't find any servers at " + this);
        }
        if (lastException == null) {
            lastException = new java.rmi.ConnectException("bad mojo");
        }
        throw lastException;
    }

    private InetAddress[] getDnsEntries() throws UnknownHostException {
        if (this.dnsEntries == null) {
            if (this.url.getAddressCount() > 1) {
                InetAddress[] entries = new InetAddress[this.url.getAddressCount()];
                for (int i = 0; i < this.url.getAddressCount(); ++i) {
                    entries[i] = InetAddress.getByName(this.getHostName(i));
                }
                this.dnsEntries = entries;
                double dHostIdx = Math.random() * (double)this.dnsEntries.length + 0.5;
                this.currentHostIdx = this.hostIdx = (int)Math.round(dHostIdx) - 1;
            } else if (thisHost.equalsIgnoreCase(this.hostName)) {
                this.dnsEntries = new InetAddress[1];
                this.dnsEntries[0] = InetAddress.getByName(this.hostName);
            } else {
                this.dnsEntries = InetAddress.getAllByName(this.hostName);
            }
        }
        return (InetAddress[])this.dnsEntries.clone();
    }

    public String getHostName(int hostIdx) {
        if (this.url.getAddressCount() > 1) {
            return this.url.getHost(hostIdx);
        }
        return this.hostName;
    }

    synchronized boolean isHostedByLocalRJVM() throws UnknownHostException {
        if (this.hostList == null) {
            this.hostList = this.getDnsEntries();
        }
        if (RJVMEnvironment.getEnvironment().isServer()) {
            for (int i = 0; i < this.hostList.length; ++i) {
                int port;
                InetAddress address = this.hostList[i];
                if (address == null) continue;
                int n = port = this.url.getAddressCount() == 1 ? this.url.getPort(0) : this.url.getPort(i);
                if (!RJVMEnvironment.getEnvironment().isLocalChannel(address, port)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        int i;
        StringBuilder buf = new StringBuilder(this.url.toString());
        buf.append("->");
        if (this.portList != null) {
            buf.append(this.hostName).append(":[");
            i = 0;
            while (true) {
                buf.append(this.portList[i]);
                if (++i >= this.portList.length) break;
                buf.append(", ");
            }
            buf.append(']');
        }
        if (this.hostList != null) {
            buf.append("->[");
            for (i = 0; i < this.hostList.length; ++i) {
                if (this.hostList[i] == null) continue;
                buf.append(this.hostList[i].getHostAddress());
                if (i == this.hostIdx) {
                    buf.append('*');
                }
                if (i + 1 >= this.hostList.length) continue;
                buf.append(", ");
            }
            buf.append(']');
        }
        return buf.toString();
    }

    private void addPeerGoneListener(RJVM newRjvm) {
        if (!this.jvmIdToInetAddressMap.containsKey(newRjvm.getID())) {
            this.jvmIdToInetAddressMap.put(newRjvm.getID(), this.hostList[this.hostIdx]);
            newRjvm.addPeerGoneListener(this);
        }
    }

    private synchronized void invalidateHostListEntry(JVMID jvmid) {
        InetAddress address = this.jvmIdToInetAddressMap.remove(jvmid);
        if (address == null) {
            return;
        }
        if (this.hostList != null) {
            if (this.hostList.length == 1) {
                this.hostList = null;
                this.dnsEntries = null;
                return;
            }
            for (int i = 0; i < this.hostList.length; ++i) {
                if (!address.equals(this.hostList[i])) continue;
                this.hostList[i] = null;
            }
        }
    }

    @Override
    public void peerGone(PeerGoneEvent pe) {
        this.invalidateHostListEntry(pe.getID());
    }

    ClientServerURL getURL() {
        return this.url;
    }

    String getPartitionUrl() {
        return this.currentPartitionUrl;
    }

    int getCurrentHostIdx() {
        return this.currentHostIdx;
    }

    static {
        try {
            thisHost = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            thisHost = "localhost";
        }
    }
}

