/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rjvm;

import java.io.IOException;
import java.io.ObjectInput;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.rmi.StubNotFoundException;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import weblogic.common.T3Exception;
import weblogic.common.T3ExecuteException;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.kernel.KernelStatus;
import weblogic.protocol.ChannelImpl;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolManager;
import weblogic.protocol.ProtocolStack;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerChannelManager;
import weblogic.protocol.ServerIdentityManager;
import weblogic.rjvm.BasicOutboundRequest;
import weblogic.rjvm.ConnectionManager;
import weblogic.rjvm.HeartbeatMonitor;
import weblogic.rjvm.InvokableFinder;
import weblogic.rjvm.JVMID;
import weblogic.rjvm.JVMMessage;
import weblogic.rjvm.LocalRJVM;
import weblogic.rjvm.MsgAbbrevInputStream;
import weblogic.rjvm.MsgAbbrevJVMConnection;
import weblogic.rjvm.MsgAbbrevOutputStream;
import weblogic.rjvm.PartitionGoneListener;
import weblogic.rjvm.PeerGoneEvent;
import weblogic.rjvm.PeerGoneException;
import weblogic.rjvm.PeerGoneListener;
import weblogic.rjvm.RJVM;
import weblogic.rjvm.RJVMEnvironment;
import weblogic.rjvm.RJVMLogger;
import weblogic.rjvm.RJVMManager;
import weblogic.rjvm.RemoteInvokable;
import weblogic.rjvm.ReplyStream;
import weblogic.rjvm.ResponseImpl;
import weblogic.rmi.RMILogger;
import weblogic.rmi.extensions.DisconnectEventImpl;
import weblogic.rmi.extensions.DisconnectListener;
import weblogic.rmi.extensions.ServerDisconnectEventImpl;
import weblogic.rmi.extensions.UnrecoverableConnectionException;
import weblogic.rmi.extensions.server.RemoteReference;
import weblogic.rmi.extensions.server.RuntimeMethodDescriptor;
import weblogic.rmi.internal.OIDManager;
import weblogic.rmi.internal.RMIEnvironment;
import weblogic.rmi.internal.ServerReference;
import weblogic.rmi.spi.Channel;
import weblogic.rmi.spi.HostID;
import weblogic.rmi.spi.InboundRequest;
import weblogic.rmi.spi.Interceptor;
import weblogic.rmi.spi.InterceptorManager;
import weblogic.rmi.spi.OutboundRequest;
import weblogic.rmi.spi.OutboundResponse;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.UserInfo;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.acl.internal.AuthenticatedUser;
import weblogic.security.service.PrivilegedActions;
import weblogic.timers.NakedTimerListener;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManagerFactory;
import weblogic.utils.Debug;
import weblogic.utils.KeyTable;
import weblogic.utils.NestedException;
import weblogic.utils.collections.ArraySet;
import weblogic.work.WorkAdapter;
import weblogic.work.WorkManagerFactory;

class RJVMImpl
implements RJVM,
PeerInfoable {
    private static final DebugLogger debugMessaging = DebugLogger.getDebugLogger("DebugMessaging");
    private static final DebugLogger debugConnection = DebugLogger.getDebugLogger("DebugConnection");
    private final JVMID id;
    private InvokableFinder finder;
    private volatile ConnectionManager connectionManager;
    private byte[] sharedSecret;
    private Object services;
    private volatile boolean isDead;
    boolean convertedToAdminQOS;
    private int peerChannelMaxMessageSize = -1;
    private ConcurrentHashMap<String, AuthenticatedUser> userTable = new ConcurrentHashMap();
    private Timer monitorTrigger;
    private int nextResponseId;
    private final KeyTable pendingResponses = new KeyTable();
    private final ArraySet<PeerGoneListener> peerGoneListeners = new ArraySet();
    private final ArraySet<PartitionGoneListener> partitionGoneListeners = new ArraySet();
    private final Date connectTime = new Date();
    private final ConcurrentHashMap<ResponseImpl, Object> responseContexts = new ConcurrentHashMap();
    private int periodLengthMillis;
    private volatile long timeOfLastMessage = -1L;
    private volatile boolean sentNoMessageRecently = true;
    private volatile boolean hbMessageReceivedThisPeriod;
    private volatile PeerInfo peerInfo;
    protected Channel remoteChannel;
    private final Object bootstrapLock = new Object();
    protected static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private int hbIdlePeriods;
    private boolean interopMode = true;
    protected boolean preDiabloPeer = true;
    private boolean bootstrapping;
    private String bootstrapErrorMessage = null;
    private volatile boolean peerRequestConnectionShutdown = false;
    private boolean cSharpClient = false;
    private Map<Channel, Long> connectionFailureLogged = new HashMap<Channel, Long>();
    private final Object connectionManagerCreateLock = new Object();
    private int notInUseCounter = 0;
    private final Set<DisconnectListener> disconnectListeners = new ArraySet<DisconnectListener>();

    boolean isCSharpClient() {
        return this.cSharpClient;
    }

    void setCSharpClient() {
        this.cSharpClient = true;
    }

    RJVMImpl(JVMID i, InvokableFinder f) {
        this.id = i;
        this.finder = f;
        if (this.finder == null) {
            RJVMLogger.logFinderInit();
        }
        this.nextResponseId = 1;
    }

    RJVMImpl(JVMID i, ServerChannel c, PeerInfo info) {
        this.id = i;
        this.remoteChannel = this.createRemoteChannel(i, c);
        this.peerInfo = info;
        this.interopMode = !LocalRJVM.getLocalRJVM().getPeerInfo().equals(this.peerInfo);
        this.preDiabloPeer = this.isPreDiabloPeer();
    }

    private boolean isPreDiabloPeer() {
        return this.peerInfo == null || this.peerInfo.compareTo(PeerInfo.VERSION_DIABLO) < 0;
    }

    private Channel createRemoteChannel(JVMID rid, Protocol p) {
        if (p != null && rid != null) {
            if (rid.isClient()) {
                return new ChannelImpl(rid.getAddress(), -1, p.getProtocolName());
            }
            if (rid.isDummy()) {
                return new ChannelImpl(rid.getHostAddress(), rid.getPort(p), p.getProtocolName());
            }
            return new ChannelImpl(rid.getAddress(), rid.getPort(p), p.getProtocolName());
        }
        return null;
    }

    private Channel createRemoteChannel(JVMID rid, ServerChannel c) {
        if (c != null) {
            return this.createRemoteChannel(rid, c.getProtocol());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerChannel ensureConnectionEstablishedByName(ServerChannel channel, String partitionName) throws Throwable {
        byte protocolNum = channel.getProtocol().toByte();
        if (this.isConnectedByName(partitionName, protocolNum)) {
            return channel;
        }
        while (true) {
            boolean needsToBootstrap;
            Object object = this.bootstrapLock;
            synchronized (object) {
                if (!this.bootstrapping) {
                    needsToBootstrap = true;
                    this.bootstrapping = true;
                } else {
                    needsToBootstrap = false;
                }
            }
            if (needsToBootstrap) {
                try {
                    this.bootstrapErrorMessage = null;
                    ConnectionManager bootstrapConMan = this.findOrCreateConMan();
                    this.remoteChannel = this.createRemoteChannel(this.getID(), channel.getProtocol());
                    MsgAbbrevJVMConnection conn = bootstrapConMan.bootstrap(this.getID().getHostAddress(), this, channel, partitionName, null);
                    if (conn != null) {
                        ServerChannel serverChannel = conn.getChannel();
                        return serverChannel;
                    }
                    ServerChannel serverChannel = channel;
                    return serverChannel;
                }
                catch (Throwable t) {
                    this.bootstrapErrorMessage = t.getMessage();
                    throw t;
                }
                finally {
                    Object object2 = this.bootstrapLock;
                    synchronized (object2) {
                        this.bootstrapping = false;
                        this.bootstrapLock.notifyAll();
                    }
                }
            }
            object = this.bootstrapLock;
            synchronized (object) {
                while (this.bootstrapping) {
                    try {
                        this.bootstrapLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.bootstrapErrorMessage != null) {
                    throw new IOException(this.bootstrapErrorMessage);
                }
                if (this.isConnectedByName(partitionName, protocolNum)) {
                    return channel;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerChannel ensureConnectionEstablishedByURL(ServerChannel channel, String partitionURL) throws Throwable {
        byte protocolNum = channel.getProtocol().toByte();
        if (this.isConnectedByURL(partitionURL, protocolNum)) {
            return channel;
        }
        while (true) {
            boolean needsToBootstrap;
            Object object = this.bootstrapLock;
            synchronized (object) {
                if (!this.bootstrapping) {
                    needsToBootstrap = true;
                    this.bootstrapping = true;
                } else {
                    needsToBootstrap = false;
                }
            }
            if (needsToBootstrap) {
                try {
                    this.bootstrapErrorMessage = null;
                    ConnectionManager bootstrapConMan = this.findOrCreateConMan();
                    this.remoteChannel = this.createRemoteChannel(this.getID(), channel.getProtocol());
                    MsgAbbrevJVMConnection conn = bootstrapConMan.bootstrap(this.getID().getHostAddress(), this, channel, null, partitionURL);
                    if (conn != null) {
                        ServerChannel serverChannel = conn.getChannel();
                        return serverChannel;
                    }
                    ServerChannel serverChannel = channel;
                    return serverChannel;
                }
                catch (Throwable t) {
                    this.bootstrapErrorMessage = t.getMessage();
                    throw t;
                }
                finally {
                    Object object2 = this.bootstrapLock;
                    synchronized (object2) {
                        this.bootstrapping = false;
                        this.bootstrapLock.notifyAll();
                    }
                }
            }
            object = this.bootstrapLock;
            synchronized (object) {
                while (this.bootstrapping) {
                    try {
                        this.bootstrapLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.bootstrapErrorMessage != null) {
                    throw new IOException(this.bootstrapErrorMessage);
                }
                if (this.isConnectedByURL(partitionURL, protocolNum)) {
                    return channel;
                }
            }
        }
    }

    private boolean isConnectedByName(String partitionName, byte protocolNum) {
        if (this.connectionManager == null) {
            return false;
        }
        boolean b = this.connectionManager.isConnectedByNameInPairedConnTable(partitionName, protocolNum);
        if (!b && this.connectionManager.router != null) {
            b = this.connectionManager.router.isConnectedByNameInPairedConnTable(partitionName, protocolNum);
        }
        return b;
    }

    private boolean isConnectedByURL(String partitionURL, byte protocolNum) {
        if (this.connectionManager == null) {
            return false;
        }
        String pn = this.connectionManager.getPartitionNameByURL(partitionURL);
        return pn != null && this.isConnectedByName(pn, protocolNum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MsgAbbrevOutputStream getOutputStreamByURL(ServerChannel channel, String partitionURL) throws IOException {
        ServerChannel ch;
        if (partitionURL == null) {
            throw new IllegalArgumentException("Can't proceed further without partitionURL");
        }
        this.connectionCheck();
        try {
            ch = this.ensureConnectionEstablishedByURL(channel, partitionURL);
        }
        catch (Throwable t) {
            this.processThrowableFromEnsureConnectionEstablished(t, channel, partitionURL);
            ch = channel;
        }
        ArraySet<PeerGoneListener> t = this.peerGoneListeners;
        synchronized (t) {
            if (this.peerRequestConnectionShutdown) {
                throw new UnrecoverableConnectionException("This RJVM has already been shutdown " + this.getID());
            }
            if (this.isDead) {
                throw new ConnectException("This RJVM has already been shutdown " + this.getID());
            }
        }
        ConnectionManager manager = this.findOrCreateConMan();
        return manager.getOutputStreamByURL(ch, partitionURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MsgAbbrevOutputStream getOutputStreamByName(ServerChannel channel, String partitionName) throws IOException {
        ServerChannel ch;
        if (partitionName == null) {
            throw new IllegalArgumentException("Can't proceed further without partitionName");
        }
        this.connectionCheck();
        try {
            ch = this.ensureConnectionEstablishedByName(channel, partitionName);
        }
        catch (Throwable t) {
            this.processThrowableFromEnsureConnectionEstablished(t, channel, partitionName);
            ch = channel;
        }
        ArraySet<PeerGoneListener> t = this.peerGoneListeners;
        synchronized (t) {
            if (this.peerRequestConnectionShutdown) {
                throw new UnrecoverableConnectionException("This RJVM has already been shutdown " + this.getID());
            }
            if (this.isDead) {
                throw new ConnectException("This RJVM has already been shutdown " + this.getID());
            }
        }
        ConnectionManager manager = this.findOrCreateConMan();
        return manager.getOutputStreamByName(ch, partitionName);
    }

    private void processThrowableFromEnsureConnectionEstablished(Throwable throwable, ServerChannel channel, String partitionNameOrUrl) throws ConnectException {
        if (channel.getProtocol().toByte() == 1 || channel.getProtocol().toByte() == 3) {
            if (this.logConnectionFailure(channel)) {
                RMILogger.logException("Could not establish a connectionManager with " + this.getID() + ", " + partitionNameOrUrl + ", using protocol " + channel.getProtocol() + ". Will retry with another channel that has the same qos as the current one.", throwable);
            }
        } else {
            Exception ex = throwable instanceof Exception ? (Exception)throwable : new Exception(throwable);
            throw new ConnectException("Could not establish a connectionManager with " + this.getID() + ", " + partitionNameOrUrl + ' ' + throwable, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean logConnectionFailure(ServerChannel channel) {
        Map<Channel, Long> map = this.connectionFailureLogged;
        synchronized (map) {
            Long value = this.connectionFailureLogged.get(channel);
            this.connectionFailureLogged.put(channel, System.currentTimeMillis());
            return value == null;
        }
    }

    @Override
    public JVMID getID() {
        return this.id;
    }

    @Override
    public final AuthenticatedUser getUser(String partitionName) {
        if (partitionName == null) {
            throw new IllegalArgumentException("getUser called with null partitionName");
        }
        return this.userTable.get(partitionName);
    }

    @Override
    public final void setUser(String partitionURL, AuthenticatedUser au) {
        if (au == null) {
            throw new IllegalArgumentException("setUser called with null AuthenticatedUser");
        }
        if (partitionURL == null) {
            throw new IllegalArgumentException("setUser called with null partitionURL");
        }
        String pName = this.findOrCreateConMan().getPartitionNameByURL(partitionURL);
        if (pName == null) {
            throw new IllegalStateException("Can't find partitionName for URL: " + partitionURL);
        }
        this.userTable.putIfAbsent(pName, au);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ConnectionManager findOrCreateConMan() {
        if (this.connectionManager == null) {
            Object object = this.connectionManagerCreateLock;
            synchronized (object) {
                if (this.connectionManager == null) {
                    this.connectionManager = ConnectionManager.create(this);
                    if (this.isDead) {
                        this.connectionManager.shutdown();
                    }
                }
            }
        }
        return this.connectionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ConnectionManager findOrSetConMan(ConnectionManager useThisIfNull) {
        if (this.connectionManager == null) {
            Object object = this.connectionManagerCreateLock;
            synchronized (object) {
                if (this.connectionManager == null) {
                    this.connectionManager = useThisIfNull;
                    if (this.isDead) {
                        this.connectionManager.shutdown();
                    }
                } else if (this.connectionManager != useThisIfNull) {
                    this.connectionManager.mergeConnections(useThisIfNull);
                }
            }
        }
        return this.connectionManager;
    }

    final void findOrCreateConManRouter(ConnectionManager inRouter) {
        ConnectionManager myConMan = this.findOrCreateConMan();
        myConMan.setRouter(inRouter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addPeerGoneListener(PeerGoneListener peerGoneListener) {
        ArraySet<PeerGoneListener> arraySet = this.peerGoneListeners;
        synchronized (arraySet) {
            if (this.isDead) {
                PeerGoneEvent ev = new PeerGoneEvent(this, new IOException("RJVM has already been shutdown " + this.getID()));
                peerGoneListener.peerGone(ev);
            } else {
                this.peerGoneListeners.add(peerGoneListener);
                if (peerGoneListener instanceof PartitionGoneListener) {
                    this.addPartitionGoneListener((PartitionGoneListener)((Object)peerGoneListener));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removePeerGoneListener(PeerGoneListener peerGoneListener) {
        ArraySet<PeerGoneListener> arraySet = this.peerGoneListeners;
        synchronized (arraySet) {
            this.peerGoneListeners.remove(peerGoneListener);
            if (peerGoneListener instanceof PartitionGoneListener) {
                this.removePartitionGoneListener((PartitionGoneListener)((Object)peerGoneListener));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPartitionGoneListener(PartitionGoneListener partitionGoneListener) {
        ArraySet<PartitionGoneListener> arraySet = this.partitionGoneListeners;
        synchronized (arraySet) {
            this.partitionGoneListeners.add(partitionGoneListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removePartitionGoneListener(PartitionGoneListener partitionGoneListener) {
        ArraySet<PartitionGoneListener> arraySet = this.partitionGoneListeners;
        synchronized (arraySet) {
            this.partitionGoneListeners.remove(partitionGoneListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addPendingResponse(ResponseImpl resp, Object txContext) {
        if (Thread.currentThread().getName().contains("weblogic.kernel.Non-Blocking") && KernelStatus.DEBUG && debugMessaging.isDebugEnabled()) {
            RJVMLogger.logDebug2("Sending an outbound request on a non-blocking thread", new Exception());
        }
        KeyTable keyTable = this.pendingResponses;
        synchronized (keyTable) {
            int txTimeout;
            int responseId;
            while (true) {
                ++this.nextResponseId;
                ResponseImpl oldResp = (ResponseImpl)this.pendingResponses.remove(responseId);
                if (oldResp == null) break;
                if (KernelStatus.DEBUG && debugMessaging.isDebugEnabled()) {
                    RJVMLogger.logDebug("Interrupting an old request with responseId: " + responseId);
                }
                oldResp.notify(new IOException("Interrupting waiting for response"));
            }
            resp.setId(responseId);
            if (resp.getTimeout() > 0 && txContext != null && (txTimeout = this.getTxTimeout(txContext)) > resp.getTimeout()) {
                resp.setTimeout(txTimeout);
            }
            if (this.isDead) {
                PeerGoneEvent ev = new PeerGoneEvent(this, new IOException("RJVM has already been shutdown " + this.getID()));
                if (!resp.hasTxContext()) {
                    resp.setTxContext(txContext);
                }
                resp.peerGone(ev);
            } else {
                if (txContext != null) {
                    this.responseContexts.put(resp, txContext);
                }
                this.pendingResponses.put(resp);
            }
            return responseId;
        }
    }

    private int getTxTimeout(Object txContext) {
        Interceptor ti = InterceptorManager.getManager().getTransactionInterceptor();
        if (ti != null) {
            return ti.getTransactionTimeout(txContext);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseImpl removePendingResponse(int responseId) {
        KeyTable keyTable = this.pendingResponses;
        synchronized (keyTable) {
            ResponseImpl returnable = (ResponseImpl)this.pendingResponses.remove(responseId);
            if (returnable != null) {
                this.responseContexts.remove(returnable);
            }
            return returnable;
        }
    }

    @Override
    public final MsgAbbrevOutputStream getRequestStream(String partitionName) throws IOException {
        return this.getRequestStream(null, partitionName, null);
    }

    @Override
    public final MsgAbbrevOutputStream getRequestStream(ServerChannel channel) throws IOException {
        return this.getRequestStream(channel, "DOMAIN", null);
    }

    @Override
    public final MsgAbbrevOutputStream getRequestStream(ServerChannel channel, String partitionName, String partitionURL) throws IOException {
        if (partitionName == null && partitionURL == null) {
            throw new IllegalArgumentException("Both partitionName and partitionURL are NULL");
        }
        AuthenticatedSubject subject = RMIEnvironment.getEnvironment().getCurrentSubjectForWire(kernelId);
        byte QOS = subject != null ? (byte)subject.getQOS() : (byte)101;
        channel = this.ensureChannel(channel, QOS);
        if (KernelStatus.DEBUG && debugMessaging.isDebugEnabled()) {
            RJVMLogger.logDebug("getRequestStream() for user: " + subject + ", QOS: " + QOS + ", channel: " + channel + ", partitionName: " + partitionName + ", partitionURL: " + partitionURL);
        }
        return this.getMsgAbbrevOutputStream(channel, partitionName, partitionURL, subject);
    }

    MsgAbbrevOutputStream getMsgAbbrevOutputStream(ServerChannel channel, String partitionName, String partitionURL, AuthenticatedSubject subject) throws IOException {
        try {
            MsgAbbrevOutputStream out = partitionName != null ? this.getOutputStreamByName(channel, partitionName) : this.getOutputStreamByURL(channel, partitionURL);
            out.setUser(subject);
            return out;
        }
        catch (IOException ioe) {
            if (this.connectionManager != null && !this.connectionManager.isConnectedInPairedConnTable()) {
                if (KernelStatus.DEBUG && debugMessaging.isDebugEnabled()) {
                    RJVMLogger.logDebug("Throwing PeerGone; partitionName: " + partitionName + " partitionURL: " + partitionURL);
                }
                this.peerGone(ioe);
            }
            throw ioe;
        }
    }

    protected ServerChannel ensureChannel(ServerChannel channel, byte QOS) {
        Protocol protocol = this.getProtocolToUse(QOS);
        if (protocol != null && protocol == this.id.getConnectToProtocol(protocol)) {
            if (channel == null || !ProtocolManager.getRealProtocol(channel.getProtocol()).equals(protocol)) {
                channel = this.findOrCreateConMan().protocolToChannel(protocol);
            }
        } else if (channel == null || !channel.getProtocol().isSatisfactoryQOS(QOS)) {
            channel = this.findOrCreateConMan().qosToChannel(QOS);
        }
        return channel;
    }

    private void connectionCheck() throws IOException {
        if (this.peerRequestConnectionShutdown) {
            throw new UnrecoverableConnectionException("This RJVM has already been shutdown " + this.getID());
        }
        if (this.isDead) {
            throw new ConnectException("This RJVM has already been shutdown " + this.getID());
        }
    }

    private Protocol getProtocolToUse(byte QOS) {
        Protocol protocol = ProtocolStack.get();
        if (protocol != null && (protocol = ProtocolManager.getRealProtocol(protocol)).isSatisfactoryQOS(QOS) && this.isProtocolSupported(protocol)) {
            return protocol;
        }
        return null;
    }

    private boolean isProtocolSupported(Protocol protocol) {
        if (this.getID().isClient() || this.getID().isBootstrapping()) {
            return true;
        }
        return this.getID().getPort(protocol) != -1;
    }

    @Override
    public final MsgAbbrevOutputStream getRequestStreamForDefaultUser(Protocol protocol, String partitionName, String partitionURL) throws IOException {
        byte QOS;
        AuthenticatedSubject subject = RMIEnvironment.getEnvironment().getCurrentSubjectForWire(kernelId);
        byte by = QOS = subject == null ? (byte)101 : (byte)subject.getQOS();
        if (KernelStatus.DEBUG && debugMessaging.isDebugEnabled()) {
            RJVMLogger.logDebug("getRequestStreamForDefaultUser() Using QOS of the current subject on the wire: " + subject + ", QOS: " + QOS + ", partitionName: " + partitionName + ", partitionURL: " + partitionURL);
        }
        if (QOS == 103) {
            try {
                if (!protocol.isSatisfactoryQOS(QOS)) {
                    protocol = protocol.upgrade();
                }
                MsgAbbrevOutputStream out = partitionName != null ? this.getOutputStreamByName(ServerChannelManager.findOutboundServerChannel(protocol), partitionName) : this.getOutputStreamByURL(ServerChannelManager.findOutboundServerChannel(protocol), partitionURL);
                out.setUser(subject);
                return out;
            }
            catch (IOException ioe) {
                this.peerGone(ioe);
                throw ioe;
            }
        }
        QOS = 101;
        try {
            if (!protocol.isSatisfactoryQOS(QOS)) {
                protocol = protocol.upgrade();
            }
            MsgAbbrevOutputStream out = partitionName != null ? this.getOutputStreamByName(ServerChannelManager.findOutboundServerChannel(protocol), partitionName) : this.getOutputStreamByURL(ServerChannelManager.findOutboundServerChannel(protocol), partitionURL);
            out.setUser(null);
            return out;
        }
        catch (IOException ioe) {
            this.peerGone(ioe);
            throw ioe;
        }
    }

    @Override
    public final MsgAbbrevOutputStream getResponseStream(ServerChannel channel, byte qos, String partitionName) throws IOException {
        if (KernelStatus.DEBUG && debugMessaging.isDebugEnabled()) {
            RJVMLogger.logDebug("getResponseStream() ServerChannel: " + channel + ", QOS: " + qos + ", partitionName: " + partitionName);
        }
        try {
            MsgAbbrevOutputStream out = this.getOutputStreamByName(channel, partitionName);
            out.header.QOS = qos;
            return out;
        }
        catch (IOException ioe) {
            if (!this.findOrCreateConMan().isConnectedInPairedConnTable()) {
                if (KernelStatus.DEBUG && debugMessaging.isDebugEnabled()) {
                    RJVMLogger.logDebug("Throwing PeerGone");
                }
                this.peerGone(ioe);
            }
            throw ioe;
        }
    }

    @Override
    public final InvokableFinder getFinder() {
        return this.finder;
    }

    @Override
    public final boolean isDead() {
        return this.isDead;
    }

    final boolean isScavengeable(int scavengeInterval) {
        boolean scavengeable = false;
        if (this.peerInfo != null) {
            if (!this.findOrCreateConMan().isInUse()) {
                ++this.notInUseCounter;
                if (this.notInUseCounter == scavengeInterval) {
                    scavengeable = true;
                }
            } else {
                this.notInUseCounter = 0;
            }
        }
        return scavengeable;
    }

    @Override
    public final HostID getHostID() {
        return this.getID();
    }

    @Override
    public final Channel getRemoteChannel() {
        Debug.assertion(this.remoteChannel != null);
        return this.remoteChannel;
    }

    @Override
    public final ServerChannel getServerChannel() {
        throw new AssertionError((Object)"getServerChannel() not supported");
    }

    @Override
    public final OutboundRequest getOutboundRequest(RemoteReference rr, RuntimeMethodDescriptor md, String serverChannel, String partitionURL) throws IOException {
        if (this.id != null && this.id.getConnectToProtocol(null) != null) {
            return this.getOutboundRequest(rr, md, serverChannel, this.id.getConnectToProtocol(null), partitionURL);
        }
        ServerChannel channel = serverChannel == null ? null : ServerChannelManager.findLocalServerChannel(serverChannel);
        return new BasicOutboundRequest(rr, this.getRequestStream(channel, null, partitionURL), md);
    }

    @Override
    public final OutboundRequest getOutboundRequest(RemoteReference remoteReference, RuntimeMethodDescriptor methodDescriptor, String serverChannelName, Protocol protocol, String partitionURL) throws IOException {
        if (this.id != null) {
            protocol = this.id.getConnectToProtocol(protocol);
        }
        ServerChannel channel = serverChannelName == null ? ServerChannelManager.findOutboundServerChannel(protocol) : ServerChannelManager.findLocalServerChannel(serverChannelName);
        return new BasicOutboundRequest(remoteReference, this.getRequestStream(channel, null, partitionURL), methodDescriptor);
    }

    public final String getServerName() {
        return this.getID().getServerName();
    }

    @Override
    public final String getClusterURL(ObjectInput in) {
        return this.getID().getClusterURL(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean addDisconnectListener(Remote stub, DisconnectListener listener) {
        Set<DisconnectListener> set = this.disconnectListeners;
        synchronized (set) {
            return this.disconnectListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean removeDisconnectListener(Remote stub, DisconnectListener listener) {
        Set<DisconnectListener> set = this.disconnectListeners;
        synchronized (set) {
            return this.disconnectListeners.remove(listener);
        }
    }

    private Date getConnectTime() {
        return this.connectTime;
    }

    @Override
    public final boolean isUnresponsive() {
        return this.hbIdlePeriods > 1;
    }

    private void setPublicKey(byte[] key) {
        this.sharedSecret = LocalRJVM.getLocalRJVM().getSharedKey(key);
    }

    final void send(int id, JVMMessage.Command cmd, ResponseImpl resp, MsgAbbrevOutputStream msgStream, byte QOS) {
        ConnectionManager cm = this.findOrCreateConMan();
        Protocol protocol = ProtocolManager.getProtocol(QOS);
        AuthenticatedUser user = msgStream.getUser();
        byte qos = QOS;
        if (user != null) {
            qos = user.getQOS();
        }
        if (!protocol.isSatisfactoryQOS(qos)) {
            QOS = qos;
        }
        msgStream.header.init(this.getID(), QOS, cmd);
        msgStream.header.responseId = resp == null ? msgStream.getReplyID() : this.addPendingResponse(resp, msgStream.getTxContext());
        msgStream.header.invokableId = id;
        cm.sendMsg(msgStream);
        this.sentNoMessageRecently = false;
    }

    final void gotExceptionSending(JVMMessage[] outstanding, String partitionName, IOException exception) {
        if (KernelStatus.DEBUG && debugMessaging.isDebugEnabled()) {
            RJVMLogger.logDebug2("Exception sending on " + this.getID() + " for partition " + partitionName, exception);
        }
        for (JVMMessage msg : outstanding) {
            ResponseImpl resp;
            if (msg == null || !JVMID.localID().equals(msg.src) || !this.getID().equals(msg.dest) || (resp = this.removePendingResponse(msg.responseId)) == null) continue;
            resp.notify(exception);
        }
        this.peerGone(exception);
    }

    final void gotExceptionReceiving(Throwable exception, String protocol) {
        PeerGoneException e;
        if (KernelStatus.DEBUG && debugMessaging.isDebugEnabled()) {
            RJVMLogger.logDebug2("Exception receiving " + protocol + " message on " + this.getID(), exception);
        }
        if (exception instanceof PeerGoneException) {
            e = (PeerGoneException)exception;
        } else {
            Exception nested = exception instanceof Exception ? (Exception)exception : new NestedException(exception);
            e = new PeerGoneException("", nested);
        }
        this.peerGone(e);
    }

    @Override
    public final void messageReceived() {
        if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
            long currentTime = System.currentTimeMillis();
            long difference = currentTime - this.timeOfLastMessage;
            if (this.periodLengthMillis != 0 && this.timeOfLastMessage != -1L && difference > (long)(this.periodLengthMillis + 200)) {
                RJVMLogger.logDebug("PeerGone danger - no message received over a: '" + difference + "' millisecond period");
            }
            this.timeOfLastMessage = currentTime;
        }
        if (this.monitorTrigger == null) {
            this.startHeartbeatTimer(this.periodLengthMillis);
        }
        this.hbMessageReceivedThisPeriod = true;
    }

    final void dispatch(MsgAbbrevInputStream is) {
        this.messageReceived();
        JVMMessage header = is.getMessageHeader();
        switch (header.cmd) {
            case CMD_INTERNAL: {
                break;
            }
            case CMD_ONE_WAY: 
            case CMD_REQUEST: {
                this.dispatchRequest(is);
                break;
            }
            case CMD_RESPONSE: {
                this.dispatchResponse(is);
                break;
            }
            case CMD_ERROR_RESPONSE: {
                this.dispatchErrorResponse(is);
                break;
            }
            default: {
                throw new AssertionError((Object)("Received unknown CMD: '" + (Object)((Object)header.cmd) + '\''));
            }
        }
    }

    private void dispatchRequest(MsgAbbrevInputStream inputStream) {
        block22: {
            JVMMessage header = inputStream.getMessageHeader();
            try {
                ServerReference sRef;
                inputStream.setResponseId(header.responseId);
                int rid = header.invokableId;
                if (KernelStatus.DEBUG && debugMessaging.isDebugEnabled()) {
                    RJVMLogger.logDebug("dispatchRequest with " + inputStream.getSubject());
                }
                if (rid == 1) {
                    RemoteInvokable ri = this.finder.lookupRemoteInvokable(rid);
                    if (ri == null) {
                        throw new NoSuchObjectException("Unable to dispatch request for boot time services: the object has been garbage collected.");
                    }
                    RJVMEnvironment.getEnvironment().invokeBootService(ri, inputStream);
                    return;
                }
                SecurityException se = null;
                if (RJVMEnvironment.getEnvironment().isServer() && rid != 27 && inputStream.getConnection().getQOS() == 103 && rid != 2) {
                    AuthenticatedSubject subject = (AuthenticatedSubject)inputStream.getSubject();
                    if (subject == null) {
                        se = new SecurityException("Authentication Denied");
                    } else if (!SubjectUtils.doesUserHaveAnyAdminRoles(subject)) {
                        if (KernelStatus.DEBUG && debugMessaging.isDebugEnabled()) {
                            RJVMLogger.logDebug("Subject " + subject + " does not have system administrator privilege");
                        }
                        se = new SecurityException("User " + SubjectUtils.getPrincipalNames(subject) + " does not have access to the administrator port.");
                    }
                }
                if ((sRef = OIDManager.getInstance().findServerReference(rid)) == null) {
                    RemoteInvokable ri = this.finder.lookupRemoteInvokable(rid);
                    if (ri != null) {
                        ri.invoke(inputStream);
                        return;
                    }
                    try {
                        sRef = OIDManager.getInstance().getServerReference(rid);
                    }
                    catch (NoSuchObjectException nsoe) {
                        if (inputStream.getTxContext() != null) {
                            Interceptor ti = InterceptorManager.getManager().getTransactionInterceptor();
                            if (ti != null) {
                                ti.receiveRequest(inputStream.getTxContext());
                            }
                            WorkManagerFactory.getInstance().getSystem().schedule(new TxErrorReporter(inputStream, nsoe));
                            return;
                        }
                        throw nsoe;
                    }
                }
                if (se == null) {
                    sRef.dispatch(inputStream);
                } else {
                    sRef.dispatchError(inputStream, se);
                }
            }
            catch (Throwable t) {
                block21: {
                    if (KernelStatus.DEBUG && debugMessaging.isDebugEnabled()) {
                        RJVMLogger.logDebug2("Dispatch problem", t);
                    }
                    try {
                        WorkManagerFactory.getInstance().getSystem().schedule(new ErrorReporter(inputStream.getResponseStream(), t));
                    }
                    catch (IOException ioe) {
                        if (!KernelStatus.DEBUG || !debugMessaging.isDebugEnabled()) break block21;
                        RJVMLogger.logDebug2("Failed to deliever error response to client", ioe);
                    }
                }
                if (!(t instanceof Error)) break block22;
                throw (Error)t;
            }
        }
    }

    private void dispatchResponse(MsgAbbrevInputStream inputStream) {
        JVMMessage header = inputStream.getMessageHeader();
        int responseNumber = header.responseId;
        ResponseImpl resp = this.removePendingResponse(responseNumber);
        if (resp == null) {
            RJVMLogger.logUnsolResponse(responseNumber);
            return;
        }
        resp.setTxContext(inputStream.getTxContext());
        resp.notify(inputStream);
    }

    private void dispatchErrorResponse(MsgAbbrevInputStream inputStream) {
        JVMMessage header = inputStream.getMessageHeader();
        int rid = header.invokableId;
        ResponseImpl resp = this.removePendingResponse(rid);
        if (resp == null) {
            RJVMLogger.logUnsolResponseError(rid);
            return;
        }
        resp.setTxContext(inputStream.getTxContext());
        resp.notifyError(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void completeConnectionSetup(int remotePeriodLength, byte[] sharedSecret, PeerInfo peerInfo, MsgAbbrevJVMConnection conn, byte QOS) {
        if (this.isDead) {
            return;
        }
        ServerChannel channel = conn.getChannel();
        if (this.peerInfo != null) {
            if (remotePeriodLength != this.periodLengthMillis) {
                RJVMLogger.logHBPeriod(remotePeriodLength, this.periodLengthMillis);
            }
            return;
        }
        RJVMImpl rJVMImpl = this;
        synchronized (rJVMImpl) {
            if (this.peerInfo != null) {
                if (remotePeriodLength != this.periodLengthMillis) {
                    RJVMLogger.logHBPeriod(remotePeriodLength, this.periodLengthMillis);
                }
                return;
            }
            if (sharedSecret != null) {
                this.setPublicKey(sharedSecret);
            }
            if (this.id != null && this.id != JVMID.localID()) {
                int localPeriodLength = HeartbeatMonitor.periodLengthMillis();
                if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
                    RJVMLogger.logDebug("Remote heartbeat: '" + remotePeriodLength + "', local heartbeat: '" + localPeriodLength + '\'');
                }
                if (localPeriodLength == 0 || remotePeriodLength == 0) {
                    if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
                        RJVMLogger.logDebug("Disabling heartbeats for RJVM: '" + this.getID() + '\'');
                    }
                    this.periodLengthMillis = 0;
                } else {
                    this.periodLengthMillis = Math.max(remotePeriodLength, localPeriodLength);
                    if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
                        RJVMLogger.logDebug("Setting heartbeat for RJVM: '" + this.getID() + "' to: '" + this.periodLengthMillis + "' milliseconds");
                    }
                    if (this.bootstrapping) {
                        this.startHeartbeatTimer(this.periodLengthMillis);
                    }
                }
            }
            Protocol prot = channel != null ? channel.getProtocol() : null;
            this.remoteChannel = prot != null ? this.createRemoteChannel(this.id, this.findOrCreateConMan().protocolToChannel(prot)) : this.createRemoteChannel(this.id, this.findOrCreateConMan().qosToChannel(QOS));
            this.interopMode = !LocalRJVM.getLocalRJVM().getPeerInfo().equals(peerInfo);
            this.peerChannelMaxMessageSize = conn.getPeerChannelMaxMessageSize();
            this.peerInfo = peerInfo;
            this.preDiabloPeer = this.isPreDiabloPeer();
            if (this.id != null && this.id.isServer()) {
                ServerIdentityManager.recordIdentity(this.id);
            }
        }
    }

    @Override
    public PeerInfo getPeerInfo() {
        return this.peerInfo;
    }

    final byte[] getSharedSecret() {
        return this.sharedSecret;
    }

    final void setSharedSecret(byte[] key) {
        this.sharedSecret = key;
    }

    int getPeriodLengthMillis() {
        return this.periodLengthMillis;
    }

    final boolean getInteropMode() {
        return this.interopMode;
    }

    final boolean isPreDiablo() {
        return this.preDiabloPeer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalPeerGoneOnPendingResponses(PeerGoneEvent ev) {
        KeyTable keyTable = this.pendingResponses;
        synchronized (keyTable) {
            Enumeration e = this.pendingResponses.elements();
            while (e.hasMoreElements()) {
                ResponseImpl response = (ResponseImpl)e.nextElement();
                if (!response.hasTxContext()) {
                    response.setTxContext(this.responseContexts.remove(response));
                }
                response.peerGone(ev);
            }
        }
    }

    final void peerGone(IOException reason) {
        this.peerGone(reason, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void peerGone(IOException reason, boolean suppressPeerGone) {
        if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
            RJVMLogger.logDebug2("!!!!!! Firing PeerGone to " + this.getID(), reason);
        }
        try {
            Set<DisconnectListener> set;
            Object object;
            if (reason instanceof UnrecoverableConnectionException) {
                this.peerRequestConnectionShutdown = true;
            }
            if (this.peerInfo == null) {
                reason = new ConnectException("PeerGone thrown while in non-connected state", reason);
            }
            PeerGoneEvent ev = new PeerGoneEvent(this, reason, suppressPeerGone);
            RJVMImpl rJVMImpl = this;
            synchronized (rJVMImpl) {
                block28: {
                    if (!this.isDead) break block28;
                    return;
                }
                object = this.pendingResponses;
                synchronized (object) {
                    set = this.connectionManagerCreateLock;
                    synchronized (set) {
                        ArraySet<PeerGoneListener> arraySet = this.peerGoneListeners;
                        synchronized (arraySet) {
                            this.isDead = true;
                            if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
                                RJVMLogger.logDebug2("RJVM [" + this + "] is set to be dead!", new Throwable());
                            }
                        }
                    }
                }
                this.peerChannelMaxMessageSize = -1;
                this.peerInfo = null;
                this.interopMode = true;
                this.notifyAll();
            }
            if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
                RJVMLogger.logDebug2("Signaling peer: '" + this.getID() + "' gone - " + reason, new Throwable(reason));
            }
            this.findOrCreateConMan().shutdown();
            this.signalPeerGoneOnPendingResponses(ev);
            final ArraySet<PeerGoneListener> peerGoneListenersCopy = new ArraySet<PeerGoneListener>();
            object = this.peerGoneListeners;
            synchronized (object) {
                peerGoneListenersCopy.addAll(this.peerGoneListeners);
            }
            final ArraySet<DisconnectListener> disconnectListenersCopy = new ArraySet<DisconnectListener>();
            set = this.disconnectListeners;
            synchronized (set) {
                disconnectListenersCopy.addAll(this.disconnectListeners);
            }
            final PeerGoneEvent peerGoneEvent = ev;
            WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

                @Override
                public void run() {
                    StringBuilder sb;
                    for (Object nextElem : peerGoneListenersCopy) {
                        try {
                            new PeerGoneDeliverer(peerGoneEvent, (PeerGoneListener)nextElem).run();
                        }
                        catch (Throwable t) {
                            if (!debugConnection.isDebugEnabled()) continue;
                            sb = new StringBuilder();
                            sb.append("Thrown while delivering PeerGoneEvent ").append(peerGoneEvent);
                            sb.append(" to ").append(nextElem);
                            debugConnection.debug(sb.toString(), t);
                        }
                    }
                    for (Object nextElem : disconnectListenersCopy) {
                        try {
                            new DisconnectEventDeliverer(RJVMImpl.this.getServerName(), peerGoneEvent.getReason(), (DisconnectListener)nextElem).run();
                        }
                        catch (Throwable t) {
                            if (!debugConnection.isDebugEnabled()) continue;
                            sb = new StringBuilder();
                            sb.append("Thrown while delivering PeerGoneEvent ").append(peerGoneEvent);
                            sb.append(" to ").append(nextElem);
                            debugConnection.debug(sb.toString(), t);
                        }
                    }
                    RJVMManager.getRJVMManager().peerGone(peerGoneEvent);
                }
            });
        }
        finally {
            this.close();
        }
    }

    final void partitionGone(String partitionName, Throwable throwable) {
        block5: {
            try {
                PeerGoneEvent ev = new PeerGoneEvent(this, new IOException(throwable), true, partitionName);
                for (PartitionGoneListener partitionGoneListener : this.partitionGoneListeners) {
                    try {
                        new PartitionGoneDeliverer(partitionGoneListener, ev).run();
                    }
                    catch (Throwable t) {
                        if (!debugConnection.isDebugEnabled()) continue;
                        StringBuilder sb = new StringBuilder();
                        sb.append("Thrown while delivering Partition Gone Event ").append(ev);
                        sb.append(" to ").append(partitionGoneListener);
                        debugConnection.debug(sb.toString(), t);
                    }
                }
            }
            catch (Throwable th) {
                if (!debugConnection.isDebugEnabled()) break block5;
                debugConnection.debug("error occured notifying listener", th);
            }
        }
    }

    @Override
    public final void disconnect() {
        this.disconnect("User requested disconnect", false);
    }

    @Override
    public final void disconnect(String msg, boolean suppressPeerGone) {
        this.peerGone(new PeerGoneException(msg), suppressPeerGone);
    }

    @Override
    public long getCreationTime() {
        return this.getConnectTime().getTime();
    }

    @Override
    public final Object getColocatedServices() throws RemoteException {
        if (this.services != null) {
            return this.services;
        }
        if (!this.getID().isServer()) {
            throw new StubNotFoundException("RJVM: '" + this.getID() + "' not a server");
        }
        AuthenticatedSubject subject = RMIEnvironment.getEnvironment().getCurrentSubjectForWire(kernelId);
        byte QOS = subject == null ? (byte)101 : (byte)subject.getQOS();
        Protocol protocol = this.findOrCreateConMan().qosToChannel(QOS).getProtocol();
        int port = this.getID().getPort(protocol);
        if (port == -1) {
            throw new ConnectIOException("No valid port for protocol: '" + protocol + '\'');
        }
        this.services = this.getT3ServicesUsingClient(protocol.getProtocolName() + "://" + this.getID().address().getHostName() + ':' + port, subject);
        return this.services;
    }

    private Object getT3ServicesUsingClient(String url, UserInfo user) throws ConnectException, ConnectIOException, ServerException {
        try {
            Class<?> c = Class.forName("weblogic.common.T3Client");
            Class[] argTypes = new Class[]{String.class, UserInfo.class};
            Constructor<?> constructor = c.getConstructor(argTypes);
            Object[] args = new Object[]{url, user};
            Object t3Client = constructor.newInstance(args);
            argTypes = new Class[]{};
            Method connect = c.getMethod("connect", argTypes);
            args = new Object[]{};
            connect.invoke(t3Client, args);
            Method getT3Services = c.getMethod("getT3Services", argTypes);
            return getT3Services.invoke(t3Client, args);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            Throwable actual = e.getTargetException();
            if (actual instanceof SecurityException) {
                throw (SecurityException)actual;
            }
            if (actual instanceof T3Exception) {
                throw new ConnectException("Problem getting services", (Exception)actual);
            }
            if (actual instanceof T3ExecuteException) {
                throw new ServerException("Problem getting services", (Exception)actual);
            }
            if (actual instanceof UnknownHostException) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)("Previously known host: '" + Arrays.toString(this.getID().address().getAddress()) + "' now unknown")))).initCause(actual);
            }
            if (actual instanceof IOException) {
                throw new ConnectIOException("Problem getting services", (Exception)actual);
            }
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Unexpected exception"))).initCause(actual);
        }
    }

    public final String toString() {
        return super.toString() + " - JVMID: '" + this.getID() + "' connect time: '" + this.getConnectTime() + '\'';
    }

    public final String getCodebase(Protocol protocol) {
        String prot = protocol.isSecure() ? "https" : "http";
        InetAddress addr = this.getID().getInetAddress();
        int port = this.getID().getPort(protocol);
        StringBuilder cb = new StringBuilder(prot);
        cb.append("://");
        if (addr instanceof Inet6Address) {
            cb.append('[').append(addr.getHostAddress()).append(']');
        } else {
            cb.append(addr.getHostAddress());
        }
        cb.append(':').append(port);
        if (KernelStatus.getTunellingURLPrefix() != null) {
            cb.append(KernelStatus.getTunellingURLPrefix());
        }
        cb.append(RJVMEnvironment.getEnvironment().getInternalWebAppContextPath()).append("/classes/");
        return cb.toString();
    }

    private void close() {
        if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
            RJVMLogger.logDebug("Closing: '" + this.getID() + '\'');
        }
        this.cancelHeartbeatTimer();
    }

    private void startHeartbeatTimer(int periodLength) {
        if (periodLength <= 0) {
            return;
        }
        HeartbeatChecker trigger = new HeartbeatChecker(periodLength);
        this.monitorTrigger = TimerManagerFactory.getTimerManagerFactory().getTimerManager("RJVMHeartbeats", "weblogic.kernel.System").schedule((TimerListener)trigger, this.periodLengthMillis, (long)this.periodLengthMillis);
    }

    public AuthenticatedSubject getCurrentSubjectForWire() {
        return RMIEnvironment.getEnvironment().getCurrentSubjectForWire(kernelId);
    }

    private void cancelHeartbeatTimer() {
        if (this.monitorTrigger != null) {
            this.monitorTrigger.cancel();
        }
    }

    @Override
    public int getPeerChannelMaxMessageSize() {
        return this.peerChannelMaxMessageSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitBootstrapDone() {
        Object object = this.bootstrapLock;
        synchronized (object) {
            while (this.bootstrapping) {
                try {
                    this.bootstrapLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private static final class TxErrorReporter
    extends WorkAdapter {
        final InboundRequest request;
        final Throwable problem;

        TxErrorReporter(InboundRequest request, Throwable problem) {
            this.request = request;
            this.problem = problem;
        }

        @Override
        public final void run() {
            try {
                Interceptor ti = InterceptorManager.getManager().getTransactionInterceptor();
                if (ti != null) {
                    ti.dispatchRequest(this.request.getTxContext());
                }
                OutboundResponse response = this.request.getOutboundResponse();
                response.transferThreadLocalContext(this.request);
                response.sendThrowable(this.problem);
            }
            catch (IOException e) {
                RJVMLogger.logDebug2("Unable to send error response to client", e);
            }
        }

        @Override
        public final String toString() {
            return super.toString() + " - problem: '" + this.problem + '\'';
        }
    }

    private static final class ErrorReporter
    extends WorkAdapter {
        final ReplyStream resp;
        final Throwable problem;

        ErrorReporter(ReplyStream resp, Throwable problem) {
            this.resp = resp;
            this.problem = problem;
        }

        @Override
        public final void run() {
            this.resp.sendThrowable(this.problem);
        }

        @Override
        public final String toString() {
            return super.toString() + " - problem: '" + this.problem + '\'';
        }
    }

    private static final class DisconnectEventDeliverer
    implements Runnable {
        final Exception e;
        final DisconnectListener l;
        private String serverName;

        DisconnectEventDeliverer(String serverName, Exception e, DisconnectListener l) {
            this.serverName = serverName;
            this.e = e;
            this.l = l;
        }

        @Override
        public final void run() {
            DisconnectEventImpl event = this.serverName != null ? new ServerDisconnectEventImpl(this.e, this.serverName) : new DisconnectEventImpl(this.e);
            this.l.onDisconnect(event);
        }

        public final String toString() {
            return super.toString() + " - reason: '" + this.e + '\'';
        }
    }

    private static final class PeerGoneDeliverer
    implements Runnable {
        final PeerGoneEvent ev;
        final PeerGoneListener l;

        PeerGoneDeliverer(PeerGoneEvent ev, PeerGoneListener l) {
            this.ev = ev;
            this.l = l;
        }

        @Override
        public final void run() {
            if (!this.ev.suppressPeerGoneEvent()) {
                this.l.peerGone(this.ev);
            }
        }

        public final String toString() {
            return super.toString() + " - event: '" + this.ev + '\'';
        }
    }

    private final class HeartbeatChecker
    implements NakedTimerListener {
        private final int period;

        HeartbeatChecker(int period) {
            this.period = period;
        }

        @Override
        public final void timerExpired(Timer timer) {
            if (!RJVMImpl.this.connectionManager.isConnectedInPairedConnTable()) {
                if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
                    RJVMLogger.logDebug("Heartbeat is ignored since current RJVM [" + this + "] is NOT connected yet!");
                }
                return;
            }
            try {
                if (this.hbCheckTimeout()) {
                    RJVMImpl.this.peerGone(new PeerGoneException("No message was received for: '" + this.period * HeartbeatMonitor.idlePeriodsUntilTimeout() / 1000 + "' seconds"));
                }
                if (!RJVMImpl.this.isDead && RJVMImpl.this.sentNoMessageRecently) {
                    RJVMImpl.this.findOrCreateConMan().sendHeartbeatMsg();
                }
                RJVMImpl.this.sentNoMessageRecently = true;
            }
            catch (Throwable t) {
                try {
                    RJVMLogger.logHBTrigger(RJVMImpl.this.getID().toString(), t);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        private boolean hbCheckTimeout() {
            RJVMImpl.this.hbIdlePeriods = RJVMImpl.this.hbMessageReceivedThisPeriod ? 0 : RJVMImpl.this.hbIdlePeriods + 1;
            RJVMImpl.this.hbMessageReceivedThisPeriod = false;
            return RJVMImpl.this.hbIdlePeriods >= HeartbeatMonitor.idlePeriodsUntilTimeout();
        }
    }

    private static final class PartitionGoneDeliverer
    implements Runnable {
        final PeerGoneEvent peerGoneEvent;
        final PartitionGoneListener partitionGoneListener;

        PartitionGoneDeliverer(PartitionGoneListener partitionGoneListener, PeerGoneEvent e) {
            this.peerGoneEvent = e;
            this.partitionGoneListener = partitionGoneListener;
        }

        @Override
        public final void run() {
            this.partitionGoneListener.partitionGone(this.peerGoneEvent);
        }
    }
}

