/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rjvm;

import java.io.IOException;
import java.rmi.UnmarshalException;
import weblogic.common.WLObjectInput;
import weblogic.rjvm.PeerGoneEvent;
import weblogic.rjvm.RJVM;
import weblogic.rjvm.ResponseImpl;
import weblogic.rjvm.ResponseListener;
import weblogic.rmi.extensions.server.RuntimeMethodDescriptor;
import weblogic.utils.StackTraceUtils;

final class ResponseWithListener
extends ResponseImpl {
    private final ResponseListener l;

    ResponseWithListener(RJVM rjvm, int timeout, ResponseListener l, RuntimeMethodDescriptor md) {
        super(rjvm, timeout, md);
        this.l = l;
    }

    @Override
    public void notify(WLObjectInput msg) {
        super.notify(msg);
        this.l.response(this);
    }

    @Override
    public void notifyError(WLObjectInput msgThrowable) {
        super.notifyError(msgThrowable);
        this.l.response(this);
    }

    @Override
    public void notify(Throwable t) {
        super.notify(t);
        this.l.response(this);
    }

    @Override
    public final Object unmarshalReturn() throws Throwable {
        this.retrieveThreadLocalContext();
        Throwable throwable = this.getThrowable();
        if (throwable != null) {
            throw StackTraceUtils.getThrowableWithCause(throwable);
        }
        try {
            return this.getMsgInput().readObject(Object.class);
        }
        catch (IOException ioe) {
            throw new UnmarshalException("failed to unmarshal async result", ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new UnmarshalException("failed to unmarshal async result", cnfe);
        }
    }

    @Override
    public void peerGone(PeerGoneEvent e) {
        super.peerGone(e);
        this.l.response(this);
    }
}

