/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rjvm.t3.client;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import javax.net.SocketFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.protocol.ServerChannel;
import weblogic.socket.WeblogicSocketFactory;
import weblogic.socket.utils.ProxyUtils;

public class T3ClientWeblogicSocketFactory
extends WeblogicSocketFactory {
    public static final String SSL_MINIMUM_PROTOCOL_VERSION_PROP = "weblogic.security.SSL.minimumProtocolVersion";
    public static final String SSL_PREFERRED_PROTOCOL_VERSION_PROP = "weblogic.security.SSL.preferredProtocolVersion";
    private static final String JDK_TLS_CLIENT_PROTOCOLS_PROP = "jdk.tls.client.protocols";
    private final SSLSocketFactory sslSocketFactory;
    private final ServerChannel channel;
    private String minProtocolVersion;
    private String protocolVersion;
    private final boolean jdkTlsClientProtocolsSpecified;
    private final boolean minProtocolVersionSpecified;
    private DebugLogger log = DebugLogger.getDebugLogger("DebugConnection");

    private static boolean contains(String[] array, String value) {
        for (String elem : array) {
            if (!value.equals(elem)) continue;
            return true;
        }
        return false;
    }

    public T3ClientWeblogicSocketFactory(SSLSocketFactory sslSocketFactory, ServerChannel channel) {
        this.sslSocketFactory = sslSocketFactory;
        this.channel = channel;
        this.minProtocolVersion = System.getProperty(SSL_MINIMUM_PROTOCOL_VERSION_PROP, "TLSv1");
        this.protocolVersion = System.getProperty(SSL_PREFERRED_PROTOCOL_VERSION_PROP);
        this.jdkTlsClientProtocolsSpecified = System.getProperty(JDK_TLS_CLIENT_PROTOCOLS_PROP) != null;
        this.minProtocolVersionSpecified = System.getProperty(SSL_MINIMUM_PROTOCOL_VERSION_PROP) != null;
    }

    public T3ClientWeblogicSocketFactory(SocketFactory socketFactory, ServerChannel channel) {
        throw new UnsupportedOperationException("Only SSLSocketFactory is supported");
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.createSocket(InetAddress.getByName(host), port);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.createSocket(host, port, 0);
    }

    @Override
    public Socket createSocket(InetAddress host, int port, int connectionTimeoutMillis) throws IOException {
        int timeout = connectionTimeoutMillis > 0 || this.channel == null ? connectionTimeoutMillis : this.channel.getConnectTimeout() * 1000;
        SSLSocket sslSocket = null;
        boolean alreadyConnected = false;
        if (ProxyUtils.canProxy(host, true)) {
            Socket sock = ProxyUtils.getSSLClientProxy(host.getCanonicalHostName(), port, connectionTimeoutMillis);
            sslSocket = (SSLSocket)this.sslSocketFactory.createSocket(sock, host.getCanonicalHostName(), port, true);
            alreadyConnected = true;
        } else {
            sslSocket = (SSLSocket)this.sslSocketFactory.createSocket();
        }
        this.log.debug("Proxy is used: " + ProxyUtils.canProxy(host, true) + " Proxy Host: " + ProxyUtils.getProxyHost() + " Proxy port: " + ProxyUtils.getProxyPort() + " Dont Proxy: " + ProxyUtils.getDontProxy() + " Proxy Auth: " + ProxyUtils.getProxyAuthStr() + " Proxy Auth Class: " + ProxyUtils.getProxyAuthClassName() + " SSL Proxy Host: " + ProxyUtils.getSSLProxyHost() + " SSL Proxy Port: " + ProxyUtils.getSSLProxyPort() + " SSL Dont Proxy: " + ProxyUtils.getSSLDontProxy());
        ArrayList<String> enabledProtocols = this.getEnabledProtocols(sslSocket.getSupportedProtocols(), sslSocket.getEnabledProtocols());
        for (int i = enabledProtocols.size() - 1; i >= 0; --i) {
            try {
                this.configureSocket(sslSocket, host, port, timeout, alreadyConnected);
                sslSocket.setEnabledProtocols(new String[]{enabledProtocols.get(i)});
                sslSocket.startHandshake();
                this.log.debug("Handshake succeeded: " + enabledProtocols.get(i));
                return sslSocket;
            }
            catch (SSLException e) {
                sslSocket.close();
                this.log.debug("Handshake failed: " + enabledProtocols.get(i) + ", error = " + e.getMessage());
                if (i == 0) {
                    throw e;
                }
                sslSocket = (SSLSocket)this.sslSocketFactory.createSocket();
                continue;
            }
        }
        return null;
    }

    private void configureSocket(SSLSocket sslSocket, InetAddress host, int port, int timeout, boolean alreadyConnected) throws IOException {
        if (!alreadyConnected) {
            sslSocket.connect(new InetSocketAddress(host, port), timeout);
        }
        sslSocket.setTcpNoDelay(true);
        sslSocket.setTrafficClass(16);
    }

    private ArrayList<String> getEnabledProtocols(String[] supportedProtocols, String[] socketEnabledProtocols) {
        ArrayList<String> enabledProtocols = new ArrayList<String>();
        if (this.jdkTlsClientProtocolsSpecified) {
            if (this.minProtocolVersionSpecified) {
                this.log.debug("weblogic.security.SSL.minimumProtocolVersion property is ignored because jdk.tls.client.protocols property is set");
            }
            if (socketEnabledProtocols != null) {
                for (String protocol : socketEnabledProtocols) {
                    enabledProtocols.add(protocol);
                }
            }
        } else {
            for (int i = 0; i < supportedProtocols.length; ++i) {
                if (this.minProtocolVersion.compareTo(supportedProtocols[i]) > 0) continue;
                enabledProtocols.add(supportedProtocols[i]);
            }
            if (enabledProtocols.isEmpty()) {
                this.log.debug("Invalid value: weblogic.security.SSL.minimumProtocolVersion=" + this.minProtocolVersion);
                throw new RuntimeException("Invalid value: weblogic.security.SSL.minimumProtocolVersion=" + this.minProtocolVersion);
            }
        }
        if (this.protocolVersion != null && !enabledProtocols.contains(this.protocolVersion)) {
            this.log.debug("Invalid value: weblogic.security.SSL.preferredProtocolVersion=" + this.protocolVersion + ". Either the protocol is not valid or does not comply with " + (this.jdkTlsClientProtocolsSpecified ? "jdk.tls.client.protocols property" : "weblogic.security.SSL.minimumProtocolVersion=" + this.minProtocolVersion));
            throw new RuntimeException("Invalid value: weblogic.security.SSL.preferredProtocolVersion=" + this.protocolVersion);
        }
        if (this.protocolVersion != null) {
            enabledProtocols.remove(this.protocolVersion);
        }
        Collections.sort(enabledProtocols);
        if (this.protocolVersion != null) {
            enabledProtocols.add(this.protocolVersion);
        }
        return enabledProtocols;
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i, InetAddress inetAddress1, int i1) {
        throw new UnsupportedOperationException("Binding characteristics are determined by the channel");
    }

    @Override
    public Socket createSocket(String address, int port, InetAddress localHost, int localPort) {
        throw new UnsupportedOperationException("Binding characteristics are determined by the channel");
    }
}

