/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi;

import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.AlreadyBoundException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.naming.CommunicationException;
import javax.naming.InvalidNameException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import weblogic.protocol.ServerURL;
import weblogic.rmi.JndiInfo;
import weblogic.rmi.JndiNamingInfo;
import weblogic.rmi.registry.LocateRegistry;

public final class Naming {
    public static final String RMI_NAMING_JNDI_HOME = "weblogic.rmi";
    public static final String RMI_NAMING_JNDI_PATH = "weblogic.rmi/";

    private static synchronized JndiNamingInfo createJndiInfo(ServerURL url) throws MalformedURLException, RemoteException {
        try {
            return (JndiNamingInfo)JndiInfo.parse(url, false);
        }
        catch (CommunicationException ce) {
            throw new java.rmi.UnknownHostException("Could not init server [" + url.toString() + "]", ce);
        }
        catch (NamingException ne) {
            Naming.toWeblogicRmiException(ne, url.toString());
            return null;
        }
    }

    public static Remote lookup(String name) throws NotBoundException, MalformedURLException, RemoteException {
        Remote o = null;
        ServerURL url = LocateRegistry.getServerURL(name);
        JndiNamingInfo jndiInfo = Naming.createJndiInfo(url);
        try {
            o = (Remote)jndiInfo.getContext().lookup(jndiInfo.getPath());
        }
        catch (InvalidNameException e) {
            throw (MalformedURLException)new MalformedURLException(jndiInfo.getPath() + " provoked").initCause(e);
        }
        catch (NameNotFoundException e) {
            throw (NotBoundException)new NotBoundException(jndiInfo.getPath() + " provoked").initCause(e);
        }
        catch (NamingException ne) {
            Naming.toWeblogicRmiException(ne, jndiInfo.getPath());
        }
        return o;
    }

    public static void bindJava(String name, Remote impl) throws AlreadyBoundException, MalformedURLException, RemoteException {
        Naming.bindInternal(name, impl);
    }

    public static void bind(String name, Remote impl) throws AlreadyBoundException, MalformedURLException, RemoteException {
        Naming.bindInternal(name, impl);
    }

    private static void bindInternal(String name, Object impl) throws AlreadyBoundException, MalformedURLException, RemoteException {
        ServerURL url = LocateRegistry.getServerURL(name);
        JndiNamingInfo jndiInfo = Naming.createJndiInfo(url);
        try {
            jndiInfo.getContext().bind(jndiInfo.getPath(), impl);
        }
        catch (NameAlreadyBoundException e) {
            throw (AlreadyBoundException)new AlreadyBoundException(jndiInfo.getPath() + " provoked").initCause(e);
        }
        catch (NameNotFoundException e) {
            throw (MalformedURLException)new MalformedURLException(jndiInfo.getPath() + " provoked").initCause(e);
        }
        catch (NamingException ne) {
            Naming.toWeblogicRmiException(ne, jndiInfo.getPath());
        }
    }

    public static void unbind(String name) throws NotBoundException, MalformedURLException, RemoteException {
        ServerURL url = LocateRegistry.getServerURL(name);
        JndiNamingInfo jndiInfo = Naming.createJndiInfo(url);
        try {
            jndiInfo.getContext().unbind(jndiInfo.getPath());
        }
        catch (InvalidNameException | NameNotFoundException ne) {
            throw (NotBoundException)new NotBoundException(jndiInfo.getPath() + " provoked").initCause(ne);
        }
        catch (NamingException ne) {
            Naming.toWeblogicRmiException(ne, jndiInfo.getPath());
        }
    }

    public static void rebindJava(String name, Remote obj) throws MalformedURLException, RemoteException {
        Naming.rebindInternal(name, obj);
    }

    public static void rebind(String name, Remote obj) throws MalformedURLException, RemoteException {
        Naming.rebindInternal(name, obj);
    }

    private static void rebindInternal(String name, Object obj) throws MalformedURLException, RemoteException {
        ServerURL url = LocateRegistry.getServerURL(name);
        JndiNamingInfo jndiInfo = Naming.createJndiInfo(url);
        try {
            jndiInfo.getContext().rebind(jndiInfo.getPath(), obj);
        }
        catch (NameNotFoundException e) {
            throw (MalformedURLException)new MalformedURLException(jndiInfo.getPath() + " provoked").initCause(e);
        }
        catch (NamingException ne) {
            Naming.toWeblogicRmiException(ne, jndiInfo.getPath());
        }
    }

    public static String[] list(String name) throws MalformedURLException, RemoteException {
        String[] results = new String[]{};
        ServerURL url = LocateRegistry.getServerURL(name);
        JndiNamingInfo jndiInfo = Naming.createJndiInfo(url);
        try {
            ArrayList<String> set = new ArrayList<String>();
            NamingEnumeration<NameClassPair> e = jndiInfo.getContext().list("");
            while (e.hasMore()) {
                String binding_name = e.next().getName();
                set.add(jndiInfo.getFullURL(binding_name));
            }
            if (set.size() == 0) {
                return results;
            }
            results = new String[set.size()];
            set.toArray(results);
        }
        catch (NamingException ne) {
            Naming.toWeblogicRmiException(ne, jndiInfo.getProviderUrl());
        }
        return results;
    }

    private static void toWeblogicRmiException(NamingException ne, String url) throws MalformedURLException, RemoteException {
        Throwable t = ne.getRootCause();
        if (t == null) {
            if (ne instanceof InvalidNameException) {
                throw (MalformedURLException)new MalformedURLException(url + " provoked").initCause(ne);
            }
            throw new ConnectIOException("An unexpected exception occurred", ne);
        }
        if (t instanceof MalformedURLException) {
            throw (MalformedURLException)t;
        }
        if (t instanceof UnknownHostException) {
            throw new java.rmi.UnknownHostException("Remapped jndi exception", (Exception)t);
        }
        if (t instanceof java.rmi.UnknownHostException) {
            throw (java.rmi.UnknownHostException)t;
        }
        if (t instanceof ConnectException) {
            throw (MalformedURLException)new MalformedURLException("Remapped jndi exception provoked").initCause(t);
        }
        if (t instanceof RemoteException) {
            throw (RemoteException)t;
        }
        throw new MarshalException("Remapped jndi exception", (Exception)t);
    }

    private Naming() {
    }
}

