/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.cluster;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.rmi.ConnectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import javax.naming.Context;
import javax.naming.NamingException;
import org.omg.CORBA.SystemException;
import weblogic.common.WLObjectInput;
import weblogic.common.WLObjectOutput;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.kernel.KernelStatus;
import weblogic.rmi.RMILogger;
import weblogic.rmi.RemoteEJBInvokeException;
import weblogic.rmi.RemoteEJBPreInvokeException;
import weblogic.rmi.cluster.BasicReplicaList;
import weblogic.rmi.cluster.CallRouter;
import weblogic.rmi.cluster.ClusterableRemoteRef;
import weblogic.rmi.cluster.PeerNotActiveException;
import weblogic.rmi.cluster.PiggybackRequester;
import weblogic.rmi.cluster.ReplicaAwareInfo;
import weblogic.rmi.cluster.ReplicaHandler;
import weblogic.rmi.cluster.ReplicaList;
import weblogic.rmi.cluster.RetryHandler;
import weblogic.rmi.cluster.RichReplicaList;
import weblogic.rmi.cluster.ThreadPreferredHost;
import weblogic.rmi.cluster.TransactionalAffinityHandler;
import weblogic.rmi.cluster.Version;
import weblogic.rmi.extensions.RemoteHelper;
import weblogic.rmi.extensions.RemoteSystemException;
import weblogic.rmi.extensions.StubFactory;
import weblogic.rmi.extensions.server.ColocatedStream;
import weblogic.rmi.extensions.server.RemoteReference;
import weblogic.rmi.extensions.server.RemoteWrapper;
import weblogic.rmi.extensions.server.RuntimeMethodDescriptor;
import weblogic.rmi.internal.RMIEnvironment;
import weblogic.rmi.internal.StubInfoIntf;
import weblogic.rmi.spi.EndPoint;
import weblogic.rmi.spi.HostID;
import weblogic.rmi.spi.RMIRuntime;
import weblogic.utils.Debug;

public class BasicReplicaHandler
implements ReplicaHandler,
PiggybackRequester,
Externalizable {
    private static final long serialVersionUID = 5316697778118669758L;
    private static final DebugLogger debugFailoverLogger = DebugLogger.getDebugLogger("DebugFailOver");
    private static final DebugLogger debugLoadbalancingLogger = DebugLogger.getDebugLogger("DebugLoadBalancing");
    private static final boolean DEBUG = false;
    protected int current = 0;
    protected ReplicaList replicaList;
    protected CallRouter callRouter;
    protected boolean stickToFirstServer;
    protected boolean propagateEnvironment;
    protected String jndiName;
    protected transient ReplicaAwareInfo info;
    protected transient RemoteReference primary;
    private transient boolean firstRequest = true;
    private transient Object env = RMIEnvironment.getEnvironment().threadEnvironmentGet();
    private transient HostID lastPreferredHost = null;
    private transient boolean isAffinityRequired = false;

    protected int getCurrent() {
        return this.current;
    }

    protected void setCurrent(int current) {
        this.current = current;
    }

    protected void setAffinityRequired(boolean isAffinityRequired) {
        this.isAffinityRequired = isAffinityRequired;
    }

    protected boolean isAffinityRequired() {
        return this.isAffinityRequired;
    }

    protected void setStickToFirstServer(boolean stickToFirstServer) {
        this.stickToFirstServer = stickToFirstServer;
    }

    public BasicReplicaHandler(ReplicaAwareInfo info, RemoteReference primary) {
        this(info, BasicReplicaHandler.newReplicaList(info, primary));
        this.primary = primary;
    }

    private static ReplicaList newReplicaList(ReplicaAwareInfo info, RemoteReference primary) {
        if (info.getCallRouter() == null) {
            return new BasicReplicaList(primary);
        }
        return new RichReplicaList(primary);
    }

    protected BasicReplicaHandler(ReplicaAwareInfo info, ReplicaList list) {
        this();
        this.callRouter = info.getCallRouter();
        this.stickToFirstServer = info.getStickToFirstServer();
        this.jndiName = info.getJNDIName();
        this.propagateEnvironment = info.getPropagateEnvironment();
        Debug.assertion(this.callRouter == null || list instanceof RichReplicaList, "list must support server name mapping");
        this.replicaList = list;
    }

    @Override
    public Version getPiggybackRequest() {
        return this.replicaList.version();
    }

    @Override
    public void setPiggybackResponse(Object response) {
        if (response != null) {
            this.resetReplicaList((ReplicaList)response);
        }
    }

    @Override
    public ReplicaList getReplicaList() {
        return this.replicaList;
    }

    @Override
    public void resetReplicaList(ReplicaList newList) {
        if (newList.getClass().equals(this.replicaList.getClass())) {
            this.replicaList.reset(newList);
        } else {
            this.replicaList = newList;
        }
        int count = this.replicaList.size();
        if (count == 0) {
            this.current = 0;
        } else {
            double dIdx = Math.random() * (double)count + 0.5;
            this.current = (int)Math.round(dIdx) - 1;
        }
    }

    protected boolean isRecoverableFailure(RuntimeMethodDescriptor md, RemoteException e) {
        if (e instanceof RemoteEJBPreInvokeException) {
            return true;
        }
        if (e instanceof RemoteEJBInvokeException) {
            Throwable t = BasicReplicaHandler.unwrapRemoteEJBInvokeException((RemoteEJBInvokeException)e);
            if (t instanceof RemoteException) {
                e = (RemoteException)t;
            } else {
                return false;
            }
        }
        if (md.isIdempotent()) {
            return RemoteHelper.isRecoverableFailure(e);
        }
        return RemoteHelper.isRecoverablePreInvokeFailure(e);
    }

    public static Throwable unwrapRemoteEJBInvokeException(RemoteEJBInvokeException e) {
        Throwable t = e.getCause();
        if (t instanceof RemoteException) {
            return t;
        }
        if (t instanceof IOException) {
            return new UnmarshalException(t.getMessage(), (Exception)t);
        }
        if (t instanceof SystemException) {
            return new RemoteSystemException((SystemException)t);
        }
        if (t instanceof NamingException) {
            NamingException ne = (NamingException)t;
            if (RMIEnvironment.getEnvironment().isAdminModeAccessException(ne)) {
                return new RemoteException("", ne);
            }
            Throwable tt = ClusterableRemoteRef.getRootCauseForNamingException(ne);
            if (tt instanceof RemoteException) {
                return tt;
            }
        }
        return t;
    }

    protected final String getJNDIName() {
        return this.jndiName;
    }

    public void setJNDIName(String jndiName) {
        this.jndiName = jndiName;
    }

    @Override
    public RemoteReference failOver(RemoteReference failedRef, RuntimeMethodDescriptor md, Method m, Object[] params, RemoteException re, RetryHandler retryHandler) throws RemoteException {
        int retryCount = retryHandler.getRetryCount();
        if (re == null) {
            return this.failOverToPreventTimeout(failedRef, md, m, params, re, retryCount);
        }
        if (!this.isRecoverableFailure(md, re)) {
            if (debugFailoverLogger.isDebugEnabled()) {
                debugFailoverLogger.debug(this.getJNDIName() + " can't recover from unrecoverable exception " + re);
            }
            throw RemoteHelper.returnOrUnwrap(re);
        }
        if (debugFailoverLogger.isDebugEnabled()) {
            debugFailoverLogger.debug(this.getJNDIName() + " attempting failover due to: " + re);
        }
        this.replicaList.remove(failedRef);
        if (retryCount == 0) {
            retryHandler.setMaxRetryCount(this.replicaList.size());
        }
        boolean isAlreadyRefreshed = retryHandler.isListRefreshed();
        if (!(this.replicaList.size() != 0 || retryHandler.updateIsListRefreshed(this.refreshReplicaList()) && this.replicaList.size() != 0)) {
            if (debugFailoverLogger.isDebugEnabled()) {
                debugFailoverLogger.debug(this.getJNDIName() + " unable to failover");
            }
            throw RemoteHelper.returnOrUnwrap(re);
        }
        if (isAlreadyRefreshed && retryHandler.isListExhausted()) {
            if (debugFailoverLogger.isDebugEnabled()) {
                debugFailoverLogger.debug(this.getJNDIName() + " unable to failover after " + retryCount + " tries");
            }
            throw RemoteHelper.returnOrUnwrap(re);
        }
        if (!isAlreadyRefreshed && retryHandler.isListRefreshed()) {
            retryHandler.setMaxRetryCount(retryCount + this.replicaList.size() - 1);
        }
        RemoteReference ref = null;
        if (this.callRouter != null) {
            ref = this.chooseReplicaUsingCallRouter(m, params);
        }
        if (ref == null && this.isAffinityRequired) {
            ref = this.chooseReplicaAfterFailureUsingAffinity(failedRef, m, params, re);
        }
        if (ref == null) {
            ref = this.chooseReplicaAfterFailure(failedRef, m, params, re);
        }
        if (ref == null) {
            if (debugFailoverLogger.isDebugEnabled()) {
                debugFailoverLogger.debug(this.getJNDIName() + " unable to failover after " + retryCount + " tries");
            }
            throw RemoteHelper.returnOrUnwrap(re);
        }
        if (ref == failedRef) {
            if (debugFailoverLogger.isDebugEnabled()) {
                debugFailoverLogger.debug(this.getJNDIName() + " unable to failover");
            }
            throw RemoteHelper.returnOrUnwrap(re);
        }
        if (debugFailoverLogger.isDebugEnabled()) {
            debugFailoverLogger.debug(this.getJNDIName() + " failing over to " + ref.getHostID());
        }
        return ref;
    }

    private RemoteReference failOverToPreventTimeout(RemoteReference failedRef, RuntimeMethodDescriptor md, Method m, Object[] params, RemoteException re, int retryCount) throws RemoteException {
        if (!(this.replicaList.size() != 0 || this.refreshReplicaList() && this.replicaList.size() != 0)) {
            return failedRef;
        }
        if (this.callRouter == null && this.isAffinityRequired) {
            return failedRef;
        }
        RemoteReference ref = null;
        for (int count = this.replicaList.size(); count > 0; --count) {
            if (this.callRouter != null) {
                ref = this.chooseReplicaUsingCallRouter(m, params);
            }
            if (ref == null) {
                ref = this.chooseReplicaAfterFailure(failedRef, m, params, re);
            }
            if (ref == null) {
                return failedRef;
            }
            if (ref.hasRequestTimedOut()) continue;
            return ref;
        }
        return failedRef;
    }

    @Override
    public RemoteReference loadBalance(RemoteReference currentRef, Method method, Object[] params, TransactionalAffinityHandler txnAffinityHandler, RuntimeMethodDescriptor md) {
        RemoteReference newRef = null;
        if (this.callRouter != null) {
            try {
                newRef = this.chooseReplicaUsingCallRouter(method, params);
                if (newRef != null) {
                    this.stickToFirstServer = false;
                }
            }
            catch (ConnectException e) {
                return null;
            }
        }
        if (newRef == null) {
            if (!this.firstRequest && this.stickToFirstServer) {
                newRef = currentRef;
            } else {
                newRef = this.getPreferredRef(currentRef, txnAffinityHandler, md);
                if (newRef == null) {
                    newRef = currentRef;
                    for (int count = this.replicaList.size(); count > 0; --count) {
                        RemoteReference nextReplica = this.isAffinityRequired ? this.chooseReplicaUsingAffinity(currentRef, method, params) : this.chooseReplica(currentRef, method, params);
                        try {
                            if (nextReplica == null || BasicReplicaHandler.isHostUnresponsive(nextReplica)) continue;
                            newRef = nextReplica;
                            break;
                        }
                        catch (PeerNotActiveException e) {
                            this.replicaList.remove(nextReplica);
                        }
                    }
                }
            }
            this.firstRequest = false;
        }
        if (debugLoadbalancingLogger.isDebugEnabled()) {
            if (newRef != null) {
                debugLoadbalancingLogger.debug(this.getJNDIName() + " request routing from " + (currentRef == null ? null : currentRef.getHostID()) + " to " + newRef.getHostID());
            } else {
                debugLoadbalancingLogger.debug(this.getJNDIName() + " from " + (currentRef == null ? null : currentRef.getHostID()) + " request can't find live host");
            }
        }
        return newRef;
    }

    private RemoteReference getPreferredRef(RemoteReference currentRef, TransactionalAffinityHandler txnAffinityHandler, RuntimeMethodDescriptor md) {
        RemoteReference preferredRef = null;
        if (KernelStatus.isServer() && currentRef.getHostID().isLocal()) {
            return currentRef;
        }
        if (preferredRef == null) {
            if (txnAffinityHandler != null && txnAffinityHandler.requiresAffinityBasedHandling(md) && (preferredRef = txnAffinityHandler.findTxnAffinityBasedRef(currentRef, this.jndiName, this.replicaList)) != null) {
                return preferredRef;
            }
            HostID preferredHost = ThreadPreferredHost.get();
            if (preferredHost == null) {
                this.lastPreferredHost = null;
            } else if (preferredHost == this.lastPreferredHost) {
                preferredRef = currentRef;
            } else {
                preferredRef = this.replicaList.findReplicaHostedBy(preferredHost);
                if (preferredRef != null) {
                    this.lastPreferredHost = preferredHost;
                }
            }
            if (debugLoadbalancingLogger.isDebugEnabled() && preferredHost != null && preferredRef == null) {
                debugLoadbalancingLogger.debug("couldn't find replica for " + this.getJNDIName() + "hosted by " + preferredHost + " in\n: " + this.replicaList);
            }
        }
        return preferredRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RemoteReference chooseReplica(RemoteReference currentRef, Method method, Object[] params) {
        ReplicaList replicaList = this.replicaList;
        synchronized (replicaList) {
            int count = this.replicaList.size();
            if (count == 0) {
                return currentRef;
            }
            this.current = (this.current + 1) % count;
            return this.replicaList.get(this.current);
        }
    }

    protected RemoteReference chooseReplicaAfterFailure(RemoteReference currentRef, Method method, Object[] params, RemoteException exception) {
        return this.chooseReplica(currentRef, method, params);
    }

    protected RemoteReference chooseReplicaUsingCallRouter(Method method, Object[] params) throws ConnectException {
        RichReplicaList replicaList = (RichReplicaList)this.getReplicaList();
        String[] servers = this.callRouter.getServerList(method, params);
        if (servers == null) {
            if (debugLoadbalancingLogger.isDebugEnabled()) {
                debugLoadbalancingLogger.debug("CallRouter returned null list");
            }
            return null;
        }
        for (int j = 0; j < 2; ++j) {
            for (int i = 0; i < servers.length; ++i) {
                RemoteReference choice;
                if (debugLoadbalancingLogger.isDebugEnabled()) {
                    debugLoadbalancingLogger.debug(this.getJNDIName() + " trying " + servers[i]);
                }
                if ((choice = replicaList.findReplicaHostedBy(servers[i])) == null || RemoteHelper.isHostDead(choice)) continue;
                return choice;
            }
            this.refreshReplicaList();
        }
        throw new ConnectException("Failed to reach any server hosting " + this.getJNDIName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean refreshReplicaList() {
        block25: {
            if (this.jndiName == null || RMIEnvironment.getEnvironment().isIIOPVendorInfoCluster(this.replicaList)) {
                return false;
            }
            Context ctx = null;
            try {
                RemoteReference ref;
                Object obj;
                if (debugFailoverLogger.isDebugEnabled()) {
                    debugFailoverLogger.debug(this.jndiName + " refreshing replica list");
                }
                if ((obj = (ctx = RMIEnvironment.getEnvironment().getContext(this.env)).lookup(this.jndiName)) instanceof StubInfoIntf) {
                    ref = ((StubInfoIntf)obj).getStubInfo().getRemoteRef();
                } else if (obj instanceof ClusterableRemoteRef) {
                    ref = (ClusterableRemoteRef)obj;
                } else {
                    Object obj1 = ((RemoteWrapper)obj).getRemoteDelegate();
                    if (RemoteHelper.isCollocated(obj1)) {
                        if (debugFailoverLogger.isDebugEnabled()) {
                            debugFailoverLogger.debug("RemoteDelegate: " + obj1 + " is co-located. Generating stub");
                        }
                        obj1 = StubFactory.getStub((Remote)obj1);
                    }
                    ref = ((StubInfoIntf)obj1).getStubInfo().getRemoteRef();
                }
                if (!(ref instanceof ClusterableRemoteRef)) {
                    if (debugFailoverLogger.isDebugEnabled()) {
                        debugFailoverLogger.debug(this.jndiName + " failed to refresh replica list");
                    }
                    break block25;
                }
                ReplicaList list = ((ClusterableRemoteRef)ref).getReplicaList();
                this.resetReplicaList(list);
                boolean bl = true;
                return bl;
            }
            catch (NamingException e) {
                if (debugFailoverLogger.isDebugEnabled()) {
                    debugFailoverLogger.debug(this.getJNDIName() + " failed to refresh replica list");
                }
            }
            finally {
                block26: {
                    if (ctx != null) {
                        try {
                            ctx.close();
                        }
                        catch (NamingException ne) {
                            if (!debugFailoverLogger.isDebugEnabled()) break block26;
                            BasicReplicaHandler.log("failed to close context");
                        }
                    }
                }
            }
        }
        return false;
    }

    protected static final boolean isHostUnresponsive(RemoteReference ref) throws PeerNotActiveException {
        if (RMIEnvironment.getEnvironment().isIIOPHostID(ref.getHostID())) {
            return false;
        }
        EndPoint endPoint = RMIRuntime.findOrCreateEndPoint(ref.getHostID());
        if (endPoint == null || endPoint.isDead()) {
            throw new PeerNotActiveException();
        }
        return endPoint.isUnresponsive();
    }

    private static boolean isConnectionEstablished(RemoteReference ref) {
        EndPoint endPoint = RMIRuntime.findEndPoint(ref.getHostID());
        return endPoint != null && !endPoint.isDead();
    }

    private RemoteReference getReplicaWithEndPoint(RemoteReference currentRef, Method method, Object[] params) {
        RemoteReference ref = null;
        ReplicaList replicaList = this.getReplicaList();
        for (int cnt = replicaList.size(); cnt > 0; --cnt) {
            RemoteReference nextReplica = this.chooseReplica(currentRef, method, params);
            if (!BasicReplicaHandler.isConnectionEstablished(nextReplica)) continue;
            ref = nextReplica;
            break;
        }
        return ref;
    }

    private RemoteReference chooseReplicaUsingAffinity(RemoteReference currentRef, Method method, Object[] params) {
        RemoteReference ref;
        if (KernelStatus.isServer()) {
            ref = this.chooseReplica(currentRef, method, params);
        } else if (BasicReplicaHandler.isConnectionEstablished(currentRef)) {
            ref = currentRef;
        } else {
            ref = this.getReplicaWithEndPoint(currentRef, method, params);
            if (ref == null) {
                ref = this.chooseReplica(currentRef, method, params);
            }
        }
        return ref;
    }

    private RemoteReference chooseReplicaAfterFailureUsingAffinity(RemoteReference currentRef, Method method, Object[] params, RemoteException exception) {
        RemoteReference ref;
        if (KernelStatus.isServer()) {
            ref = this.chooseReplicaAfterFailure(currentRef, method, params, exception);
        } else {
            ref = this.getReplicaWithEndPoint(currentRef, method, params);
            if (ref == null) {
                ref = this.chooseReplicaAfterFailure(currentRef, method, params, exception);
            }
        }
        return ref;
    }

    protected static final void log(String s) {
        RMILogger.logDebug(s);
    }

    public String toString() {
        return this.replicaList.toString();
    }

    public BasicReplicaHandler() {
        if (this.env == null) {
            this.env = RMIEnvironment.getEnvironment().newEnvironment();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.current = this.current + 1 & Integer.MAX_VALUE;
        if (out instanceof WLObjectOutput) {
            WLObjectOutput wlOut = (WLObjectOutput)out;
            wlOut.writeInt(this.current);
            wlOut.writeObjectWL(this.replicaList);
            wlOut.writeBoolean(this.stickToFirstServer || this.isAffinityRequired);
            wlOut.writeObject(this.jndiName);
            wlOut.writeObject(this.callRouter);
            if (wlOut instanceof ColocatedStream) {
                wlOut.writeImmutable(this.env);
            }
        } else {
            out.writeInt(this.current);
            out.writeObject(this.replicaList);
            out.writeBoolean(this.stickToFirstServer || this.isAffinityRequired);
            out.writeObject(this.jndiName);
            out.writeObject(this.callRouter);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (in instanceof WLObjectInput) {
            WLObjectInput wlIn = (WLObjectInput)in;
            this.current = wlIn.readInt();
            this.replicaList = (ReplicaList)wlIn.readObjectWL();
            this.stickToFirstServer = wlIn.readBoolean();
            this.jndiName = (String)wlIn.readObject();
            this.callRouter = (CallRouter)wlIn.readObject();
            if (wlIn instanceof ColocatedStream) {
                this.env = wlIn.readImmutable();
            }
        } else {
            this.current = in.readInt();
            this.replicaList = (ReplicaList)in.readObject();
            this.stickToFirstServer = in.readBoolean();
            this.jndiName = (String)in.readObject();
            this.callRouter = (CallRouter)in.readObject();
        }
    }
}

