/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.cluster;

import java.lang.reflect.Method;
import java.net.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.jndi.Environment;
import weblogic.rmi.RemoteEJBInvokeException;
import weblogic.rmi.RemoteEJBPreInvokeException;
import weblogic.rmi.cluster.BasicReplicaHandler;
import weblogic.rmi.cluster.ClusterableRemoteRef;
import weblogic.rmi.cluster.ReplicaHandler;
import weblogic.rmi.cluster.ReplicaList;
import weblogic.rmi.cluster.RetryHandler;
import weblogic.rmi.cluster.TransactionalAffinityHandler;
import weblogic.rmi.extensions.RemoteHelper;
import weblogic.rmi.extensions.server.RemoteReference;
import weblogic.rmi.extensions.server.RuntimeMethodDescriptor;
import weblogic.rmi.internal.StubInfoIntf;
import weblogic.transaction.TransactionHelper;
import weblogic.utils.AssertionError;

final class EntityBeanReplicaHandler
implements ReplicaHandler {
    private final Object pk;
    private final String jndiName;
    private int homeListSize = 0;
    private final Environment env;

    EntityBeanReplicaHandler(Object pk, String jndiName, Environment env) {
        this.pk = pk;
        this.jndiName = jndiName;
        this.env = env;
    }

    protected boolean isRecoverableFailure(RuntimeMethodDescriptor md, RemoteException e) {
        if (e instanceof RemoteEJBPreInvokeException) {
            return true;
        }
        if (e instanceof RemoteEJBInvokeException) {
            Throwable t = BasicReplicaHandler.unwrapRemoteEJBInvokeException((RemoteEJBInvokeException)e);
            if (t instanceof RemoteException) {
                e = (RemoteException)t;
            } else {
                return false;
            }
        }
        if (md.isIdempotent()) {
            return RemoteHelper.isRecoverableFailure(e);
        }
        return RemoteHelper.isRecoverablePreInvokeFailure(e);
    }

    @Override
    public RemoteReference loadBalance(RemoteReference currentReplica, Method method, Object[] params, TransactionalAffinityHandler txnAffinityHandler, RuntimeMethodDescriptor methodDescriptor) {
        throw new AssertionError("Should never call loadbalance");
    }

    @Override
    public final RemoteReference failOver(RemoteReference failedReplica, RuntimeMethodDescriptor md, Method method, Object[] params, RemoteException re, RetryHandler retryHandler) throws RemoteException {
        int retryCount = retryHandler.getRetryCount();
        Object ref = null;
        if (retryCount != 0 && retryCount > this.homeListSize) {
            throw re;
        }
        if (this.isRecoverableFailure(md, re) && TransactionHelper.getTransactionHelper().getTransaction() == null) {
            Context ctx = null;
            try {
                ctx = this.env.getInitialContext();
                Object home = ctx.lookup(this.jndiName);
                if (retryCount == 0) {
                    this.homeListSize = this.getListSize(home);
                }
                Method findByPrimaryKey = home.getClass().getMethod("findByPrimaryKey", this.pk.getClass());
                StubInfoIntf stub = (StubInfoIntf)findByPrimaryKey.invoke(home, this.pk);
                RemoteReference remoteReference = stub.getStubInfo().getRemoteRef();
                return remoteReference;
            }
            catch (NamingException ne) {
                throw new NoSuchObjectException(ne.toString() + " ClusterAddress (a DNS name) should be set for automatic failover. Check edocs on Configuring a cluster");
            }
            catch (Exception e) {
                if (e instanceof java.rmi.ConnectException || e instanceof ConnectIOException || e instanceof UnknownHostException || e instanceof ConnectException) {
                    throw new RemoteException("Couldn't reach " + this.env.getProviderUrl() + ", you should set ClusterAddress (a DNS name) for automatic  failover. Check edocs on Configuring a cluster");
                }
                throw re;
            }
            finally {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (NamingException namingException) {}
                }
            }
        }
        throw re;
    }

    @Override
    public ReplicaList getReplicaList() {
        return null;
    }

    @Override
    public void resetReplicaList(ReplicaList list) {
    }

    public void resetRefreshedCount() {
    }

    private int getListSize(Object home) {
        StubInfoIntf stub = (StubInfoIntf)home;
        ClusterableRemoteRef ref = (ClusterableRemoteRef)stub.getStubInfo().getRemoteRef();
        return ref.getReplicaCount();
    }
}

